# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['favicons', 'favicons._cli', 'favicons._types']

package_data = \
{'': ['*']}

install_requires = \
['pillow>=7.2,<9.0',
 'rich>=6.0,<11.0',
 'svglib>=1.0.0,<2.0.0',
 'typer>=0.3.1,<0.4.0']

entry_points = \
{'console_scripts': ['favicons = favicons:cli']}

setup_kwargs = {
    'name': 'favicons',
    'version': '0.1.0',
    'description': 'Favicon generator for Python 3 with strongly typed sync & async APIs, CLI, & HTML generation.',
    'long_description': '<div align="center">\n  <h1>Favicons</h1>\n  <h3>Favicon generator for Python 3 with strongly typed sync & async APIs, CLI, & HTML generation.</h3>\n</div>\n\n<hr/>\n\n<div align="center">\n\n[![PyPI](https://img.shields.io/pypi/v/favicons?style=for-the-badge)](https://pypi.org/project/favicons/)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/favicons?style=for-the-badge)\n[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/thatmattlove/favicons/Tests?style=for-the-badge)](https://github.com/thatmattlove/favicons/actions/workflows/ci.yml)\n\n[![GitHub Contributors](https://img.shields.io/github/contributors/thatmattlove/favicons?style=for-the-badge&color=blueviolet)](https://github.com/thatmattlove/favicons)\n\n\n<br/>\n\n### [Changelog](https://github.com/thatmattlove/favicons/blob/master/CHANGELOG.md)\n\n</div>\n\n- [Installation](#installation)\n- [Documentation](#documentation)\n  - [Supported Formats](#supported-formats)\n  - [CLI](#cli)\n    - [`generate`](#generate)\n    - [`html`](#html)\n    - [`json`](#json)\n    - [`names`](#names)\n  - [Python Sync API](#python-sync-api)\n  - [Python Async API](#python-async-api)\n  - [HTML](#html-1)\n  - [Tuple](#tuple)\n  - [JSON](#json-1)\n- [License](#license)\n\n## Installation\n\n```shell\npip3 install favicons\n```\n\n## Documentation\n\n*More docs are coming. Remember, this is a work in progress.*\n\n### Supported Formats\n- SVG\n- PNG\n- JPEG\n- TIFF\n\n### CLI\n\n```console\n$ favicons --help\n\nUsage: favicons [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  generate  Generate Favicons\n  html      Get favicons as HTML.\n  json      Get favicons as JSON.\n  names     Get favicon file names.\n```\n\n#### `generate`\n\nGenerate Favicons from the command line:\n\n```console\nUsage: favicons generate [OPTIONS]\n\n  Generate Favicons\n\nOptions:\n  --source PATH                    Source Image  [required]\n  --output-directory PATH          Output Directory  [required]\n  --background-color TEXT          Background Color  [default: #000000]\n  --transparent / --no-transparent Transparent Background  [default: True]\n  --base-url TEXT                  Base URL for HTML output  [default: /]\n  --help                           Show this message and exit.\n```\n\n#### `html`\n\nGenerate HTML elements (same options as `generate`).\n\n#### `json`\n\nGenerate JSON array of favicon objects (same options as `generate`).\n\n#### `names`\n\nGenerate list of favicon file names (same options as `generate`).\n\n### Python Sync API\n\n```python\nfrom favicons import Favicons\n\nYOUR_ICON = "/home/user/icon.jpg"\nWEB_SERVER_ROOT = "/var/www/html"\n\nwith Favicons(YOUR_ICON, WEB_SERVER_ROOT) as favicons:\n    favicons.generate()\n    for icon in favicons.filenames():\n        print(icon)\n\n# favicon.ico\n# favicon-16x16.png\n# favicon-32x32.png\n# favicon-64x64.png\n# favicon-96x96.png\n# favicon-180x180.png\n# apple-touch-icon-57x57.png\n# apple-touch-icon-60x60.png\n# apple-touch-icon-72x72.png\n# apple-touch-icon-76x76.png\n# apple-touch-icon-114x114.png\n# apple-touch-icon-120x120.png\n# apple-touch-icon-144x144.png\n# apple-touch-icon-152x152.png\n# apple-touch-icon-167x167.png\n# apple-touch-icon-180x180.png\n# mstile-70x70.png\n# mstile-270x270.png\n# mstile-310x310.png\n# mstile-310x150.png\n# favicon-196x196.png\n```\n\n### Python Async API\n\n```python\nfrom favicons import Favicons\n\nYOUR_ICON = "/home/user/icon.jpg"\nWEB_SERVER_ROOT = "/var/www/html"\n\nasync with Favicons(YOUR_ICON, WEB_SERVER_ROOT) as favicons:\n    await favicons.generate()\n    for icon in favicons.filenames():\n        print(icon)\n\n# favicon.ico\n# favicon-16x16.png\n# favicon-32x32.png\n# favicon-64x64.png\n# favicon-96x96.png\n# favicon-180x180.png\n# apple-touch-icon-57x57.png\n# apple-touch-icon-60x60.png\n# apple-touch-icon-72x72.png\n# apple-touch-icon-76x76.png\n# apple-touch-icon-114x114.png\n# apple-touch-icon-120x120.png\n# apple-touch-icon-144x144.png\n# apple-touch-icon-152x152.png\n# apple-touch-icon-167x167.png\n# apple-touch-icon-180x180.png\n# mstile-70x70.png\n# mstile-270x270.png\n# mstile-310x310.png\n# mstile-310x150.png\n# favicon-196x196.png\n```\n\n### HTML\nGet HTML elements for each generated favicon:\n\n```python\nfrom favicons import Favicons\n\nYOUR_ICON = "/home/user/icon.jpg"\nWEB_SERVER_ROOT = "/var/www/html"\n\nasync with Favicons(YOUR_ICON, WEB_SERVER_ROOT) as favicons:\n    await favicons.generate()\n    # As generator\n    html = favicons.html_gen()\n    # As tuple\n    html = favicons.html()\n\nprint(html)\n# (\n#   \'<link rel="None" type="image/ico" href="/favicon.ico" />\',\n#   \'<link rel="icon" type="image/png" href="/favicon-16x16.png" />\',\n#   \'<link rel="icon" type="image/png" href="/favicon-32x32.png" />\',\n#   \'<link rel="icon" type="image/png" href="/favicon-64x64.png" />\',\n#   \'<link rel="icon" type="image/png" href="/favicon-96x96.png" />\',\n#   \'<link rel="icon" type="image/png" href="/favicon-180x180.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-57x57.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-60x60.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-72x72.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-76x76.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-114x114.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-120x120.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-144x144.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-152x152.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-167x167.png" />\',\n#   \'<link rel="apple-touch-icon" type="image/png" \'\n#   \'href="/apple-touch-icon-180x180.png" />\',\n#   \'<link rel="None" type="image/png" href="/mstile-70x70.png" />\',\n#   \'<link rel="None" type="image/png" href="/mstile-270x270.png" />\',\n#   \'<link rel="None" type="image/png" href="/mstile-310x310.png" />\',\n#   \'<link rel="None" type="image/png" href="/mstile-310x150.png" />\',\n#   \'<link rel="shortcut icon" type="image/png" href="/favicon-196x196.png" />\'\n# )\n```\n\n### Tuple\nGet a Python tuple containing each generated favicon\'s properties:\n\n```python\nfrom favicons import Favicons\n\nYOUR_ICON = "/home/user/icon.jpg"\nWEB_SERVER_ROOT = "/var/www/html"\n\nasync with Favicons(YOUR_ICON, WEB_SERVER_ROOT) as favicons:\n    await favicons.generate()\n    as_tuple = favicons.formats()\n    print(as_tuple)\n# (\n#   {\n#     \'dimensions\': (64, 64),\n#     \'image_format\': \'ico\',\n#     \'prefix\': \'favicon\',\n#     \'rel\': None\n#   },\n#   {\n#     \'dimensions\': (16, 16),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'favicon\',\n#     \'rel\': \'icon\'\n#   },\n#   {\n#     \'dimensions\': (32, 32),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'favicon\',\n#     \'rel\': \'icon\'\n#   },\n#   {\n#     \'dimensions\': (64, 64),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'favicon\',\n#     \'rel\': \'icon\'\n#   },\n#   {\n#     \'dimensions\': (96, 96),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'favicon\',\n#     \'rel\': \'icon\'\n#   },\n#   {\n#     \'dimensions\': (180, 180),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'favicon\',\n#     \'rel\': \'icon\'\n#   },\n#   {\n#     \'dimensions\': (57, 57),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (60, 60),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (72, 72),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (76, 76),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (114, 114),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (120, 120),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (144, 144),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (152, 152),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (167, 167),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (180, 180),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'apple-touch-icon\',\n#     \'rel\': \'apple-touch-icon\'\n#   },\n#   {\n#     \'dimensions\': (70, 70),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'mstile\',\n#     \'rel\': None\n#   },\n#   {\n#     \'dimensions\': (270, 270),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'mstile\',\n#     \'rel\': None\n#   },\n#   {\n#     \'dimensions\': (310, 310),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'mstile\',\n#     \'rel\': None\n#   },\n#   {\n#     \'dimensions\': (310, 150),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'mstile\',\n#     \'rel\': None\n#   },\n#   {\n#     \'dimensions\': (196, 196),\n#     \'image_format\': \'png\',\n#     \'prefix\': \'favicon\',\n#     \'rel\': \'shortcut icon\'\n#   }\n# )\n```\n\n### JSON\nGet a JSON array containing each generated favicon\'s properties:\n\n```python\nfrom favicons import Favicons\n\nYOUR_ICON = "/home/user/icon.jpg"\nWEB_SERVER_ROOT = "/var/www/html"\n\nasync with Favicons(YOUR_ICON, WEB_SERVER_ROOT) as favicons:\n    await favicons.generate()\n    as_json = favicons.json(indent=2)\n    print(as_json)\n\n# [\n#   {\n#     "image_format": "ico",\n#     "dimensions": [\n#       64,\n#       64\n#     ],\n#     "prefix": "favicon",\n#     "rel": null\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       16,\n#       16\n#     ],\n#     "prefix": "favicon",\n#     "rel": "icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       32,\n#       32\n#     ],\n#     "prefix": "favicon",\n#     "rel": "icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       64,\n#       64\n#     ],\n#     "prefix": "favicon",\n#     "rel": "icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       96,\n#       96\n#     ],\n#     "prefix": "favicon",\n#     "rel": "icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       180,\n#       180\n#     ],\n#     "prefix": "favicon",\n#     "rel": "icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       57,\n#       57\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       60,\n#       60\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       72,\n#       72\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       76,\n#       76\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       114,\n#       114\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       120,\n#       120\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       144,\n#       144\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       152,\n#       152\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       167,\n#       167\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       180,\n#       180\n#     ],\n#     "prefix": "apple-touch-icon",\n#     "rel": "apple-touch-icon"\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       70,\n#       70\n#     ],\n#     "prefix": "mstile",\n#     "rel": null\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       270,\n#       270\n#     ],\n#     "prefix": "mstile",\n#     "rel": null\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       310,\n#       310\n#     ],\n#     "prefix": "mstile",\n#     "rel": null\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       310,\n#       150\n#     ],\n#     "prefix": "mstile",\n#     "rel": null\n#   },\n#   {\n#     "image_format": "png",\n#     "dimensions": [\n#       196,\n#       196\n#     ],\n#     "prefix": "favicon",\n#     "rel": "shortcut icon"\n#   }\n# ]\n```\n\n## License\n\n[Clear BSD License](https://github.com/thatmattlove/blob/favicons/master/LICENSE)\n',
    'author': 'Matt Love',
    'author_email': 'matt@hyperglass.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/thatmattlove/favicons',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0',
}


setup(**setup_kwargs)
