# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostRuntimePolicyArgs', 'HostRuntimePolicy']

@pulumi.input_type
class HostRuntimePolicyArgs:
    def __init__(__self__, *,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_os_user_activity: Optional[pulumi.Input[bool]] = None,
                 audit_brute_force_login: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 audit_host_failed_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_host_successful_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_user_account_management: Optional[pulumi.Input[bool]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs']] = None,
                 malware_scan_options: Optional[pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs']] = None,
                 monitor_system_log_integrity: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 monitor_windows_services: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_groups_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_groups_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 package_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_scanning_detection: Optional[pulumi.Input[bool]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]]] = None,
                 windows_registry_monitoring: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs']] = None,
                 windows_registry_protection: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs']] = None):
        """
        The set of arguments for constructing a HostRuntimePolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_os_user_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_brute_force_login: Detects brute force login attempts
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[bool] audit_host_failed_login_events: If true, host failed logins will be audited.
        :param pulumi.Input[bool] audit_host_successful_login_events: If true, host successful logins will be audited.
        :param pulumi.Input[bool] audit_user_account_management: If true, account management will be audited.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[str] description: The description of the host runtime policy
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs'] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs'] malware_scan_options: Configuration for Real-Time Malware Protection.
        :param pulumi.Input[bool] monitor_system_log_integrity: If true, system log will be monitored.
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[bool] monitor_windows_services: If true, windows service operations will be monitored.
        :param pulumi.Input[str] name: Name of the host runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_alloweds: List of OS (Linux or Windows) groups that are allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_blockeds: List of OS (Linux or Windows) groups that are not allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_alloweds: List of OS (Linux or Windows) users that are allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_blockeds: List of OS (Linux or Windows) users that are not allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] package_blocks: List of packages that are not allowed read, write or execute all files that under the packages.
        :param pulumi.Input[bool] port_scanning_detection: If true, port scanning behaviors will be audited.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]] scope_variables: List of scope attributes.
        :param pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs'] windows_registry_monitoring: Configuration for windows registry monitoring.
        :param pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs'] windows_registry_protection: Configuration for windows registry protection.
        """
        if application_scopes is not None:
            pulumi.set(__self__, "application_scopes", application_scopes)
        if audit_all_os_user_activity is not None:
            pulumi.set(__self__, "audit_all_os_user_activity", audit_all_os_user_activity)
        if audit_brute_force_login is not None:
            pulumi.set(__self__, "audit_brute_force_login", audit_brute_force_login)
        if audit_full_command_arguments is not None:
            pulumi.set(__self__, "audit_full_command_arguments", audit_full_command_arguments)
        if audit_host_failed_login_events is not None:
            pulumi.set(__self__, "audit_host_failed_login_events", audit_host_failed_login_events)
        if audit_host_successful_login_events is not None:
            pulumi.set(__self__, "audit_host_successful_login_events", audit_host_successful_login_events)
        if audit_user_account_management is not None:
            pulumi.set(__self__, "audit_user_account_management", audit_user_account_management)
        if block_cryptocurrency_mining is not None:
            pulumi.set(__self__, "block_cryptocurrency_mining", block_cryptocurrency_mining)
        if blocked_files is not None:
            pulumi.set(__self__, "blocked_files", blocked_files)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ip_reputation_security is not None:
            pulumi.set(__self__, "enable_ip_reputation_security", enable_ip_reputation_security)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if enforce_after_days is not None:
            pulumi.set(__self__, "enforce_after_days", enforce_after_days)
        if file_integrity_monitoring is not None:
            pulumi.set(__self__, "file_integrity_monitoring", file_integrity_monitoring)
        if malware_scan_options is not None:
            pulumi.set(__self__, "malware_scan_options", malware_scan_options)
        if monitor_system_log_integrity is not None:
            pulumi.set(__self__, "monitor_system_log_integrity", monitor_system_log_integrity)
        if monitor_system_time_changes is not None:
            pulumi.set(__self__, "monitor_system_time_changes", monitor_system_time_changes)
        if monitor_windows_services is not None:
            pulumi.set(__self__, "monitor_windows_services", monitor_windows_services)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_groups_alloweds is not None:
            pulumi.set(__self__, "os_groups_alloweds", os_groups_alloweds)
        if os_groups_blockeds is not None:
            pulumi.set(__self__, "os_groups_blockeds", os_groups_blockeds)
        if os_users_alloweds is not None:
            pulumi.set(__self__, "os_users_alloweds", os_users_alloweds)
        if os_users_blockeds is not None:
            pulumi.set(__self__, "os_users_blockeds", os_users_blockeds)
        if package_blocks is not None:
            pulumi.set(__self__, "package_blocks", package_blocks)
        if port_scanning_detection is not None:
            pulumi.set(__self__, "port_scanning_detection", port_scanning_detection)
        if scope_expression is not None:
            pulumi.set(__self__, "scope_expression", scope_expression)
        if scope_variables is not None:
            pulumi.set(__self__, "scope_variables", scope_variables)
        if windows_registry_monitoring is not None:
            pulumi.set(__self__, "windows_registry_monitoring", windows_registry_monitoring)
        if windows_registry_protection is not None:
            pulumi.set(__self__, "windows_registry_protection", windows_registry_protection)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter(name="auditAllOsUserActivity")
    def audit_all_os_user_activity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, all process activity will be audited.
        """
        return pulumi.get(self, "audit_all_os_user_activity")

    @audit_all_os_user_activity.setter
    def audit_all_os_user_activity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all_os_user_activity", value)

    @property
    @pulumi.getter(name="auditBruteForceLogin")
    def audit_brute_force_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Detects brute force login attempts
        """
        return pulumi.get(self, "audit_brute_force_login")

    @audit_brute_force_login.setter
    def audit_brute_force_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_brute_force_login", value)

    @property
    @pulumi.getter(name="auditFullCommandArguments")
    def audit_full_command_arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, full command arguments will be audited.
        """
        return pulumi.get(self, "audit_full_command_arguments")

    @audit_full_command_arguments.setter
    def audit_full_command_arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_full_command_arguments", value)

    @property
    @pulumi.getter(name="auditHostFailedLoginEvents")
    def audit_host_failed_login_events(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, host failed logins will be audited.
        """
        return pulumi.get(self, "audit_host_failed_login_events")

    @audit_host_failed_login_events.setter
    def audit_host_failed_login_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_host_failed_login_events", value)

    @property
    @pulumi.getter(name="auditHostSuccessfulLoginEvents")
    def audit_host_successful_login_events(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, host successful logins will be audited.
        """
        return pulumi.get(self, "audit_host_successful_login_events")

    @audit_host_successful_login_events.setter
    def audit_host_successful_login_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_host_successful_login_events", value)

    @property
    @pulumi.getter(name="auditUserAccountManagement")
    def audit_user_account_management(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, account management will be audited.
        """
        return pulumi.get(self, "audit_user_account_management")

    @audit_user_account_management.setter
    def audit_user_account_management(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_user_account_management", value)

    @property
    @pulumi.getter(name="blockCryptocurrencyMining")
    def block_cryptocurrency_mining(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        """
        return pulumi.get(self, "block_cryptocurrency_mining")

    @block_cryptocurrency_mining.setter
    def block_cryptocurrency_mining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_cryptocurrency_mining", value)

    @property
    @pulumi.getter(name="blockedFiles")
    def blocked_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files that are prevented from being read, modified and executed in the containers.
        """
        return pulumi.get(self, "blocked_files")

    @blocked_files.setter
    def blocked_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_files", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the host runtime policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableIpReputationSecurity")
    def enable_ip_reputation_security(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        """
        return pulumi.get(self, "enable_ip_reputation_security")

    @enable_ip_reputation_security.setter
    def enable_ip_reputation_security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ip_reputation_security", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter(name="enforceAfterDays")
    def enforce_after_days(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of days after which the runtime policy will be changed to enforce mode.
        """
        return pulumi.get(self, "enforce_after_days")

    @enforce_after_days.setter
    def enforce_after_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enforce_after_days", value)

    @property
    @pulumi.getter(name="fileIntegrityMonitoring")
    def file_integrity_monitoring(self) -> Optional[pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs']]:
        """
        Configuration for file integrity monitoring.
        """
        return pulumi.get(self, "file_integrity_monitoring")

    @file_integrity_monitoring.setter
    def file_integrity_monitoring(self, value: Optional[pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs']]):
        pulumi.set(self, "file_integrity_monitoring", value)

    @property
    @pulumi.getter(name="malwareScanOptions")
    def malware_scan_options(self) -> Optional[pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs']]:
        """
        Configuration for Real-Time Malware Protection.
        """
        return pulumi.get(self, "malware_scan_options")

    @malware_scan_options.setter
    def malware_scan_options(self, value: Optional[pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs']]):
        pulumi.set(self, "malware_scan_options", value)

    @property
    @pulumi.getter(name="monitorSystemLogIntegrity")
    def monitor_system_log_integrity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, system log will be monitored.
        """
        return pulumi.get(self, "monitor_system_log_integrity")

    @monitor_system_log_integrity.setter
    def monitor_system_log_integrity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_system_log_integrity", value)

    @property
    @pulumi.getter(name="monitorSystemTimeChanges")
    def monitor_system_time_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, system time changes will be monitored.
        """
        return pulumi.get(self, "monitor_system_time_changes")

    @monitor_system_time_changes.setter
    def monitor_system_time_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_system_time_changes", value)

    @property
    @pulumi.getter(name="monitorWindowsServices")
    def monitor_windows_services(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, windows service operations will be monitored.
        """
        return pulumi.get(self, "monitor_windows_services")

    @monitor_windows_services.setter
    def monitor_windows_services(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_windows_services", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the host runtime policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osGroupsAlloweds")
    def os_groups_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) groups that are allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        """
        return pulumi.get(self, "os_groups_alloweds")

    @os_groups_alloweds.setter
    def os_groups_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_groups_alloweds", value)

    @property
    @pulumi.getter(name="osGroupsBlockeds")
    def os_groups_blockeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) groups that are not allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        """
        return pulumi.get(self, "os_groups_blockeds")

    @os_groups_blockeds.setter
    def os_groups_blockeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_groups_blockeds", value)

    @property
    @pulumi.getter(name="osUsersAlloweds")
    def os_users_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) users that are allowed to authenticate to the host, and block authentication requests from all others.
        """
        return pulumi.get(self, "os_users_alloweds")

    @os_users_alloweds.setter
    def os_users_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_users_alloweds", value)

    @property
    @pulumi.getter(name="osUsersBlockeds")
    def os_users_blockeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) users that are not allowed to authenticate to the host, and block authentication requests from all others.
        """
        return pulumi.get(self, "os_users_blockeds")

    @os_users_blockeds.setter
    def os_users_blockeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_users_blockeds", value)

    @property
    @pulumi.getter(name="packageBlocks")
    def package_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of packages that are not allowed read, write or execute all files that under the packages.
        """
        return pulumi.get(self, "package_blocks")

    @package_blocks.setter
    def package_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "package_blocks", value)

    @property
    @pulumi.getter(name="portScanningDetection")
    def port_scanning_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, port scanning behaviors will be audited.
        """
        return pulumi.get(self, "port_scanning_detection")

    @port_scanning_detection.setter
    def port_scanning_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_scanning_detection", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]]]):
        pulumi.set(self, "scope_variables", value)

    @property
    @pulumi.getter(name="windowsRegistryMonitoring")
    def windows_registry_monitoring(self) -> Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs']]:
        """
        Configuration for windows registry monitoring.
        """
        return pulumi.get(self, "windows_registry_monitoring")

    @windows_registry_monitoring.setter
    def windows_registry_monitoring(self, value: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs']]):
        pulumi.set(self, "windows_registry_monitoring", value)

    @property
    @pulumi.getter(name="windowsRegistryProtection")
    def windows_registry_protection(self) -> Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs']]:
        """
        Configuration for windows registry protection.
        """
        return pulumi.get(self, "windows_registry_protection")

    @windows_registry_protection.setter
    def windows_registry_protection(self, value: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs']]):
        pulumi.set(self, "windows_registry_protection", value)


@pulumi.input_type
class _HostRuntimePolicyState:
    def __init__(__self__, *,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_os_user_activity: Optional[pulumi.Input[bool]] = None,
                 audit_brute_force_login: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 audit_host_failed_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_host_successful_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_user_account_management: Optional[pulumi.Input[bool]] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs']] = None,
                 malware_scan_options: Optional[pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs']] = None,
                 monitor_system_log_integrity: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 monitor_windows_services: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_groups_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_groups_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 package_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_scanning_detection: Optional[pulumi.Input[bool]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]]] = None,
                 windows_registry_monitoring: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs']] = None,
                 windows_registry_protection: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs']] = None):
        """
        Input properties used for looking up and filtering HostRuntimePolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_os_user_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_brute_force_login: Detects brute force login attempts
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[bool] audit_host_failed_login_events: If true, host failed logins will be audited.
        :param pulumi.Input[bool] audit_host_successful_login_events: If true, host successful logins will be audited.
        :param pulumi.Input[bool] audit_user_account_management: If true, account management will be audited.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[str] description: The description of the host runtime policy
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs'] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs'] malware_scan_options: Configuration for Real-Time Malware Protection.
        :param pulumi.Input[bool] monitor_system_log_integrity: If true, system log will be monitored.
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[bool] monitor_windows_services: If true, windows service operations will be monitored.
        :param pulumi.Input[str] name: Name of the host runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_alloweds: List of OS (Linux or Windows) groups that are allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_blockeds: List of OS (Linux or Windows) groups that are not allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_alloweds: List of OS (Linux or Windows) users that are allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_blockeds: List of OS (Linux or Windows) users that are not allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] package_blocks: List of packages that are not allowed read, write or execute all files that under the packages.
        :param pulumi.Input[bool] port_scanning_detection: If true, port scanning behaviors will be audited.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]] scope_variables: List of scope attributes.
        :param pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs'] windows_registry_monitoring: Configuration for windows registry monitoring.
        :param pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs'] windows_registry_protection: Configuration for windows registry protection.
        """
        if application_scopes is not None:
            pulumi.set(__self__, "application_scopes", application_scopes)
        if audit_all_os_user_activity is not None:
            pulumi.set(__self__, "audit_all_os_user_activity", audit_all_os_user_activity)
        if audit_brute_force_login is not None:
            pulumi.set(__self__, "audit_brute_force_login", audit_brute_force_login)
        if audit_full_command_arguments is not None:
            pulumi.set(__self__, "audit_full_command_arguments", audit_full_command_arguments)
        if audit_host_failed_login_events is not None:
            pulumi.set(__self__, "audit_host_failed_login_events", audit_host_failed_login_events)
        if audit_host_successful_login_events is not None:
            pulumi.set(__self__, "audit_host_successful_login_events", audit_host_successful_login_events)
        if audit_user_account_management is not None:
            pulumi.set(__self__, "audit_user_account_management", audit_user_account_management)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if block_cryptocurrency_mining is not None:
            pulumi.set(__self__, "block_cryptocurrency_mining", block_cryptocurrency_mining)
        if blocked_files is not None:
            pulumi.set(__self__, "blocked_files", blocked_files)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ip_reputation_security is not None:
            pulumi.set(__self__, "enable_ip_reputation_security", enable_ip_reputation_security)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if enforce_after_days is not None:
            pulumi.set(__self__, "enforce_after_days", enforce_after_days)
        if file_integrity_monitoring is not None:
            pulumi.set(__self__, "file_integrity_monitoring", file_integrity_monitoring)
        if malware_scan_options is not None:
            pulumi.set(__self__, "malware_scan_options", malware_scan_options)
        if monitor_system_log_integrity is not None:
            pulumi.set(__self__, "monitor_system_log_integrity", monitor_system_log_integrity)
        if monitor_system_time_changes is not None:
            pulumi.set(__self__, "monitor_system_time_changes", monitor_system_time_changes)
        if monitor_windows_services is not None:
            pulumi.set(__self__, "monitor_windows_services", monitor_windows_services)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_groups_alloweds is not None:
            pulumi.set(__self__, "os_groups_alloweds", os_groups_alloweds)
        if os_groups_blockeds is not None:
            pulumi.set(__self__, "os_groups_blockeds", os_groups_blockeds)
        if os_users_alloweds is not None:
            pulumi.set(__self__, "os_users_alloweds", os_users_alloweds)
        if os_users_blockeds is not None:
            pulumi.set(__self__, "os_users_blockeds", os_users_blockeds)
        if package_blocks is not None:
            pulumi.set(__self__, "package_blocks", package_blocks)
        if port_scanning_detection is not None:
            pulumi.set(__self__, "port_scanning_detection", port_scanning_detection)
        if scope_expression is not None:
            pulumi.set(__self__, "scope_expression", scope_expression)
        if scope_variables is not None:
            pulumi.set(__self__, "scope_variables", scope_variables)
        if windows_registry_monitoring is not None:
            pulumi.set(__self__, "windows_registry_monitoring", windows_registry_monitoring)
        if windows_registry_protection is not None:
            pulumi.set(__self__, "windows_registry_protection", windows_registry_protection)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter(name="auditAllOsUserActivity")
    def audit_all_os_user_activity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, all process activity will be audited.
        """
        return pulumi.get(self, "audit_all_os_user_activity")

    @audit_all_os_user_activity.setter
    def audit_all_os_user_activity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all_os_user_activity", value)

    @property
    @pulumi.getter(name="auditBruteForceLogin")
    def audit_brute_force_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Detects brute force login attempts
        """
        return pulumi.get(self, "audit_brute_force_login")

    @audit_brute_force_login.setter
    def audit_brute_force_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_brute_force_login", value)

    @property
    @pulumi.getter(name="auditFullCommandArguments")
    def audit_full_command_arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, full command arguments will be audited.
        """
        return pulumi.get(self, "audit_full_command_arguments")

    @audit_full_command_arguments.setter
    def audit_full_command_arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_full_command_arguments", value)

    @property
    @pulumi.getter(name="auditHostFailedLoginEvents")
    def audit_host_failed_login_events(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, host failed logins will be audited.
        """
        return pulumi.get(self, "audit_host_failed_login_events")

    @audit_host_failed_login_events.setter
    def audit_host_failed_login_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_host_failed_login_events", value)

    @property
    @pulumi.getter(name="auditHostSuccessfulLoginEvents")
    def audit_host_successful_login_events(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, host successful logins will be audited.
        """
        return pulumi.get(self, "audit_host_successful_login_events")

    @audit_host_successful_login_events.setter
    def audit_host_successful_login_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_host_successful_login_events", value)

    @property
    @pulumi.getter(name="auditUserAccountManagement")
    def audit_user_account_management(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, account management will be audited.
        """
        return pulumi.get(self, "audit_user_account_management")

    @audit_user_account_management.setter
    def audit_user_account_management(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_user_account_management", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="blockCryptocurrencyMining")
    def block_cryptocurrency_mining(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        """
        return pulumi.get(self, "block_cryptocurrency_mining")

    @block_cryptocurrency_mining.setter
    def block_cryptocurrency_mining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_cryptocurrency_mining", value)

    @property
    @pulumi.getter(name="blockedFiles")
    def blocked_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files that are prevented from being read, modified and executed in the containers.
        """
        return pulumi.get(self, "blocked_files")

    @blocked_files.setter
    def blocked_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_files", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the host runtime policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableIpReputationSecurity")
    def enable_ip_reputation_security(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        """
        return pulumi.get(self, "enable_ip_reputation_security")

    @enable_ip_reputation_security.setter
    def enable_ip_reputation_security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ip_reputation_security", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter(name="enforceAfterDays")
    def enforce_after_days(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of days after which the runtime policy will be changed to enforce mode.
        """
        return pulumi.get(self, "enforce_after_days")

    @enforce_after_days.setter
    def enforce_after_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enforce_after_days", value)

    @property
    @pulumi.getter(name="fileIntegrityMonitoring")
    def file_integrity_monitoring(self) -> Optional[pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs']]:
        """
        Configuration for file integrity monitoring.
        """
        return pulumi.get(self, "file_integrity_monitoring")

    @file_integrity_monitoring.setter
    def file_integrity_monitoring(self, value: Optional[pulumi.Input['HostRuntimePolicyFileIntegrityMonitoringArgs']]):
        pulumi.set(self, "file_integrity_monitoring", value)

    @property
    @pulumi.getter(name="malwareScanOptions")
    def malware_scan_options(self) -> Optional[pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs']]:
        """
        Configuration for Real-Time Malware Protection.
        """
        return pulumi.get(self, "malware_scan_options")

    @malware_scan_options.setter
    def malware_scan_options(self, value: Optional[pulumi.Input['HostRuntimePolicyMalwareScanOptionsArgs']]):
        pulumi.set(self, "malware_scan_options", value)

    @property
    @pulumi.getter(name="monitorSystemLogIntegrity")
    def monitor_system_log_integrity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, system log will be monitored.
        """
        return pulumi.get(self, "monitor_system_log_integrity")

    @monitor_system_log_integrity.setter
    def monitor_system_log_integrity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_system_log_integrity", value)

    @property
    @pulumi.getter(name="monitorSystemTimeChanges")
    def monitor_system_time_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, system time changes will be monitored.
        """
        return pulumi.get(self, "monitor_system_time_changes")

    @monitor_system_time_changes.setter
    def monitor_system_time_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_system_time_changes", value)

    @property
    @pulumi.getter(name="monitorWindowsServices")
    def monitor_windows_services(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, windows service operations will be monitored.
        """
        return pulumi.get(self, "monitor_windows_services")

    @monitor_windows_services.setter
    def monitor_windows_services(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_windows_services", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the host runtime policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osGroupsAlloweds")
    def os_groups_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) groups that are allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        """
        return pulumi.get(self, "os_groups_alloweds")

    @os_groups_alloweds.setter
    def os_groups_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_groups_alloweds", value)

    @property
    @pulumi.getter(name="osGroupsBlockeds")
    def os_groups_blockeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) groups that are not allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        """
        return pulumi.get(self, "os_groups_blockeds")

    @os_groups_blockeds.setter
    def os_groups_blockeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_groups_blockeds", value)

    @property
    @pulumi.getter(name="osUsersAlloweds")
    def os_users_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) users that are allowed to authenticate to the host, and block authentication requests from all others.
        """
        return pulumi.get(self, "os_users_alloweds")

    @os_users_alloweds.setter
    def os_users_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_users_alloweds", value)

    @property
    @pulumi.getter(name="osUsersBlockeds")
    def os_users_blockeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OS (Linux or Windows) users that are not allowed to authenticate to the host, and block authentication requests from all others.
        """
        return pulumi.get(self, "os_users_blockeds")

    @os_users_blockeds.setter
    def os_users_blockeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_users_blockeds", value)

    @property
    @pulumi.getter(name="packageBlocks")
    def package_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of packages that are not allowed read, write or execute all files that under the packages.
        """
        return pulumi.get(self, "package_blocks")

    @package_blocks.setter
    def package_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "package_blocks", value)

    @property
    @pulumi.getter(name="portScanningDetection")
    def port_scanning_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, port scanning behaviors will be audited.
        """
        return pulumi.get(self, "port_scanning_detection")

    @port_scanning_detection.setter
    def port_scanning_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_scanning_detection", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostRuntimePolicyScopeVariableArgs']]]]):
        pulumi.set(self, "scope_variables", value)

    @property
    @pulumi.getter(name="windowsRegistryMonitoring")
    def windows_registry_monitoring(self) -> Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs']]:
        """
        Configuration for windows registry monitoring.
        """
        return pulumi.get(self, "windows_registry_monitoring")

    @windows_registry_monitoring.setter
    def windows_registry_monitoring(self, value: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryMonitoringArgs']]):
        pulumi.set(self, "windows_registry_monitoring", value)

    @property
    @pulumi.getter(name="windowsRegistryProtection")
    def windows_registry_protection(self) -> Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs']]:
        """
        Configuration for windows registry protection.
        """
        return pulumi.get(self, "windows_registry_protection")

    @windows_registry_protection.setter
    def windows_registry_protection(self, value: Optional[pulumi.Input['HostRuntimePolicyWindowsRegistryProtectionArgs']]):
        pulumi.set(self, "windows_registry_protection", value)


class HostRuntimePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_os_user_activity: Optional[pulumi.Input[bool]] = None,
                 audit_brute_force_login: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 audit_host_failed_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_host_successful_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_user_account_management: Optional[pulumi.Input[bool]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyFileIntegrityMonitoringArgs']]] = None,
                 malware_scan_options: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyMalwareScanOptionsArgs']]] = None,
                 monitor_system_log_integrity: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 monitor_windows_services: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_groups_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_groups_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 package_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_scanning_detection: Optional[pulumi.Input[bool]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostRuntimePolicyScopeVariableArgs']]]]] = None,
                 windows_registry_monitoring: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryMonitoringArgs']]] = None,
                 windows_registry_protection: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryProtectionArgs']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        host_runtime_policy = aquasec.HostRuntimePolicy("hostRuntimePolicy",
            audit_all_os_user_activity=True,
            audit_brute_force_login=True,
            audit_full_command_arguments=True,
            audit_host_failed_login_events=True,
            audit_host_successful_login_events=True,
            audit_user_account_management=True,
            block_cryptocurrency_mining=True,
            blocked_files=["blocked"],
            description="host_runtime_policy",
            enable_ip_reputation_security=True,
            enabled=True,
            enforce=False,
            file_integrity_monitoring=aquasec.HostRuntimePolicyFileIntegrityMonitoringArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                monitor_attributes=True,
                monitor_create=True,
                monitor_delete=True,
                monitor_modify=True,
                monitor_read=True,
                monitored_paths=["paths"],
                monitored_processes=["process"],
                monitored_users=["user"],
            ),
            monitor_system_log_integrity=True,
            monitor_system_time_changes=True,
            monitor_windows_services=True,
            os_groups_alloweds=["group1"],
            os_groups_blockeds=["group2"],
            os_users_alloweds=["user1"],
            os_users_blockeds=["user2"],
            package_blocks=["package1"],
            port_scanning_detection=True,
            windows_registry_monitoring=aquasec.HostRuntimePolicyWindowsRegistryMonitoringArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                monitor_attributes=True,
                monitor_create=True,
                monitor_delete=True,
                monitor_modify=True,
                monitor_read=True,
                monitored_paths=["paths"],
                monitored_processes=["process"],
                monitored_users=["user"],
            ),
            windows_registry_protection=aquasec.HostRuntimePolicyWindowsRegistryProtectionArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                protected_paths=["paths"],
                protected_processes=["process"],
                protected_users=["user"],
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_os_user_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_brute_force_login: Detects brute force login attempts
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[bool] audit_host_failed_login_events: If true, host failed logins will be audited.
        :param pulumi.Input[bool] audit_host_successful_login_events: If true, host successful logins will be audited.
        :param pulumi.Input[bool] audit_user_account_management: If true, account management will be audited.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[str] description: The description of the host runtime policy
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyFileIntegrityMonitoringArgs']] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyMalwareScanOptionsArgs']] malware_scan_options: Configuration for Real-Time Malware Protection.
        :param pulumi.Input[bool] monitor_system_log_integrity: If true, system log will be monitored.
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[bool] monitor_windows_services: If true, windows service operations will be monitored.
        :param pulumi.Input[str] name: Name of the host runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_alloweds: List of OS (Linux or Windows) groups that are allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_blockeds: List of OS (Linux or Windows) groups that are not allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_alloweds: List of OS (Linux or Windows) users that are allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_blockeds: List of OS (Linux or Windows) users that are not allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] package_blocks: List of packages that are not allowed read, write or execute all files that under the packages.
        :param pulumi.Input[bool] port_scanning_detection: If true, port scanning behaviors will be audited.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostRuntimePolicyScopeVariableArgs']]]] scope_variables: List of scope attributes.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryMonitoringArgs']] windows_registry_monitoring: Configuration for windows registry monitoring.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryProtectionArgs']] windows_registry_protection: Configuration for windows registry protection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[HostRuntimePolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        host_runtime_policy = aquasec.HostRuntimePolicy("hostRuntimePolicy",
            audit_all_os_user_activity=True,
            audit_brute_force_login=True,
            audit_full_command_arguments=True,
            audit_host_failed_login_events=True,
            audit_host_successful_login_events=True,
            audit_user_account_management=True,
            block_cryptocurrency_mining=True,
            blocked_files=["blocked"],
            description="host_runtime_policy",
            enable_ip_reputation_security=True,
            enabled=True,
            enforce=False,
            file_integrity_monitoring=aquasec.HostRuntimePolicyFileIntegrityMonitoringArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                monitor_attributes=True,
                monitor_create=True,
                monitor_delete=True,
                monitor_modify=True,
                monitor_read=True,
                monitored_paths=["paths"],
                monitored_processes=["process"],
                monitored_users=["user"],
            ),
            monitor_system_log_integrity=True,
            monitor_system_time_changes=True,
            monitor_windows_services=True,
            os_groups_alloweds=["group1"],
            os_groups_blockeds=["group2"],
            os_users_alloweds=["user1"],
            os_users_blockeds=["user2"],
            package_blocks=["package1"],
            port_scanning_detection=True,
            windows_registry_monitoring=aquasec.HostRuntimePolicyWindowsRegistryMonitoringArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                monitor_attributes=True,
                monitor_create=True,
                monitor_delete=True,
                monitor_modify=True,
                monitor_read=True,
                monitored_paths=["paths"],
                monitored_processes=["process"],
                monitored_users=["user"],
            ),
            windows_registry_protection=aquasec.HostRuntimePolicyWindowsRegistryProtectionArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                protected_paths=["paths"],
                protected_processes=["process"],
                protected_users=["user"],
            ))
        ```

        :param str resource_name: The name of the resource.
        :param HostRuntimePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostRuntimePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_os_user_activity: Optional[pulumi.Input[bool]] = None,
                 audit_brute_force_login: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 audit_host_failed_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_host_successful_login_events: Optional[pulumi.Input[bool]] = None,
                 audit_user_account_management: Optional[pulumi.Input[bool]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyFileIntegrityMonitoringArgs']]] = None,
                 malware_scan_options: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyMalwareScanOptionsArgs']]] = None,
                 monitor_system_log_integrity: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 monitor_windows_services: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_groups_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_groups_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_users_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 package_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_scanning_detection: Optional[pulumi.Input[bool]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostRuntimePolicyScopeVariableArgs']]]]] = None,
                 windows_registry_monitoring: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryMonitoringArgs']]] = None,
                 windows_registry_protection: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryProtectionArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostRuntimePolicyArgs.__new__(HostRuntimePolicyArgs)

            __props__.__dict__["application_scopes"] = application_scopes
            __props__.__dict__["audit_all_os_user_activity"] = audit_all_os_user_activity
            __props__.__dict__["audit_brute_force_login"] = audit_brute_force_login
            __props__.__dict__["audit_full_command_arguments"] = audit_full_command_arguments
            __props__.__dict__["audit_host_failed_login_events"] = audit_host_failed_login_events
            __props__.__dict__["audit_host_successful_login_events"] = audit_host_successful_login_events
            __props__.__dict__["audit_user_account_management"] = audit_user_account_management
            __props__.__dict__["block_cryptocurrency_mining"] = block_cryptocurrency_mining
            __props__.__dict__["blocked_files"] = blocked_files
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_ip_reputation_security"] = enable_ip_reputation_security
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["enforce"] = enforce
            __props__.__dict__["enforce_after_days"] = enforce_after_days
            __props__.__dict__["file_integrity_monitoring"] = file_integrity_monitoring
            __props__.__dict__["malware_scan_options"] = malware_scan_options
            __props__.__dict__["monitor_system_log_integrity"] = monitor_system_log_integrity
            __props__.__dict__["monitor_system_time_changes"] = monitor_system_time_changes
            __props__.__dict__["monitor_windows_services"] = monitor_windows_services
            __props__.__dict__["name"] = name
            __props__.__dict__["os_groups_alloweds"] = os_groups_alloweds
            __props__.__dict__["os_groups_blockeds"] = os_groups_blockeds
            __props__.__dict__["os_users_alloweds"] = os_users_alloweds
            __props__.__dict__["os_users_blockeds"] = os_users_blockeds
            __props__.__dict__["package_blocks"] = package_blocks
            __props__.__dict__["port_scanning_detection"] = port_scanning_detection
            __props__.__dict__["scope_expression"] = scope_expression
            __props__.__dict__["scope_variables"] = scope_variables
            __props__.__dict__["windows_registry_monitoring"] = windows_registry_monitoring
            __props__.__dict__["windows_registry_protection"] = windows_registry_protection
            __props__.__dict__["author"] = None
        super(HostRuntimePolicy, __self__).__init__(
            'aquasec:index/hostRuntimePolicy:HostRuntimePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            audit_all_os_user_activity: Optional[pulumi.Input[bool]] = None,
            audit_brute_force_login: Optional[pulumi.Input[bool]] = None,
            audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
            audit_host_failed_login_events: Optional[pulumi.Input[bool]] = None,
            audit_host_successful_login_events: Optional[pulumi.Input[bool]] = None,
            audit_user_account_management: Optional[pulumi.Input[bool]] = None,
            author: Optional[pulumi.Input[str]] = None,
            block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
            blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            enforce: Optional[pulumi.Input[bool]] = None,
            enforce_after_days: Optional[pulumi.Input[int]] = None,
            file_integrity_monitoring: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyFileIntegrityMonitoringArgs']]] = None,
            malware_scan_options: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyMalwareScanOptionsArgs']]] = None,
            monitor_system_log_integrity: Optional[pulumi.Input[bool]] = None,
            monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
            monitor_windows_services: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            os_groups_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            os_groups_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            os_users_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            os_users_blockeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            package_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            port_scanning_detection: Optional[pulumi.Input[bool]] = None,
            scope_expression: Optional[pulumi.Input[str]] = None,
            scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostRuntimePolicyScopeVariableArgs']]]]] = None,
            windows_registry_monitoring: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryMonitoringArgs']]] = None,
            windows_registry_protection: Optional[pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryProtectionArgs']]] = None) -> 'HostRuntimePolicy':
        """
        Get an existing HostRuntimePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_os_user_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_brute_force_login: Detects brute force login attempts
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[bool] audit_host_failed_login_events: If true, host failed logins will be audited.
        :param pulumi.Input[bool] audit_host_successful_login_events: If true, host successful logins will be audited.
        :param pulumi.Input[bool] audit_user_account_management: If true, account management will be audited.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[str] description: The description of the host runtime policy
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyFileIntegrityMonitoringArgs']] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyMalwareScanOptionsArgs']] malware_scan_options: Configuration for Real-Time Malware Protection.
        :param pulumi.Input[bool] monitor_system_log_integrity: If true, system log will be monitored.
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[bool] monitor_windows_services: If true, windows service operations will be monitored.
        :param pulumi.Input[str] name: Name of the host runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_alloweds: List of OS (Linux or Windows) groups that are allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_groups_blockeds: List of OS (Linux or Windows) groups that are not allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_alloweds: List of OS (Linux or Windows) users that are allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_users_blockeds: List of OS (Linux or Windows) users that are not allowed to authenticate to the host, and block authentication requests from all others.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] package_blocks: List of packages that are not allowed read, write or execute all files that under the packages.
        :param pulumi.Input[bool] port_scanning_detection: If true, port scanning behaviors will be audited.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostRuntimePolicyScopeVariableArgs']]]] scope_variables: List of scope attributes.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryMonitoringArgs']] windows_registry_monitoring: Configuration for windows registry monitoring.
        :param pulumi.Input[pulumi.InputType['HostRuntimePolicyWindowsRegistryProtectionArgs']] windows_registry_protection: Configuration for windows registry protection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostRuntimePolicyState.__new__(_HostRuntimePolicyState)

        __props__.__dict__["application_scopes"] = application_scopes
        __props__.__dict__["audit_all_os_user_activity"] = audit_all_os_user_activity
        __props__.__dict__["audit_brute_force_login"] = audit_brute_force_login
        __props__.__dict__["audit_full_command_arguments"] = audit_full_command_arguments
        __props__.__dict__["audit_host_failed_login_events"] = audit_host_failed_login_events
        __props__.__dict__["audit_host_successful_login_events"] = audit_host_successful_login_events
        __props__.__dict__["audit_user_account_management"] = audit_user_account_management
        __props__.__dict__["author"] = author
        __props__.__dict__["block_cryptocurrency_mining"] = block_cryptocurrency_mining
        __props__.__dict__["blocked_files"] = blocked_files
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_ip_reputation_security"] = enable_ip_reputation_security
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["enforce"] = enforce
        __props__.__dict__["enforce_after_days"] = enforce_after_days
        __props__.__dict__["file_integrity_monitoring"] = file_integrity_monitoring
        __props__.__dict__["malware_scan_options"] = malware_scan_options
        __props__.__dict__["monitor_system_log_integrity"] = monitor_system_log_integrity
        __props__.__dict__["monitor_system_time_changes"] = monitor_system_time_changes
        __props__.__dict__["monitor_windows_services"] = monitor_windows_services
        __props__.__dict__["name"] = name
        __props__.__dict__["os_groups_alloweds"] = os_groups_alloweds
        __props__.__dict__["os_groups_blockeds"] = os_groups_blockeds
        __props__.__dict__["os_users_alloweds"] = os_users_alloweds
        __props__.__dict__["os_users_blockeds"] = os_users_blockeds
        __props__.__dict__["package_blocks"] = package_blocks
        __props__.__dict__["port_scanning_detection"] = port_scanning_detection
        __props__.__dict__["scope_expression"] = scope_expression
        __props__.__dict__["scope_variables"] = scope_variables
        __props__.__dict__["windows_registry_monitoring"] = windows_registry_monitoring
        __props__.__dict__["windows_registry_protection"] = windows_registry_protection
        return HostRuntimePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @property
    @pulumi.getter(name="auditAllOsUserActivity")
    def audit_all_os_user_activity(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, all process activity will be audited.
        """
        return pulumi.get(self, "audit_all_os_user_activity")

    @property
    @pulumi.getter(name="auditBruteForceLogin")
    def audit_brute_force_login(self) -> pulumi.Output[Optional[bool]]:
        """
        Detects brute force login attempts
        """
        return pulumi.get(self, "audit_brute_force_login")

    @property
    @pulumi.getter(name="auditFullCommandArguments")
    def audit_full_command_arguments(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, full command arguments will be audited.
        """
        return pulumi.get(self, "audit_full_command_arguments")

    @property
    @pulumi.getter(name="auditHostFailedLoginEvents")
    def audit_host_failed_login_events(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, host failed logins will be audited.
        """
        return pulumi.get(self, "audit_host_failed_login_events")

    @property
    @pulumi.getter(name="auditHostSuccessfulLoginEvents")
    def audit_host_successful_login_events(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, host successful logins will be audited.
        """
        return pulumi.get(self, "audit_host_successful_login_events")

    @property
    @pulumi.getter(name="auditUserAccountManagement")
    def audit_user_account_management(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, account management will be audited.
        """
        return pulumi.get(self, "audit_user_account_management")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="blockCryptocurrencyMining")
    def block_cryptocurrency_mining(self) -> pulumi.Output[Optional[bool]]:
        """
        Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        """
        return pulumi.get(self, "block_cryptocurrency_mining")

    @property
    @pulumi.getter(name="blockedFiles")
    def blocked_files(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of files that are prevented from being read, modified and executed in the containers.
        """
        return pulumi.get(self, "blocked_files")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the host runtime policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableIpReputationSecurity")
    def enable_ip_reputation_security(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        """
        return pulumi.get(self, "enable_ip_reputation_security")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def enforce(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter(name="enforceAfterDays")
    def enforce_after_days(self) -> pulumi.Output[Optional[int]]:
        """
        Indicates the number of days after which the runtime policy will be changed to enforce mode.
        """
        return pulumi.get(self, "enforce_after_days")

    @property
    @pulumi.getter(name="fileIntegrityMonitoring")
    def file_integrity_monitoring(self) -> pulumi.Output[Optional['outputs.HostRuntimePolicyFileIntegrityMonitoring']]:
        """
        Configuration for file integrity monitoring.
        """
        return pulumi.get(self, "file_integrity_monitoring")

    @property
    @pulumi.getter(name="malwareScanOptions")
    def malware_scan_options(self) -> pulumi.Output[Optional['outputs.HostRuntimePolicyMalwareScanOptions']]:
        """
        Configuration for Real-Time Malware Protection.
        """
        return pulumi.get(self, "malware_scan_options")

    @property
    @pulumi.getter(name="monitorSystemLogIntegrity")
    def monitor_system_log_integrity(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, system log will be monitored.
        """
        return pulumi.get(self, "monitor_system_log_integrity")

    @property
    @pulumi.getter(name="monitorSystemTimeChanges")
    def monitor_system_time_changes(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, system time changes will be monitored.
        """
        return pulumi.get(self, "monitor_system_time_changes")

    @property
    @pulumi.getter(name="monitorWindowsServices")
    def monitor_windows_services(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, windows service operations will be monitored.
        """
        return pulumi.get(self, "monitor_windows_services")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the host runtime policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osGroupsAlloweds")
    def os_groups_alloweds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of OS (Linux or Windows) groups that are allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        """
        return pulumi.get(self, "os_groups_alloweds")

    @property
    @pulumi.getter(name="osGroupsBlockeds")
    def os_groups_blockeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of OS (Linux or Windows) groups that are not allowed to authenticate to the host, and block authentication requests from all others. Groups can be either Linux groups or Windows AD groups.
        """
        return pulumi.get(self, "os_groups_blockeds")

    @property
    @pulumi.getter(name="osUsersAlloweds")
    def os_users_alloweds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of OS (Linux or Windows) users that are allowed to authenticate to the host, and block authentication requests from all others.
        """
        return pulumi.get(self, "os_users_alloweds")

    @property
    @pulumi.getter(name="osUsersBlockeds")
    def os_users_blockeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of OS (Linux or Windows) users that are not allowed to authenticate to the host, and block authentication requests from all others.
        """
        return pulumi.get(self, "os_users_blockeds")

    @property
    @pulumi.getter(name="packageBlocks")
    def package_blocks(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of packages that are not allowed read, write or execute all files that under the packages.
        """
        return pulumi.get(self, "package_blocks")

    @property
    @pulumi.getter(name="portScanningDetection")
    def port_scanning_detection(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, port scanning behaviors will be audited.
        """
        return pulumi.get(self, "port_scanning_detection")

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> pulumi.Output[str]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> pulumi.Output[Sequence['outputs.HostRuntimePolicyScopeVariable']]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @property
    @pulumi.getter(name="windowsRegistryMonitoring")
    def windows_registry_monitoring(self) -> pulumi.Output[Optional['outputs.HostRuntimePolicyWindowsRegistryMonitoring']]:
        """
        Configuration for windows registry monitoring.
        """
        return pulumi.get(self, "windows_registry_monitoring")

    @property
    @pulumi.getter(name="windowsRegistryProtection")
    def windows_registry_protection(self) -> pulumi.Output[Optional['outputs.HostRuntimePolicyWindowsRegistryProtection']]:
        """
        Configuration for windows registry protection.
        """
        return pulumi.get(self, "windows_registry_protection")

