# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationRegistryArgs', 'IntegrationRegistry']

@pulumi.input_type
class IntegrationRegistryArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 author: Optional[pulumi.Input[str]] = None,
                 auto_pull: Optional[pulumi.Input[bool]] = None,
                 auto_pull_interval: Optional[pulumi.Input[int]] = None,
                 auto_pull_max: Optional[pulumi.Input[int]] = None,
                 auto_pull_rescan: Optional[pulumi.Input[bool]] = None,
                 auto_pull_time: Optional[pulumi.Input[str]] = None,
                 image_creation_date_condition: Optional[pulumi.Input[str]] = None,
                 last_updated: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRegistryOptionArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pull_image_age: Optional[pulumi.Input[str]] = None,
                 pull_image_count: Optional[pulumi.Input[int]] = None,
                 scanner_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scanner_type: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IntegrationRegistry resource.
        :param pulumi.Input[str] type: Registry type (HUB / V1 / V2 / ENGINE / AWS / GCR).
        :param pulumi.Input[str] author: The username of the user who created or last modified the registry
        :param pulumi.Input[bool] auto_pull: Whether to automatically pull images from the registry on creation and daily
        :param pulumi.Input[int] auto_pull_interval: The interval in days to start pulling new images from the registry, Defaults to 1
        :param pulumi.Input[int] auto_pull_max: Maximum number of repositories to pull every day, defaults to 100
        :param pulumi.Input[bool] auto_pull_rescan: Whether to automatically pull and rescan images from the registry on creation and daily
        :param pulumi.Input[str] auto_pull_time: The time of day to start pulling new images from the registry, in the format HH:MM (24-hour clock), defaults to 03:00
        :param pulumi.Input[str] image_creation_date_condition: Additional condition for pulling and rescanning images, Defaults to 'none'
        :param pulumi.Input[str] last_updated: The last time the registry was modified in UNIX time
        :param pulumi.Input[str] name: The name of the registry; string, required - this will be treated as the registry's ID, so choose a simple alphanumerical name without special signs and spaces
        :param pulumi.Input[str] password: The password for registry authentication
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefixes: List of possible prefixes to image names pulled from the registry
        :param pulumi.Input[str] pull_image_age: When auto pull image enabled, sets maximum age of auto pulled images (for example for 5 Days the value should be: 5D), Requires `image_creation_date_condition = "image_age"`
        :param pulumi.Input[int] pull_image_count: When auto pull image enabled, sets maximum age of auto pulled images tags from each repository (based on image creation date) Requires `image_creation_date_condition = "image_count"`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scanner_names: List of scanner names
        :param pulumi.Input[str] scanner_type: The Scanner type
        :param pulumi.Input[str] url: The URL, address or region of the registry
        :param pulumi.Input[str] username: The username for registry authentication.
        """
        pulumi.set(__self__, "type", type)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if auto_pull is not None:
            pulumi.set(__self__, "auto_pull", auto_pull)
        if auto_pull_interval is not None:
            pulumi.set(__self__, "auto_pull_interval", auto_pull_interval)
        if auto_pull_max is not None:
            pulumi.set(__self__, "auto_pull_max", auto_pull_max)
        if auto_pull_rescan is not None:
            pulumi.set(__self__, "auto_pull_rescan", auto_pull_rescan)
        if auto_pull_time is not None:
            pulumi.set(__self__, "auto_pull_time", auto_pull_time)
        if image_creation_date_condition is not None:
            pulumi.set(__self__, "image_creation_date_condition", image_creation_date_condition)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)
        if pull_image_age is not None:
            pulumi.set(__self__, "pull_image_age", pull_image_age)
        if pull_image_count is not None:
            pulumi.set(__self__, "pull_image_count", pull_image_count)
        if scanner_names is not None:
            pulumi.set(__self__, "scanner_names", scanner_names)
        if scanner_type is not None:
            pulumi.set(__self__, "scanner_type", scanner_type)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Registry type (HUB / V1 / V2 / ENGINE / AWS / GCR).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the user who created or last modified the registry
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="autoPull")
    def auto_pull(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically pull images from the registry on creation and daily
        """
        return pulumi.get(self, "auto_pull")

    @auto_pull.setter
    def auto_pull(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pull", value)

    @property
    @pulumi.getter(name="autoPullInterval")
    def auto_pull_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in days to start pulling new images from the registry, Defaults to 1
        """
        return pulumi.get(self, "auto_pull_interval")

    @auto_pull_interval.setter
    def auto_pull_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_pull_interval", value)

    @property
    @pulumi.getter(name="autoPullMax")
    def auto_pull_max(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of repositories to pull every day, defaults to 100
        """
        return pulumi.get(self, "auto_pull_max")

    @auto_pull_max.setter
    def auto_pull_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_pull_max", value)

    @property
    @pulumi.getter(name="autoPullRescan")
    def auto_pull_rescan(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically pull and rescan images from the registry on creation and daily
        """
        return pulumi.get(self, "auto_pull_rescan")

    @auto_pull_rescan.setter
    def auto_pull_rescan(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pull_rescan", value)

    @property
    @pulumi.getter(name="autoPullTime")
    def auto_pull_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of day to start pulling new images from the registry, in the format HH:MM (24-hour clock), defaults to 03:00
        """
        return pulumi.get(self, "auto_pull_time")

    @auto_pull_time.setter
    def auto_pull_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pull_time", value)

    @property
    @pulumi.getter(name="imageCreationDateCondition")
    def image_creation_date_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Additional condition for pulling and rescanning images, Defaults to 'none'
        """
        return pulumi.get(self, "image_creation_date_condition")

    @image_creation_date_condition.setter
    def image_creation_date_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_creation_date_condition", value)

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last time the registry was modified in UNIX time
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the registry; string, required - this will be treated as the registry's ID, so choose a simple alphanumerical name without special signs and spaces
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRegistryOptionArgs']]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRegistryOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for registry authentication
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of possible prefixes to image names pulled from the registry
        """
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prefixes", value)

    @property
    @pulumi.getter(name="pullImageAge")
    def pull_image_age(self) -> Optional[pulumi.Input[str]]:
        """
        When auto pull image enabled, sets maximum age of auto pulled images (for example for 5 Days the value should be: 5D), Requires `image_creation_date_condition = "image_age"`
        """
        return pulumi.get(self, "pull_image_age")

    @pull_image_age.setter
    def pull_image_age(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pull_image_age", value)

    @property
    @pulumi.getter(name="pullImageCount")
    def pull_image_count(self) -> Optional[pulumi.Input[int]]:
        """
        When auto pull image enabled, sets maximum age of auto pulled images tags from each repository (based on image creation date) Requires `image_creation_date_condition = "image_count"`
        """
        return pulumi.get(self, "pull_image_count")

    @pull_image_count.setter
    def pull_image_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pull_image_count", value)

    @property
    @pulumi.getter(name="scannerNames")
    def scanner_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of scanner names
        """
        return pulumi.get(self, "scanner_names")

    @scanner_names.setter
    def scanner_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scanner_names", value)

    @property
    @pulumi.getter(name="scannerType")
    def scanner_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Scanner type
        """
        return pulumi.get(self, "scanner_type")

    @scanner_type.setter
    def scanner_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scanner_type", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL, address or region of the registry
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for registry authentication.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _IntegrationRegistryState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input[str]] = None,
                 auto_pull: Optional[pulumi.Input[bool]] = None,
                 auto_pull_interval: Optional[pulumi.Input[int]] = None,
                 auto_pull_max: Optional[pulumi.Input[int]] = None,
                 auto_pull_rescan: Optional[pulumi.Input[bool]] = None,
                 auto_pull_time: Optional[pulumi.Input[str]] = None,
                 image_creation_date_condition: Optional[pulumi.Input[str]] = None,
                 last_updated: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRegistryOptionArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pull_image_age: Optional[pulumi.Input[str]] = None,
                 pull_image_count: Optional[pulumi.Input[int]] = None,
                 scanner_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scanner_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IntegrationRegistry resources.
        :param pulumi.Input[str] author: The username of the user who created or last modified the registry
        :param pulumi.Input[bool] auto_pull: Whether to automatically pull images from the registry on creation and daily
        :param pulumi.Input[int] auto_pull_interval: The interval in days to start pulling new images from the registry, Defaults to 1
        :param pulumi.Input[int] auto_pull_max: Maximum number of repositories to pull every day, defaults to 100
        :param pulumi.Input[bool] auto_pull_rescan: Whether to automatically pull and rescan images from the registry on creation and daily
        :param pulumi.Input[str] auto_pull_time: The time of day to start pulling new images from the registry, in the format HH:MM (24-hour clock), defaults to 03:00
        :param pulumi.Input[str] image_creation_date_condition: Additional condition for pulling and rescanning images, Defaults to 'none'
        :param pulumi.Input[str] last_updated: The last time the registry was modified in UNIX time
        :param pulumi.Input[str] name: The name of the registry; string, required - this will be treated as the registry's ID, so choose a simple alphanumerical name without special signs and spaces
        :param pulumi.Input[str] password: The password for registry authentication
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefixes: List of possible prefixes to image names pulled from the registry
        :param pulumi.Input[str] pull_image_age: When auto pull image enabled, sets maximum age of auto pulled images (for example for 5 Days the value should be: 5D), Requires `image_creation_date_condition = "image_age"`
        :param pulumi.Input[int] pull_image_count: When auto pull image enabled, sets maximum age of auto pulled images tags from each repository (based on image creation date) Requires `image_creation_date_condition = "image_count"`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scanner_names: List of scanner names
        :param pulumi.Input[str] scanner_type: The Scanner type
        :param pulumi.Input[str] type: Registry type (HUB / V1 / V2 / ENGINE / AWS / GCR).
        :param pulumi.Input[str] url: The URL, address or region of the registry
        :param pulumi.Input[str] username: The username for registry authentication.
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if auto_pull is not None:
            pulumi.set(__self__, "auto_pull", auto_pull)
        if auto_pull_interval is not None:
            pulumi.set(__self__, "auto_pull_interval", auto_pull_interval)
        if auto_pull_max is not None:
            pulumi.set(__self__, "auto_pull_max", auto_pull_max)
        if auto_pull_rescan is not None:
            pulumi.set(__self__, "auto_pull_rescan", auto_pull_rescan)
        if auto_pull_time is not None:
            pulumi.set(__self__, "auto_pull_time", auto_pull_time)
        if image_creation_date_condition is not None:
            pulumi.set(__self__, "image_creation_date_condition", image_creation_date_condition)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)
        if pull_image_age is not None:
            pulumi.set(__self__, "pull_image_age", pull_image_age)
        if pull_image_count is not None:
            pulumi.set(__self__, "pull_image_count", pull_image_count)
        if scanner_names is not None:
            pulumi.set(__self__, "scanner_names", scanner_names)
        if scanner_type is not None:
            pulumi.set(__self__, "scanner_type", scanner_type)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the user who created or last modified the registry
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="autoPull")
    def auto_pull(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically pull images from the registry on creation and daily
        """
        return pulumi.get(self, "auto_pull")

    @auto_pull.setter
    def auto_pull(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pull", value)

    @property
    @pulumi.getter(name="autoPullInterval")
    def auto_pull_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in days to start pulling new images from the registry, Defaults to 1
        """
        return pulumi.get(self, "auto_pull_interval")

    @auto_pull_interval.setter
    def auto_pull_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_pull_interval", value)

    @property
    @pulumi.getter(name="autoPullMax")
    def auto_pull_max(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of repositories to pull every day, defaults to 100
        """
        return pulumi.get(self, "auto_pull_max")

    @auto_pull_max.setter
    def auto_pull_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_pull_max", value)

    @property
    @pulumi.getter(name="autoPullRescan")
    def auto_pull_rescan(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically pull and rescan images from the registry on creation and daily
        """
        return pulumi.get(self, "auto_pull_rescan")

    @auto_pull_rescan.setter
    def auto_pull_rescan(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pull_rescan", value)

    @property
    @pulumi.getter(name="autoPullTime")
    def auto_pull_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of day to start pulling new images from the registry, in the format HH:MM (24-hour clock), defaults to 03:00
        """
        return pulumi.get(self, "auto_pull_time")

    @auto_pull_time.setter
    def auto_pull_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pull_time", value)

    @property
    @pulumi.getter(name="imageCreationDateCondition")
    def image_creation_date_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Additional condition for pulling and rescanning images, Defaults to 'none'
        """
        return pulumi.get(self, "image_creation_date_condition")

    @image_creation_date_condition.setter
    def image_creation_date_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_creation_date_condition", value)

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last time the registry was modified in UNIX time
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the registry; string, required - this will be treated as the registry's ID, so choose a simple alphanumerical name without special signs and spaces
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRegistryOptionArgs']]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRegistryOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for registry authentication
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of possible prefixes to image names pulled from the registry
        """
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prefixes", value)

    @property
    @pulumi.getter(name="pullImageAge")
    def pull_image_age(self) -> Optional[pulumi.Input[str]]:
        """
        When auto pull image enabled, sets maximum age of auto pulled images (for example for 5 Days the value should be: 5D), Requires `image_creation_date_condition = "image_age"`
        """
        return pulumi.get(self, "pull_image_age")

    @pull_image_age.setter
    def pull_image_age(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pull_image_age", value)

    @property
    @pulumi.getter(name="pullImageCount")
    def pull_image_count(self) -> Optional[pulumi.Input[int]]:
        """
        When auto pull image enabled, sets maximum age of auto pulled images tags from each repository (based on image creation date) Requires `image_creation_date_condition = "image_count"`
        """
        return pulumi.get(self, "pull_image_count")

    @pull_image_count.setter
    def pull_image_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pull_image_count", value)

    @property
    @pulumi.getter(name="scannerNames")
    def scanner_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of scanner names
        """
        return pulumi.get(self, "scanner_names")

    @scanner_names.setter
    def scanner_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scanner_names", value)

    @property
    @pulumi.getter(name="scannerType")
    def scanner_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Scanner type
        """
        return pulumi.get(self, "scanner_type")

    @scanner_type.setter
    def scanner_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scanner_type", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Registry type (HUB / V1 / V2 / ENGINE / AWS / GCR).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL, address or region of the registry
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for registry authentication.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class IntegrationRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 auto_pull: Optional[pulumi.Input[bool]] = None,
                 auto_pull_interval: Optional[pulumi.Input[int]] = None,
                 auto_pull_max: Optional[pulumi.Input[int]] = None,
                 auto_pull_rescan: Optional[pulumi.Input[bool]] = None,
                 auto_pull_time: Optional[pulumi.Input[str]] = None,
                 image_creation_date_condition: Optional[pulumi.Input[str]] = None,
                 last_updated: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IntegrationRegistryOptionArgs']]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pull_image_age: Optional[pulumi.Input[str]] = None,
                 pull_image_count: Optional[pulumi.Input[int]] = None,
                 scanner_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scanner_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a IntegrationRegistry resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author: The username of the user who created or last modified the registry
        :param pulumi.Input[bool] auto_pull: Whether to automatically pull images from the registry on creation and daily
        :param pulumi.Input[int] auto_pull_interval: The interval in days to start pulling new images from the registry, Defaults to 1
        :param pulumi.Input[int] auto_pull_max: Maximum number of repositories to pull every day, defaults to 100
        :param pulumi.Input[bool] auto_pull_rescan: Whether to automatically pull and rescan images from the registry on creation and daily
        :param pulumi.Input[str] auto_pull_time: The time of day to start pulling new images from the registry, in the format HH:MM (24-hour clock), defaults to 03:00
        :param pulumi.Input[str] image_creation_date_condition: Additional condition for pulling and rescanning images, Defaults to 'none'
        :param pulumi.Input[str] last_updated: The last time the registry was modified in UNIX time
        :param pulumi.Input[str] name: The name of the registry; string, required - this will be treated as the registry's ID, so choose a simple alphanumerical name without special signs and spaces
        :param pulumi.Input[str] password: The password for registry authentication
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefixes: List of possible prefixes to image names pulled from the registry
        :param pulumi.Input[str] pull_image_age: When auto pull image enabled, sets maximum age of auto pulled images (for example for 5 Days the value should be: 5D), Requires `image_creation_date_condition = "image_age"`
        :param pulumi.Input[int] pull_image_count: When auto pull image enabled, sets maximum age of auto pulled images tags from each repository (based on image creation date) Requires `image_creation_date_condition = "image_count"`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scanner_names: List of scanner names
        :param pulumi.Input[str] scanner_type: The Scanner type
        :param pulumi.Input[str] type: Registry type (HUB / V1 / V2 / ENGINE / AWS / GCR).
        :param pulumi.Input[str] url: The URL, address or region of the registry
        :param pulumi.Input[str] username: The username for registry authentication.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IntegrationRegistry resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IntegrationRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 auto_pull: Optional[pulumi.Input[bool]] = None,
                 auto_pull_interval: Optional[pulumi.Input[int]] = None,
                 auto_pull_max: Optional[pulumi.Input[int]] = None,
                 auto_pull_rescan: Optional[pulumi.Input[bool]] = None,
                 auto_pull_time: Optional[pulumi.Input[str]] = None,
                 image_creation_date_condition: Optional[pulumi.Input[str]] = None,
                 last_updated: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IntegrationRegistryOptionArgs']]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pull_image_age: Optional[pulumi.Input[str]] = None,
                 pull_image_count: Optional[pulumi.Input[int]] = None,
                 scanner_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scanner_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationRegistryArgs.__new__(IntegrationRegistryArgs)

            __props__.__dict__["author"] = author
            __props__.__dict__["auto_pull"] = auto_pull
            __props__.__dict__["auto_pull_interval"] = auto_pull_interval
            __props__.__dict__["auto_pull_max"] = auto_pull_max
            __props__.__dict__["auto_pull_rescan"] = auto_pull_rescan
            __props__.__dict__["auto_pull_time"] = auto_pull_time
            __props__.__dict__["image_creation_date_condition"] = image_creation_date_condition
            __props__.__dict__["last_updated"] = last_updated
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["password"] = password
            __props__.__dict__["prefixes"] = prefixes
            __props__.__dict__["pull_image_age"] = pull_image_age
            __props__.__dict__["pull_image_count"] = pull_image_count
            __props__.__dict__["scanner_names"] = scanner_names
            __props__.__dict__["scanner_type"] = scanner_type
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["url"] = url
            __props__.__dict__["username"] = username
        super(IntegrationRegistry, __self__).__init__(
            'aquasec:index/integrationRegistry:IntegrationRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[str]] = None,
            auto_pull: Optional[pulumi.Input[bool]] = None,
            auto_pull_interval: Optional[pulumi.Input[int]] = None,
            auto_pull_max: Optional[pulumi.Input[int]] = None,
            auto_pull_rescan: Optional[pulumi.Input[bool]] = None,
            auto_pull_time: Optional[pulumi.Input[str]] = None,
            image_creation_date_condition: Optional[pulumi.Input[str]] = None,
            last_updated: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IntegrationRegistryOptionArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            pull_image_age: Optional[pulumi.Input[str]] = None,
            pull_image_count: Optional[pulumi.Input[int]] = None,
            scanner_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scanner_type: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'IntegrationRegistry':
        """
        Get an existing IntegrationRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author: The username of the user who created or last modified the registry
        :param pulumi.Input[bool] auto_pull: Whether to automatically pull images from the registry on creation and daily
        :param pulumi.Input[int] auto_pull_interval: The interval in days to start pulling new images from the registry, Defaults to 1
        :param pulumi.Input[int] auto_pull_max: Maximum number of repositories to pull every day, defaults to 100
        :param pulumi.Input[bool] auto_pull_rescan: Whether to automatically pull and rescan images from the registry on creation and daily
        :param pulumi.Input[str] auto_pull_time: The time of day to start pulling new images from the registry, in the format HH:MM (24-hour clock), defaults to 03:00
        :param pulumi.Input[str] image_creation_date_condition: Additional condition for pulling and rescanning images, Defaults to 'none'
        :param pulumi.Input[str] last_updated: The last time the registry was modified in UNIX time
        :param pulumi.Input[str] name: The name of the registry; string, required - this will be treated as the registry's ID, so choose a simple alphanumerical name without special signs and spaces
        :param pulumi.Input[str] password: The password for registry authentication
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefixes: List of possible prefixes to image names pulled from the registry
        :param pulumi.Input[str] pull_image_age: When auto pull image enabled, sets maximum age of auto pulled images (for example for 5 Days the value should be: 5D), Requires `image_creation_date_condition = "image_age"`
        :param pulumi.Input[int] pull_image_count: When auto pull image enabled, sets maximum age of auto pulled images tags from each repository (based on image creation date) Requires `image_creation_date_condition = "image_count"`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scanner_names: List of scanner names
        :param pulumi.Input[str] scanner_type: The Scanner type
        :param pulumi.Input[str] type: Registry type (HUB / V1 / V2 / ENGINE / AWS / GCR).
        :param pulumi.Input[str] url: The URL, address or region of the registry
        :param pulumi.Input[str] username: The username for registry authentication.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationRegistryState.__new__(_IntegrationRegistryState)

        __props__.__dict__["author"] = author
        __props__.__dict__["auto_pull"] = auto_pull
        __props__.__dict__["auto_pull_interval"] = auto_pull_interval
        __props__.__dict__["auto_pull_max"] = auto_pull_max
        __props__.__dict__["auto_pull_rescan"] = auto_pull_rescan
        __props__.__dict__["auto_pull_time"] = auto_pull_time
        __props__.__dict__["image_creation_date_condition"] = image_creation_date_condition
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["password"] = password
        __props__.__dict__["prefixes"] = prefixes
        __props__.__dict__["pull_image_age"] = pull_image_age
        __props__.__dict__["pull_image_count"] = pull_image_count
        __props__.__dict__["scanner_names"] = scanner_names
        __props__.__dict__["scanner_type"] = scanner_type
        __props__.__dict__["type"] = type
        __props__.__dict__["url"] = url
        __props__.__dict__["username"] = username
        return IntegrationRegistry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        The username of the user who created or last modified the registry
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="autoPull")
    def auto_pull(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically pull images from the registry on creation and daily
        """
        return pulumi.get(self, "auto_pull")

    @property
    @pulumi.getter(name="autoPullInterval")
    def auto_pull_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The interval in days to start pulling new images from the registry, Defaults to 1
        """
        return pulumi.get(self, "auto_pull_interval")

    @property
    @pulumi.getter(name="autoPullMax")
    def auto_pull_max(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of repositories to pull every day, defaults to 100
        """
        return pulumi.get(self, "auto_pull_max")

    @property
    @pulumi.getter(name="autoPullRescan")
    def auto_pull_rescan(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically pull and rescan images from the registry on creation and daily
        """
        return pulumi.get(self, "auto_pull_rescan")

    @property
    @pulumi.getter(name="autoPullTime")
    def auto_pull_time(self) -> pulumi.Output[Optional[str]]:
        """
        The time of day to start pulling new images from the registry, in the format HH:MM (24-hour clock), defaults to 03:00
        """
        return pulumi.get(self, "auto_pull_time")

    @property
    @pulumi.getter(name="imageCreationDateCondition")
    def image_creation_date_condition(self) -> pulumi.Output[str]:
        """
        Additional condition for pulling and rescanning images, Defaults to 'none'
        """
        return pulumi.get(self, "image_creation_date_condition")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[str]:
        """
        The last time the registry was modified in UNIX time
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the registry; string, required - this will be treated as the registry's ID, so choose a simple alphanumerical name without special signs and spaces
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationRegistryOption']]]:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password for registry authentication
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def prefixes(self) -> pulumi.Output[Sequence[str]]:
        """
        List of possible prefixes to image names pulled from the registry
        """
        return pulumi.get(self, "prefixes")

    @property
    @pulumi.getter(name="pullImageAge")
    def pull_image_age(self) -> pulumi.Output[str]:
        """
        When auto pull image enabled, sets maximum age of auto pulled images (for example for 5 Days the value should be: 5D), Requires `image_creation_date_condition = "image_age"`
        """
        return pulumi.get(self, "pull_image_age")

    @property
    @pulumi.getter(name="pullImageCount")
    def pull_image_count(self) -> pulumi.Output[int]:
        """
        When auto pull image enabled, sets maximum age of auto pulled images tags from each repository (based on image creation date) Requires `image_creation_date_condition = "image_count"`
        """
        return pulumi.get(self, "pull_image_count")

    @property
    @pulumi.getter(name="scannerNames")
    def scanner_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of scanner names
        """
        return pulumi.get(self, "scanner_names")

    @property
    @pulumi.getter(name="scannerType")
    def scanner_type(self) -> pulumi.Output[str]:
        """
        The Scanner type
        """
        return pulumi.get(self, "scanner_type")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Registry type (HUB / V1 / V2 / ENGINE / AWS / GCR).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL, address or region of the registry
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The username for registry authentication.
        """
        return pulumi.get(self, "username")

