# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[str],
                 role_name: pulumi.Input[str],
                 scopes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 description: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[str] permission: The name of the Permission Set that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] role_name: The name of the role, comprised of alphanumeric characters and '-', '_', ' ', ':', '.', '@', '!', '^'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: List of Application Scopes that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] description: Free text description for the role.
        :param pulumi.Input[str] updated_at: The date of the last modification of the role.
        """
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "scopes", scopes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[str]:
        """
        The name of the Permission Set that will affect the users assigned to this specific Role.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[str]:
        """
        The name of the role, comprised of alphanumeric characters and '-', '_', ' ', ':', '.', '@', '!', '^'.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of Application Scopes that will affect the users assigned to this specific Role.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description for the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date of the last modification of the role.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[str] author: The name of the user who created the role. Only returned from the API for existing permissions, not part of the permission creation/modification structure.
        :param pulumi.Input[str] description: Free text description for the role.
        :param pulumi.Input[str] permission: The name of the Permission Set that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] role_name: The name of the role, comprised of alphanumeric characters and '-', '_', ' ', ':', '.', '@', '!', '^'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: List of Application Scopes that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] updated_at: The date of the last modification of the role.
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user who created the role. Only returned from the API for existing permissions, not part of the permission creation/modification structure.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description for the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Permission Set that will affect the users assigned to this specific Role.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role, comprised of alphanumeric characters and '-', '_', ' ', ':', '.', '@', '!', '^'.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Application Scopes that will affect the users assigned to this specific Role.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date of the last modification of the role.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `Role` resource manages your roles within Aqua.

        The roles created must have permission set and at least one Role Application Scope that is already present within Aqua.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        ia_c = aquasec.Role("iaC",
            description="RoleIaC",
            permission="PermissionIaC",
            role_name="RoleIaC",
            scopes=["Global"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Free text description for the role.
        :param pulumi.Input[str] permission: The name of the Permission Set that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] role_name: The name of the role, comprised of alphanumeric characters and '-', '_', ' ', ':', '.', '@', '!', '^'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: List of Application Scopes that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] updated_at: The date of the last modification of the role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `Role` resource manages your roles within Aqua.

        The roles created must have permission set and at least one Role Application Scope that is already present within Aqua.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        ia_c = aquasec.Role("iaC",
            description="RoleIaC",
            permission="PermissionIaC",
            role_name="RoleIaC",
            scopes=["Global"])
        ```

        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            __props__.__dict__["description"] = description
            if permission is None and not opts.urn:
                raise TypeError("Missing required property 'permission'")
            __props__.__dict__["permission"] = permission
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["updated_at"] = updated_at
            __props__.__dict__["author"] = None
        super(Role, __self__).__init__(
            'aquasec:index/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            permission: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author: The name of the user who created the role. Only returned from the API for existing permissions, not part of the permission creation/modification structure.
        :param pulumi.Input[str] description: Free text description for the role.
        :param pulumi.Input[str] permission: The name of the Permission Set that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] role_name: The name of the role, comprised of alphanumeric characters and '-', '_', ' ', ':', '.', '@', '!', '^'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: List of Application Scopes that will affect the users assigned to this specific Role.
        :param pulumi.Input[str] updated_at: The date of the last modification of the role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["author"] = author
        __props__.__dict__["description"] = description
        __props__.__dict__["permission"] = permission
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["updated_at"] = updated_at
        return Role(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        The name of the user who created the role. Only returned from the API for existing permissions, not part of the permission creation/modification structure.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Free text description for the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output[str]:
        """
        The name of the Permission Set that will affect the users assigned to this specific Role.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[str]:
        """
        The name of the role, comprised of alphanumeric characters and '-', '_', ' ', ':', '.', '@', '!', '^'.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        List of Application Scopes that will affect the users assigned to this specific Role.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date of the last modification of the role.
        """
        return pulumi.get(self, "updated_at")

