"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const messaging_function_1 = require("../resources/messaging/messaging-function");
class MessagingResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const MessagingResourceProvider = new custom_resources_1.Provider(this, 'MessagingResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.messagingCustomResource = new aws_cdk_lib_1.CustomResource(this, 'messagingCustomResource', {
            serviceToken: MessagingResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        const constructName = 'MessagingResources';
        const existing = stack.node.tryFindChild(constructName);
        /* istanbul ignore next */
        if (existing) {
            return existing;
        }
        const messagingCustomResourceRole = new aws_iam_1.Role(this, 'messagingCustomResourceRole', {
            description: 'Amazon Chime SDK Messaging Resources',
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateAppInstance',
                                'chime:CreateChannelFlow',
                                'chime:DeleteChannelFlow',
                                'chime:DescribeAppInstance',
                                'chime:ListAppInstances',
                                'chime:UpdateAppInstance',
                                'chime:DeleteAppInstance',
                                'chime:CreateAppInstanceUser',
                                'chime:DeleteAppInstanceUser',
                                'chime:ListAppInstanceUsers',
                                'chime:UpdateAppInstanceUser',
                                'chime:DescribeAppInstanceUser',
                                'chime:CreateAppInstanceAdmin',
                                'chime:DescribeAppInstanceAdmin',
                                'chime:ListAppInstanceAdmins',
                                'chime:DeleteAppInstanceAdmin',
                                'chime:PutAppInstanceRetentionSettings',
                                'chime:GetAppInstanceRetentionSettings',
                                'chime:PutAppInstanceStreamingConfigurations',
                                'chime:GetAppInstanceStreamingConfigurations',
                                'chime:DeleteAppInstanceStreamingConfigurations',
                                'chime:TagResource',
                                'chime:UntagResource',
                                'chime:ListTagsForResource',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                    ],
                }),
                ['kinesisPolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:kinesis:${stack.region}:${stack.account}:stream/chime-messaging-*`,
                            ],
                            actions: ['kinesis:DescribeStream'],
                        }),
                    ],
                }),
                ['ssmPolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new messaging_function_1.MessagingFunction(this, 'messagingResourcesFunction', {
            role: messagingCustomResourceRole,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        // const fn = new NodejsFunction(this, 'messagingResourcesFunction', {
        //   entry: 'src/resources/messaging/index.ts',
        //   handler: 'handler',
        //   runtime: Runtime.NODEJS_18_X,
        //   architecture: Architecture.ARM_64,
        //   role: messagingCustomResourceRole,
        //   timeout: Duration.seconds(60),
        // });
        return fn;
    }
}
exports.MessagingResources = MessagingResources;
_a = JSII_RTTI_SYMBOL_1;
MessagingResources[_a] = { fqn: "cdk-amazon-chime-resources.MessagingResources", version: "2.2.1" };
//# sourceMappingURL=data:application/json;base64,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