"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const mediaInsightsPipeline_1 = require("./mediaInsightsPipeline");
const response = {};
let resourcePropertiesUid;
let requestProperties;
exports.handler = async (event, context) => {
    console.info('event: ', JSON.stringify(event));
    const resourceType = event.ResourceProperties.resourceType;
    const requestType = event.RequestType;
    resourcePropertiesUid = event.ResourceProperties.uid;
    requestProperties = event.ResourceProperties.properties;
    response.StackId = event.StackId;
    response.RequestId = event.RequestId;
    response.LogicalResourceId = event.LogicalResourceId;
    response.PhysicalResourceId = context.logGroupName;
    switch (resourceType) {
        case 'MediaPipelineInsights':
            switch (requestType) {
                case 'Create':
                    response.Data = await mediaInsightsPipeline_1.CreateMediaInsightsPipelineConfiguration(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason =
                        'CreateMediaInsightsPipelineConfiguration successful';
                    break;
                case 'Update':
                    response.Data = await mediaInsightsPipeline_1.UpdateMediaInsightsPipelineConfiguration(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason =
                        'UpdateMediaInsightsPipelineConfiguration successful';
                    break;
                case 'Delete':
                    await mediaInsightsPipeline_1.DeleteMediaInsightsPipelineConfiguration(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason =
                        'DeleteMediaInsightsPipelineConfiguration successful';
                    break;
            }
    }
    console.log(`Response: ${JSON.stringify(response)}`);
    return response;
};
//# sourceMappingURL=data:application/json;base64,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