"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSDKMediaPipelines = void 0;
const ChimeSDKMediaPipelinesClient_1 = require("./ChimeSDKMediaPipelinesClient");
const CreateMediaCapturePipelineCommand_1 = require("./commands/CreateMediaCapturePipelineCommand");
const CreateMediaConcatenationPipelineCommand_1 = require("./commands/CreateMediaConcatenationPipelineCommand");
const CreateMediaInsightsPipelineCommand_1 = require("./commands/CreateMediaInsightsPipelineCommand");
const CreateMediaInsightsPipelineConfigurationCommand_1 = require("./commands/CreateMediaInsightsPipelineConfigurationCommand");
const CreateMediaLiveConnectorPipelineCommand_1 = require("./commands/CreateMediaLiveConnectorPipelineCommand");
const DeleteMediaCapturePipelineCommand_1 = require("./commands/DeleteMediaCapturePipelineCommand");
const DeleteMediaInsightsPipelineConfigurationCommand_1 = require("./commands/DeleteMediaInsightsPipelineConfigurationCommand");
const DeleteMediaPipelineCommand_1 = require("./commands/DeleteMediaPipelineCommand");
const GetMediaCapturePipelineCommand_1 = require("./commands/GetMediaCapturePipelineCommand");
const GetMediaInsightsPipelineConfigurationCommand_1 = require("./commands/GetMediaInsightsPipelineConfigurationCommand");
const GetMediaPipelineCommand_1 = require("./commands/GetMediaPipelineCommand");
const ListMediaCapturePipelinesCommand_1 = require("./commands/ListMediaCapturePipelinesCommand");
const ListMediaInsightsPipelineConfigurationsCommand_1 = require("./commands/ListMediaInsightsPipelineConfigurationsCommand");
const ListMediaPipelinesCommand_1 = require("./commands/ListMediaPipelinesCommand");
const ListTagsForResourceCommand_1 = require("./commands/ListTagsForResourceCommand");
const TagResourceCommand_1 = require("./commands/TagResourceCommand");
const UntagResourceCommand_1 = require("./commands/UntagResourceCommand");
const UpdateMediaInsightsPipelineConfigurationCommand_1 = require("./commands/UpdateMediaInsightsPipelineConfigurationCommand");
const UpdateMediaInsightsPipelineStatusCommand_1 = require("./commands/UpdateMediaInsightsPipelineStatusCommand");
class ChimeSDKMediaPipelines extends ChimeSDKMediaPipelinesClient_1.ChimeSDKMediaPipelinesClient {
    createMediaCapturePipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaCapturePipelineCommand_1.CreateMediaCapturePipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaConcatenationPipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaConcatenationPipelineCommand_1.CreateMediaConcatenationPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaInsightsPipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaInsightsPipelineCommand_1.CreateMediaInsightsPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new CreateMediaInsightsPipelineConfigurationCommand_1.CreateMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaLiveConnectorPipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaLiveConnectorPipelineCommand_1.CreateMediaLiveConnectorPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteMediaCapturePipeline(args, optionsOrCb, cb) {
        const command = new DeleteMediaCapturePipelineCommand_1.DeleteMediaCapturePipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new DeleteMediaInsightsPipelineConfigurationCommand_1.DeleteMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteMediaPipeline(args, optionsOrCb, cb) {
        const command = new DeleteMediaPipelineCommand_1.DeleteMediaPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getMediaCapturePipeline(args, optionsOrCb, cb) {
        const command = new GetMediaCapturePipelineCommand_1.GetMediaCapturePipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new GetMediaInsightsPipelineConfigurationCommand_1.GetMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getMediaPipeline(args, optionsOrCb, cb) {
        const command = new GetMediaPipelineCommand_1.GetMediaPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listMediaCapturePipelines(args, optionsOrCb, cb) {
        const command = new ListMediaCapturePipelinesCommand_1.ListMediaCapturePipelinesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listMediaInsightsPipelineConfigurations(args, optionsOrCb, cb) {
        const command = new ListMediaInsightsPipelineConfigurationsCommand_1.ListMediaInsightsPipelineConfigurationsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listMediaPipelines(args, optionsOrCb, cb) {
        const command = new ListMediaPipelinesCommand_1.ListMediaPipelinesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listTagsForResource(args, optionsOrCb, cb) {
        const command = new ListTagsForResourceCommand_1.ListTagsForResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    tagResource(args, optionsOrCb, cb) {
        const command = new TagResourceCommand_1.TagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    untagResource(args, optionsOrCb, cb) {
        const command = new UntagResourceCommand_1.UntagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new UpdateMediaInsightsPipelineConfigurationCommand_1.UpdateMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateMediaInsightsPipelineStatus(args, optionsOrCb, cb) {
        const command = new UpdateMediaInsightsPipelineStatusCommand_1.UpdateMediaInsightsPipelineStatusCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
}
exports.ChimeSDKMediaPipelines = ChimeSDKMediaPipelines;
