"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deserializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand = exports.deserializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand = exports.deserializeAws_restJson1UntagResourceCommand = exports.deserializeAws_restJson1TagResourceCommand = exports.deserializeAws_restJson1ListTagsForResourceCommand = exports.deserializeAws_restJson1ListMediaPipelinesCommand = exports.deserializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand = exports.deserializeAws_restJson1ListMediaCapturePipelinesCommand = exports.deserializeAws_restJson1GetMediaPipelineCommand = exports.deserializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand = exports.deserializeAws_restJson1GetMediaCapturePipelineCommand = exports.deserializeAws_restJson1DeleteMediaPipelineCommand = exports.deserializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand = exports.deserializeAws_restJson1DeleteMediaCapturePipelineCommand = exports.deserializeAws_restJson1CreateMediaLiveConnectorPipelineCommand = exports.deserializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand = exports.deserializeAws_restJson1CreateMediaInsightsPipelineCommand = exports.deserializeAws_restJson1CreateMediaConcatenationPipelineCommand = exports.deserializeAws_restJson1CreateMediaCapturePipelineCommand = exports.serializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand = exports.serializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand = exports.serializeAws_restJson1UntagResourceCommand = exports.serializeAws_restJson1TagResourceCommand = exports.serializeAws_restJson1ListTagsForResourceCommand = exports.serializeAws_restJson1ListMediaPipelinesCommand = exports.serializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand = exports.serializeAws_restJson1ListMediaCapturePipelinesCommand = exports.serializeAws_restJson1GetMediaPipelineCommand = exports.serializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand = exports.serializeAws_restJson1GetMediaCapturePipelineCommand = exports.serializeAws_restJson1DeleteMediaPipelineCommand = exports.serializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand = exports.serializeAws_restJson1DeleteMediaCapturePipelineCommand = exports.serializeAws_restJson1CreateMediaLiveConnectorPipelineCommand = exports.serializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand = exports.serializeAws_restJson1CreateMediaInsightsPipelineCommand = exports.serializeAws_restJson1CreateMediaConcatenationPipelineCommand = exports.serializeAws_restJson1CreateMediaCapturePipelineCommand = void 0;
const protocol_http_1 = require("@aws-sdk/protocol-http");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const uuid_1 = require("uuid");
const ChimeSDKMediaPipelinesServiceException_1 = require("../models/ChimeSDKMediaPipelinesServiceException");
const models_0_1 = require("../models/models_0");
const serializeAws_restJson1CreateMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-capture-pipelines";
    let body;
    body = JSON.stringify({
        ...(input.ChimeSdkMeetingConfiguration != null && {
            ChimeSdkMeetingConfiguration: serializeAws_restJson1ChimeSdkMeetingConfiguration(input.ChimeSdkMeetingConfiguration, context),
        }),
        ClientRequestToken: input.ClientRequestToken ?? (0, uuid_1.v4)(),
        ...(input.SinkArn != null && { SinkArn: input.SinkArn }),
        ...(input.SinkType != null && { SinkType: input.SinkType }),
        ...(input.SourceArn != null && { SourceArn: input.SourceArn }),
        ...(input.SourceType != null && { SourceType: input.SourceType }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1CreateMediaCapturePipelineCommand = serializeAws_restJson1CreateMediaCapturePipelineCommand;
const serializeAws_restJson1CreateMediaConcatenationPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-concatenation-pipelines";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? (0, uuid_1.v4)(),
        ...(input.Sinks != null && { Sinks: serializeAws_restJson1ConcatenationSinkList(input.Sinks, context) }),
        ...(input.Sources != null && { Sources: serializeAws_restJson1ConcatenationSourceList(input.Sources, context) }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1CreateMediaConcatenationPipelineCommand = serializeAws_restJson1CreateMediaConcatenationPipelineCommand;
const serializeAws_restJson1CreateMediaInsightsPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipelines";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? (0, uuid_1.v4)(),
        ...(input.KinesisVideoStreamRecordingSourceRuntimeConfiguration != null && {
            KinesisVideoStreamRecordingSourceRuntimeConfiguration: serializeAws_restJson1KinesisVideoStreamRecordingSourceRuntimeConfiguration(input.KinesisVideoStreamRecordingSourceRuntimeConfiguration, context),
        }),
        ...(input.KinesisVideoStreamSourceRuntimeConfiguration != null && {
            KinesisVideoStreamSourceRuntimeConfiguration: serializeAws_restJson1KinesisVideoStreamSourceRuntimeConfiguration(input.KinesisVideoStreamSourceRuntimeConfiguration, context),
        }),
        ...(input.MediaInsightsPipelineConfigurationArn != null && {
            MediaInsightsPipelineConfigurationArn: input.MediaInsightsPipelineConfigurationArn,
        }),
        ...(input.MediaInsightsRuntimeMetadata != null && {
            MediaInsightsRuntimeMetadata: serializeAws_restJson1MediaInsightsRuntimeMetadata(input.MediaInsightsRuntimeMetadata, context),
        }),
        ...(input.S3RecordingSinkRuntimeConfiguration != null && {
            S3RecordingSinkRuntimeConfiguration: serializeAws_restJson1S3RecordingSinkRuntimeConfiguration(input.S3RecordingSinkRuntimeConfiguration, context),
        }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1CreateMediaInsightsPipelineCommand = serializeAws_restJson1CreateMediaInsightsPipelineCommand;
const serializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipeline-configurations";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? (0, uuid_1.v4)(),
        ...(input.Elements != null && {
            Elements: serializeAws_restJson1MediaInsightsPipelineConfigurationElements(input.Elements, context),
        }),
        ...(input.MediaInsightsPipelineConfigurationName != null && {
            MediaInsightsPipelineConfigurationName: input.MediaInsightsPipelineConfigurationName,
        }),
        ...(input.RealTimeAlertConfiguration != null && {
            RealTimeAlertConfiguration: serializeAws_restJson1RealTimeAlertConfiguration(input.RealTimeAlertConfiguration, context),
        }),
        ...(input.ResourceAccessRoleArn != null && { ResourceAccessRoleArn: input.ResourceAccessRoleArn }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand = serializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand;
const serializeAws_restJson1CreateMediaLiveConnectorPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-live-connector-pipelines";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? (0, uuid_1.v4)(),
        ...(input.Sinks != null && { Sinks: serializeAws_restJson1LiveConnectorSinkList(input.Sinks, context) }),
        ...(input.Sources != null && { Sources: serializeAws_restJson1LiveConnectorSourceList(input.Sources, context) }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1CreateMediaLiveConnectorPipelineCommand = serializeAws_restJson1CreateMediaLiveConnectorPipelineCommand;
const serializeAws_restJson1DeleteMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sdk-media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1DeleteMediaCapturePipelineCommand = serializeAws_restJson1DeleteMediaCapturePipelineCommand;
const serializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand = serializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand;
const serializeAws_restJson1DeleteMediaPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1DeleteMediaPipelineCommand = serializeAws_restJson1DeleteMediaPipelineCommand;
const serializeAws_restJson1GetMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sdk-media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1GetMediaCapturePipelineCommand = serializeAws_restJson1GetMediaCapturePipelineCommand;
const serializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand = serializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand;
const serializeAws_restJson1GetMediaPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1GetMediaPipelineCommand = serializeAws_restJson1GetMediaPipelineCommand;
const serializeAws_restJson1ListMediaCapturePipelinesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-capture-pipelines";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.serializeAws_restJson1ListMediaCapturePipelinesCommand = serializeAws_restJson1ListMediaCapturePipelinesCommand;
const serializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipeline-configurations";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.serializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand = serializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand;
const serializeAws_restJson1ListMediaPipelinesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.serializeAws_restJson1ListMediaPipelinesCommand = serializeAws_restJson1ListMediaPipelinesCommand;
const serializeAws_restJson1ListTagsForResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        arn: [, (0, smithy_client_1.expectNonNull)(input.ResourceARN, `ResourceARN`)],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.serializeAws_restJson1ListTagsForResourceCommand = serializeAws_restJson1ListTagsForResourceCommand;
const serializeAws_restJson1TagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "tag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.serializeAws_restJson1TagResourceCommand = serializeAws_restJson1TagResourceCommand;
const serializeAws_restJson1UntagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "untag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.TagKeys != null && { TagKeys: serializeAws_restJson1TagKeyList(input.TagKeys, context) }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.serializeAws_restJson1UntagResourceCommand = serializeAws_restJson1UntagResourceCommand;
const serializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    body = JSON.stringify({
        ...(input.Elements != null && {
            Elements: serializeAws_restJson1MediaInsightsPipelineConfigurationElements(input.Elements, context),
        }),
        ...(input.RealTimeAlertConfiguration != null && {
            RealTimeAlertConfiguration: serializeAws_restJson1RealTimeAlertConfiguration(input.RealTimeAlertConfiguration, context),
        }),
        ...(input.ResourceAccessRoleArn != null && { ResourceAccessRoleArn: input.ResourceAccessRoleArn }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand = serializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand;
const serializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-status/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    body = JSON.stringify({
        ...(input.UpdateStatus != null && { UpdateStatus: input.UpdateStatus }),
    });
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.serializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand = serializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand;
const deserializeAws_restJson1CreateMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipeline != null) {
        contents.MediaCapturePipeline = deserializeAws_restJson1MediaCapturePipeline(data.MediaCapturePipeline, context);
    }
    return contents;
};
exports.deserializeAws_restJson1CreateMediaCapturePipelineCommand = deserializeAws_restJson1CreateMediaCapturePipelineCommand;
const deserializeAws_restJson1CreateMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1CreateMediaConcatenationPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMediaConcatenationPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaConcatenationPipeline != null) {
        contents.MediaConcatenationPipeline = deserializeAws_restJson1MediaConcatenationPipeline(data.MediaConcatenationPipeline, context);
    }
    return contents;
};
exports.deserializeAws_restJson1CreateMediaConcatenationPipelineCommand = deserializeAws_restJson1CreateMediaConcatenationPipelineCommand;
const deserializeAws_restJson1CreateMediaConcatenationPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1CreateMediaInsightsPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMediaInsightsPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipeline != null) {
        contents.MediaInsightsPipeline = deserializeAws_restJson1MediaInsightsPipeline(data.MediaInsightsPipeline, context);
    }
    return contents;
};
exports.deserializeAws_restJson1CreateMediaInsightsPipelineCommand = deserializeAws_restJson1CreateMediaInsightsPipelineCommand;
const deserializeAws_restJson1CreateMediaInsightsPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfiguration != null) {
        contents.MediaInsightsPipelineConfiguration = deserializeAws_restJson1MediaInsightsPipelineConfiguration(data.MediaInsightsPipelineConfiguration, context);
    }
    return contents;
};
exports.deserializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand = deserializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommand;
const deserializeAws_restJson1CreateMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1CreateMediaLiveConnectorPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMediaLiveConnectorPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaLiveConnectorPipeline != null) {
        contents.MediaLiveConnectorPipeline = deserializeAws_restJson1MediaLiveConnectorPipeline(data.MediaLiveConnectorPipeline, context);
    }
    return contents;
};
exports.deserializeAws_restJson1CreateMediaLiveConnectorPipelineCommand = deserializeAws_restJson1CreateMediaLiveConnectorPipelineCommand;
const deserializeAws_restJson1CreateMediaLiveConnectorPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1DeleteMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
exports.deserializeAws_restJson1DeleteMediaCapturePipelineCommand = deserializeAws_restJson1DeleteMediaCapturePipelineCommand;
const deserializeAws_restJson1DeleteMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
exports.deserializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand = deserializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommand;
const deserializeAws_restJson1DeleteMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1DeleteMediaPipelineCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteMediaPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
exports.deserializeAws_restJson1DeleteMediaPipelineCommand = deserializeAws_restJson1DeleteMediaPipelineCommand;
const deserializeAws_restJson1DeleteMediaPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1GetMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipeline != null) {
        contents.MediaCapturePipeline = deserializeAws_restJson1MediaCapturePipeline(data.MediaCapturePipeline, context);
    }
    return contents;
};
exports.deserializeAws_restJson1GetMediaCapturePipelineCommand = deserializeAws_restJson1GetMediaCapturePipelineCommand;
const deserializeAws_restJson1GetMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfiguration != null) {
        contents.MediaInsightsPipelineConfiguration = deserializeAws_restJson1MediaInsightsPipelineConfiguration(data.MediaInsightsPipelineConfiguration, context);
    }
    return contents;
};
exports.deserializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand = deserializeAws_restJson1GetMediaInsightsPipelineConfigurationCommand;
const deserializeAws_restJson1GetMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1GetMediaPipelineCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMediaPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaPipeline != null) {
        contents.MediaPipeline = deserializeAws_restJson1MediaPipeline(data.MediaPipeline, context);
    }
    return contents;
};
exports.deserializeAws_restJson1GetMediaPipelineCommand = deserializeAws_restJson1GetMediaPipelineCommand;
const deserializeAws_restJson1GetMediaPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1ListMediaCapturePipelinesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListMediaCapturePipelinesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipelines != null) {
        contents.MediaCapturePipelines = deserializeAws_restJson1MediaCapturePipelineSummaryList(data.MediaCapturePipelines, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = (0, smithy_client_1.expectString)(data.NextToken);
    }
    return contents;
};
exports.deserializeAws_restJson1ListMediaCapturePipelinesCommand = deserializeAws_restJson1ListMediaCapturePipelinesCommand;
const deserializeAws_restJson1ListMediaCapturePipelinesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfigurations != null) {
        contents.MediaInsightsPipelineConfigurations =
            deserializeAws_restJson1MediaInsightsPipelineConfigurationSummaryList(data.MediaInsightsPipelineConfigurations, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = (0, smithy_client_1.expectString)(data.NextToken);
    }
    return contents;
};
exports.deserializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand = deserializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommand;
const deserializeAws_restJson1ListMediaInsightsPipelineConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1ListMediaPipelinesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListMediaPipelinesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaPipelines != null) {
        contents.MediaPipelines = deserializeAws_restJson1MediaPipelineList(data.MediaPipelines, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = (0, smithy_client_1.expectString)(data.NextToken);
    }
    return contents;
};
exports.deserializeAws_restJson1ListMediaPipelinesCommand = deserializeAws_restJson1ListMediaPipelinesCommand;
const deserializeAws_restJson1ListMediaPipelinesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListTagsForResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.Tags != null) {
        contents.Tags = deserializeAws_restJson1TagList(data.Tags, context);
    }
    return contents;
};
exports.deserializeAws_restJson1ListTagsForResourceCommand = deserializeAws_restJson1ListTagsForResourceCommand;
const deserializeAws_restJson1ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1TagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
exports.deserializeAws_restJson1TagResourceCommand = deserializeAws_restJson1TagResourceCommand;
const deserializeAws_restJson1TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UntagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
exports.deserializeAws_restJson1UntagResourceCommand = deserializeAws_restJson1UntagResourceCommand;
const deserializeAws_restJson1UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfiguration != null) {
        contents.MediaInsightsPipelineConfiguration = deserializeAws_restJson1MediaInsightsPipelineConfiguration(data.MediaInsightsPipelineConfiguration, context);
    }
    return contents;
};
exports.deserializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand = deserializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommand;
const deserializeAws_restJson1UpdateMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const deserializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateMediaInsightsPipelineStatusCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
exports.deserializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand = deserializeAws_restJson1UpdateMediaInsightsPipelineStatusCommand;
const deserializeAws_restJson1UpdateMediaInsightsPipelineStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            (0, smithy_client_1.throwDefaultError)({
                output,
                parsedBody,
                exceptionCtor: ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException,
                errorCode,
            });
    }
};
const map = smithy_client_1.map;
const deserializeAws_restJson1BadRequestExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1ConflictExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1ForbiddenExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.ForbiddenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1NotFoundExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1ResourceLimitExceededExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1ServiceFailureExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.ServiceFailureException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1ServiceUnavailableExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1ThrottledClientExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.ThrottledClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const deserializeAws_restJson1UnauthorizedClientExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = (0, smithy_client_1.expectString)(data.Code);
    }
    if (data.Message != null) {
        contents.Message = (0, smithy_client_1.expectString)(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = (0, smithy_client_1.expectString)(data.RequestId);
    }
    const exception = new models_0_1.UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const serializeAws_restJson1AmazonTranscribeCallAnalyticsProcessorConfiguration = (input, context) => {
    return {
        ...(input.CallAnalyticsStreamCategories != null && {
            CallAnalyticsStreamCategories: serializeAws_restJson1CategoryNameList(input.CallAnalyticsStreamCategories, context),
        }),
        ...(input.ContentIdentificationType != null && { ContentIdentificationType: input.ContentIdentificationType }),
        ...(input.ContentRedactionType != null && { ContentRedactionType: input.ContentRedactionType }),
        ...(input.EnablePartialResultsStabilization != null && {
            EnablePartialResultsStabilization: input.EnablePartialResultsStabilization,
        }),
        ...(input.FilterPartialResults != null && { FilterPartialResults: input.FilterPartialResults }),
        ...(input.LanguageCode != null && { LanguageCode: input.LanguageCode }),
        ...(input.LanguageModelName != null && { LanguageModelName: input.LanguageModelName }),
        ...(input.PartialResultsStability != null && { PartialResultsStability: input.PartialResultsStability }),
        ...(input.PiiEntityTypes != null && { PiiEntityTypes: input.PiiEntityTypes }),
        ...(input.PostCallAnalyticsSettings != null && {
            PostCallAnalyticsSettings: serializeAws_restJson1PostCallAnalyticsSettings(input.PostCallAnalyticsSettings, context),
        }),
        ...(input.VocabularyFilterMethod != null && { VocabularyFilterMethod: input.VocabularyFilterMethod }),
        ...(input.VocabularyFilterName != null && { VocabularyFilterName: input.VocabularyFilterName }),
        ...(input.VocabularyName != null && { VocabularyName: input.VocabularyName }),
    };
};
const serializeAws_restJson1AmazonTranscribeProcessorConfiguration = (input, context) => {
    return {
        ...(input.ContentIdentificationType != null && { ContentIdentificationType: input.ContentIdentificationType }),
        ...(input.ContentRedactionType != null && { ContentRedactionType: input.ContentRedactionType }),
        ...(input.EnablePartialResultsStabilization != null && {
            EnablePartialResultsStabilization: input.EnablePartialResultsStabilization,
        }),
        ...(input.FilterPartialResults != null && { FilterPartialResults: input.FilterPartialResults }),
        ...(input.LanguageCode != null && { LanguageCode: input.LanguageCode }),
        ...(input.LanguageModelName != null && { LanguageModelName: input.LanguageModelName }),
        ...(input.PartialResultsStability != null && { PartialResultsStability: input.PartialResultsStability }),
        ...(input.PiiEntityTypes != null && { PiiEntityTypes: input.PiiEntityTypes }),
        ...(input.ShowSpeakerLabel != null && { ShowSpeakerLabel: input.ShowSpeakerLabel }),
        ...(input.VocabularyFilterMethod != null && { VocabularyFilterMethod: input.VocabularyFilterMethod }),
        ...(input.VocabularyFilterName != null && { VocabularyFilterName: input.VocabularyFilterName }),
        ...(input.VocabularyName != null && { VocabularyName: input.VocabularyName }),
    };
};
const serializeAws_restJson1ArtifactsConcatenationConfiguration = (input, context) => {
    return {
        ...(input.Audio != null && { Audio: serializeAws_restJson1AudioConcatenationConfiguration(input.Audio, context) }),
        ...(input.CompositedVideo != null && {
            CompositedVideo: serializeAws_restJson1CompositedVideoConcatenationConfiguration(input.CompositedVideo, context),
        }),
        ...(input.Content != null && {
            Content: serializeAws_restJson1ContentConcatenationConfiguration(input.Content, context),
        }),
        ...(input.DataChannel != null && {
            DataChannel: serializeAws_restJson1DataChannelConcatenationConfiguration(input.DataChannel, context),
        }),
        ...(input.MeetingEvents != null && {
            MeetingEvents: serializeAws_restJson1MeetingEventsConcatenationConfiguration(input.MeetingEvents, context),
        }),
        ...(input.TranscriptionMessages != null && {
            TranscriptionMessages: serializeAws_restJson1TranscriptionMessagesConcatenationConfiguration(input.TranscriptionMessages, context),
        }),
        ...(input.Video != null && { Video: serializeAws_restJson1VideoConcatenationConfiguration(input.Video, context) }),
    };
};
const serializeAws_restJson1ArtifactsConfiguration = (input, context) => {
    return {
        ...(input.Audio != null && { Audio: serializeAws_restJson1AudioArtifactsConfiguration(input.Audio, context) }),
        ...(input.CompositedVideo != null && {
            CompositedVideo: serializeAws_restJson1CompositedVideoArtifactsConfiguration(input.CompositedVideo, context),
        }),
        ...(input.Content != null && {
            Content: serializeAws_restJson1ContentArtifactsConfiguration(input.Content, context),
        }),
        ...(input.Video != null && { Video: serializeAws_restJson1VideoArtifactsConfiguration(input.Video, context) }),
    };
};
const serializeAws_restJson1AttendeeIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1AudioArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
    };
};
const serializeAws_restJson1AudioConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1CategoryNameList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1ChannelDefinition = (input, context) => {
    return {
        ...(input.ChannelId != null && { ChannelId: input.ChannelId }),
        ...(input.ParticipantRole != null && { ParticipantRole: input.ParticipantRole }),
    };
};
const serializeAws_restJson1ChannelDefinitions = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1ChannelDefinition(entry, context);
    });
};
const serializeAws_restJson1ChimeSdkMeetingConcatenationConfiguration = (input, context) => {
    return {
        ...(input.ArtifactsConfiguration != null && {
            ArtifactsConfiguration: serializeAws_restJson1ArtifactsConcatenationConfiguration(input.ArtifactsConfiguration, context),
        }),
    };
};
const serializeAws_restJson1ChimeSdkMeetingConfiguration = (input, context) => {
    return {
        ...(input.ArtifactsConfiguration != null && {
            ArtifactsConfiguration: serializeAws_restJson1ArtifactsConfiguration(input.ArtifactsConfiguration, context),
        }),
        ...(input.SourceConfiguration != null && {
            SourceConfiguration: serializeAws_restJson1SourceConfiguration(input.SourceConfiguration, context),
        }),
    };
};
const serializeAws_restJson1ChimeSdkMeetingLiveConnectorConfiguration = (input, context) => {
    return {
        ...(input.Arn != null && { Arn: input.Arn }),
        ...(input.CompositedVideo != null && {
            CompositedVideo: serializeAws_restJson1CompositedVideoArtifactsConfiguration(input.CompositedVideo, context),
        }),
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.SourceConfiguration != null && {
            SourceConfiguration: serializeAws_restJson1SourceConfiguration(input.SourceConfiguration, context),
        }),
    };
};
const serializeAws_restJson1CompositedVideoArtifactsConfiguration = (input, context) => {
    return {
        ...(input.GridViewConfiguration != null && {
            GridViewConfiguration: serializeAws_restJson1GridViewConfiguration(input.GridViewConfiguration, context),
        }),
        ...(input.Layout != null && { Layout: input.Layout }),
        ...(input.Resolution != null && { Resolution: input.Resolution }),
    };
};
const serializeAws_restJson1CompositedVideoConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1ConcatenationSink = (input, context) => {
    return {
        ...(input.S3BucketSinkConfiguration != null && {
            S3BucketSinkConfiguration: serializeAws_restJson1S3BucketSinkConfiguration(input.S3BucketSinkConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
    };
};
const serializeAws_restJson1ConcatenationSinkList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1ConcatenationSink(entry, context);
    });
};
const serializeAws_restJson1ConcatenationSource = (input, context) => {
    return {
        ...(input.MediaCapturePipelineSourceConfiguration != null && {
            MediaCapturePipelineSourceConfiguration: serializeAws_restJson1MediaCapturePipelineSourceConfiguration(input.MediaCapturePipelineSourceConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
    };
};
const serializeAws_restJson1ConcatenationSourceList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1ConcatenationSource(entry, context);
    });
};
const serializeAws_restJson1ContentArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1ContentConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1DataChannelConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1ExternalUserIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1FragmentSelector = (input, context) => {
    return {
        ...(input.FragmentSelectorType != null && { FragmentSelectorType: input.FragmentSelectorType }),
        ...(input.TimestampRange != null && {
            TimestampRange: serializeAws_restJson1TimestampRange(input.TimestampRange, context),
        }),
    };
};
const serializeAws_restJson1GridViewConfiguration = (input, context) => {
    return {
        ...(input.ContentShareLayout != null && { ContentShareLayout: input.ContentShareLayout }),
        ...(input.PresenterOnlyConfiguration != null && {
            PresenterOnlyConfiguration: serializeAws_restJson1PresenterOnlyConfiguration(input.PresenterOnlyConfiguration, context),
        }),
    };
};
const serializeAws_restJson1IssueDetectionConfiguration = (input, context) => {
    return {
        ...(input.RuleName != null && { RuleName: input.RuleName }),
    };
};
const serializeAws_restJson1KeywordMatchConfiguration = (input, context) => {
    return {
        ...(input.Keywords != null && { Keywords: serializeAws_restJson1KeywordMatchWordList(input.Keywords, context) }),
        ...(input.Negate != null && { Negate: input.Negate }),
        ...(input.RuleName != null && { RuleName: input.RuleName }),
    };
};
const serializeAws_restJson1KeywordMatchWordList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1KinesisDataStreamSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const serializeAws_restJson1KinesisVideoStreamRecordingSourceRuntimeConfiguration = (input, context) => {
    return {
        ...(input.FragmentSelector != null && {
            FragmentSelector: serializeAws_restJson1FragmentSelector(input.FragmentSelector, context),
        }),
        ...(input.Streams != null && { Streams: serializeAws_restJson1RecordingStreamList(input.Streams, context) }),
    };
};
const serializeAws_restJson1KinesisVideoStreamSourceRuntimeConfiguration = (input, context) => {
    return {
        ...(input.MediaEncoding != null && { MediaEncoding: input.MediaEncoding }),
        ...(input.MediaSampleRate != null && { MediaSampleRate: input.MediaSampleRate }),
        ...(input.Streams != null && { Streams: serializeAws_restJson1Streams(input.Streams, context) }),
    };
};
const serializeAws_restJson1LambdaFunctionSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const serializeAws_restJson1LiveConnectorRTMPConfiguration = (input, context) => {
    return {
        ...(input.AudioChannels != null && { AudioChannels: input.AudioChannels }),
        ...(input.AudioSampleRate != null && { AudioSampleRate: input.AudioSampleRate }),
        ...(input.Url != null && { Url: input.Url }),
    };
};
const serializeAws_restJson1LiveConnectorSinkConfiguration = (input, context) => {
    return {
        ...(input.RTMPConfiguration != null && {
            RTMPConfiguration: serializeAws_restJson1LiveConnectorRTMPConfiguration(input.RTMPConfiguration, context),
        }),
        ...(input.SinkType != null && { SinkType: input.SinkType }),
    };
};
const serializeAws_restJson1LiveConnectorSinkList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1LiveConnectorSinkConfiguration(entry, context);
    });
};
const serializeAws_restJson1LiveConnectorSourceConfiguration = (input, context) => {
    return {
        ...(input.ChimeSdkMeetingLiveConnectorConfiguration != null && {
            ChimeSdkMeetingLiveConnectorConfiguration: serializeAws_restJson1ChimeSdkMeetingLiveConnectorConfiguration(input.ChimeSdkMeetingLiveConnectorConfiguration, context),
        }),
        ...(input.SourceType != null && { SourceType: input.SourceType }),
    };
};
const serializeAws_restJson1LiveConnectorSourceList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1LiveConnectorSourceConfiguration(entry, context);
    });
};
const serializeAws_restJson1MediaCapturePipelineSourceConfiguration = (input, context) => {
    return {
        ...(input.ChimeSdkMeetingConfiguration != null && {
            ChimeSdkMeetingConfiguration: serializeAws_restJson1ChimeSdkMeetingConcatenationConfiguration(input.ChimeSdkMeetingConfiguration, context),
        }),
        ...(input.MediaPipelineArn != null && { MediaPipelineArn: input.MediaPipelineArn }),
    };
};
const serializeAws_restJson1MediaInsightsPipelineConfigurationElement = (input, context) => {
    return {
        ...(input.AmazonTranscribeCallAnalyticsProcessorConfiguration != null && {
            AmazonTranscribeCallAnalyticsProcessorConfiguration: serializeAws_restJson1AmazonTranscribeCallAnalyticsProcessorConfiguration(input.AmazonTranscribeCallAnalyticsProcessorConfiguration, context),
        }),
        ...(input.AmazonTranscribeProcessorConfiguration != null && {
            AmazonTranscribeProcessorConfiguration: serializeAws_restJson1AmazonTranscribeProcessorConfiguration(input.AmazonTranscribeProcessorConfiguration, context),
        }),
        ...(input.KinesisDataStreamSinkConfiguration != null && {
            KinesisDataStreamSinkConfiguration: serializeAws_restJson1KinesisDataStreamSinkConfiguration(input.KinesisDataStreamSinkConfiguration, context),
        }),
        ...(input.LambdaFunctionSinkConfiguration != null && {
            LambdaFunctionSinkConfiguration: serializeAws_restJson1LambdaFunctionSinkConfiguration(input.LambdaFunctionSinkConfiguration, context),
        }),
        ...(input.S3RecordingSinkConfiguration != null && {
            S3RecordingSinkConfiguration: serializeAws_restJson1S3RecordingSinkConfiguration(input.S3RecordingSinkConfiguration, context),
        }),
        ...(input.SnsTopicSinkConfiguration != null && {
            SnsTopicSinkConfiguration: serializeAws_restJson1SnsTopicSinkConfiguration(input.SnsTopicSinkConfiguration, context),
        }),
        ...(input.SqsQueueSinkConfiguration != null && {
            SqsQueueSinkConfiguration: serializeAws_restJson1SqsQueueSinkConfiguration(input.SqsQueueSinkConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
        ...(input.VoiceAnalyticsProcessorConfiguration != null && {
            VoiceAnalyticsProcessorConfiguration: serializeAws_restJson1VoiceAnalyticsProcessorConfiguration(input.VoiceAnalyticsProcessorConfiguration, context),
        }),
    };
};
const serializeAws_restJson1MediaInsightsPipelineConfigurationElements = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1MediaInsightsPipelineConfigurationElement(entry, context);
    });
};
const serializeAws_restJson1MediaInsightsRuntimeMetadata = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = value;
        return acc;
    }, {});
};
const serializeAws_restJson1MeetingEventsConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1PostCallAnalyticsSettings = (input, context) => {
    return {
        ...(input.ContentRedactionOutput != null && { ContentRedactionOutput: input.ContentRedactionOutput }),
        ...(input.DataAccessRoleArn != null && { DataAccessRoleArn: input.DataAccessRoleArn }),
        ...(input.OutputEncryptionKMSKeyId != null && { OutputEncryptionKMSKeyId: input.OutputEncryptionKMSKeyId }),
        ...(input.OutputLocation != null && { OutputLocation: input.OutputLocation }),
    };
};
const serializeAws_restJson1PresenterOnlyConfiguration = (input, context) => {
    return {
        ...(input.PresenterPosition != null && { PresenterPosition: input.PresenterPosition }),
    };
};
const serializeAws_restJson1RealTimeAlertConfiguration = (input, context) => {
    return {
        ...(input.Disabled != null && { Disabled: input.Disabled }),
        ...(input.Rules != null && { Rules: serializeAws_restJson1RealTimeAlertRuleList(input.Rules, context) }),
    };
};
const serializeAws_restJson1RealTimeAlertRule = (input, context) => {
    return {
        ...(input.IssueDetectionConfiguration != null && {
            IssueDetectionConfiguration: serializeAws_restJson1IssueDetectionConfiguration(input.IssueDetectionConfiguration, context),
        }),
        ...(input.KeywordMatchConfiguration != null && {
            KeywordMatchConfiguration: serializeAws_restJson1KeywordMatchConfiguration(input.KeywordMatchConfiguration, context),
        }),
        ...(input.SentimentConfiguration != null && {
            SentimentConfiguration: serializeAws_restJson1SentimentConfiguration(input.SentimentConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
    };
};
const serializeAws_restJson1RealTimeAlertRuleList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1RealTimeAlertRule(entry, context);
    });
};
const serializeAws_restJson1RecordingStreamConfiguration = (input, context) => {
    return {
        ...(input.StreamArn != null && { StreamArn: input.StreamArn }),
    };
};
const serializeAws_restJson1RecordingStreamList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1RecordingStreamConfiguration(entry, context);
    });
};
const serializeAws_restJson1S3BucketSinkConfiguration = (input, context) => {
    return {
        ...(input.Destination != null && { Destination: input.Destination }),
    };
};
const serializeAws_restJson1S3RecordingSinkConfiguration = (input, context) => {
    return {
        ...(input.Destination != null && { Destination: input.Destination }),
    };
};
const serializeAws_restJson1S3RecordingSinkRuntimeConfiguration = (input, context) => {
    return {
        ...(input.Destination != null && { Destination: input.Destination }),
        ...(input.RecordingFileFormat != null && { RecordingFileFormat: input.RecordingFileFormat }),
    };
};
const serializeAws_restJson1SelectedVideoStreams = (input, context) => {
    return {
        ...(input.AttendeeIds != null && { AttendeeIds: serializeAws_restJson1AttendeeIdList(input.AttendeeIds, context) }),
        ...(input.ExternalUserIds != null && {
            ExternalUserIds: serializeAws_restJson1ExternalUserIdList(input.ExternalUserIds, context),
        }),
    };
};
const serializeAws_restJson1SentimentConfiguration = (input, context) => {
    return {
        ...(input.RuleName != null && { RuleName: input.RuleName }),
        ...(input.SentimentType != null && { SentimentType: input.SentimentType }),
        ...(input.TimePeriod != null && { TimePeriod: input.TimePeriod }),
    };
};
const serializeAws_restJson1SnsTopicSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const serializeAws_restJson1SourceConfiguration = (input, context) => {
    return {
        ...(input.SelectedVideoStreams != null && {
            SelectedVideoStreams: serializeAws_restJson1SelectedVideoStreams(input.SelectedVideoStreams, context),
        }),
    };
};
const serializeAws_restJson1SqsQueueSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const serializeAws_restJson1StreamChannelDefinition = (input, context) => {
    return {
        ...(input.ChannelDefinitions != null && {
            ChannelDefinitions: serializeAws_restJson1ChannelDefinitions(input.ChannelDefinitions, context),
        }),
        ...(input.NumberOfChannels != null && { NumberOfChannels: input.NumberOfChannels }),
    };
};
const serializeAws_restJson1StreamConfiguration = (input, context) => {
    return {
        ...(input.FragmentNumber != null && { FragmentNumber: input.FragmentNumber }),
        ...(input.StreamArn != null && { StreamArn: input.StreamArn }),
        ...(input.StreamChannelDefinition != null && {
            StreamChannelDefinition: serializeAws_restJson1StreamChannelDefinition(input.StreamChannelDefinition, context),
        }),
    };
};
const serializeAws_restJson1Streams = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1StreamConfiguration(entry, context);
    });
};
const serializeAws_restJson1Tag = (input, context) => {
    return {
        ...(input.Key != null && { Key: input.Key }),
        ...(input.Value != null && { Value: input.Value }),
    };
};
const serializeAws_restJson1TagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1TagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1Tag(entry, context);
    });
};
const serializeAws_restJson1TimestampRange = (input, context) => {
    return {
        ...(input.EndTimestamp != null && { EndTimestamp: Math.round(input.EndTimestamp.getTime() / 1000) }),
        ...(input.StartTimestamp != null && { StartTimestamp: Math.round(input.StartTimestamp.getTime() / 1000) }),
    };
};
const serializeAws_restJson1TranscriptionMessagesConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1VideoArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1VideoConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1VoiceAnalyticsProcessorConfiguration = (input, context) => {
    return {
        ...(input.SpeakerSearchStatus != null && { SpeakerSearchStatus: input.SpeakerSearchStatus }),
        ...(input.VoiceToneAnalysisStatus != null && { VoiceToneAnalysisStatus: input.VoiceToneAnalysisStatus }),
    };
};
const deserializeAws_restJson1AmazonTranscribeCallAnalyticsProcessorConfiguration = (output, context) => {
    return {
        CallAnalyticsStreamCategories: output.CallAnalyticsStreamCategories != null
            ? deserializeAws_restJson1CategoryNameList(output.CallAnalyticsStreamCategories, context)
            : undefined,
        ContentIdentificationType: (0, smithy_client_1.expectString)(output.ContentIdentificationType),
        ContentRedactionType: (0, smithy_client_1.expectString)(output.ContentRedactionType),
        EnablePartialResultsStabilization: (0, smithy_client_1.expectBoolean)(output.EnablePartialResultsStabilization),
        FilterPartialResults: (0, smithy_client_1.expectBoolean)(output.FilterPartialResults),
        LanguageCode: (0, smithy_client_1.expectString)(output.LanguageCode),
        LanguageModelName: (0, smithy_client_1.expectString)(output.LanguageModelName),
        PartialResultsStability: (0, smithy_client_1.expectString)(output.PartialResultsStability),
        PiiEntityTypes: (0, smithy_client_1.expectString)(output.PiiEntityTypes),
        PostCallAnalyticsSettings: output.PostCallAnalyticsSettings != null
            ? deserializeAws_restJson1PostCallAnalyticsSettings(output.PostCallAnalyticsSettings, context)
            : undefined,
        VocabularyFilterMethod: (0, smithy_client_1.expectString)(output.VocabularyFilterMethod),
        VocabularyFilterName: (0, smithy_client_1.expectString)(output.VocabularyFilterName),
        VocabularyName: (0, smithy_client_1.expectString)(output.VocabularyName),
    };
};
const deserializeAws_restJson1AmazonTranscribeProcessorConfiguration = (output, context) => {
    return {
        ContentIdentificationType: (0, smithy_client_1.expectString)(output.ContentIdentificationType),
        ContentRedactionType: (0, smithy_client_1.expectString)(output.ContentRedactionType),
        EnablePartialResultsStabilization: (0, smithy_client_1.expectBoolean)(output.EnablePartialResultsStabilization),
        FilterPartialResults: (0, smithy_client_1.expectBoolean)(output.FilterPartialResults),
        LanguageCode: (0, smithy_client_1.expectString)(output.LanguageCode),
        LanguageModelName: (0, smithy_client_1.expectString)(output.LanguageModelName),
        PartialResultsStability: (0, smithy_client_1.expectString)(output.PartialResultsStability),
        PiiEntityTypes: (0, smithy_client_1.expectString)(output.PiiEntityTypes),
        ShowSpeakerLabel: (0, smithy_client_1.expectBoolean)(output.ShowSpeakerLabel),
        VocabularyFilterMethod: (0, smithy_client_1.expectString)(output.VocabularyFilterMethod),
        VocabularyFilterName: (0, smithy_client_1.expectString)(output.VocabularyFilterName),
        VocabularyName: (0, smithy_client_1.expectString)(output.VocabularyName),
    };
};
const deserializeAws_restJson1ArtifactsConcatenationConfiguration = (output, context) => {
    return {
        Audio: output.Audio != null ? deserializeAws_restJson1AudioConcatenationConfiguration(output.Audio, context) : undefined,
        CompositedVideo: output.CompositedVideo != null
            ? deserializeAws_restJson1CompositedVideoConcatenationConfiguration(output.CompositedVideo, context)
            : undefined,
        Content: output.Content != null
            ? deserializeAws_restJson1ContentConcatenationConfiguration(output.Content, context)
            : undefined,
        DataChannel: output.DataChannel != null
            ? deserializeAws_restJson1DataChannelConcatenationConfiguration(output.DataChannel, context)
            : undefined,
        MeetingEvents: output.MeetingEvents != null
            ? deserializeAws_restJson1MeetingEventsConcatenationConfiguration(output.MeetingEvents, context)
            : undefined,
        TranscriptionMessages: output.TranscriptionMessages != null
            ? deserializeAws_restJson1TranscriptionMessagesConcatenationConfiguration(output.TranscriptionMessages, context)
            : undefined,
        Video: output.Video != null ? deserializeAws_restJson1VideoConcatenationConfiguration(output.Video, context) : undefined,
    };
};
const deserializeAws_restJson1ArtifactsConfiguration = (output, context) => {
    return {
        Audio: output.Audio != null ? deserializeAws_restJson1AudioArtifactsConfiguration(output.Audio, context) : undefined,
        CompositedVideo: output.CompositedVideo != null
            ? deserializeAws_restJson1CompositedVideoArtifactsConfiguration(output.CompositedVideo, context)
            : undefined,
        Content: output.Content != null
            ? deserializeAws_restJson1ContentArtifactsConfiguration(output.Content, context)
            : undefined,
        Video: output.Video != null ? deserializeAws_restJson1VideoArtifactsConfiguration(output.Video, context) : undefined,
    };
};
const deserializeAws_restJson1AttendeeIdList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return (0, smithy_client_1.expectString)(entry);
    });
    return retVal;
};
const deserializeAws_restJson1AudioArtifactsConfiguration = (output, context) => {
    return {
        MuxType: (0, smithy_client_1.expectString)(output.MuxType),
    };
};
const deserializeAws_restJson1AudioConcatenationConfiguration = (output, context) => {
    return {
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1CategoryNameList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return (0, smithy_client_1.expectString)(entry);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelDefinition = (output, context) => {
    return {
        ChannelId: (0, smithy_client_1.expectInt32)(output.ChannelId),
        ParticipantRole: (0, smithy_client_1.expectString)(output.ParticipantRole),
    };
};
const deserializeAws_restJson1ChannelDefinitions = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelDefinition(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChimeSdkMeetingConcatenationConfiguration = (output, context) => {
    return {
        ArtifactsConfiguration: output.ArtifactsConfiguration != null
            ? deserializeAws_restJson1ArtifactsConcatenationConfiguration(output.ArtifactsConfiguration, context)
            : undefined,
    };
};
const deserializeAws_restJson1ChimeSdkMeetingConfiguration = (output, context) => {
    return {
        ArtifactsConfiguration: output.ArtifactsConfiguration != null
            ? deserializeAws_restJson1ArtifactsConfiguration(output.ArtifactsConfiguration, context)
            : undefined,
        SourceConfiguration: output.SourceConfiguration != null
            ? deserializeAws_restJson1SourceConfiguration(output.SourceConfiguration, context)
            : undefined,
    };
};
const deserializeAws_restJson1ChimeSdkMeetingLiveConnectorConfiguration = (output, context) => {
    return {
        Arn: (0, smithy_client_1.expectString)(output.Arn),
        CompositedVideo: output.CompositedVideo != null
            ? deserializeAws_restJson1CompositedVideoArtifactsConfiguration(output.CompositedVideo, context)
            : undefined,
        MuxType: (0, smithy_client_1.expectString)(output.MuxType),
        SourceConfiguration: output.SourceConfiguration != null
            ? deserializeAws_restJson1SourceConfiguration(output.SourceConfiguration, context)
            : undefined,
    };
};
const deserializeAws_restJson1CompositedVideoArtifactsConfiguration = (output, context) => {
    return {
        GridViewConfiguration: output.GridViewConfiguration != null
            ? deserializeAws_restJson1GridViewConfiguration(output.GridViewConfiguration, context)
            : undefined,
        Layout: (0, smithy_client_1.expectString)(output.Layout),
        Resolution: (0, smithy_client_1.expectString)(output.Resolution),
    };
};
const deserializeAws_restJson1CompositedVideoConcatenationConfiguration = (output, context) => {
    return {
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1ConcatenationSink = (output, context) => {
    return {
        S3BucketSinkConfiguration: output.S3BucketSinkConfiguration != null
            ? deserializeAws_restJson1S3BucketSinkConfiguration(output.S3BucketSinkConfiguration, context)
            : undefined,
        Type: (0, smithy_client_1.expectString)(output.Type),
    };
};
const deserializeAws_restJson1ConcatenationSinkList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ConcatenationSink(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ConcatenationSource = (output, context) => {
    return {
        MediaCapturePipelineSourceConfiguration: output.MediaCapturePipelineSourceConfiguration != null
            ? deserializeAws_restJson1MediaCapturePipelineSourceConfiguration(output.MediaCapturePipelineSourceConfiguration, context)
            : undefined,
        Type: (0, smithy_client_1.expectString)(output.Type),
    };
};
const deserializeAws_restJson1ConcatenationSourceList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ConcatenationSource(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ContentArtifactsConfiguration = (output, context) => {
    return {
        MuxType: (0, smithy_client_1.expectString)(output.MuxType),
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1ContentConcatenationConfiguration = (output, context) => {
    return {
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1DataChannelConcatenationConfiguration = (output, context) => {
    return {
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1ExternalUserIdList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return (0, smithy_client_1.expectString)(entry);
    });
    return retVal;
};
const deserializeAws_restJson1FragmentSelector = (output, context) => {
    return {
        FragmentSelectorType: (0, smithy_client_1.expectString)(output.FragmentSelectorType),
        TimestampRange: output.TimestampRange != null
            ? deserializeAws_restJson1TimestampRange(output.TimestampRange, context)
            : undefined,
    };
};
const deserializeAws_restJson1GridViewConfiguration = (output, context) => {
    return {
        ContentShareLayout: (0, smithy_client_1.expectString)(output.ContentShareLayout),
        PresenterOnlyConfiguration: output.PresenterOnlyConfiguration != null
            ? deserializeAws_restJson1PresenterOnlyConfiguration(output.PresenterOnlyConfiguration, context)
            : undefined,
    };
};
const deserializeAws_restJson1IssueDetectionConfiguration = (output, context) => {
    return {
        RuleName: (0, smithy_client_1.expectString)(output.RuleName),
    };
};
const deserializeAws_restJson1KeywordMatchConfiguration = (output, context) => {
    return {
        Keywords: output.Keywords != null ? deserializeAws_restJson1KeywordMatchWordList(output.Keywords, context) : undefined,
        Negate: (0, smithy_client_1.expectBoolean)(output.Negate),
        RuleName: (0, smithy_client_1.expectString)(output.RuleName),
    };
};
const deserializeAws_restJson1KeywordMatchWordList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return (0, smithy_client_1.expectString)(entry);
    });
    return retVal;
};
const deserializeAws_restJson1KinesisDataStreamSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: (0, smithy_client_1.expectString)(output.InsightsTarget),
    };
};
const deserializeAws_restJson1KinesisVideoStreamRecordingSourceRuntimeConfiguration = (output, context) => {
    return {
        FragmentSelector: output.FragmentSelector != null
            ? deserializeAws_restJson1FragmentSelector(output.FragmentSelector, context)
            : undefined,
        Streams: output.Streams != null ? deserializeAws_restJson1RecordingStreamList(output.Streams, context) : undefined,
    };
};
const deserializeAws_restJson1KinesisVideoStreamSourceRuntimeConfiguration = (output, context) => {
    return {
        MediaEncoding: (0, smithy_client_1.expectString)(output.MediaEncoding),
        MediaSampleRate: (0, smithy_client_1.expectInt32)(output.MediaSampleRate),
        Streams: output.Streams != null ? deserializeAws_restJson1Streams(output.Streams, context) : undefined,
    };
};
const deserializeAws_restJson1LambdaFunctionSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: (0, smithy_client_1.expectString)(output.InsightsTarget),
    };
};
const deserializeAws_restJson1LiveConnectorRTMPConfiguration = (output, context) => {
    return {
        AudioChannels: (0, smithy_client_1.expectString)(output.AudioChannels),
        AudioSampleRate: (0, smithy_client_1.expectString)(output.AudioSampleRate),
        Url: (0, smithy_client_1.expectString)(output.Url),
    };
};
const deserializeAws_restJson1LiveConnectorSinkConfiguration = (output, context) => {
    return {
        RTMPConfiguration: output.RTMPConfiguration != null
            ? deserializeAws_restJson1LiveConnectorRTMPConfiguration(output.RTMPConfiguration, context)
            : undefined,
        SinkType: (0, smithy_client_1.expectString)(output.SinkType),
    };
};
const deserializeAws_restJson1LiveConnectorSinkList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1LiveConnectorSinkConfiguration(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1LiveConnectorSourceConfiguration = (output, context) => {
    return {
        ChimeSdkMeetingLiveConnectorConfiguration: output.ChimeSdkMeetingLiveConnectorConfiguration != null
            ? deserializeAws_restJson1ChimeSdkMeetingLiveConnectorConfiguration(output.ChimeSdkMeetingLiveConnectorConfiguration, context)
            : undefined,
        SourceType: (0, smithy_client_1.expectString)(output.SourceType),
    };
};
const deserializeAws_restJson1LiveConnectorSourceList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1LiveConnectorSourceConfiguration(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MediaCapturePipeline = (output, context) => {
    return {
        ChimeSdkMeetingConfiguration: output.ChimeSdkMeetingConfiguration != null
            ? deserializeAws_restJson1ChimeSdkMeetingConfiguration(output.ChimeSdkMeetingConfiguration, context)
            : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.CreatedTimestamp))
            : undefined,
        MediaPipelineArn: (0, smithy_client_1.expectString)(output.MediaPipelineArn),
        MediaPipelineId: (0, smithy_client_1.expectString)(output.MediaPipelineId),
        SinkArn: (0, smithy_client_1.expectString)(output.SinkArn),
        SinkType: (0, smithy_client_1.expectString)(output.SinkType),
        SourceArn: (0, smithy_client_1.expectString)(output.SourceArn),
        SourceType: (0, smithy_client_1.expectString)(output.SourceType),
        Status: (0, smithy_client_1.expectString)(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1MediaCapturePipelineSourceConfiguration = (output, context) => {
    return {
        ChimeSdkMeetingConfiguration: output.ChimeSdkMeetingConfiguration != null
            ? deserializeAws_restJson1ChimeSdkMeetingConcatenationConfiguration(output.ChimeSdkMeetingConfiguration, context)
            : undefined,
        MediaPipelineArn: (0, smithy_client_1.expectString)(output.MediaPipelineArn),
    };
};
const deserializeAws_restJson1MediaCapturePipelineSummary = (output, context) => {
    return {
        MediaPipelineArn: (0, smithy_client_1.expectString)(output.MediaPipelineArn),
        MediaPipelineId: (0, smithy_client_1.expectString)(output.MediaPipelineId),
    };
};
const deserializeAws_restJson1MediaCapturePipelineSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1MediaCapturePipelineSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MediaConcatenationPipeline = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.CreatedTimestamp))
            : undefined,
        MediaPipelineArn: (0, smithy_client_1.expectString)(output.MediaPipelineArn),
        MediaPipelineId: (0, smithy_client_1.expectString)(output.MediaPipelineId),
        Sinks: output.Sinks != null ? deserializeAws_restJson1ConcatenationSinkList(output.Sinks, context) : undefined,
        Sources: output.Sources != null ? deserializeAws_restJson1ConcatenationSourceList(output.Sources, context) : undefined,
        Status: (0, smithy_client_1.expectString)(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1MediaInsightsPipeline = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.CreatedTimestamp))
            : undefined,
        KinesisVideoStreamRecordingSourceRuntimeConfiguration: output.KinesisVideoStreamRecordingSourceRuntimeConfiguration != null
            ? deserializeAws_restJson1KinesisVideoStreamRecordingSourceRuntimeConfiguration(output.KinesisVideoStreamRecordingSourceRuntimeConfiguration, context)
            : undefined,
        KinesisVideoStreamSourceRuntimeConfiguration: output.KinesisVideoStreamSourceRuntimeConfiguration != null
            ? deserializeAws_restJson1KinesisVideoStreamSourceRuntimeConfiguration(output.KinesisVideoStreamSourceRuntimeConfiguration, context)
            : undefined,
        MediaInsightsPipelineConfigurationArn: (0, smithy_client_1.expectString)(output.MediaInsightsPipelineConfigurationArn),
        MediaInsightsRuntimeMetadata: output.MediaInsightsRuntimeMetadata != null
            ? deserializeAws_restJson1MediaInsightsRuntimeMetadata(output.MediaInsightsRuntimeMetadata, context)
            : undefined,
        MediaPipelineArn: (0, smithy_client_1.expectString)(output.MediaPipelineArn),
        MediaPipelineId: (0, smithy_client_1.expectString)(output.MediaPipelineId),
        S3RecordingSinkRuntimeConfiguration: output.S3RecordingSinkRuntimeConfiguration != null
            ? deserializeAws_restJson1S3RecordingSinkRuntimeConfiguration(output.S3RecordingSinkRuntimeConfiguration, context)
            : undefined,
        Status: (0, smithy_client_1.expectString)(output.Status),
    };
};
const deserializeAws_restJson1MediaInsightsPipelineConfiguration = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.CreatedTimestamp))
            : undefined,
        Elements: output.Elements != null
            ? deserializeAws_restJson1MediaInsightsPipelineConfigurationElements(output.Elements, context)
            : undefined,
        MediaInsightsPipelineConfigurationArn: (0, smithy_client_1.expectString)(output.MediaInsightsPipelineConfigurationArn),
        MediaInsightsPipelineConfigurationId: (0, smithy_client_1.expectString)(output.MediaInsightsPipelineConfigurationId),
        MediaInsightsPipelineConfigurationName: (0, smithy_client_1.expectString)(output.MediaInsightsPipelineConfigurationName),
        RealTimeAlertConfiguration: output.RealTimeAlertConfiguration != null
            ? deserializeAws_restJson1RealTimeAlertConfiguration(output.RealTimeAlertConfiguration, context)
            : undefined,
        ResourceAccessRoleArn: (0, smithy_client_1.expectString)(output.ResourceAccessRoleArn),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1MediaInsightsPipelineConfigurationElement = (output, context) => {
    return {
        AmazonTranscribeCallAnalyticsProcessorConfiguration: output.AmazonTranscribeCallAnalyticsProcessorConfiguration != null
            ? deserializeAws_restJson1AmazonTranscribeCallAnalyticsProcessorConfiguration(output.AmazonTranscribeCallAnalyticsProcessorConfiguration, context)
            : undefined,
        AmazonTranscribeProcessorConfiguration: output.AmazonTranscribeProcessorConfiguration != null
            ? deserializeAws_restJson1AmazonTranscribeProcessorConfiguration(output.AmazonTranscribeProcessorConfiguration, context)
            : undefined,
        KinesisDataStreamSinkConfiguration: output.KinesisDataStreamSinkConfiguration != null
            ? deserializeAws_restJson1KinesisDataStreamSinkConfiguration(output.KinesisDataStreamSinkConfiguration, context)
            : undefined,
        LambdaFunctionSinkConfiguration: output.LambdaFunctionSinkConfiguration != null
            ? deserializeAws_restJson1LambdaFunctionSinkConfiguration(output.LambdaFunctionSinkConfiguration, context)
            : undefined,
        S3RecordingSinkConfiguration: output.S3RecordingSinkConfiguration != null
            ? deserializeAws_restJson1S3RecordingSinkConfiguration(output.S3RecordingSinkConfiguration, context)
            : undefined,
        SnsTopicSinkConfiguration: output.SnsTopicSinkConfiguration != null
            ? deserializeAws_restJson1SnsTopicSinkConfiguration(output.SnsTopicSinkConfiguration, context)
            : undefined,
        SqsQueueSinkConfiguration: output.SqsQueueSinkConfiguration != null
            ? deserializeAws_restJson1SqsQueueSinkConfiguration(output.SqsQueueSinkConfiguration, context)
            : undefined,
        Type: (0, smithy_client_1.expectString)(output.Type),
        VoiceAnalyticsProcessorConfiguration: output.VoiceAnalyticsProcessorConfiguration != null
            ? deserializeAws_restJson1VoiceAnalyticsProcessorConfiguration(output.VoiceAnalyticsProcessorConfiguration, context)
            : undefined,
    };
};
const deserializeAws_restJson1MediaInsightsPipelineConfigurationElements = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1MediaInsightsPipelineConfigurationElement(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MediaInsightsPipelineConfigurationSummary = (output, context) => {
    return {
        MediaInsightsPipelineConfigurationArn: (0, smithy_client_1.expectString)(output.MediaInsightsPipelineConfigurationArn),
        MediaInsightsPipelineConfigurationId: (0, smithy_client_1.expectString)(output.MediaInsightsPipelineConfigurationId),
        MediaInsightsPipelineConfigurationName: (0, smithy_client_1.expectString)(output.MediaInsightsPipelineConfigurationName),
    };
};
const deserializeAws_restJson1MediaInsightsPipelineConfigurationSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1MediaInsightsPipelineConfigurationSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MediaInsightsRuntimeMetadata = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = (0, smithy_client_1.expectString)(value);
        return acc;
    }, {});
};
const deserializeAws_restJson1MediaLiveConnectorPipeline = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.CreatedTimestamp))
            : undefined,
        MediaPipelineArn: (0, smithy_client_1.expectString)(output.MediaPipelineArn),
        MediaPipelineId: (0, smithy_client_1.expectString)(output.MediaPipelineId),
        Sinks: output.Sinks != null ? deserializeAws_restJson1LiveConnectorSinkList(output.Sinks, context) : undefined,
        Sources: output.Sources != null ? deserializeAws_restJson1LiveConnectorSourceList(output.Sources, context) : undefined,
        Status: (0, smithy_client_1.expectString)(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1MediaPipeline = (output, context) => {
    return {
        MediaCapturePipeline: output.MediaCapturePipeline != null
            ? deserializeAws_restJson1MediaCapturePipeline(output.MediaCapturePipeline, context)
            : undefined,
        MediaConcatenationPipeline: output.MediaConcatenationPipeline != null
            ? deserializeAws_restJson1MediaConcatenationPipeline(output.MediaConcatenationPipeline, context)
            : undefined,
        MediaInsightsPipeline: output.MediaInsightsPipeline != null
            ? deserializeAws_restJson1MediaInsightsPipeline(output.MediaInsightsPipeline, context)
            : undefined,
        MediaLiveConnectorPipeline: output.MediaLiveConnectorPipeline != null
            ? deserializeAws_restJson1MediaLiveConnectorPipeline(output.MediaLiveConnectorPipeline, context)
            : undefined,
    };
};
const deserializeAws_restJson1MediaPipelineList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1MediaPipelineSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MediaPipelineSummary = (output, context) => {
    return {
        MediaPipelineArn: (0, smithy_client_1.expectString)(output.MediaPipelineArn),
        MediaPipelineId: (0, smithy_client_1.expectString)(output.MediaPipelineId),
    };
};
const deserializeAws_restJson1MeetingEventsConcatenationConfiguration = (output, context) => {
    return {
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1PostCallAnalyticsSettings = (output, context) => {
    return {
        ContentRedactionOutput: (0, smithy_client_1.expectString)(output.ContentRedactionOutput),
        DataAccessRoleArn: (0, smithy_client_1.expectString)(output.DataAccessRoleArn),
        OutputEncryptionKMSKeyId: (0, smithy_client_1.expectString)(output.OutputEncryptionKMSKeyId),
        OutputLocation: (0, smithy_client_1.expectString)(output.OutputLocation),
    };
};
const deserializeAws_restJson1PresenterOnlyConfiguration = (output, context) => {
    return {
        PresenterPosition: (0, smithy_client_1.expectString)(output.PresenterPosition),
    };
};
const deserializeAws_restJson1RealTimeAlertConfiguration = (output, context) => {
    return {
        Disabled: (0, smithy_client_1.expectBoolean)(output.Disabled),
        Rules: output.Rules != null ? deserializeAws_restJson1RealTimeAlertRuleList(output.Rules, context) : undefined,
    };
};
const deserializeAws_restJson1RealTimeAlertRule = (output, context) => {
    return {
        IssueDetectionConfiguration: output.IssueDetectionConfiguration != null
            ? deserializeAws_restJson1IssueDetectionConfiguration(output.IssueDetectionConfiguration, context)
            : undefined,
        KeywordMatchConfiguration: output.KeywordMatchConfiguration != null
            ? deserializeAws_restJson1KeywordMatchConfiguration(output.KeywordMatchConfiguration, context)
            : undefined,
        SentimentConfiguration: output.SentimentConfiguration != null
            ? deserializeAws_restJson1SentimentConfiguration(output.SentimentConfiguration, context)
            : undefined,
        Type: (0, smithy_client_1.expectString)(output.Type),
    };
};
const deserializeAws_restJson1RealTimeAlertRuleList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1RealTimeAlertRule(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1RecordingStreamConfiguration = (output, context) => {
    return {
        StreamArn: (0, smithy_client_1.expectString)(output.StreamArn),
    };
};
const deserializeAws_restJson1RecordingStreamList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1RecordingStreamConfiguration(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1S3BucketSinkConfiguration = (output, context) => {
    return {
        Destination: (0, smithy_client_1.expectString)(output.Destination),
    };
};
const deserializeAws_restJson1S3RecordingSinkConfiguration = (output, context) => {
    return {
        Destination: (0, smithy_client_1.expectString)(output.Destination),
    };
};
const deserializeAws_restJson1S3RecordingSinkRuntimeConfiguration = (output, context) => {
    return {
        Destination: (0, smithy_client_1.expectString)(output.Destination),
        RecordingFileFormat: (0, smithy_client_1.expectString)(output.RecordingFileFormat),
    };
};
const deserializeAws_restJson1SelectedVideoStreams = (output, context) => {
    return {
        AttendeeIds: output.AttendeeIds != null ? deserializeAws_restJson1AttendeeIdList(output.AttendeeIds, context) : undefined,
        ExternalUserIds: output.ExternalUserIds != null
            ? deserializeAws_restJson1ExternalUserIdList(output.ExternalUserIds, context)
            : undefined,
    };
};
const deserializeAws_restJson1SentimentConfiguration = (output, context) => {
    return {
        RuleName: (0, smithy_client_1.expectString)(output.RuleName),
        SentimentType: (0, smithy_client_1.expectString)(output.SentimentType),
        TimePeriod: (0, smithy_client_1.expectInt32)(output.TimePeriod),
    };
};
const deserializeAws_restJson1SnsTopicSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: (0, smithy_client_1.expectString)(output.InsightsTarget),
    };
};
const deserializeAws_restJson1SourceConfiguration = (output, context) => {
    return {
        SelectedVideoStreams: output.SelectedVideoStreams != null
            ? deserializeAws_restJson1SelectedVideoStreams(output.SelectedVideoStreams, context)
            : undefined,
    };
};
const deserializeAws_restJson1SqsQueueSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: (0, smithy_client_1.expectString)(output.InsightsTarget),
    };
};
const deserializeAws_restJson1StreamChannelDefinition = (output, context) => {
    return {
        ChannelDefinitions: output.ChannelDefinitions != null
            ? deserializeAws_restJson1ChannelDefinitions(output.ChannelDefinitions, context)
            : undefined,
        NumberOfChannels: (0, smithy_client_1.expectInt32)(output.NumberOfChannels),
    };
};
const deserializeAws_restJson1StreamConfiguration = (output, context) => {
    return {
        FragmentNumber: (0, smithy_client_1.expectString)(output.FragmentNumber),
        StreamArn: (0, smithy_client_1.expectString)(output.StreamArn),
        StreamChannelDefinition: output.StreamChannelDefinition != null
            ? deserializeAws_restJson1StreamChannelDefinition(output.StreamChannelDefinition, context)
            : undefined,
    };
};
const deserializeAws_restJson1Streams = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1StreamConfiguration(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Tag = (output, context) => {
    return {
        Key: (0, smithy_client_1.expectString)(output.Key),
        Value: (0, smithy_client_1.expectString)(output.Value),
    };
};
const deserializeAws_restJson1TagList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Tag(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1TimestampRange = (output, context) => {
    return {
        EndTimestamp: output.EndTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(output.EndTimestamp)))
            : undefined,
        StartTimestamp: output.StartTimestamp != null
            ? (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(output.StartTimestamp)))
            : undefined,
    };
};
const deserializeAws_restJson1TranscriptionMessagesConcatenationConfiguration = (output, context) => {
    return {
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1VideoArtifactsConfiguration = (output, context) => {
    return {
        MuxType: (0, smithy_client_1.expectString)(output.MuxType),
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1VideoConcatenationConfiguration = (output, context) => {
    return {
        State: (0, smithy_client_1.expectString)(output.State),
    };
};
const deserializeAws_restJson1VoiceAnalyticsProcessorConfiguration = (output, context) => {
    return {
        SpeakerSearchStatus: (0, smithy_client_1.expectString)(output.SpeakerSearchStatus),
        VoiceToneAnalysisStatus: (0, smithy_client_1.expectString)(output.VoiceToneAnalysisStatus),
    };
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBody = (streamBody = new Uint8Array(), context) => {
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const isSerializableHeaderValue = (value) => value !== undefined &&
    value !== null &&
    value !== "" &&
    (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) &&
    (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
