import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateMediaInsightsPipelineRequestFilterSensitiveLog, CreateMediaInsightsPipelineResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_restJson1CreateMediaInsightsPipelineCommand, serializeAws_restJson1CreateMediaInsightsPipelineCommand, } from "../protocols/Aws_restJson1";
export class CreateMediaInsightsPipelineCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, CreateMediaInsightsPipelineCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeSDKMediaPipelinesClient";
        const commandName = "CreateMediaInsightsPipelineCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: CreateMediaInsightsPipelineRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CreateMediaInsightsPipelineResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_restJson1CreateMediaInsightsPipelineCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_restJson1CreateMediaInsightsPipelineCommand(output, context);
    }
}
