import { HttpHandlerOptions as __HttpHandlerOptions } from "@aws-sdk/types";
import { ChimeSDKMediaPipelinesClient } from "./ChimeSDKMediaPipelinesClient";
import { CreateMediaCapturePipelineCommandInput, CreateMediaCapturePipelineCommandOutput } from "./commands/CreateMediaCapturePipelineCommand";
import { CreateMediaConcatenationPipelineCommandInput, CreateMediaConcatenationPipelineCommandOutput } from "./commands/CreateMediaConcatenationPipelineCommand";
import { CreateMediaInsightsPipelineCommandInput, CreateMediaInsightsPipelineCommandOutput } from "./commands/CreateMediaInsightsPipelineCommand";
import { CreateMediaInsightsPipelineConfigurationCommandInput, CreateMediaInsightsPipelineConfigurationCommandOutput } from "./commands/CreateMediaInsightsPipelineConfigurationCommand";
import { CreateMediaLiveConnectorPipelineCommandInput, CreateMediaLiveConnectorPipelineCommandOutput } from "./commands/CreateMediaLiveConnectorPipelineCommand";
import { DeleteMediaCapturePipelineCommandInput, DeleteMediaCapturePipelineCommandOutput } from "./commands/DeleteMediaCapturePipelineCommand";
import { DeleteMediaInsightsPipelineConfigurationCommandInput, DeleteMediaInsightsPipelineConfigurationCommandOutput } from "./commands/DeleteMediaInsightsPipelineConfigurationCommand";
import { DeleteMediaPipelineCommandInput, DeleteMediaPipelineCommandOutput } from "./commands/DeleteMediaPipelineCommand";
import { GetMediaCapturePipelineCommandInput, GetMediaCapturePipelineCommandOutput } from "./commands/GetMediaCapturePipelineCommand";
import { GetMediaInsightsPipelineConfigurationCommandInput, GetMediaInsightsPipelineConfigurationCommandOutput } from "./commands/GetMediaInsightsPipelineConfigurationCommand";
import { GetMediaPipelineCommandInput, GetMediaPipelineCommandOutput } from "./commands/GetMediaPipelineCommand";
import { ListMediaCapturePipelinesCommandInput, ListMediaCapturePipelinesCommandOutput } from "./commands/ListMediaCapturePipelinesCommand";
import { ListMediaInsightsPipelineConfigurationsCommandInput, ListMediaInsightsPipelineConfigurationsCommandOutput } from "./commands/ListMediaInsightsPipelineConfigurationsCommand";
import { ListMediaPipelinesCommandInput, ListMediaPipelinesCommandOutput } from "./commands/ListMediaPipelinesCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateMediaInsightsPipelineConfigurationCommandInput, UpdateMediaInsightsPipelineConfigurationCommandOutput } from "./commands/UpdateMediaInsightsPipelineConfigurationCommand";
import { UpdateMediaInsightsPipelineStatusCommandInput, UpdateMediaInsightsPipelineStatusCommandOutput } from "./commands/UpdateMediaInsightsPipelineStatusCommand";
/**
 * @public
 * <p>The Amazon Chime SDK media pipeline APIs in this section allow software developers to
 *          create Amazon Chime SDK media pipelines that capture, concatenate, or stream your Amazon Chime SDK meetings. For more information about media pipelines, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_Operations_Amazon_Chime_SDK_Media_Pipelines.html">Amazon Chime SDK media pipelines</a>. </p>
 */
export declare class ChimeSDKMediaPipelines extends ChimeSDKMediaPipelinesClient {
    /**
     * @public
     * <p>Creates a media pipeline.</p>
     */
    createMediaCapturePipeline(args: CreateMediaCapturePipelineCommandInput, options?: __HttpHandlerOptions): Promise<CreateMediaCapturePipelineCommandOutput>;
    createMediaCapturePipeline(args: CreateMediaCapturePipelineCommandInput, cb: (err: any, data?: CreateMediaCapturePipelineCommandOutput) => void): void;
    createMediaCapturePipeline(args: CreateMediaCapturePipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateMediaCapturePipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a media concatenation pipeline.</p>
     */
    createMediaConcatenationPipeline(args: CreateMediaConcatenationPipelineCommandInput, options?: __HttpHandlerOptions): Promise<CreateMediaConcatenationPipelineCommandOutput>;
    createMediaConcatenationPipeline(args: CreateMediaConcatenationPipelineCommandInput, cb: (err: any, data?: CreateMediaConcatenationPipelineCommandOutput) => void): void;
    createMediaConcatenationPipeline(args: CreateMediaConcatenationPipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateMediaConcatenationPipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a media insights pipeline.</p>
     */
    createMediaInsightsPipeline(args: CreateMediaInsightsPipelineCommandInput, options?: __HttpHandlerOptions): Promise<CreateMediaInsightsPipelineCommandOutput>;
    createMediaInsightsPipeline(args: CreateMediaInsightsPipelineCommandInput, cb: (err: any, data?: CreateMediaInsightsPipelineCommandOutput) => void): void;
    createMediaInsightsPipeline(args: CreateMediaInsightsPipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateMediaInsightsPipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>A structure that contains the static configurations for a media insights
     *          pipeline.</p>
     */
    createMediaInsightsPipelineConfiguration(args: CreateMediaInsightsPipelineConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<CreateMediaInsightsPipelineConfigurationCommandOutput>;
    createMediaInsightsPipelineConfiguration(args: CreateMediaInsightsPipelineConfigurationCommandInput, cb: (err: any, data?: CreateMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    createMediaInsightsPipelineConfiguration(args: CreateMediaInsightsPipelineConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a media live connector pipeline in an Amazon Chime SDK meeting.</p>
     */
    createMediaLiveConnectorPipeline(args: CreateMediaLiveConnectorPipelineCommandInput, options?: __HttpHandlerOptions): Promise<CreateMediaLiveConnectorPipelineCommandOutput>;
    createMediaLiveConnectorPipeline(args: CreateMediaLiveConnectorPipelineCommandInput, cb: (err: any, data?: CreateMediaLiveConnectorPipelineCommandOutput) => void): void;
    createMediaLiveConnectorPipeline(args: CreateMediaLiveConnectorPipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateMediaLiveConnectorPipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the media pipeline.</p>
     */
    deleteMediaCapturePipeline(args: DeleteMediaCapturePipelineCommandInput, options?: __HttpHandlerOptions): Promise<DeleteMediaCapturePipelineCommandOutput>;
    deleteMediaCapturePipeline(args: DeleteMediaCapturePipelineCommandInput, cb: (err: any, data?: DeleteMediaCapturePipelineCommandOutput) => void): void;
    deleteMediaCapturePipeline(args: DeleteMediaCapturePipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteMediaCapturePipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the specified configuration settings.</p>
     */
    deleteMediaInsightsPipelineConfiguration(args: DeleteMediaInsightsPipelineConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<DeleteMediaInsightsPipelineConfigurationCommandOutput>;
    deleteMediaInsightsPipelineConfiguration(args: DeleteMediaInsightsPipelineConfigurationCommandInput, cb: (err: any, data?: DeleteMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    deleteMediaInsightsPipelineConfiguration(args: DeleteMediaInsightsPipelineConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the media pipeline.</p>
     */
    deleteMediaPipeline(args: DeleteMediaPipelineCommandInput, options?: __HttpHandlerOptions): Promise<DeleteMediaPipelineCommandOutput>;
    deleteMediaPipeline(args: DeleteMediaPipelineCommandInput, cb: (err: any, data?: DeleteMediaPipelineCommandOutput) => void): void;
    deleteMediaPipeline(args: DeleteMediaPipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteMediaPipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>Gets an existing media pipeline.</p>
     */
    getMediaCapturePipeline(args: GetMediaCapturePipelineCommandInput, options?: __HttpHandlerOptions): Promise<GetMediaCapturePipelineCommandOutput>;
    getMediaCapturePipeline(args: GetMediaCapturePipelineCommandInput, cb: (err: any, data?: GetMediaCapturePipelineCommandOutput) => void): void;
    getMediaCapturePipeline(args: GetMediaCapturePipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetMediaCapturePipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>Gets the configuration settings for a media insights pipeline.</p>
     */
    getMediaInsightsPipelineConfiguration(args: GetMediaInsightsPipelineConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<GetMediaInsightsPipelineConfigurationCommandOutput>;
    getMediaInsightsPipelineConfiguration(args: GetMediaInsightsPipelineConfigurationCommandInput, cb: (err: any, data?: GetMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    getMediaInsightsPipelineConfiguration(args: GetMediaInsightsPipelineConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Gets an existing media pipeline.</p>
     */
    getMediaPipeline(args: GetMediaPipelineCommandInput, options?: __HttpHandlerOptions): Promise<GetMediaPipelineCommandOutput>;
    getMediaPipeline(args: GetMediaPipelineCommandInput, cb: (err: any, data?: GetMediaPipelineCommandOutput) => void): void;
    getMediaPipeline(args: GetMediaPipelineCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetMediaPipelineCommandOutput) => void): void;
    /**
     * @public
     * <p>Returns a list of media pipelines.</p>
     */
    listMediaCapturePipelines(args: ListMediaCapturePipelinesCommandInput, options?: __HttpHandlerOptions): Promise<ListMediaCapturePipelinesCommandOutput>;
    listMediaCapturePipelines(args: ListMediaCapturePipelinesCommandInput, cb: (err: any, data?: ListMediaCapturePipelinesCommandOutput) => void): void;
    listMediaCapturePipelines(args: ListMediaCapturePipelinesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListMediaCapturePipelinesCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the available media insights pipeline configurations.</p>
     */
    listMediaInsightsPipelineConfigurations(args: ListMediaInsightsPipelineConfigurationsCommandInput, options?: __HttpHandlerOptions): Promise<ListMediaInsightsPipelineConfigurationsCommandOutput>;
    listMediaInsightsPipelineConfigurations(args: ListMediaInsightsPipelineConfigurationsCommandInput, cb: (err: any, data?: ListMediaInsightsPipelineConfigurationsCommandOutput) => void): void;
    listMediaInsightsPipelineConfigurations(args: ListMediaInsightsPipelineConfigurationsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListMediaInsightsPipelineConfigurationsCommandOutput) => void): void;
    /**
     * @public
     * <p>Returns a list of media pipelines.</p>
     */
    listMediaPipelines(args: ListMediaPipelinesCommandInput, options?: __HttpHandlerOptions): Promise<ListMediaPipelinesCommandOutput>;
    listMediaPipelines(args: ListMediaPipelinesCommandInput, cb: (err: any, data?: ListMediaPipelinesCommandOutput) => void): void;
    listMediaPipelines(args: ListMediaPipelinesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListMediaPipelinesCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the tags available for a media pipeline.</p>
     */
    listTagsForResource(args: ListTagsForResourceCommandInput, options?: __HttpHandlerOptions): Promise<ListTagsForResourceCommandOutput>;
    listTagsForResource(args: ListTagsForResourceCommandInput, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    listTagsForResource(args: ListTagsForResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    /**
     * @public
     * <p>The ARN of the media pipeline that you want to tag. Consists of the pipeline's endpoint region, resource ID, and pipeline ID.</p>
     */
    tagResource(args: TagResourceCommandInput, options?: __HttpHandlerOptions): Promise<TagResourceCommandOutput>;
    tagResource(args: TagResourceCommandInput, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    tagResource(args: TagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    /**
     * @public
     * <p>Removes any tags from a media pipeline.</p>
     */
    untagResource(args: UntagResourceCommandInput, options?: __HttpHandlerOptions): Promise<UntagResourceCommandOutput>;
    untagResource(args: UntagResourceCommandInput, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    untagResource(args: UntagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the media insights pipeline's configuration settings.</p>
     */
    updateMediaInsightsPipelineConfiguration(args: UpdateMediaInsightsPipelineConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<UpdateMediaInsightsPipelineConfigurationCommandOutput>;
    updateMediaInsightsPipelineConfiguration(args: UpdateMediaInsightsPipelineConfigurationCommandInput, cb: (err: any, data?: UpdateMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    updateMediaInsightsPipelineConfiguration(args: UpdateMediaInsightsPipelineConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateMediaInsightsPipelineConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the status of a media insights pipeline.</p>
     */
    updateMediaInsightsPipelineStatus(args: UpdateMediaInsightsPipelineStatusCommandInput, options?: __HttpHandlerOptions): Promise<UpdateMediaInsightsPipelineStatusCommandOutput>;
    updateMediaInsightsPipelineStatus(args: UpdateMediaInsightsPipelineStatusCommandInput, cb: (err: any, data?: UpdateMediaInsightsPipelineStatusCommandOutput) => void): void;
    updateMediaInsightsPipelineStatus(args: UpdateMediaInsightsPipelineStatusCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateMediaInsightsPipelineStatusCommandOutput) => void): void;
}
