import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMediaPipelinesClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMediaPipelinesClient";
import { CreateMediaInsightsPipelineRequest, CreateMediaInsightsPipelineResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link CreateMediaInsightsPipelineCommand}.
 */
export interface CreateMediaInsightsPipelineCommandInput extends CreateMediaInsightsPipelineRequest {
}
/**
 * @public
 *
 * The output of {@link CreateMediaInsightsPipelineCommand}.
 */
export interface CreateMediaInsightsPipelineCommandOutput extends CreateMediaInsightsPipelineResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Creates a media insights pipeline.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMediaPipelinesClient, CreateMediaInsightsPipelineCommand } from "@aws-sdk/client-chime-sdk-media-pipelines"; // ES Modules import
 * // const { ChimeSDKMediaPipelinesClient, CreateMediaInsightsPipelineCommand } = require("@aws-sdk/client-chime-sdk-media-pipelines"); // CommonJS import
 * const client = new ChimeSDKMediaPipelinesClient(config);
 * const input = { // CreateMediaInsightsPipelineRequest
 *   MediaInsightsPipelineConfigurationArn: "STRING_VALUE", // required
 *   KinesisVideoStreamSourceRuntimeConfiguration: { // KinesisVideoStreamSourceRuntimeConfiguration
 *     Streams: [ // Streams // required
 *       { // StreamConfiguration
 *         StreamArn: "STRING_VALUE", // required
 *         FragmentNumber: "STRING_VALUE",
 *         StreamChannelDefinition: { // StreamChannelDefinition
 *           NumberOfChannels: Number("int"), // required
 *           ChannelDefinitions: [ // ChannelDefinitions
 *             { // ChannelDefinition
 *               ChannelId: Number("int"), // required
 *               ParticipantRole: "AGENT" || "CUSTOMER",
 *             },
 *           ],
 *         },
 *       },
 *     ],
 *     MediaEncoding: "pcm", // required
 *     MediaSampleRate: Number("int"), // required
 *   },
 *   MediaInsightsRuntimeMetadata: { // MediaInsightsRuntimeMetadata
 *     "<keys>": "STRING_VALUE",
 *   },
 *   KinesisVideoStreamRecordingSourceRuntimeConfiguration: { // KinesisVideoStreamRecordingSourceRuntimeConfiguration
 *     Streams: [ // RecordingStreamList // required
 *       { // RecordingStreamConfiguration
 *         StreamArn: "STRING_VALUE",
 *       },
 *     ],
 *     FragmentSelector: { // FragmentSelector
 *       FragmentSelectorType: "ProducerTimestamp" || "ServerTimestamp", // required
 *       TimestampRange: { // TimestampRange
 *         StartTimestamp: new Date("TIMESTAMP"), // required
 *         EndTimestamp: new Date("TIMESTAMP"), // required
 *       },
 *     },
 *   },
 *   S3RecordingSinkRuntimeConfiguration: { // S3RecordingSinkRuntimeConfiguration
 *     Destination: "STRING_VALUE", // required
 *     RecordingFileFormat: "Wav" || "Opus", // required
 *   },
 *   Tags: [ // TagList
 *     { // Tag
 *       Key: "STRING_VALUE", // required
 *       Value: "STRING_VALUE", // required
 *     },
 *   ],
 *   ClientRequestToken: "STRING_VALUE",
 * };
 * const command = new CreateMediaInsightsPipelineCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param CreateMediaInsightsPipelineCommandInput - {@link CreateMediaInsightsPipelineCommandInput}
 * @returns {@link CreateMediaInsightsPipelineCommandOutput}
 * @see {@link CreateMediaInsightsPipelineCommandInput} for command's `input` shape.
 * @see {@link CreateMediaInsightsPipelineCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMediaPipelinesClientResolvedConfig | config} for ChimeSDKMediaPipelinesClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>One or more of the resources in the request does not exist in the system.</p>
 *
 * @throws {@link ResourceLimitExceededException} (client fault)
 *  <p>The request exceeds the resource limit.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class CreateMediaInsightsPipelineCommand extends $Command<CreateMediaInsightsPipelineCommandInput, CreateMediaInsightsPipelineCommandOutput, ChimeSDKMediaPipelinesClientResolvedConfig> {
    readonly input: CreateMediaInsightsPipelineCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: CreateMediaInsightsPipelineCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMediaPipelinesClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateMediaInsightsPipelineCommandInput, CreateMediaInsightsPipelineCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
