import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMediaPipelinesClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMediaPipelinesClient";
import { CreateMediaLiveConnectorPipelineRequest, CreateMediaLiveConnectorPipelineResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link CreateMediaLiveConnectorPipelineCommand}.
 */
export interface CreateMediaLiveConnectorPipelineCommandInput extends CreateMediaLiveConnectorPipelineRequest {
}
/**
 * @public
 *
 * The output of {@link CreateMediaLiveConnectorPipelineCommand}.
 */
export interface CreateMediaLiveConnectorPipelineCommandOutput extends CreateMediaLiveConnectorPipelineResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Creates a media live connector pipeline in an Amazon Chime SDK meeting.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMediaPipelinesClient, CreateMediaLiveConnectorPipelineCommand } from "@aws-sdk/client-chime-sdk-media-pipelines"; // ES Modules import
 * // const { ChimeSDKMediaPipelinesClient, CreateMediaLiveConnectorPipelineCommand } = require("@aws-sdk/client-chime-sdk-media-pipelines"); // CommonJS import
 * const client = new ChimeSDKMediaPipelinesClient(config);
 * const input = { // CreateMediaLiveConnectorPipelineRequest
 *   Sources: [ // LiveConnectorSourceList // required
 *     { // LiveConnectorSourceConfiguration
 *       SourceType: "ChimeSdkMeeting", // required
 *       ChimeSdkMeetingLiveConnectorConfiguration: { // ChimeSdkMeetingLiveConnectorConfiguration
 *         Arn: "STRING_VALUE", // required
 *         MuxType: "AudioWithCompositedVideo" || "AudioWithActiveSpeakerVideo", // required
 *         CompositedVideo: { // CompositedVideoArtifactsConfiguration
 *           Layout: "GridView",
 *           Resolution: "HD" || "FHD",
 *           GridViewConfiguration: { // GridViewConfiguration
 *             ContentShareLayout: "PresenterOnly" || "Horizontal" || "Vertical", // required
 *             PresenterOnlyConfiguration: { // PresenterOnlyConfiguration
 *               PresenterPosition: "TopLeft" || "TopRight" || "BottomLeft" || "BottomRight",
 *             },
 *           },
 *         },
 *         SourceConfiguration: { // SourceConfiguration
 *           SelectedVideoStreams: { // SelectedVideoStreams
 *             AttendeeIds: [ // AttendeeIdList
 *               "STRING_VALUE",
 *             ],
 *             ExternalUserIds: [ // ExternalUserIdList
 *               "STRING_VALUE",
 *             ],
 *           },
 *         },
 *       },
 *     },
 *   ],
 *   Sinks: [ // LiveConnectorSinkList // required
 *     { // LiveConnectorSinkConfiguration
 *       SinkType: "RTMP", // required
 *       RTMPConfiguration: { // LiveConnectorRTMPConfiguration
 *         Url: "STRING_VALUE", // required
 *         AudioChannels: "Stereo" || "Mono",
 *         AudioSampleRate: "STRING_VALUE",
 *       },
 *     },
 *   ],
 *   ClientRequestToken: "STRING_VALUE",
 *   Tags: [ // TagList
 *     { // Tag
 *       Key: "STRING_VALUE", // required
 *       Value: "STRING_VALUE", // required
 *     },
 *   ],
 * };
 * const command = new CreateMediaLiveConnectorPipelineCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param CreateMediaLiveConnectorPipelineCommandInput - {@link CreateMediaLiveConnectorPipelineCommandInput}
 * @returns {@link CreateMediaLiveConnectorPipelineCommandOutput}
 * @see {@link CreateMediaLiveConnectorPipelineCommandInput} for command's `input` shape.
 * @see {@link CreateMediaLiveConnectorPipelineCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMediaPipelinesClientResolvedConfig | config} for ChimeSDKMediaPipelinesClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ResourceLimitExceededException} (client fault)
 *  <p>The request exceeds the resource limit.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class CreateMediaLiveConnectorPipelineCommand extends $Command<CreateMediaLiveConnectorPipelineCommandInput, CreateMediaLiveConnectorPipelineCommandOutput, ChimeSDKMediaPipelinesClientResolvedConfig> {
    readonly input: CreateMediaLiveConnectorPipelineCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: CreateMediaLiveConnectorPipelineCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMediaPipelinesClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateMediaLiveConnectorPipelineCommandInput, CreateMediaLiveConnectorPipelineCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
