import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMediaPipelinesClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMediaPipelinesClient";
import { UpdateMediaInsightsPipelineStatusRequest } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link UpdateMediaInsightsPipelineStatusCommand}.
 */
export interface UpdateMediaInsightsPipelineStatusCommandInput extends UpdateMediaInsightsPipelineStatusRequest {
}
/**
 * @public
 *
 * The output of {@link UpdateMediaInsightsPipelineStatusCommand}.
 */
export interface UpdateMediaInsightsPipelineStatusCommandOutput extends __MetadataBearer {
}
/**
 * @public
 * <p>Updates the status of a media insights pipeline.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMediaPipelinesClient, UpdateMediaInsightsPipelineStatusCommand } from "@aws-sdk/client-chime-sdk-media-pipelines"; // ES Modules import
 * // const { ChimeSDKMediaPipelinesClient, UpdateMediaInsightsPipelineStatusCommand } = require("@aws-sdk/client-chime-sdk-media-pipelines"); // CommonJS import
 * const client = new ChimeSDKMediaPipelinesClient(config);
 * const input = { // UpdateMediaInsightsPipelineStatusRequest
 *   Identifier: "STRING_VALUE", // required
 *   UpdateStatus: "Pause" || "Resume", // required
 * };
 * const command = new UpdateMediaInsightsPipelineStatusCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param UpdateMediaInsightsPipelineStatusCommandInput - {@link UpdateMediaInsightsPipelineStatusCommandInput}
 * @returns {@link UpdateMediaInsightsPipelineStatusCommandOutput}
 * @see {@link UpdateMediaInsightsPipelineStatusCommandInput} for command's `input` shape.
 * @see {@link UpdateMediaInsightsPipelineStatusCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMediaPipelinesClientResolvedConfig | config} for ChimeSDKMediaPipelinesClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>One or more of the resources in the request does not exist in the system.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class UpdateMediaInsightsPipelineStatusCommand extends $Command<UpdateMediaInsightsPipelineStatusCommandInput, UpdateMediaInsightsPipelineStatusCommandOutput, ChimeSDKMediaPipelinesClientResolvedConfig> {
    readonly input: UpdateMediaInsightsPipelineStatusCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: UpdateMediaInsightsPipelineStatusCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMediaPipelinesClientResolvedConfig, options?: __HttpHandlerOptions): Handler<UpdateMediaInsightsPipelineStatusCommandInput, UpdateMediaInsightsPipelineStatusCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
