import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { ChimeSDKMediaPipelinesServiceException as __BaseException } from "./ChimeSDKMediaPipelinesServiceException";
/**
 * @public
 * @enum
 */
export declare const ContentType: {
    readonly PII: "PII";
};
/**
 * @public
 */
export type ContentType = (typeof ContentType)[keyof typeof ContentType];
/**
 * @public
 * @enum
 */
export declare const CallAnalyticsLanguageCode: {
    readonly DE_DE: "de-DE";
    readonly EN_AU: "en-AU";
    readonly EN_GB: "en-GB";
    readonly EN_US: "en-US";
    readonly ES_US: "es-US";
    readonly FR_CA: "fr-CA";
    readonly FR_FR: "fr-FR";
    readonly IT_IT: "it-IT";
    readonly PT_BR: "pt-BR";
};
/**
 * @public
 */
export type CallAnalyticsLanguageCode = (typeof CallAnalyticsLanguageCode)[keyof typeof CallAnalyticsLanguageCode];
/**
 * @public
 * @enum
 */
export declare const PartialResultsStability: {
    readonly HIGH: "high";
    readonly LOW: "low";
    readonly MEDIUM: "medium";
};
/**
 * @public
 */
export type PartialResultsStability = (typeof PartialResultsStability)[keyof typeof PartialResultsStability];
/**
 * @public
 * @enum
 */
export declare const ContentRedactionOutput: {
    readonly REDACTED: "redacted";
    readonly REDACTED_AND_UNREDACTED: "redacted_and_unredacted";
};
/**
 * @public
 */
export type ContentRedactionOutput = (typeof ContentRedactionOutput)[keyof typeof ContentRedactionOutput];
/**
 * @public
 * <p>The settings for a post-call voice analytics task.</p>
 */
export interface PostCallAnalyticsSettings {
    /**
     * <p>The URL of the Amazon S3 bucket that contains the post-call data.</p>
     */
    OutputLocation: string | undefined;
    /**
     * <p>The ARN of the role used by Amazon Web Services Transcribe to upload your post call analysis. For more information, see
     *          <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call analytics with real-time transcriptions</a> in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    DataAccessRoleArn: string | undefined;
    /**
     * <p>The content redaction output settings for a post-call analysis task.</p>
     */
    ContentRedactionOutput?: ContentRedactionOutput | string;
    /**
     * <p>The ID of the KMS (Key Management System) key used to encrypt the output.</p>
     */
    OutputEncryptionKMSKeyId?: string;
}
/**
 * @public
 * @enum
 */
export declare const VocabularyFilterMethod: {
    readonly MASK: "mask";
    readonly REMOVE: "remove";
    readonly TAG: "tag";
};
/**
 * @public
 */
export type VocabularyFilterMethod = (typeof VocabularyFilterMethod)[keyof typeof VocabularyFilterMethod];
/**
 * @public
 * <p>A structure that contains the configuration settings for an Amazon Transcribe call
 *          analytics processor.</p>
 */
export interface AmazonTranscribeCallAnalyticsProcessorConfiguration {
    /**
     * <p>The language code in the configuration.</p>
     */
    LanguageCode: CallAnalyticsLanguageCode | string | undefined;
    /**
     * <p>Specifies the name of the custom vocabulary to use when processing a transcription. Note
     *          that vocabulary names are case sensitive.</p>
     *          <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a> in the <i>Amazon Transcribe Developer Guide</i>.</p>
     *          <p>Length Constraints: Minimum length of 1. Maximum length of 200. </p>
     */
    VocabularyName?: string;
    /**
     * <p>Specifies the name of the custom vocabulary filter to use when processing a
     *          transcription. Note that vocabulary filter names are case sensitive.</p>
     *          <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     *          <p>Length Constraints: Minimum length of 1. Maximum length of 200. </p>
     */
    VocabularyFilterName?: string;
    /**
     * <p>Specifies how to apply a vocabulary filter to a transcript.</p>
     *          <p>To replace words with <b>***</b>, choose <code>mask</code>.</p>
     *          <p>To delete words, choose <code>remove</code>.</p>
     *          <p>To flag words without changing them, choose <code>tag</code>. </p>
     */
    VocabularyFilterMethod?: VocabularyFilterMethod | string;
    /**
     * <p>Specifies the name of the custom language model to use when processing a transcription.
     *          Note that language model names are case sensitive.</p>
     *          <p>The language of the specified language model must match the language code specified
     *          in the transcription request. If the languages don't match, the custom language model isn't
     *          applied. Language mismatches don't generate errors or warnings.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a> in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    LanguageModelName?: string;
    /**
     * <p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy.
     *          For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    EnablePartialResultsStabilization?: boolean;
    /**
     * <p>Specifies the level of stability to use when you enable partial results stabilization
     *             (<code>EnablePartialResultsStabilization</code>).</p>
     *          <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    PartialResultsStability?: PartialResultsStability | string;
    /**
     * <p>Labels all personally identifiable information (PII) identified in your transcript.</p>
     *          <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment.</p>
     *          <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you do, your request returns a <code>BadRequestException</code>.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    ContentIdentificationType?: ContentType | string;
    /**
     * <p>Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *          <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment.</p>
     *          <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you do, your request returns a <code>BadRequestException</code>.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    ContentRedactionType?: ContentType | string;
    /**
     * <p>Specifies the types of personally identifiable information (PII) to redact from a transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
     *          <p>To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both. </p>
     *          <p>Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>,
     *                <code>CREDIT_DEBIT_EXPIRY</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,
     *                <code>NAME</code>, <code>PHONE</code>, <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.</p>
     *          <p>Length Constraints: Minimum length of 1. Maximum length of 300.</p>
     */
    PiiEntityTypes?: string;
    /**
     * <p>If true, <code>UtteranceEvents</code> with <code>IsPartial: true</code> are filtered out of the insights target.</p>
     */
    FilterPartialResults?: boolean;
    /**
     * <p>The settings for a post-call analysis task in an analytics configuration.</p>
     */
    PostCallAnalyticsSettings?: PostCallAnalyticsSettings;
    /**
     * <p>By default, all <code>CategoryEvents</code> will be sent to the insights target. If this parameter is specified, only included categories will be sent to the insights target. </p>
     */
    CallAnalyticsStreamCategories?: string[];
}
/**
 * @public
 * <p>A structure that contains the configuration settings for an Amazon Transcribe processor.</p>
 */
export interface AmazonTranscribeProcessorConfiguration {
    /**
     * <p>The language code that represents the language spoken in your audio.</p>
     *          <p>If you're unsure of the language spoken in your audio, consider using
     *             <code>IdentifyLanguage</code> to enable automatic language identification.</p>
     *          <p>For a list of languages that real-time Call Analytics supports, see the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages table</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    LanguageCode: CallAnalyticsLanguageCode | string | undefined;
    /**
     * <p>The name of the custom vocabulary that you specified in your Call Analytics
     *          request.</p>
     *          <p>Length Constraints: Minimum length of 1. Maximum length of 200.</p>
     */
    VocabularyName?: string;
    /**
     * <p>The name of the custom vocabulary filter that you specified in your Call Analytics
     *          request.</p>
     *          <p>Length Constraints: Minimum length of 1. Maximum length of 200.</p>
     */
    VocabularyFilterName?: string;
    /**
     * <p>The vocabulary filtering method used in your Call Analytics transcription.</p>
     */
    VocabularyFilterMethod?: VocabularyFilterMethod | string;
    /**
     * <p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a> in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    ShowSpeakerLabel?: boolean;
    /**
     * <p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    EnablePartialResultsStabilization?: boolean;
    /**
     * <p>The level of stability to use when you enable partial results stabilization
     *             (<code>EnablePartialResultsStabilization</code>).</p>
     *          <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    PartialResultsStability?: PartialResultsStability | string;
    /**
     * <p>Labels all personally identifiable information (PII) identified in your transcript.</p>
     *          <p>Content identification is performed at the segment level; PII specified in
     *             <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio
     *          segment.</p>
     *          <p>You can’t set <code>ContentIdentificationType</code> and
     *             <code>ContentRedactionType</code> in the same request. If you set both, your request
     *          returns a <code>BadRequestException</code>.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    ContentIdentificationType?: ContentType | string;
    /**
     * <p>Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *          <p>Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon complete transcription of an audio segment.</p>
     *          <p>You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>
     *          in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    ContentRedactionType?: ContentType | string;
    /**
     * <p>The types of personally identifiable information (PII) to redact from a transcript. You
     *          can include as many types as you'd like, or you can select <code>ALL</code>.</p>
     *          <p>To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both.</p>
     *          <p>Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>,
     *          <code>CREDIT_DEBIT_EXPIRY</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,
     *          <code>NAME</code>, <code>PHONE</code>, <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.</p>
     *          <p>Length Constraints: Minimum length of 1. Maximum length of 300.</p>
     */
    PiiEntityTypes?: string;
    /**
     * <p>The name of the custom language model that you want to use when processing your
     *          transcription. Note that language model names are case sensitive.</p>
     *          <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied.
     *             There are no errors or warnings associated with a language mismatch.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a> in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    LanguageModelName?: string;
    /**
     * <p>If true, <code>TranscriptEvents</code> with <code>IsPartial: true</code> are filtered out of the insights target.</p>
     */
    FilterPartialResults?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const AudioArtifactsConcatenationState: {
    readonly Enabled: "Enabled";
};
/**
 * @public
 */
export type AudioArtifactsConcatenationState = (typeof AudioArtifactsConcatenationState)[keyof typeof AudioArtifactsConcatenationState];
/**
 * @public
 * <p>The audio artifact concatenation configuration object.</p>
 */
export interface AudioConcatenationConfiguration {
    /**
     * <p>Enables or disables the configuration object.</p>
     */
    State: AudioArtifactsConcatenationState | string | undefined;
}
/**
 * @public
 * @enum
 */
export declare const ArtifactsConcatenationState: {
    readonly Disabled: "Disabled";
    readonly Enabled: "Enabled";
};
/**
 * @public
 */
export type ArtifactsConcatenationState = (typeof ArtifactsConcatenationState)[keyof typeof ArtifactsConcatenationState];
/**
 * @public
 * <p>The composited video configuration object for a specified
 *          media pipeline. <code>SourceType</code> must be
 *          <code>ChimeSdkMeeting</code>.</p>
 */
export interface CompositedVideoConcatenationConfiguration {
    /**
     * <p>Enables or disables the configuration object.</p>
     */
    State: ArtifactsConcatenationState | string | undefined;
}
/**
 * @public
 * <p>The composited content configuration object for a specified
 *          media pipeline. </p>
 */
export interface ContentConcatenationConfiguration {
    /**
     * <p>Enables or disables the configuration object.</p>
     */
    State: ArtifactsConcatenationState | string | undefined;
}
/**
 * @public
 * <p>The content configuration object's data channel.</p>
 */
export interface DataChannelConcatenationConfiguration {
    /**
     * <p>Enables or disables the configuration object.</p>
     */
    State: ArtifactsConcatenationState | string | undefined;
}
/**
 * @public
 * <p>The configuration object for an event concatenation pipeline.</p>
 */
export interface MeetingEventsConcatenationConfiguration {
    /**
     * <p>Enables or disables the configuration object.</p>
     */
    State: ArtifactsConcatenationState | string | undefined;
}
/**
 * @public
 * <p>The configuration object for concatenating transcription messages.</p>
 */
export interface TranscriptionMessagesConcatenationConfiguration {
    /**
     * <p>Enables or disables the configuration object.</p>
     */
    State: ArtifactsConcatenationState | string | undefined;
}
/**
 * @public
 * <p>The configuration object of a video concatenation pipeline.</p>
 */
export interface VideoConcatenationConfiguration {
    /**
     * <p>Enables or disables the configuration object.</p>
     */
    State: ArtifactsConcatenationState | string | undefined;
}
/**
 * @public
 * <p>The configuration for the artifacts concatenation.</p>
 */
export interface ArtifactsConcatenationConfiguration {
    /**
     * <p>The configuration for the audio artifacts concatenation.</p>
     */
    Audio: AudioConcatenationConfiguration | undefined;
    /**
     * <p>The configuration for the video artifacts concatenation.</p>
     */
    Video: VideoConcatenationConfiguration | undefined;
    /**
     * <p>The configuration for the content artifacts concatenation.</p>
     */
    Content: ContentConcatenationConfiguration | undefined;
    /**
     * <p>The configuration for the data channel artifacts concatenation.</p>
     */
    DataChannel: DataChannelConcatenationConfiguration | undefined;
    /**
     * <p>The configuration for the transcription messages artifacts concatenation.</p>
     */
    TranscriptionMessages: TranscriptionMessagesConcatenationConfiguration | undefined;
    /**
     * <p>The configuration for the meeting events artifacts concatenation.</p>
     */
    MeetingEvents: MeetingEventsConcatenationConfiguration | undefined;
    /**
     * <p>The configuration for the composited video artifacts concatenation.</p>
     */
    CompositedVideo: CompositedVideoConcatenationConfiguration | undefined;
}
/**
 * @public
 * @enum
 */
export declare const AudioMuxType: {
    readonly AudioOnly: "AudioOnly";
    readonly AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo";
    readonly AudioWithCompositedVideo: "AudioWithCompositedVideo";
};
/**
 * @public
 */
export type AudioMuxType = (typeof AudioMuxType)[keyof typeof AudioMuxType];
/**
 * @public
 * <p>The audio artifact configuration object.</p>
 */
export interface AudioArtifactsConfiguration {
    /**
     * <p>The MUX type of the audio artifact configuration object.</p>
     */
    MuxType: AudioMuxType | string | undefined;
}
/**
 * @public
 * @enum
 */
export declare const ContentShareLayoutOption: {
    readonly Horizontal: "Horizontal";
    readonly PresenterOnly: "PresenterOnly";
    readonly Vertical: "Vertical";
};
/**
 * @public
 */
export type ContentShareLayoutOption = (typeof ContentShareLayoutOption)[keyof typeof ContentShareLayoutOption];
/**
 * @public
 * @enum
 */
export declare const PresenterPosition: {
    readonly BottomLeft: "BottomLeft";
    readonly BottomRight: "BottomRight";
    readonly TopLeft: "TopLeft";
    readonly TopRight: "TopRight";
};
/**
 * @public
 */
export type PresenterPosition = (typeof PresenterPosition)[keyof typeof PresenterPosition];
/**
 * @public
 * <p>Defines the configuration for a presenter only video tile.</p>
 */
export interface PresenterOnlyConfiguration {
    /**
     * <p>Defines the position of the presenter video tile. Default: <code>TopRight</code>.</p>
     */
    PresenterPosition?: PresenterPosition | string;
}
/**
 * @public
 * <p>Specifies the type of grid layout.</p>
 */
export interface GridViewConfiguration {
    /**
     * <p>Defines the layout of the video tiles when content sharing is enabled.</p>
     */
    ContentShareLayout: ContentShareLayoutOption | string | undefined;
    /**
     * <p>Defines the configuration options for a presenter only video tile.</p>
     */
    PresenterOnlyConfiguration?: PresenterOnlyConfiguration;
}
/**
 * @public
 * @enum
 */
export declare const LayoutOption: {
    readonly GridView: "GridView";
};
/**
 * @public
 */
export type LayoutOption = (typeof LayoutOption)[keyof typeof LayoutOption];
/**
 * @public
 * @enum
 */
export declare const ResolutionOption: {
    readonly FHD: "FHD";
    readonly HD: "HD";
};
/**
 * @public
 */
export type ResolutionOption = (typeof ResolutionOption)[keyof typeof ResolutionOption];
/**
 * @public
 * <p>Specifies the configuration for compositing video artifacts.</p>
 */
export interface CompositedVideoArtifactsConfiguration {
    /**
     * <p>The layout setting, such as <code>GridView</code> in the configuration object.</p>
     */
    Layout?: LayoutOption | string;
    /**
     * <p>The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution: 1920 x 1080.</p>
     */
    Resolution?: ResolutionOption | string;
    /**
     * <p>The <code>GridView</code> configuration setting.</p>
     */
    GridViewConfiguration: GridViewConfiguration | undefined;
}
/**
 * @public
 * @enum
 */
export declare const ContentMuxType: {
    readonly ContentOnly: "ContentOnly";
};
/**
 * @public
 */
export type ContentMuxType = (typeof ContentMuxType)[keyof typeof ContentMuxType];
/**
 * @public
 * @enum
 */
export declare const ArtifactsState: {
    readonly Disabled: "Disabled";
    readonly Enabled: "Enabled";
};
/**
 * @public
 */
export type ArtifactsState = (typeof ArtifactsState)[keyof typeof ArtifactsState];
/**
 * @public
 * <p>The content artifact object.</p>
 */
export interface ContentArtifactsConfiguration {
    /**
     * <p>Indicates whether the content artifact is enabled or disabled.</p>
     */
    State: ArtifactsState | string | undefined;
    /**
     * <p>The MUX type of the artifact configuration.</p>
     */
    MuxType?: ContentMuxType | string;
}
/**
 * @public
 * @enum
 */
export declare const VideoMuxType: {
    readonly VideoOnly: "VideoOnly";
};
/**
 * @public
 */
export type VideoMuxType = (typeof VideoMuxType)[keyof typeof VideoMuxType];
/**
 * @public
 * <p>The video artifact configuration object.</p>
 */
export interface VideoArtifactsConfiguration {
    /**
     * <p>Indicates whether the video artifact is enabled or disabled.</p>
     */
    State: ArtifactsState | string | undefined;
    /**
     * <p>The MUX type of the video artifact configuration object.</p>
     */
    MuxType?: VideoMuxType | string;
}
/**
 * @public
 * <p>The configuration for the artifacts.</p>
 */
export interface ArtifactsConfiguration {
    /**
     * <p>The configuration for the audio artifacts.</p>
     */
    Audio: AudioArtifactsConfiguration | undefined;
    /**
     * <p>The configuration for the video artifacts.</p>
     */
    Video: VideoArtifactsConfiguration | undefined;
    /**
     * <p>The configuration for the content artifacts.</p>
     */
    Content: ContentArtifactsConfiguration | undefined;
    /**
     * <p>Enables video compositing.</p>
     */
    CompositedVideo?: CompositedVideoArtifactsConfiguration;
}
/**
 * @public
 * @enum
 */
export declare const AudioChannelsOption: {
    readonly Mono: "Mono";
    readonly Stereo: "Stereo";
};
/**
 * @public
 */
export type AudioChannelsOption = (typeof AudioChannelsOption)[keyof typeof AudioChannelsOption];
/**
 * @public
 * @enum
 */
export declare const ErrorCode: {
    readonly BadRequest: "BadRequest";
    readonly Forbidden: "Forbidden";
    readonly NotFound: "NotFound";
    readonly ResourceLimitExceeded: "ResourceLimitExceeded";
    readonly ServiceFailure: "ServiceFailure";
    readonly ServiceUnavailable: "ServiceUnavailable";
    readonly Throttling: "Throttling";
};
/**
 * @public
 */
export type ErrorCode = (typeof ErrorCode)[keyof typeof ErrorCode];
/**
 * @public
 * <p>The input parameters don't match the service's restrictions.</p>
 */
export declare class BadRequestException extends __BaseException {
    readonly name: "BadRequestException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<BadRequestException, __BaseException>);
}
/**
 * @public
 * @enum
 */
export declare const ParticipantRole: {
    readonly AGENT: "AGENT";
    readonly CUSTOMER: "CUSTOMER";
};
/**
 * @public
 */
export type ParticipantRole = (typeof ParticipantRole)[keyof typeof ParticipantRole];
/**
 * @public
 * <p>Defines an audio channel in a Kinesis video stream.</p>
 */
export interface ChannelDefinition {
    /**
     * <p>The channel ID.</p>
     */
    ChannelId: number | undefined;
    /**
     * <p>Specifies whether the audio in a channel belongs to the <code>AGENT</code> or <code>CUSTOMER</code>.</p>
     */
    ParticipantRole?: ParticipantRole | string;
}
/**
 * @public
 * <p>The video streams for a specified media pipeline. The total number of
 *          video streams can't exceed 25.</p>
 */
export interface SelectedVideoStreams {
    /**
     * <p>The attendee IDs of the streams selected for a media pipeline. </p>
     */
    AttendeeIds?: string[];
    /**
     * <p>The external user IDs of the streams selected for a media pipeline.</p>
     */
    ExternalUserIds?: string[];
}
/**
 * @public
 * <p>Source configuration for a specified media pipeline.</p>
 */
export interface SourceConfiguration {
    /**
     * <p>The selected video streams for a specified media pipeline. The number
     *          of video streams can't exceed 25.</p>
     */
    SelectedVideoStreams?: SelectedVideoStreams;
}
/**
 * @public
 * <p>The configuration object of the Amazon Chime SDK meeting for a specified media pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
 */
export interface ChimeSdkMeetingConfiguration {
    /**
     * <p>The source configuration for a specified media pipeline.</p>
     */
    SourceConfiguration?: SourceConfiguration;
    /**
     * <p>The configuration for the artifacts in an Amazon Chime SDK meeting.</p>
     */
    ArtifactsConfiguration?: ArtifactsConfiguration;
}
/**
 * @public
 * @enum
 */
export declare const MediaPipelineSinkType: {
    readonly S3Bucket: "S3Bucket";
};
/**
 * @public
 */
export type MediaPipelineSinkType = (typeof MediaPipelineSinkType)[keyof typeof MediaPipelineSinkType];
/**
 * @public
 * @enum
 */
export declare const MediaPipelineSourceType: {
    readonly ChimeSdkMeeting: "ChimeSdkMeeting";
};
/**
 * @public
 */
export type MediaPipelineSourceType = (typeof MediaPipelineSourceType)[keyof typeof MediaPipelineSourceType];
/**
 * @public
 * <p>A key/value pair that grants users access to meeting resources.</p>
 */
export interface Tag {
    /**
     * <p>The key half of a tag.</p>
     */
    Key: string | undefined;
    /**
     * <p>The value half of a tag.</p>
     */
    Value: string | undefined;
}
/**
 * @public
 */
export interface CreateMediaCapturePipelineRequest {
    /**
     * <p>Source type from which the media artifacts are captured. A Chime SDK Meeting is the only
     *          supported source.</p>
     */
    SourceType: MediaPipelineSourceType | string | undefined;
    /**
     * <p>ARN of the source from which the media artifacts are captured.</p>
     */
    SourceArn: string | undefined;
    /**
     * <p>Destination type to which the media artifacts are saved. You must use an S3 bucket.</p>
     */
    SinkType: MediaPipelineSinkType | string | undefined;
    /**
     * <p>The ARN of the sink type.</p>
     */
    SinkArn: string | undefined;
    /**
     * <p>The unique identifier for the client request. The token makes the API request idempotent. Use a unique token for each media pipeline request.</p>
     */
    ClientRequestToken?: string;
    /**
     * <p>The configuration for a specified media pipeline. <code>SourceType</code> must
     *          be <code>ChimeSdkMeeting</code>.</p>
     */
    ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
    /**
     * <p>The tag key-value pairs.</p>
     */
    Tags?: Tag[];
}
/**
 * @public
 * @enum
 */
export declare const MediaPipelineStatus: {
    readonly Failed: "Failed";
    readonly InProgress: "InProgress";
    readonly Initializing: "Initializing";
    readonly Paused: "Paused";
    readonly Stopped: "Stopped";
    readonly Stopping: "Stopping";
};
/**
 * @public
 */
export type MediaPipelineStatus = (typeof MediaPipelineStatus)[keyof typeof MediaPipelineStatus];
/**
 * @public
 * <p>A media pipeline object consisting of an ID, source type, source ARN, a sink
 *          type, a sink ARN, and a configuration object.</p>
 */
export interface MediaCapturePipeline {
    /**
     * <p>The ID of a media pipeline.</p>
     */
    MediaPipelineId?: string;
    /**
     * <p>The ARN of the media capture pipeline</p>
     */
    MediaPipelineArn?: string;
    /**
     * <p>Source type from which media artifacts are saved. You must use
     *          <code>ChimeMeeting</code>.</p>
     */
    SourceType?: MediaPipelineSourceType | string;
    /**
     * <p>ARN of the source from which the media artifacts are saved.</p>
     */
    SourceArn?: string;
    /**
     * <p>The status of the media pipeline.</p>
     */
    Status?: MediaPipelineStatus | string;
    /**
     * <p>Destination type to which the media artifacts are saved. You must use an S3
     *          Bucket.</p>
     */
    SinkType?: MediaPipelineSinkType | string;
    /**
     * <p>ARN of the destination to which the media artifacts are saved.</p>
     */
    SinkArn?: string;
    /**
     * <p>The time at which the pipeline was created, in ISO 8601 format.</p>
     */
    CreatedTimestamp?: Date;
    /**
     * <p>The time at which the pipeline was updated, in ISO 8601 format.</p>
     */
    UpdatedTimestamp?: Date;
    /**
     * <p>The configuration for a specified media pipeline. <code>SourceType</code> must
     *          be <code>ChimeSdkMeeting</code>.</p>
     */
    ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
}
/**
 * @public
 */
export interface CreateMediaCapturePipelineResponse {
    /**
     * <p>A media pipeline object, the ID, source type, source ARN, sink type, and sink
     *          ARN of a media pipeline object.</p>
     */
    MediaCapturePipeline?: MediaCapturePipeline;
}
/**
 * @public
 * <p>The client is permanently forbidden from making the request.</p>
 */
export declare class ForbiddenException extends __BaseException {
    readonly name: "ForbiddenException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request id associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
/**
 * @public
 * <p>The request exceeds the resource limit.</p>
 */
export declare class ResourceLimitExceededException extends __BaseException {
    readonly name: "ResourceLimitExceededException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>);
}
/**
 * @public
 * <p>The service encountered an unexpected error.</p>
 */
export declare class ServiceFailureException extends __BaseException {
    readonly name: "ServiceFailureException";
    readonly $fault: "server";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ServiceFailureException, __BaseException>);
}
/**
 * @public
 * <p>The service is currently unavailable.</p>
 */
export declare class ServiceUnavailableException extends __BaseException {
    readonly name: "ServiceUnavailableException";
    readonly $fault: "server";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>);
}
/**
 * @public
 * <p>The client exceeded its request rate limit.</p>
 */
export declare class ThrottledClientException extends __BaseException {
    readonly name: "ThrottledClientException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ThrottledClientException, __BaseException>);
}
/**
 * @public
 * <p>The client is not currently authorized to make the request.</p>
 */
export declare class UnauthorizedClientException extends __BaseException {
    readonly name: "UnauthorizedClientException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>);
}
/**
 * @public
 * <p>The configuration settings for the S3 bucket.</p>
 */
export interface S3BucketSinkConfiguration {
    /**
     * <p>The destination URL of the S3 bucket.</p>
     */
    Destination: string | undefined;
}
/**
 * @public
 * @enum
 */
export declare const ConcatenationSinkType: {
    readonly S3Bucket: "S3Bucket";
};
/**
 * @public
 */
export type ConcatenationSinkType = (typeof ConcatenationSinkType)[keyof typeof ConcatenationSinkType];
/**
 * @public
 * <p>The data sink of the configuration object.</p>
 */
export interface ConcatenationSink {
    /**
     * <p>The type of data sink in the configuration object.</p>
     */
    Type: ConcatenationSinkType | string | undefined;
    /**
     * <p>The configuration settings for an Amazon S3 bucket sink.</p>
     */
    S3BucketSinkConfiguration: S3BucketSinkConfiguration | undefined;
}
/**
 * @public
 * <p>The configuration object of the Amazon Chime SDK meeting concatenation for a specified
 *          media pipeline.</p>
 */
export interface ChimeSdkMeetingConcatenationConfiguration {
    /**
     * <p>The configuration for the artifacts in an Amazon Chime SDK meeting concatenation.</p>
     */
    ArtifactsConfiguration: ArtifactsConcatenationConfiguration | undefined;
}
/**
 * @public
 * <p>The source configuration object of a media capture pipeline.</p>
 */
export interface MediaCapturePipelineSourceConfiguration {
    /**
     * <p>The media pipeline ARN in the configuration object of a media capture pipeline.</p>
     */
    MediaPipelineArn: string | undefined;
    /**
     * <p>The meeting configuration settings in a media capture pipeline configuration object. </p>
     */
    ChimeSdkMeetingConfiguration: ChimeSdkMeetingConcatenationConfiguration | undefined;
}
/**
 * @public
 * @enum
 */
export declare const ConcatenationSourceType: {
    readonly MediaCapturePipeline: "MediaCapturePipeline";
};
/**
 * @public
 */
export type ConcatenationSourceType = (typeof ConcatenationSourceType)[keyof typeof ConcatenationSourceType];
/**
 * @public
 * <p>The source type and media pipeline configuration settings in a configuration object.</p>
 */
export interface ConcatenationSource {
    /**
     * <p>The type of concatenation source in a configuration object.</p>
     */
    Type: ConcatenationSourceType | string | undefined;
    /**
     * <p>The concatenation settings for the media pipeline in a configuration object.</p>
     */
    MediaCapturePipelineSourceConfiguration: MediaCapturePipelineSourceConfiguration | undefined;
}
/**
 * @public
 */
export interface CreateMediaConcatenationPipelineRequest {
    /**
     * <p>An object that specifies the sources for the media concatenation pipeline.</p>
     */
    Sources: ConcatenationSource[] | undefined;
    /**
     * <p>An object that specifies the data sinks for the media concatenation pipeline.</p>
     */
    Sinks: ConcatenationSink[] | undefined;
    /**
     * <p>The unique identifier for the client request. The token makes the API request
     *          idempotent. Use a unique token for each media concatenation pipeline request.</p>
     */
    ClientRequestToken?: string;
    /**
     * <p>The tags associated with the media concatenation pipeline.</p>
     */
    Tags?: Tag[];
}
/**
 * @public
 * <p>Concatenates audio and video data from one or more data streams.</p>
 */
export interface MediaConcatenationPipeline {
    /**
     * <p>The ID of the media pipeline being concatenated.</p>
     */
    MediaPipelineId?: string;
    /**
     * <p>The ARN of the media pipeline that you specify in the <code>SourceConfiguration</code> object.</p>
     */
    MediaPipelineArn?: string;
    /**
     * <p>The data sources being concatenated.</p>
     */
    Sources?: ConcatenationSource[];
    /**
     * <p>The data sinks of the concatenation pipeline.</p>
     */
    Sinks?: ConcatenationSink[];
    /**
     * <p>The status of the concatenation pipeline.</p>
     */
    Status?: MediaPipelineStatus | string;
    /**
     * <p>The time at which the concatenation pipeline was created.</p>
     */
    CreatedTimestamp?: Date;
    /**
     * <p>The time at which the concatenation pipeline was last updated.</p>
     */
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateMediaConcatenationPipelineResponse {
    /**
     * <p>A media concatenation pipeline object, the ID, source type, <code>MediaPipelineARN</code>, and sink of a
     *          media concatenation pipeline object.</p>
     */
    MediaConcatenationPipeline?: MediaConcatenationPipeline;
}
/**
 * @public
 * @enum
 */
export declare const FragmentSelectorType: {
    readonly ProducerTimestamp: "ProducerTimestamp";
    readonly ServerTimestamp: "ServerTimestamp";
};
/**
 * @public
 */
export type FragmentSelectorType = (typeof FragmentSelectorType)[keyof typeof FragmentSelectorType];
/**
 * @public
 * <p>The range of timestamps to return.</p>
 */
export interface TimestampRange {
    /**
     * <p>The starting timestamp for the specified range.</p>
     */
    StartTimestamp: Date | undefined;
    /**
     * <p>The ending timestamp for the specified range.</p>
     */
    EndTimestamp: Date | undefined;
}
/**
 * @public
 * <p>Describes the timestamp range and timestamp origin of a range of fragments.</p>
 *          <p>Only fragments with a start timestamp greater than or equal to the given start time and less than or equal to the end time are returned.
 *          For example, say a stream contains fragments with the following start timestamps:</p>
 *          <ul>
 *             <li>
 *                <p>00:00:00</p>
 *             </li>
 *             <li>
 *                <p>00:00:02</p>
 *             </li>
 *             <li>
 *                <p>00:00:04</p>
 *             </li>
 *             <li>
 *                <p>00:00:06</p>
 *             </li>
 *          </ul>
 *          <p>A fragment selector range with a start time of 00:00:01 and end time of 00:00:04 would return the fragments with start times of 00:00:02 and 00:00:04.</p>
 */
export interface FragmentSelector {
    /**
     * <p>The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more information, see
     *          <a href="kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html#KinesisVideo-Type-dataplane_StartSelector-StartSelectorType">StartSelectorType</a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.</p>
     */
    FragmentSelectorType: FragmentSelectorType | string | undefined;
    /**
     * <p>The range of timestamps to return.</p>
     */
    TimestampRange: TimestampRange | undefined;
}
/**
 * @public
 * <p>A structure the holds the settings for recording audio and video.</p>
 */
export interface RecordingStreamConfiguration {
    /**
     * <p>The ARN of the recording stream.</p>
     */
    StreamArn?: string;
}
/**
 * @public
 * <p>A structure that contains the runtime settings for recording a Kinesis video stream.</p>
 */
export interface KinesisVideoStreamRecordingSourceRuntimeConfiguration {
    /**
     * <p>The stream or streams to be recorded.</p>
     */
    Streams: RecordingStreamConfiguration[] | undefined;
    /**
     * <p>Describes the timestamp range and timestamp origin of a range of fragments in the Kinesis video stream.</p>
     */
    FragmentSelector: FragmentSelector | undefined;
}
/**
 * @public
 * @enum
 */
export declare const MediaEncoding: {
    readonly PCM: "pcm";
};
/**
 * @public
 */
export type MediaEncoding = (typeof MediaEncoding)[keyof typeof MediaEncoding];
/**
 * @public
 * <p>Defines a streaming channel.</p>
 */
export interface StreamChannelDefinition {
    /**
     * <p>The number of channels in a streaming channel.</p>
     */
    NumberOfChannels: number | undefined;
    /**
     * <p>The definitions of the channels in a streaming channel.</p>
     */
    ChannelDefinitions?: ChannelDefinition[];
}
/**
 * @public
 * <p>The configuration settings for a stream.</p>
 */
export interface StreamConfiguration {
    /**
     * <p>The ARN of the stream.</p>
     */
    StreamArn: string | undefined;
    /**
     * <p>The unique identifier of the fragment to begin processing.</p>
     */
    FragmentNumber?: string;
    /**
     * <p>The streaming channel definition in the stream configuration.</p>
     */
    StreamChannelDefinition: StreamChannelDefinition | undefined;
}
/**
 * @public
 * <p>The runtime configuration settings for the Kinesis video stream source.</p>
 */
export interface KinesisVideoStreamSourceRuntimeConfiguration {
    /**
     * <p>The streams in the source runtime configuration of a Kinesis video stream.</p>
     */
    Streams: StreamConfiguration[] | undefined;
    /**
     * <p>Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a> in the <i>Amazon Transcribe Developer Guide</i>.</p>
     */
    MediaEncoding: MediaEncoding | string | undefined;
    /**
     * <p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone
     *          audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to
     *          48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
     *          <p>Valid Range: Minimum value of 8000. Maximum value of 48000.</p>
     */
    MediaSampleRate: number | undefined;
}
/**
 * @public
 * @enum
 */
export declare const RecordingFileFormat: {
    readonly Opus: "Opus";
    readonly Wav: "Wav";
};
/**
 * @public
 */
export type RecordingFileFormat = (typeof RecordingFileFormat)[keyof typeof RecordingFileFormat];
/**
 * @public
 * <p>A structure that holds the settings for transmitting audio and video recordings to the runtime Amazon S3 bucket.</p>
 */
export interface S3RecordingSinkRuntimeConfiguration {
    /**
     * <p>The URL of the S3 bucket used as the runtime sink.</p>
     */
    Destination: string | undefined;
    /**
     * <p>The file formats for the audio and video files sent to the Amazon S3 bucket.</p>
     */
    RecordingFileFormat: RecordingFileFormat | string | undefined;
}
/**
 * @public
 */
export interface CreateMediaInsightsPipelineRequest {
    /**
     * <p>The ARN of the pipeline's configuration.</p>
     */
    MediaInsightsPipelineConfigurationArn: string | undefined;
    /**
     * <p>The runtime configuration for the Kinesis video stream source of the media insights
     *          pipeline.</p>
     */
    KinesisVideoStreamSourceRuntimeConfiguration?: KinesisVideoStreamSourceRuntimeConfiguration;
    /**
     * <p>The runtime metadata for the media insights pipeline. Consists of a key-value map of strings.</p>
     */
    MediaInsightsRuntimeMetadata?: Record<string, string>;
    /**
     * <p>The runtime configuration for the Kinesis video recording stream source.</p>
     */
    KinesisVideoStreamRecordingSourceRuntimeConfiguration?: KinesisVideoStreamRecordingSourceRuntimeConfiguration;
    /**
     * <p>The runtime configuration for the S3 recording sink.</p>
     */
    S3RecordingSinkRuntimeConfiguration?: S3RecordingSinkRuntimeConfiguration;
    /**
     * <p>The tags assigned to the media insights pipeline.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The unique identifier for the media insights pipeline request.</p>
     */
    ClientRequestToken?: string;
}
/**
 * @public
 * <p>A media pipeline that streams call analytics data.</p>
 */
export interface MediaInsightsPipeline {
    /**
     * <p>The ID of a media insights pipeline.</p>
     */
    MediaPipelineId?: string;
    /**
     * <p>The ARN of a media insights pipeline.</p>
     */
    MediaPipelineArn?: string;
    /**
     * <p>The ARN of a media insight pipeline's configuration settings.</p>
     */
    MediaInsightsPipelineConfigurationArn?: string;
    /**
     * <p>The status of a media insights pipeline.</p>
     */
    Status?: MediaPipelineStatus | string;
    /**
     * <p>The configuration settings for a Kinesis runtime video stream in a media insights pipeline.</p>
     */
    KinesisVideoStreamSourceRuntimeConfiguration?: KinesisVideoStreamSourceRuntimeConfiguration;
    /**
     * <p>The runtime metadata of a media insights pipeline.</p>
     */
    MediaInsightsRuntimeMetadata?: Record<string, string>;
    /**
     * <p>The runtime configuration settings for a Kinesis recording video stream in a media insights pipeline.</p>
     */
    KinesisVideoStreamRecordingSourceRuntimeConfiguration?: KinesisVideoStreamRecordingSourceRuntimeConfiguration;
    /**
     * <p>The runtime configuration of the Amazon S3 bucket that stores recordings in a media insights pipeline.</p>
     */
    S3RecordingSinkRuntimeConfiguration?: S3RecordingSinkRuntimeConfiguration;
    /**
     * <p>The time at which the media insights pipeline was created.</p>
     */
    CreatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateMediaInsightsPipelineResponse {
    /**
     * <p>The media insights pipeline object.</p>
     */
    MediaInsightsPipeline: MediaInsightsPipeline | undefined;
}
/**
 * @public
 * <p>One or more of the resources in the request does not exist in the system.</p>
 */
export declare class NotFoundException extends __BaseException {
    readonly name: "NotFoundException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
/**
 * @public
 * <p>A structure that contains the configuration settings for a Kinesis Data Stream sink.</p>
 */
export interface KinesisDataStreamSinkConfiguration {
    /**
     * <p>The URL of the sink, <a href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.</p>
     */
    InsightsTarget?: string;
}
/**
 * @public
 * <p>A structure that contains the configuration settings for an AWS Lambda function's data sink.</p>
 */
export interface LambdaFunctionSinkConfiguration {
    /**
     * <p>The URL of the sink, <a href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.</p>
     */
    InsightsTarget?: string;
}
/**
 * @public
 * <p>The structure that holds the settings for transmitting audio and video to the Amazon S3 bucket.</p>
 */
export interface S3RecordingSinkConfiguration {
    /**
     * <p>The URL of the Amazon S3 bucket used as the recording sink.</p>
     */
    Destination?: string;
}
/**
 * @public
 * <p>The configuration settings for the SNS topic sink.</p>
 */
export interface SnsTopicSinkConfiguration {
    /**
     * <p>The URL of the SNS sink, <a href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.</p>
     */
    InsightsTarget?: string;
}
/**
 * @public
 * <p>The URL of the SQS sink.</p>
 */
export interface SqsQueueSinkConfiguration {
    /**
     * <p>The URL of the SQS sink, <a href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.</p>
     */
    InsightsTarget?: string;
}
/**
 * @public
 * @enum
 */
export declare const MediaInsightsPipelineConfigurationElementType: {
    readonly AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR: "AmazonTranscribeCallAnalyticsProcessor";
    readonly AMAZON_TRANSCRIBE_PROCESSOR: "AmazonTranscribeProcessor";
    readonly KINESIS_DATA_STREAM_SINK: "KinesisDataStreamSink";
    readonly LAMBDA_FUNCTION_SINK: "LambdaFunctionSink";
    readonly S3_RECORDING_SINK: "S3RecordingSink";
    readonly SNS_TOPIC_SINK: "SnsTopicSink";
    readonly SQS_QUEUE_SINK: "SqsQueueSink";
    readonly VOICE_ANALYTICS_PROCESSOR: "VoiceAnalyticsProcessor";
};
/**
 * @public
 */
export type MediaInsightsPipelineConfigurationElementType = (typeof MediaInsightsPipelineConfigurationElementType)[keyof typeof MediaInsightsPipelineConfigurationElementType];
/**
 * @public
 * @enum
 */
export declare const VoiceAnalyticsConfigurationStatus: {
    readonly DISABLED: "Disabled";
    readonly ENABLED: "Enabled";
};
/**
 * @public
 */
export type VoiceAnalyticsConfigurationStatus = (typeof VoiceAnalyticsConfigurationStatus)[keyof typeof VoiceAnalyticsConfigurationStatus];
/**
 * @public
 * <p>The configuration settings for a voice analytics processor.</p>
 */
export interface VoiceAnalyticsProcessorConfiguration {
    /**
     * <p>The status of the speaker search task.</p>
     */
    SpeakerSearchStatus?: VoiceAnalyticsConfigurationStatus | string;
    /**
     * <p>The status of the voice tone analysis task.</p>
     */
    VoiceToneAnalysisStatus?: VoiceAnalyticsConfigurationStatus | string;
}
/**
 * @public
 * <p>An element in a media insights pipeline configuration.</p>
 */
export interface MediaInsightsPipelineConfigurationElement {
    /**
     * <p>The element type.</p>
     */
    Type: MediaInsightsPipelineConfigurationElementType | string | undefined;
    /**
     * <p>The analytics configuration settings for transcribing audio in a media insights pipeline configuration element.</p>
     */
    AmazonTranscribeCallAnalyticsProcessorConfiguration?: AmazonTranscribeCallAnalyticsProcessorConfiguration;
    /**
     * <p>The transcription processor configuration settings in a media insights pipeline
     *          configuration element.</p>
     */
    AmazonTranscribeProcessorConfiguration?: AmazonTranscribeProcessorConfiguration;
    /**
     * <p>The configuration settings for the Kinesis Data Stream Sink in a media insights pipeline configuration element.</p>
     */
    KinesisDataStreamSinkConfiguration?: KinesisDataStreamSinkConfiguration;
    /**
     * <p>The configuration settings for the Amazon S3 recording bucket in a media insights pipeline configuration element.</p>
     */
    S3RecordingSinkConfiguration?: S3RecordingSinkConfiguration;
    /**
     * <p>The voice analytics configuration settings in a media insights pipeline configuration element.</p>
     */
    VoiceAnalyticsProcessorConfiguration?: VoiceAnalyticsProcessorConfiguration;
    /**
     * <p>The configuration settings for the Amazon Web Services Lambda sink in a media insights pipeline configuration element.</p>
     */
    LambdaFunctionSinkConfiguration?: LambdaFunctionSinkConfiguration;
    /**
     * <p>The configuration settings for an SQS queue sink in a media insights pipeline configuration element.</p>
     */
    SqsQueueSinkConfiguration?: SqsQueueSinkConfiguration;
    /**
     * <p>The configuration settings for an SNS topic sink in a media insights pipeline configuration element.</p>
     */
    SnsTopicSinkConfiguration?: SnsTopicSinkConfiguration;
}
/**
 * @public
 * <p>A structure that contains the configuration settings for an issue detection task.</p>
 */
export interface IssueDetectionConfiguration {
    /**
     * <p>The name of the issue detection rule.</p>
     */
    RuleName: string | undefined;
}
/**
 * @public
 * <p>A structure that contains the settings for a keyword match task.</p>
 */
export interface KeywordMatchConfiguration {
    /**
     * <p>The name of the keyword match rule.</p>
     */
    RuleName: string | undefined;
    /**
     * <p>The keywords or phrases that you want to match.</p>
     */
    Keywords: string[] | undefined;
    /**
     * <p>Matches keywords or phrases on their presence or absence. If set to <code>TRUE</code>, the rule matches when all
     *          the specified keywords or phrases are absent. Default: <code>FALSE</code>.</p>
     */
    Negate?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const SentimentType: {
    readonly NEGATIVE: "NEGATIVE";
};
/**
 * @public
 */
export type SentimentType = (typeof SentimentType)[keyof typeof SentimentType];
/**
 * @public
 * <p>A structure that contains the configuration settings for a sentiment analysis task.</p>
 */
export interface SentimentConfiguration {
    /**
     * <p>The name of the rule in the sentiment configuration.</p>
     */
    RuleName: string | undefined;
    /**
     * <p>The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.</p>
     */
    SentimentType: SentimentType | string | undefined;
    /**
     * <p>Specifies the analysis interval.</p>
     */
    TimePeriod: number | undefined;
}
/**
 * @public
 * @enum
 */
export declare const RealTimeAlertRuleType: {
    readonly IssueDetection: "IssueDetection";
    readonly KeywordMatch: "KeywordMatch";
    readonly Sentiment: "Sentiment";
};
/**
 * @public
 */
export type RealTimeAlertRuleType = (typeof RealTimeAlertRuleType)[keyof typeof RealTimeAlertRuleType];
/**
 * @public
 * <p>Specifies the words or phrases that trigger an alert.</p>
 */
export interface RealTimeAlertRule {
    /**
     * <p>The type of alert rule.</p>
     */
    Type: RealTimeAlertRuleType | string | undefined;
    /**
     * <p>Specifies the settings for matching the keywords in a real-time alert rule.</p>
     */
    KeywordMatchConfiguration?: KeywordMatchConfiguration;
    /**
     * <p>Specifies the settings for predicting sentiment in a real-time alert rule.</p>
     */
    SentimentConfiguration?: SentimentConfiguration;
    /**
     * <p>Specifies the issue detection settings for a real-time alert rule.</p>
     */
    IssueDetectionConfiguration?: IssueDetectionConfiguration;
}
/**
 * @public
 * <p>A structure that contains the configuration settings for real-time alerts.</p>
 */
export interface RealTimeAlertConfiguration {
    /**
     * <p>Turns off real-time alerts.</p>
     */
    Disabled?: boolean;
    /**
     * <p>The rules in the alert. Rules specify the words or phrases that you want to be notified about.</p>
     */
    Rules?: RealTimeAlertRule[];
}
/**
 * @public
 */
export interface CreateMediaInsightsPipelineConfigurationRequest {
    /**
     * <p>The name of the media insights pipeline configuration.</p>
     */
    MediaInsightsPipelineConfigurationName: string | undefined;
    /**
     * <p>The ARN of the role used by the service to access Amazon Web Services resources,
     *          including <code>Transcribe</code> and <code>Transcribe Call Analytics</code>, on the
     *          caller’s behalf.</p>
     */
    ResourceAccessRoleArn: string | undefined;
    /**
     * <p>The configuration settings for the real-time alerts in a media insights pipeline configuration.</p>
     */
    RealTimeAlertConfiguration?: RealTimeAlertConfiguration;
    /**
     * <p>The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream.</p>
     */
    Elements: MediaInsightsPipelineConfigurationElement[] | undefined;
    /**
     * <p>The tags assigned to the media insights pipeline configuration.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The unique identifier for the media insights pipeline configuration request.</p>
     */
    ClientRequestToken?: string;
}
/**
 * @public
 * <p>A structure that contains the configuration settings for a media insights pipeline.</p>
 */
export interface MediaInsightsPipelineConfiguration {
    /**
     * <p>The name of the configuration.</p>
     */
    MediaInsightsPipelineConfigurationName?: string;
    /**
     * <p>The ARN of the configuration.</p>
     */
    MediaInsightsPipelineConfigurationArn?: string;
    /**
     * <p>The ARN of the role used by the service to access Amazon Web Services resources.</p>
     */
    ResourceAccessRoleArn?: string;
    /**
     * <p>Lists the rules that trigger a real-time alert.</p>
     */
    RealTimeAlertConfiguration?: RealTimeAlertConfiguration;
    /**
     * <p>The elements in the configuration.</p>
     */
    Elements?: MediaInsightsPipelineConfigurationElement[];
    /**
     * <p>The ID of the configuration.</p>
     */
    MediaInsightsPipelineConfigurationId?: string;
    /**
     * <p>The time at which the configuration was created.</p>
     */
    CreatedTimestamp?: Date;
    /**
     * <p>The time at which the configuration was last updated.</p>
     */
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateMediaInsightsPipelineConfigurationResponse {
    /**
     * <p>The configuration settings for the media insights pipeline.</p>
     */
    MediaInsightsPipelineConfiguration?: MediaInsightsPipelineConfiguration;
}
/**
 * @public
 * <p>The media pipeline's RTMP configuration object.</p>
 */
export interface LiveConnectorRTMPConfiguration {
    /**
     * <p>The URL of the RTMP configuration.</p>
     */
    Url: string | undefined;
    /**
     * <p>The audio channels set for the RTMP configuration</p>
     */
    AudioChannels?: AudioChannelsOption | string;
    /**
     * <p>The audio sample rate set for the RTMP configuration. Default: 48000.</p>
     */
    AudioSampleRate?: string;
}
/**
 * @public
 * @enum
 */
export declare const LiveConnectorSinkType: {
    readonly RTMP: "RTMP";
};
/**
 * @public
 */
export type LiveConnectorSinkType = (typeof LiveConnectorSinkType)[keyof typeof LiveConnectorSinkType];
/**
 * @public
 * <p>The media pipeline's sink configuration settings.</p>
 */
export interface LiveConnectorSinkConfiguration {
    /**
     * <p>The sink configuration's sink type.</p>
     */
    SinkType: LiveConnectorSinkType | string | undefined;
    /**
     * <p>The sink configuration's RTMP configuration settings.</p>
     */
    RTMPConfiguration: LiveConnectorRTMPConfiguration | undefined;
}
/**
 * @public
 * @enum
 */
export declare const LiveConnectorMuxType: {
    readonly AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo";
    readonly AudioWithCompositedVideo: "AudioWithCompositedVideo";
};
/**
 * @public
 */
export type LiveConnectorMuxType = (typeof LiveConnectorMuxType)[keyof typeof LiveConnectorMuxType];
/**
 * @public
 * <p>The media pipeline's configuration object.</p>
 */
export interface ChimeSdkMeetingLiveConnectorConfiguration {
    /**
     * <p>The configuration object's Chime SDK meeting ARN.</p>
     */
    Arn: string | undefined;
    /**
     * <p>The configuration object's multiplex type.</p>
     */
    MuxType: LiveConnectorMuxType | string | undefined;
    /**
     * <p>The media pipeline's composited video.</p>
     */
    CompositedVideo?: CompositedVideoArtifactsConfiguration;
    /**
     * <p>The source configuration settings of the media pipeline's configuration object.</p>
     */
    SourceConfiguration?: SourceConfiguration;
}
/**
 * @public
 * @enum
 */
export declare const LiveConnectorSourceType: {
    readonly ChimeSdkMeeting: "ChimeSdkMeeting";
};
/**
 * @public
 */
export type LiveConnectorSourceType = (typeof LiveConnectorSourceType)[keyof typeof LiveConnectorSourceType];
/**
 * @public
 * <p>The data source configuration object of a streaming media pipeline.</p>
 */
export interface LiveConnectorSourceConfiguration {
    /**
     * <p>The source configuration's media source type.</p>
     */
    SourceType: LiveConnectorSourceType | string | undefined;
    /**
     * <p>The configuration settings of the connector pipeline.</p>
     */
    ChimeSdkMeetingLiveConnectorConfiguration: ChimeSdkMeetingLiveConnectorConfiguration | undefined;
}
/**
 * @public
 */
export interface CreateMediaLiveConnectorPipelineRequest {
    /**
     * <p>The media live connector pipeline's data sources.</p>
     */
    Sources: LiveConnectorSourceConfiguration[] | undefined;
    /**
     * <p>The media live connector pipeline's data sinks.</p>
     */
    Sinks: LiveConnectorSinkConfiguration[] | undefined;
    /**
     * <p>The token assigned to the client making the request.</p>
     */
    ClientRequestToken?: string;
    /**
     * <p>The tags associated with the media live connector pipeline.</p>
     */
    Tags?: Tag[];
}
/**
 * @public
 * <p>The connector pipeline.</p>
 */
export interface MediaLiveConnectorPipeline {
    /**
     * <p>The connector pipeline's data sources.</p>
     */
    Sources?: LiveConnectorSourceConfiguration[];
    /**
     * <p>The connector pipeline's data sinks.</p>
     */
    Sinks?: LiveConnectorSinkConfiguration[];
    /**
     * <p>The connector pipeline's ID.</p>
     */
    MediaPipelineId?: string;
    /**
     * <p>The connector pipeline's ARN.</p>
     */
    MediaPipelineArn?: string;
    /**
     * <p>The connector pipeline's status.</p>
     */
    Status?: MediaPipelineStatus | string;
    /**
     * <p>The time at which the connector pipeline was created.</p>
     */
    CreatedTimestamp?: Date;
    /**
     * <p>The time at which the connector pipeline was last updated.</p>
     */
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateMediaLiveConnectorPipelineResponse {
    /**
     * <p>The new media live connector pipeline.</p>
     */
    MediaLiveConnectorPipeline?: MediaLiveConnectorPipeline;
}
/**
 * @public
 */
export interface DeleteMediaCapturePipelineRequest {
    /**
     * <p>The ID of the media pipeline being deleted. </p>
     */
    MediaPipelineId: string | undefined;
}
/**
 * @public
 * <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 */
export declare class ConflictException extends __BaseException {
    readonly name: "ConflictException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * <p>The request ID associated with the call responsible for the exception.</p>
     */
    RequestId?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
/**
 * @public
 */
export interface DeleteMediaInsightsPipelineConfigurationRequest {
    /**
     * <p>The unique identifier of the resource to be deleted. Valid values include the name and ARN of the media insights pipeline configuration.</p>
     */
    Identifier: string | undefined;
}
/**
 * @public
 */
export interface DeleteMediaPipelineRequest {
    /**
     * <p>The ID of the media pipeline to delete.</p>
     */
    MediaPipelineId: string | undefined;
}
/**
 * @public
 */
export interface GetMediaCapturePipelineRequest {
    /**
     * <p>The ID of the pipeline that you want to get.</p>
     */
    MediaPipelineId: string | undefined;
}
/**
 * @public
 */
export interface GetMediaCapturePipelineResponse {
    /**
     * <p>The media pipeline object.</p>
     */
    MediaCapturePipeline?: MediaCapturePipeline;
}
/**
 * @public
 */
export interface GetMediaInsightsPipelineConfigurationRequest {
    /**
     * <p>The unique identifier of the requested resource.  Valid values include the name and ARN of the media insights pipeline configuration.</p>
     */
    Identifier: string | undefined;
}
/**
 * @public
 */
export interface GetMediaInsightsPipelineConfigurationResponse {
    /**
     * <p>The requested media insights pipeline configuration.</p>
     */
    MediaInsightsPipelineConfiguration?: MediaInsightsPipelineConfiguration;
}
/**
 * @public
 */
export interface GetMediaPipelineRequest {
    /**
     * <p>The ID of the pipeline that you want to get.</p>
     */
    MediaPipelineId: string | undefined;
}
/**
 * @public
 * <p>A pipeline consisting of a media capture, media concatenation, or live-streaming pipeline.</p>
 */
export interface MediaPipeline {
    /**
     * <p>A pipeline that enables users to capture audio and video.</p>
     */
    MediaCapturePipeline?: MediaCapturePipeline;
    /**
     * <p>The connector pipeline of the media pipeline.</p>
     */
    MediaLiveConnectorPipeline?: MediaLiveConnectorPipeline;
    /**
     * <p>The media concatenation pipeline in a media pipeline.</p>
     */
    MediaConcatenationPipeline?: MediaConcatenationPipeline;
    /**
     * <p>The media insights pipeline of a media pipeline.</p>
     */
    MediaInsightsPipeline?: MediaInsightsPipeline;
}
/**
 * @public
 */
export interface GetMediaPipelineResponse {
    /**
     * <p>The media pipeline object.</p>
     */
    MediaPipeline?: MediaPipeline;
}
/**
 * @public
 */
export interface ListMediaCapturePipelinesRequest {
    /**
     * <p>The token used to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>
     */
    MaxResults?: number;
}
/**
 * @public
 * <p>The summary data of a media capture pipeline.</p>
 */
export interface MediaCapturePipelineSummary {
    /**
     * <p>The ID of the media pipeline in the summary.</p>
     */
    MediaPipelineId?: string;
    /**
     * <p>The ARN of the media pipeline in the summary.</p>
     */
    MediaPipelineArn?: string;
}
/**
 * @public
 */
export interface ListMediaCapturePipelinesResponse {
    /**
     * <p>The media pipeline objects in the list.</p>
     */
    MediaCapturePipelines?: MediaCapturePipelineSummary[];
    /**
     * <p>The token used to retrieve the next page of results. </p>
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface ListMediaInsightsPipelineConfigurationsRequest {
    /**
     * <p>The token used to return the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call.</p>
     */
    MaxResults?: number;
}
/**
 * @public
 * <p>A summary of the media insights pipeline configuration.</p>
 */
export interface MediaInsightsPipelineConfigurationSummary {
    /**
     * <p>The name of the media insights pipeline configuration.</p>
     */
    MediaInsightsPipelineConfigurationName?: string;
    /**
     * <p>The ID of the media insights pipeline configuration.</p>
     */
    MediaInsightsPipelineConfigurationId?: string;
    /**
     * <p>The ARN of the media insights pipeline configuration.</p>
     */
    MediaInsightsPipelineConfigurationArn?: string;
}
/**
 * @public
 */
export interface ListMediaInsightsPipelineConfigurationsResponse {
    /**
     * <p>The requested list of media insights pipeline configurations.</p>
     */
    MediaInsightsPipelineConfigurations?: MediaInsightsPipelineConfigurationSummary[];
    /**
     * <p>The token used to return the next page of results. </p>
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface ListMediaPipelinesRequest {
    /**
     * <p>The token used to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>
     */
    MaxResults?: number;
}
/**
 * @public
 * <p>The summary of the media pipeline.</p>
 */
export interface MediaPipelineSummary {
    /**
     * <p>The ID of the media pipeline in the summary.</p>
     */
    MediaPipelineId?: string;
    /**
     * <p>The ARN of the media pipeline in the summary.</p>
     */
    MediaPipelineArn?: string;
}
/**
 * @public
 */
export interface ListMediaPipelinesResponse {
    /**
     * <p>The media pipeline objects in the list.</p>
     */
    MediaPipelines?: MediaPipelineSummary[];
    /**
     * <p>The token used to retrieve the next page of results. </p>
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface ListTagsForResourceRequest {
    /**
     * <p>The ARN of the media pipeline associated with any tags. The ARN consists of the pipeline's region, resource ID, and pipeline ID.</p>
     */
    ResourceARN: string | undefined;
}
/**
 * @public
 */
export interface ListTagsForResourceResponse {
    /**
     * <p>The tags associated with the specified media pipeline.</p>
     */
    Tags?: Tag[];
}
/**
 * @public
 */
export interface TagResourceRequest {
    /**
     * <p>The ARN of the media pipeline associated with any tags. The ARN consists of the pipeline's endpoint region, resource ID, and pipeline ID.</p>
     */
    ResourceARN: string | undefined;
    /**
     * <p>The tags associated with the specified media pipeline.</p>
     */
    Tags: Tag[] | undefined;
}
/**
 * @public
 */
export interface TagResourceResponse {
}
/**
 * @public
 */
export interface UntagResourceRequest {
    /**
     * <p>The ARN of the pipeline that you want to untag.</p>
     */
    ResourceARN: string | undefined;
    /**
     * <p>The key/value pairs in the tag that you want to remove.</p>
     */
    TagKeys: string[] | undefined;
}
/**
 * @public
 */
export interface UntagResourceResponse {
}
/**
 * @public
 */
export interface UpdateMediaInsightsPipelineConfigurationRequest {
    /**
     * <p>The unique identifier for the resource to be updated. Valid values include the name and ARN of the media insights pipeline configuration.</p>
     */
    Identifier: string | undefined;
    /**
     * <p>The ARN of the role used by the service to access Amazon Web Services resources.</p>
     */
    ResourceAccessRoleArn: string | undefined;
    /**
     * <p>The configuration settings for real-time alerts for the media insights pipeline.</p>
     */
    RealTimeAlertConfiguration?: RealTimeAlertConfiguration;
    /**
     * <p>The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream..</p>
     */
    Elements: MediaInsightsPipelineConfigurationElement[] | undefined;
}
/**
 * @public
 */
export interface UpdateMediaInsightsPipelineConfigurationResponse {
    /**
     * <p>The updated configuration settings.</p>
     */
    MediaInsightsPipelineConfiguration?: MediaInsightsPipelineConfiguration;
}
/**
 * @public
 * @enum
 */
export declare const MediaPipelineStatusUpdate: {
    readonly Pause: "Pause";
    readonly Resume: "Resume";
};
/**
 * @public
 */
export type MediaPipelineStatusUpdate = (typeof MediaPipelineStatusUpdate)[keyof typeof MediaPipelineStatusUpdate];
/**
 * @public
 */
export interface UpdateMediaInsightsPipelineStatusRequest {
    /**
     * <p>The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media insights pipeline.</p>
     */
    Identifier: string | undefined;
    /**
     * <p>The requested status of the media insights pipeline.</p>
     */
    UpdateStatus: MediaPipelineStatusUpdate | string | undefined;
}
/**
 * @internal
 */
export declare const SelectedVideoStreamsFilterSensitiveLog: (obj: SelectedVideoStreams) => any;
/**
 * @internal
 */
export declare const SourceConfigurationFilterSensitiveLog: (obj: SourceConfiguration) => any;
/**
 * @internal
 */
export declare const ChimeSdkMeetingConfigurationFilterSensitiveLog: (obj: ChimeSdkMeetingConfiguration) => any;
/**
 * @internal
 */
export declare const CreateMediaCapturePipelineRequestFilterSensitiveLog: (obj: CreateMediaCapturePipelineRequest) => any;
/**
 * @internal
 */
export declare const MediaCapturePipelineFilterSensitiveLog: (obj: MediaCapturePipeline) => any;
/**
 * @internal
 */
export declare const CreateMediaCapturePipelineResponseFilterSensitiveLog: (obj: CreateMediaCapturePipelineResponse) => any;
/**
 * @internal
 */
export declare const S3BucketSinkConfigurationFilterSensitiveLog: (obj: S3BucketSinkConfiguration) => any;
/**
 * @internal
 */
export declare const ConcatenationSinkFilterSensitiveLog: (obj: ConcatenationSink) => any;
/**
 * @internal
 */
export declare const MediaCapturePipelineSourceConfigurationFilterSensitiveLog: (obj: MediaCapturePipelineSourceConfiguration) => any;
/**
 * @internal
 */
export declare const ConcatenationSourceFilterSensitiveLog: (obj: ConcatenationSource) => any;
/**
 * @internal
 */
export declare const CreateMediaConcatenationPipelineRequestFilterSensitiveLog: (obj: CreateMediaConcatenationPipelineRequest) => any;
/**
 * @internal
 */
export declare const MediaConcatenationPipelineFilterSensitiveLog: (obj: MediaConcatenationPipeline) => any;
/**
 * @internal
 */
export declare const CreateMediaConcatenationPipelineResponseFilterSensitiveLog: (obj: CreateMediaConcatenationPipelineResponse) => any;
/**
 * @internal
 */
export declare const S3RecordingSinkRuntimeConfigurationFilterSensitiveLog: (obj: S3RecordingSinkRuntimeConfiguration) => any;
/**
 * @internal
 */
export declare const CreateMediaInsightsPipelineRequestFilterSensitiveLog: (obj: CreateMediaInsightsPipelineRequest) => any;
/**
 * @internal
 */
export declare const MediaInsightsPipelineFilterSensitiveLog: (obj: MediaInsightsPipeline) => any;
/**
 * @internal
 */
export declare const CreateMediaInsightsPipelineResponseFilterSensitiveLog: (obj: CreateMediaInsightsPipelineResponse) => any;
/**
 * @internal
 */
export declare const KinesisDataStreamSinkConfigurationFilterSensitiveLog: (obj: KinesisDataStreamSinkConfiguration) => any;
/**
 * @internal
 */
export declare const LambdaFunctionSinkConfigurationFilterSensitiveLog: (obj: LambdaFunctionSinkConfiguration) => any;
/**
 * @internal
 */
export declare const S3RecordingSinkConfigurationFilterSensitiveLog: (obj: S3RecordingSinkConfiguration) => any;
/**
 * @internal
 */
export declare const SnsTopicSinkConfigurationFilterSensitiveLog: (obj: SnsTopicSinkConfiguration) => any;
/**
 * @internal
 */
export declare const SqsQueueSinkConfigurationFilterSensitiveLog: (obj: SqsQueueSinkConfiguration) => any;
/**
 * @internal
 */
export declare const MediaInsightsPipelineConfigurationElementFilterSensitiveLog: (obj: MediaInsightsPipelineConfigurationElement) => any;
/**
 * @internal
 */
export declare const CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog: (obj: CreateMediaInsightsPipelineConfigurationRequest) => any;
/**
 * @internal
 */
export declare const MediaInsightsPipelineConfigurationFilterSensitiveLog: (obj: MediaInsightsPipelineConfiguration) => any;
/**
 * @internal
 */
export declare const CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog: (obj: CreateMediaInsightsPipelineConfigurationResponse) => any;
/**
 * @internal
 */
export declare const LiveConnectorRTMPConfigurationFilterSensitiveLog: (obj: LiveConnectorRTMPConfiguration) => any;
/**
 * @internal
 */
export declare const LiveConnectorSinkConfigurationFilterSensitiveLog: (obj: LiveConnectorSinkConfiguration) => any;
/**
 * @internal
 */
export declare const ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog: (obj: ChimeSdkMeetingLiveConnectorConfiguration) => any;
/**
 * @internal
 */
export declare const LiveConnectorSourceConfigurationFilterSensitiveLog: (obj: LiveConnectorSourceConfiguration) => any;
/**
 * @internal
 */
export declare const CreateMediaLiveConnectorPipelineRequestFilterSensitiveLog: (obj: CreateMediaLiveConnectorPipelineRequest) => any;
/**
 * @internal
 */
export declare const MediaLiveConnectorPipelineFilterSensitiveLog: (obj: MediaLiveConnectorPipeline) => any;
/**
 * @internal
 */
export declare const CreateMediaLiveConnectorPipelineResponseFilterSensitiveLog: (obj: CreateMediaLiveConnectorPipelineResponse) => any;
/**
 * @internal
 */
export declare const GetMediaCapturePipelineResponseFilterSensitiveLog: (obj: GetMediaCapturePipelineResponse) => any;
/**
 * @internal
 */
export declare const GetMediaInsightsPipelineConfigurationResponseFilterSensitiveLog: (obj: GetMediaInsightsPipelineConfigurationResponse) => any;
/**
 * @internal
 */
export declare const MediaPipelineFilterSensitiveLog: (obj: MediaPipeline) => any;
/**
 * @internal
 */
export declare const GetMediaPipelineResponseFilterSensitiveLog: (obj: GetMediaPipelineResponse) => any;
/**
 * @internal
 */
export declare const MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog: (obj: MediaInsightsPipelineConfigurationSummary) => any;
/**
 * @internal
 */
export declare const ListMediaInsightsPipelineConfigurationsResponseFilterSensitiveLog: (obj: ListMediaInsightsPipelineConfigurationsResponse) => any;
/**
 * @internal
 */
export declare const UpdateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog: (obj: UpdateMediaInsightsPipelineConfigurationRequest) => any;
/**
 * @internal
 */
export declare const UpdateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog: (obj: UpdateMediaInsightsPipelineConfigurationResponse) => any;
