import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { GetChannelMembershipPreferencesRequest, GetChannelMembershipPreferencesResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link GetChannelMembershipPreferencesCommand}.
 */
export interface GetChannelMembershipPreferencesCommandInput extends GetChannelMembershipPreferencesRequest {
}
/**
 * @public
 *
 * The output of {@link GetChannelMembershipPreferencesCommand}.
 */
export interface GetChannelMembershipPreferencesCommandOutput extends GetChannelMembershipPreferencesResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Gets the membership preferences of an <code>AppInstanceUser</code> or <code>AppInstanceBot</code>
 *          for the specified channel. A user or a bot must be a member of the channel and own the membership to be able
 *          to retrieve membership preferences. Users or bots in the <code>AppInstanceAdmin</code> and channel moderator roles can't
 *          retrieve preferences for other users or bots. Banned users or bots can't retrieve membership preferences for the
 *          channel from which they are banned.</p>
 *          <note>
 *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
 *          ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in
 *          the header.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, GetChannelMembershipPreferencesCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, GetChannelMembershipPreferencesCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const input = { // GetChannelMembershipPreferencesRequest
 *   ChannelArn: "STRING_VALUE", // required
 *   MemberArn: "STRING_VALUE", // required
 *   ChimeBearer: "STRING_VALUE", // required
 * };
 * const command = new GetChannelMembershipPreferencesCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param GetChannelMembershipPreferencesCommandInput - {@link GetChannelMembershipPreferencesCommandInput}
 * @returns {@link GetChannelMembershipPreferencesCommandOutput}
 * @see {@link GetChannelMembershipPreferencesCommandInput} for command's `input` shape.
 * @see {@link GetChannelMembershipPreferencesCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class GetChannelMembershipPreferencesCommand extends $Command<GetChannelMembershipPreferencesCommandInput, GetChannelMembershipPreferencesCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: GetChannelMembershipPreferencesCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: GetChannelMembershipPreferencesCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetChannelMembershipPreferencesCommandInput, GetChannelMembershipPreferencesCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
