import {
  Account,
  AccountSettings,
  Address,
  AlexaForBusinessMetadata,
  AppInstanceAdminSummary,
  AppInstanceRetentionSettings,
  AppInstanceStreamingConfiguration,
  AppInstanceSummary,
  AppInstanceUserSummary,
  Attendee,
  Bot,
  BusinessCallingSettings,
  CandidateAddress,
  Capability,
  ChannelBanSummary,
  ChannelMembershipForAppInstanceUserSummary,
  ChannelMembershipSummary,
  ChannelMembershipType,
  ChannelMessagePersistenceType,
  ChannelMessageSummary,
  ChannelMessageType,
  ChannelMode,
  ChannelModeratedByAppInstanceUserSummary,
  ChannelModeratorSummary,
  ChannelPrivacy,
  ChannelSummary,
  ConversationRetentionSettings,
  Credential,
  EmailStatus,
  EmergencyCallingConfiguration,
  EngineTranscribeMedicalSettings,
  EngineTranscribeSettings,
  EventsConfiguration,
  InviteStatus,
  License,
  MediaCapturePipeline,
  Meeting,
  PhoneNumber,
  PhoneNumberAssociationName,
  PhoneNumberOrder,
  PhoneNumberProductType,
  PhoneNumberStatus,
  PhoneNumberType,
  ProxySession,
  ProxySessionStatus,
  Room,
  RoomMembership,
  RoomMembershipRole,
  SipMediaApplication,
  SipMediaApplicationCall,
  SipMediaApplicationEndpoint,
  SipRule,
  SipRuleTargetApplication,
  Tag,
  User,
  UserType,
  VoiceConnector,
  VoiceConnectorGroup,
  VoiceConnectorItem,
  VoiceConnectorSettings,
} from "./models_0";
export interface RoomRetentionSettings {
  RetentionDays?: number;
}
export interface RetentionSettings {
  RoomRetentionSettings?: RoomRetentionSettings;
  ConversationRetentionSettings?: ConversationRetentionSettings;
}
export interface GetRetentionSettingsResponse {
  RetentionSettings?: RetentionSettings;
  InitiateDeletionTimestamp?: Date;
}
export interface GetRoomRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
}
export interface GetRoomResponse {
  Room?: Room;
}
export interface GetSipMediaApplicationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface GetSipMediaApplicationResponse {
  SipMediaApplication?: SipMediaApplication;
}
export interface GetSipMediaApplicationLoggingConfigurationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface SipMediaApplicationLoggingConfiguration {
  EnableSipMediaApplicationMessageLogs?: boolean;
}
export interface GetSipMediaApplicationLoggingConfigurationResponse {
  SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface GetSipRuleRequest {
  SipRuleId: string | undefined;
}
export interface GetSipRuleResponse {
  SipRule?: SipRule;
}
export interface GetUserRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
}
export interface GetUserResponse {
  User?: User;
}
export interface GetUserSettingsRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
}
export interface TelephonySettings {
  InboundCalling: boolean | undefined;
  OutboundCalling: boolean | undefined;
  SMS: boolean | undefined;
}
export interface UserSettings {
  Telephony: TelephonySettings | undefined;
}
export interface GetUserSettingsResponse {
  UserSettings?: UserSettings;
}
export interface GetVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
}
export interface GetVoiceConnectorResponse {
  VoiceConnector?: VoiceConnector;
}
export interface GetVoiceConnectorEmergencyCallingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface GetVoiceConnectorEmergencyCallingConfigurationResponse {
  EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
export interface GetVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
}
export interface GetVoiceConnectorGroupResponse {
  VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface GetVoiceConnectorLoggingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface LoggingConfiguration {
  EnableSIPLogs?: boolean;
  EnableMediaMetricLogs?: boolean;
}
export interface GetVoiceConnectorLoggingConfigurationResponse {
  LoggingConfiguration?: LoggingConfiguration;
}
export interface GetVoiceConnectorOriginationRequest {
  VoiceConnectorId: string | undefined;
}
export declare const OriginationRouteProtocol: {
  readonly TCP: "TCP";
  readonly UDP: "UDP";
};
export type OriginationRouteProtocol =
  (typeof OriginationRouteProtocol)[keyof typeof OriginationRouteProtocol];
export interface OriginationRoute {
  Host?: string;
  Port?: number;
  Protocol?: OriginationRouteProtocol | string;
  Priority?: number;
  Weight?: number;
}
export interface Origination {
  Routes?: OriginationRoute[];
  Disabled?: boolean;
}
export interface GetVoiceConnectorOriginationResponse {
  Origination?: Origination;
}
export interface GetVoiceConnectorProxyRequest {
  VoiceConnectorId: string | undefined;
}
export interface Proxy {
  DefaultSessionExpiryMinutes?: number;
  Disabled?: boolean;
  FallBackPhoneNumber?: string;
  PhoneNumberCountries?: string[];
}
export interface GetVoiceConnectorProxyResponse {
  Proxy?: Proxy;
}
export interface GetVoiceConnectorStreamingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export declare const NotificationTarget: {
  readonly EventBridge: "EventBridge";
  readonly SNS: "SNS";
  readonly SQS: "SQS";
};
export type NotificationTarget =
  (typeof NotificationTarget)[keyof typeof NotificationTarget];
export interface StreamingNotificationTarget {
  NotificationTarget: NotificationTarget | string | undefined;
}
export interface StreamingConfiguration {
  DataRetentionInHours: number | undefined;
  Disabled?: boolean;
  StreamingNotificationTargets?: StreamingNotificationTarget[];
}
export interface GetVoiceConnectorStreamingConfigurationResponse {
  StreamingConfiguration?: StreamingConfiguration;
}
export interface GetVoiceConnectorTerminationRequest {
  VoiceConnectorId: string | undefined;
}
export interface Termination {
  CpsLimit?: number;
  DefaultPhoneNumber?: string;
  CallingRegions?: string[];
  CidrAllowedList?: string[];
  Disabled?: boolean;
}
export interface GetVoiceConnectorTerminationResponse {
  Termination?: Termination;
}
export interface GetVoiceConnectorTerminationHealthRequest {
  VoiceConnectorId: string | undefined;
}
export interface TerminationHealth {
  Timestamp?: Date;
  Source?: string;
}
export interface GetVoiceConnectorTerminationHealthResponse {
  TerminationHealth?: TerminationHealth;
}
export interface Invite {
  InviteId?: string;
  Status?: InviteStatus | string;
  EmailAddress?: string;
  EmailStatus?: EmailStatus | string;
}
export interface InviteUsersRequest {
  AccountId: string | undefined;
  UserEmailList: string[] | undefined;
  UserType?: UserType | string;
}
export interface InviteUsersResponse {
  Invites?: Invite[];
}
export interface ListAccountsRequest {
  Name?: string;
  UserEmail?: string;
  NextToken?: string;
  MaxResults?: number;
}
export interface ListAccountsResponse {
  Accounts?: Account[];
  NextToken?: string;
}
export interface ListAppInstanceAdminsRequest {
  AppInstanceArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstanceAdminsResponse {
  AppInstanceArn?: string;
  AppInstanceAdmins?: AppInstanceAdminSummary[];
  NextToken?: string;
}
export interface ListAppInstancesRequest {
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstancesResponse {
  AppInstances?: AppInstanceSummary[];
  NextToken?: string;
}
export interface ListAppInstanceUsersRequest {
  AppInstanceArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstanceUsersResponse {
  AppInstanceArn?: string;
  AppInstanceUsers?: AppInstanceUserSummary[];
  NextToken?: string;
}
export interface ListAttendeesRequest {
  MeetingId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
}
export interface ListAttendeesResponse {
  Attendees?: Attendee[];
  NextToken?: string;
}
export interface ListAttendeeTagsRequest {
  MeetingId: string | undefined;
  AttendeeId: string | undefined;
}
export interface ListAttendeeTagsResponse {
  Tags?: Tag[];
}
export interface ListBotsRequest {
  AccountId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListBotsResponse {
  Bots?: Bot[];
  NextToken?: string;
}
export interface ListChannelBansRequest {
  ChannelArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer?: string;
}
export interface ListChannelBansResponse {
  ChannelArn?: string;
  NextToken?: string;
  ChannelBans?: ChannelBanSummary[];
}
export interface ListChannelMembershipsRequest {
  ChannelArn: string | undefined;
  Type?: ChannelMembershipType | string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer?: string;
}
export interface ListChannelMembershipsResponse {
  ChannelArn?: string;
  ChannelMemberships?: ChannelMembershipSummary[];
  NextToken?: string;
}
export interface ListChannelMembershipsForAppInstanceUserRequest {
  AppInstanceUserArn?: string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer?: string;
}
export interface ListChannelMembershipsForAppInstanceUserResponse {
  ChannelMemberships?: ChannelMembershipForAppInstanceUserSummary[];
  NextToken?: string;
}
export declare const SortOrder: {
  readonly ASCENDING: "ASCENDING";
  readonly DESCENDING: "DESCENDING";
};
export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder];
export interface ListChannelMessagesRequest {
  ChannelArn: string | undefined;
  SortOrder?: SortOrder | string;
  NotBefore?: Date;
  NotAfter?: Date;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer?: string;
}
export interface ListChannelMessagesResponse {
  ChannelArn?: string;
  NextToken?: string;
  ChannelMessages?: ChannelMessageSummary[];
}
export interface ListChannelModeratorsRequest {
  ChannelArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer?: string;
}
export interface ListChannelModeratorsResponse {
  ChannelArn?: string;
  NextToken?: string;
  ChannelModerators?: ChannelModeratorSummary[];
}
export interface ListChannelsRequest {
  AppInstanceArn: string | undefined;
  Privacy?: ChannelPrivacy | string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer?: string;
}
export interface ListChannelsResponse {
  Channels?: ChannelSummary[];
  NextToken?: string;
}
export interface ListChannelsModeratedByAppInstanceUserRequest {
  AppInstanceUserArn?: string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer?: string;
}
export interface ListChannelsModeratedByAppInstanceUserResponse {
  Channels?: ChannelModeratedByAppInstanceUserSummary[];
  NextToken?: string;
}
export interface ListMediaCapturePipelinesRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListMediaCapturePipelinesResponse {
  MediaCapturePipelines?: MediaCapturePipeline[];
  NextToken?: string;
}
export interface ListMeetingsRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListMeetingsResponse {
  Meetings?: Meeting[];
  NextToken?: string;
}
export interface ListMeetingTagsRequest {
  MeetingId: string | undefined;
}
export interface ListMeetingTagsResponse {
  Tags?: Tag[];
}
export interface ListPhoneNumberOrdersRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListPhoneNumberOrdersResponse {
  PhoneNumberOrders?: PhoneNumberOrder[];
  NextToken?: string;
}
export interface ListPhoneNumbersRequest {
  Status?: PhoneNumberStatus | string;
  ProductType?: PhoneNumberProductType | string;
  FilterName?: PhoneNumberAssociationName | string;
  FilterValue?: string;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListPhoneNumbersResponse {
  PhoneNumbers?: PhoneNumber[];
  NextToken?: string;
}
export interface ListProxySessionsRequest {
  VoiceConnectorId: string | undefined;
  Status?: ProxySessionStatus | string;
  NextToken?: string;
  MaxResults?: number;
}
export interface ListProxySessionsResponse {
  ProxySessions?: ProxySession[];
  NextToken?: string;
}
export interface ListRoomMembershipsRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListRoomMembershipsResponse {
  RoomMemberships?: RoomMembership[];
  NextToken?: string;
}
export interface ListRoomsRequest {
  AccountId: string | undefined;
  MemberId?: string;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListRoomsResponse {
  Rooms?: Room[];
  NextToken?: string;
}
export interface ListSipMediaApplicationsRequest {
  MaxResults?: number;
  NextToken?: string;
}
export interface ListSipMediaApplicationsResponse {
  SipMediaApplications?: SipMediaApplication[];
  NextToken?: string;
}
export interface ListSipRulesRequest {
  SipMediaApplicationId?: string;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListSipRulesResponse {
  SipRules?: SipRule[];
  NextToken?: string;
}
export interface ListSupportedPhoneNumberCountriesRequest {
  ProductType: PhoneNumberProductType | string | undefined;
}
export interface PhoneNumberCountry {
  CountryCode?: string;
  SupportedPhoneNumberTypes?: (PhoneNumberType | string)[];
}
export interface ListSupportedPhoneNumberCountriesResponse {
  PhoneNumberCountries?: PhoneNumberCountry[];
}
export interface ListTagsForResourceRequest {
  ResourceARN: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Tag[];
}
export interface ListUsersRequest {
  AccountId: string | undefined;
  UserEmail?: string;
  UserType?: UserType | string;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListUsersResponse {
  Users?: User[];
  NextToken?: string;
}
export interface ListVoiceConnectorGroupsRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListVoiceConnectorGroupsResponse {
  VoiceConnectorGroups?: VoiceConnectorGroup[];
  NextToken?: string;
}
export interface ListVoiceConnectorsRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListVoiceConnectorsResponse {
  VoiceConnectors?: VoiceConnector[];
  NextToken?: string;
}
export interface ListVoiceConnectorTerminationCredentialsRequest {
  VoiceConnectorId: string | undefined;
}
export interface ListVoiceConnectorTerminationCredentialsResponse {
  Usernames?: string[];
}
export interface LogoutUserRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
}
export interface LogoutUserResponse {}
export interface PutAppInstanceRetentionSettingsRequest {
  AppInstanceArn: string | undefined;
  AppInstanceRetentionSettings: AppInstanceRetentionSettings | undefined;
}
export interface PutAppInstanceRetentionSettingsResponse {
  AppInstanceRetentionSettings?: AppInstanceRetentionSettings;
  InitiateDeletionTimestamp?: Date;
}
export interface PutAppInstanceStreamingConfigurationsRequest {
  AppInstanceArn: string | undefined;
  AppInstanceStreamingConfigurations:
    | AppInstanceStreamingConfiguration[]
    | undefined;
}
export interface PutAppInstanceStreamingConfigurationsResponse {
  AppInstanceStreamingConfigurations?: AppInstanceStreamingConfiguration[];
}
export interface PutEventsConfigurationRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
  OutboundEventsHTTPSEndpoint?: string;
  LambdaFunctionArn?: string;
}
export interface PutEventsConfigurationResponse {
  EventsConfiguration?: EventsConfiguration;
}
export interface PutRetentionSettingsRequest {
  AccountId: string | undefined;
  RetentionSettings: RetentionSettings | undefined;
}
export interface PutRetentionSettingsResponse {
  RetentionSettings?: RetentionSettings;
  InitiateDeletionTimestamp?: Date;
}
export interface PutSipMediaApplicationLoggingConfigurationRequest {
  SipMediaApplicationId: string | undefined;
  SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface PutSipMediaApplicationLoggingConfigurationResponse {
  SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface PutVoiceConnectorEmergencyCallingConfigurationRequest {
  VoiceConnectorId: string | undefined;
  EmergencyCallingConfiguration: EmergencyCallingConfiguration | undefined;
}
export interface PutVoiceConnectorEmergencyCallingConfigurationResponse {
  EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
export interface PutVoiceConnectorLoggingConfigurationRequest {
  VoiceConnectorId: string | undefined;
  LoggingConfiguration: LoggingConfiguration | undefined;
}
export interface PutVoiceConnectorLoggingConfigurationResponse {
  LoggingConfiguration?: LoggingConfiguration;
}
export interface PutVoiceConnectorOriginationRequest {
  VoiceConnectorId: string | undefined;
  Origination: Origination | undefined;
}
export interface PutVoiceConnectorOriginationResponse {
  Origination?: Origination;
}
export interface PutVoiceConnectorProxyRequest {
  VoiceConnectorId: string | undefined;
  DefaultSessionExpiryMinutes: number | undefined;
  PhoneNumberPoolCountries: string[] | undefined;
  FallBackPhoneNumber?: string;
  Disabled?: boolean;
}
export interface PutVoiceConnectorProxyResponse {
  Proxy?: Proxy;
}
export interface PutVoiceConnectorStreamingConfigurationRequest {
  VoiceConnectorId: string | undefined;
  StreamingConfiguration: StreamingConfiguration | undefined;
}
export interface PutVoiceConnectorStreamingConfigurationResponse {
  StreamingConfiguration?: StreamingConfiguration;
}
export interface PutVoiceConnectorTerminationRequest {
  VoiceConnectorId: string | undefined;
  Termination: Termination | undefined;
}
export interface PutVoiceConnectorTerminationResponse {
  Termination?: Termination;
}
export interface PutVoiceConnectorTerminationCredentialsRequest {
  VoiceConnectorId: string | undefined;
  Credentials?: Credential[];
}
export interface RedactChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer?: string;
}
export interface RedactChannelMessageResponse {
  ChannelArn?: string;
  MessageId?: string;
}
export interface RedactConversationMessageRequest {
  AccountId: string | undefined;
  ConversationId: string | undefined;
  MessageId: string | undefined;
}
export interface RedactConversationMessageResponse {}
export interface RedactRoomMessageRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MessageId: string | undefined;
}
export interface RedactRoomMessageResponse {}
export interface RegenerateSecurityTokenRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
}
export interface RegenerateSecurityTokenResponse {
  Bot?: Bot;
}
export interface ResetPersonalPINRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
}
export interface ResetPersonalPINResponse {
  User?: User;
}
export interface RestorePhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export interface RestorePhoneNumberResponse {
  PhoneNumber?: PhoneNumber;
}
export interface SearchAvailablePhoneNumbersRequest {
  AreaCode?: string;
  City?: string;
  Country?: string;
  State?: string;
  TollFreePrefix?: string;
  PhoneNumberType?: PhoneNumberType | string;
  MaxResults?: number;
  NextToken?: string;
}
export interface SearchAvailablePhoneNumbersResponse {
  E164PhoneNumbers?: string[];
  NextToken?: string;
}
export interface SendChannelMessageRequest {
  ChannelArn: string | undefined;
  Content: string | undefined;
  Type: ChannelMessageType | string | undefined;
  Persistence: ChannelMessagePersistenceType | string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  ChimeBearer?: string;
}
export interface SendChannelMessageResponse {
  ChannelArn?: string;
  MessageId?: string;
}
export interface TranscriptionConfiguration {
  EngineTranscribeSettings?: EngineTranscribeSettings;
  EngineTranscribeMedicalSettings?: EngineTranscribeMedicalSettings;
}
export interface StartMeetingTranscriptionRequest {
  MeetingId: string | undefined;
  TranscriptionConfiguration: TranscriptionConfiguration | undefined;
}
export interface StartMeetingTranscriptionResponse {}
export interface StopMeetingTranscriptionRequest {
  MeetingId: string | undefined;
}
export interface StopMeetingTranscriptionResponse {}
export interface TagAttendeeRequest {
  MeetingId: string | undefined;
  AttendeeId: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagMeetingRequest {
  MeetingId: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagResourceRequest {
  ResourceARN: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagAttendeeRequest {
  MeetingId: string | undefined;
  AttendeeId: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagMeetingRequest {
  MeetingId: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceRequest {
  ResourceARN: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UpdateAccountRequest {
  AccountId: string | undefined;
  Name?: string;
  DefaultLicense?: License | string;
}
export interface UpdateAccountResponse {
  Account?: Account;
}
export interface UpdateAccountSettingsRequest {
  AccountId: string | undefined;
  AccountSettings: AccountSettings | undefined;
}
export interface UpdateAccountSettingsResponse {}
export interface UpdateAppInstanceRequest {
  AppInstanceArn: string | undefined;
  Name: string | undefined;
  Metadata?: string;
}
export interface UpdateAppInstanceResponse {
  AppInstanceArn?: string;
}
export interface UpdateAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
  Name: string | undefined;
  Metadata?: string;
}
export interface UpdateAppInstanceUserResponse {
  AppInstanceUserArn?: string;
}
export interface UpdateBotRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
  Disabled?: boolean;
}
export interface UpdateBotResponse {
  Bot?: Bot;
}
export interface UpdateChannelRequest {
  ChannelArn: string | undefined;
  Name: string | undefined;
  Mode: ChannelMode | string | undefined;
  Metadata?: string;
  ChimeBearer?: string;
}
export interface UpdateChannelResponse {
  ChannelArn?: string;
}
export interface UpdateChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  Content?: string;
  Metadata?: string;
  ChimeBearer?: string;
}
export interface UpdateChannelMessageResponse {
  ChannelArn?: string;
  MessageId?: string;
}
export interface UpdateChannelReadMarkerRequest {
  ChannelArn: string | undefined;
  ChimeBearer?: string;
}
export interface UpdateChannelReadMarkerResponse {
  ChannelArn?: string;
}
export interface UpdateGlobalSettingsRequest {
  BusinessCalling?: BusinessCallingSettings;
  VoiceConnector?: VoiceConnectorSettings;
}
export interface UpdatePhoneNumberRequest {
  PhoneNumberId: string | undefined;
  ProductType?: PhoneNumberProductType | string;
  CallingName?: string;
}
export interface UpdatePhoneNumberResponse {
  PhoneNumber?: PhoneNumber;
}
export interface UpdatePhoneNumberSettingsRequest {
  CallingName: string | undefined;
}
export interface UpdateProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
  Capabilities: (Capability | string)[] | undefined;
  ExpiryMinutes?: number;
}
export interface UpdateProxySessionResponse {
  ProxySession?: ProxySession;
}
export interface UpdateRoomRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  Name?: string;
}
export interface UpdateRoomResponse {
  Room?: Room;
}
export interface UpdateRoomMembershipRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MemberId: string | undefined;
  Role?: RoomMembershipRole | string;
}
export interface UpdateRoomMembershipResponse {
  RoomMembership?: RoomMembership;
}
export interface UpdateSipMediaApplicationRequest {
  SipMediaApplicationId: string | undefined;
  Name?: string;
  Endpoints?: SipMediaApplicationEndpoint[];
}
export interface UpdateSipMediaApplicationResponse {
  SipMediaApplication?: SipMediaApplication;
}
export interface UpdateSipMediaApplicationCallRequest {
  SipMediaApplicationId: string | undefined;
  TransactionId: string | undefined;
  Arguments: Record<string, string> | undefined;
}
export interface UpdateSipMediaApplicationCallResponse {
  SipMediaApplicationCall?: SipMediaApplicationCall;
}
export interface UpdateSipRuleRequest {
  SipRuleId: string | undefined;
  Name: string | undefined;
  Disabled?: boolean;
  TargetApplications?: SipRuleTargetApplication[];
}
export interface UpdateSipRuleResponse {
  SipRule?: SipRule;
}
export interface UpdateUserRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
  LicenseType?: License | string;
  UserType?: UserType | string;
  AlexaForBusinessMetadata?: AlexaForBusinessMetadata;
}
export interface UpdateUserResponse {
  User?: User;
}
export interface UpdateUserSettingsRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
  UserSettings: UserSettings | undefined;
}
export interface UpdateVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  Name: string | undefined;
  RequireEncryption: boolean | undefined;
}
export interface UpdateVoiceConnectorResponse {
  VoiceConnector?: VoiceConnector;
}
export interface UpdateVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  Name: string | undefined;
  VoiceConnectorItems: VoiceConnectorItem[] | undefined;
}
export interface UpdateVoiceConnectorGroupResponse {
  VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface ValidateE911AddressRequest {
  AwsAccountId: string | undefined;
  StreetNumber: string | undefined;
  StreetInfo: string | undefined;
  City: string | undefined;
  State: string | undefined;
  Country: string | undefined;
  PostalCode: string | undefined;
}
export interface ValidateE911AddressResponse {
  ValidationResult?: number;
  AddressExternalId?: string;
  Address?: Address;
  CandidateAddressList?: CandidateAddress[];
}
export declare const GetRoomResponseFilterSensitiveLog: (
  obj: GetRoomResponse
) => any;
export declare const GetSipMediaApplicationResponseFilterSensitiveLog: (
  obj: GetSipMediaApplicationResponse
) => any;
export declare const GetUserResponseFilterSensitiveLog: (
  obj: GetUserResponse
) => any;
export declare const GetVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (
  obj: GetVoiceConnectorEmergencyCallingConfigurationResponse
) => any;
export declare const ProxyFilterSensitiveLog: (obj: Proxy) => any;
export declare const GetVoiceConnectorProxyResponseFilterSensitiveLog: (
  obj: GetVoiceConnectorProxyResponse
) => any;
export declare const TerminationFilterSensitiveLog: (obj: Termination) => any;
export declare const GetVoiceConnectorTerminationResponseFilterSensitiveLog: (
  obj: GetVoiceConnectorTerminationResponse
) => any;
export declare const InviteFilterSensitiveLog: (obj: Invite) => any;
export declare const InviteUsersRequestFilterSensitiveLog: (
  obj: InviteUsersRequest
) => any;
export declare const InviteUsersResponseFilterSensitiveLog: (
  obj: InviteUsersResponse
) => any;
export declare const ListAccountsRequestFilterSensitiveLog: (
  obj: ListAccountsRequest
) => any;
export declare const ListAppInstanceAdminsRequestFilterSensitiveLog: (
  obj: ListAppInstanceAdminsRequest
) => any;
export declare const ListAppInstanceAdminsResponseFilterSensitiveLog: (
  obj: ListAppInstanceAdminsResponse
) => any;
export declare const ListAppInstancesRequestFilterSensitiveLog: (
  obj: ListAppInstancesRequest
) => any;
export declare const ListAppInstancesResponseFilterSensitiveLog: (
  obj: ListAppInstancesResponse
) => any;
export declare const ListAppInstanceUsersRequestFilterSensitiveLog: (
  obj: ListAppInstanceUsersRequest
) => any;
export declare const ListAppInstanceUsersResponseFilterSensitiveLog: (
  obj: ListAppInstanceUsersResponse
) => any;
export declare const ListAttendeesResponseFilterSensitiveLog: (
  obj: ListAttendeesResponse
) => any;
export declare const ListAttendeeTagsResponseFilterSensitiveLog: (
  obj: ListAttendeeTagsResponse
) => any;
export declare const ListBotsResponseFilterSensitiveLog: (
  obj: ListBotsResponse
) => any;
export declare const ListChannelBansRequestFilterSensitiveLog: (
  obj: ListChannelBansRequest
) => any;
export declare const ListChannelBansResponseFilterSensitiveLog: (
  obj: ListChannelBansResponse
) => any;
export declare const ListChannelMembershipsRequestFilterSensitiveLog: (
  obj: ListChannelMembershipsRequest
) => any;
export declare const ListChannelMembershipsResponseFilterSensitiveLog: (
  obj: ListChannelMembershipsResponse
) => any;
export declare const ListChannelMembershipsForAppInstanceUserRequestFilterSensitiveLog: (
  obj: ListChannelMembershipsForAppInstanceUserRequest
) => any;
export declare const ListChannelMembershipsForAppInstanceUserResponseFilterSensitiveLog: (
  obj: ListChannelMembershipsForAppInstanceUserResponse
) => any;
export declare const ListChannelMessagesRequestFilterSensitiveLog: (
  obj: ListChannelMessagesRequest
) => any;
export declare const ListChannelMessagesResponseFilterSensitiveLog: (
  obj: ListChannelMessagesResponse
) => any;
export declare const ListChannelModeratorsRequestFilterSensitiveLog: (
  obj: ListChannelModeratorsRequest
) => any;
export declare const ListChannelModeratorsResponseFilterSensitiveLog: (
  obj: ListChannelModeratorsResponse
) => any;
export declare const ListChannelsRequestFilterSensitiveLog: (
  obj: ListChannelsRequest
) => any;
export declare const ListChannelsResponseFilterSensitiveLog: (
  obj: ListChannelsResponse
) => any;
export declare const ListChannelsModeratedByAppInstanceUserRequestFilterSensitiveLog: (
  obj: ListChannelsModeratedByAppInstanceUserRequest
) => any;
export declare const ListChannelsModeratedByAppInstanceUserResponseFilterSensitiveLog: (
  obj: ListChannelsModeratedByAppInstanceUserResponse
) => any;
export declare const ListMediaCapturePipelinesResponseFilterSensitiveLog: (
  obj: ListMediaCapturePipelinesResponse
) => any;
export declare const ListMeetingsResponseFilterSensitiveLog: (
  obj: ListMeetingsResponse
) => any;
export declare const ListMeetingTagsResponseFilterSensitiveLog: (
  obj: ListMeetingTagsResponse
) => any;
export declare const ListPhoneNumberOrdersResponseFilterSensitiveLog: (
  obj: ListPhoneNumberOrdersResponse
) => any;
export declare const ListPhoneNumbersResponseFilterSensitiveLog: (
  obj: ListPhoneNumbersResponse
) => any;
export declare const ListProxySessionsResponseFilterSensitiveLog: (
  obj: ListProxySessionsResponse
) => any;
export declare const ListRoomMembershipsResponseFilterSensitiveLog: (
  obj: ListRoomMembershipsResponse
) => any;
export declare const ListRoomsResponseFilterSensitiveLog: (
  obj: ListRoomsResponse
) => any;
export declare const ListSipMediaApplicationsResponseFilterSensitiveLog: (
  obj: ListSipMediaApplicationsResponse
) => any;
export declare const ListTagsForResourceRequestFilterSensitiveLog: (
  obj: ListTagsForResourceRequest
) => any;
export declare const ListTagsForResourceResponseFilterSensitiveLog: (
  obj: ListTagsForResourceResponse
) => any;
export declare const ListUsersRequestFilterSensitiveLog: (
  obj: ListUsersRequest
) => any;
export declare const ListUsersResponseFilterSensitiveLog: (
  obj: ListUsersResponse
) => any;
export declare const ListVoiceConnectorTerminationCredentialsResponseFilterSensitiveLog: (
  obj: ListVoiceConnectorTerminationCredentialsResponse
) => any;
export declare const PutAppInstanceStreamingConfigurationsRequestFilterSensitiveLog: (
  obj: PutAppInstanceStreamingConfigurationsRequest
) => any;
export declare const PutAppInstanceStreamingConfigurationsResponseFilterSensitiveLog: (
  obj: PutAppInstanceStreamingConfigurationsResponse
) => any;
export declare const PutEventsConfigurationRequestFilterSensitiveLog: (
  obj: PutEventsConfigurationRequest
) => any;
export declare const PutEventsConfigurationResponseFilterSensitiveLog: (
  obj: PutEventsConfigurationResponse
) => any;
export declare const PutVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorEmergencyCallingConfigurationRequest
) => any;
export declare const PutVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (
  obj: PutVoiceConnectorEmergencyCallingConfigurationResponse
) => any;
export declare const PutVoiceConnectorProxyRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorProxyRequest
) => any;
export declare const PutVoiceConnectorProxyResponseFilterSensitiveLog: (
  obj: PutVoiceConnectorProxyResponse
) => any;
export declare const PutVoiceConnectorTerminationRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorTerminationRequest
) => any;
export declare const PutVoiceConnectorTerminationResponseFilterSensitiveLog: (
  obj: PutVoiceConnectorTerminationResponse
) => any;
export declare const PutVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorTerminationCredentialsRequest
) => any;
export declare const RegenerateSecurityTokenResponseFilterSensitiveLog: (
  obj: RegenerateSecurityTokenResponse
) => any;
export declare const ResetPersonalPINResponseFilterSensitiveLog: (
  obj: ResetPersonalPINResponse
) => any;
export declare const RestorePhoneNumberResponseFilterSensitiveLog: (
  obj: RestorePhoneNumberResponse
) => any;
export declare const SearchAvailablePhoneNumbersResponseFilterSensitiveLog: (
  obj: SearchAvailablePhoneNumbersResponse
) => any;
export declare const SendChannelMessageRequestFilterSensitiveLog: (
  obj: SendChannelMessageRequest
) => any;
export declare const TagAttendeeRequestFilterSensitiveLog: (
  obj: TagAttendeeRequest
) => any;
export declare const TagMeetingRequestFilterSensitiveLog: (
  obj: TagMeetingRequest
) => any;
export declare const TagResourceRequestFilterSensitiveLog: (
  obj: TagResourceRequest
) => any;
export declare const UntagAttendeeRequestFilterSensitiveLog: (
  obj: UntagAttendeeRequest
) => any;
export declare const UntagMeetingRequestFilterSensitiveLog: (
  obj: UntagMeetingRequest
) => any;
export declare const UntagResourceRequestFilterSensitiveLog: (
  obj: UntagResourceRequest
) => any;
export declare const UpdateAppInstanceRequestFilterSensitiveLog: (
  obj: UpdateAppInstanceRequest
) => any;
export declare const UpdateAppInstanceUserRequestFilterSensitiveLog: (
  obj: UpdateAppInstanceUserRequest
) => any;
export declare const UpdateBotResponseFilterSensitiveLog: (
  obj: UpdateBotResponse
) => any;
export declare const UpdateChannelRequestFilterSensitiveLog: (
  obj: UpdateChannelRequest
) => any;
export declare const UpdateChannelMessageRequestFilterSensitiveLog: (
  obj: UpdateChannelMessageRequest
) => any;
export declare const UpdatePhoneNumberRequestFilterSensitiveLog: (
  obj: UpdatePhoneNumberRequest
) => any;
export declare const UpdatePhoneNumberResponseFilterSensitiveLog: (
  obj: UpdatePhoneNumberResponse
) => any;
export declare const UpdatePhoneNumberSettingsRequestFilterSensitiveLog: (
  obj: UpdatePhoneNumberSettingsRequest
) => any;
export declare const UpdateProxySessionResponseFilterSensitiveLog: (
  obj: UpdateProxySessionResponse
) => any;
export declare const UpdateRoomRequestFilterSensitiveLog: (
  obj: UpdateRoomRequest
) => any;
export declare const UpdateRoomResponseFilterSensitiveLog: (
  obj: UpdateRoomResponse
) => any;
export declare const UpdateRoomMembershipResponseFilterSensitiveLog: (
  obj: UpdateRoomMembershipResponse
) => any;
export declare const UpdateSipMediaApplicationRequestFilterSensitiveLog: (
  obj: UpdateSipMediaApplicationRequest
) => any;
export declare const UpdateSipMediaApplicationResponseFilterSensitiveLog: (
  obj: UpdateSipMediaApplicationResponse
) => any;
export declare const UpdateSipMediaApplicationCallRequestFilterSensitiveLog: (
  obj: UpdateSipMediaApplicationCallRequest
) => any;
export declare const UpdateUserRequestFilterSensitiveLog: (
  obj: UpdateUserRequest
) => any;
export declare const UpdateUserResponseFilterSensitiveLog: (
  obj: UpdateUserResponse
) => any;
export declare const ValidateE911AddressRequestFilterSensitiveLog: (
  obj: ValidateE911AddressRequest
) => any;
export declare const ValidateE911AddressResponseFilterSensitiveLog: (
  obj: ValidateE911AddressResponse
) => any;
