import { Endpoint, Provider, UrlParser } from "@aws-sdk/types";
import {
  EndpointsInputConfig,
  EndpointsResolvedConfig,
} from "./resolveEndpointsConfig";
export interface CustomEndpointsInputConfig extends EndpointsInputConfig {
  endpoint: string | Endpoint | Provider<Endpoint>;
}
interface PreviouslyResolved {
  urlParser: UrlParser;
}
export interface CustomEndpointsResolvedConfig extends EndpointsResolvedConfig {
  isCustomEndpoint: true;
}
export declare const resolveCustomEndpointsConfig: <T>(
  input: T & CustomEndpointsInputConfig & PreviouslyResolved
) => T & CustomEndpointsResolvedConfig;
export {};
