import numpy as np


SC_PARAMETERS = {

    'TEST': [
        ['Humid', '%', 'Humidity'],
        ['PWR_MEAS[0]', 'A', '12 Volt current, in milliamps'],
        ['TEMP', 'deg C', 'Temperature'],
        ['sys_temp_hum[2]', '%', 'CLB humidity (SHT21 chip)'],
        ['bps_v375', 'ADC', 'Voltage of 375V line (0 to 1023 ADC raw)']
    ],

    'SHORT': [
        #['AHRS_A', np.nan, np.nan], #absent?
        #['AHRS_G', np.nan, np.nan], #absent?
        #['AHRS_H', np.nan, np.nan], #absent?
        ['AHRS_PITCH', np.nan, 'AHRS Pitch'],
        ['AHRS_ROLL', np.nan, 'AHRS Roll'],
        ['AHRS_YAW', np.nan, 'AHRS Yaw'],
        ['ACDC_CUR', np.nan, 'ACDC Current, between 0 and 2560A'],
        ['DOM_Humidity', '%', 'Relative humidity'],
        ['EDFA_OOP', 'dBm', 'Output Optical Power'],
        ['Humid', '%', 'Humidity'],
        ['PWR_MEAS[0]', 'A', '12 Volt current, in milliamps'],
        ['PWR_MEAS[2]', 'A', '1.8 Volt current, in milliamps'],
        ['PWR_MEAS[1]', 'A', '1 Volt current, in milliamps'],
        ['PWR_MEAS[3]', 'A', '2.5 Volt current, in milliamps'],
        ['PWR_MEAS[6]', 'A', '3.3 Volt PMT current, in milliamps'],
        ['PWR_MEAS[4]', 'A', '3.3 Volt current, in milliamps'],
        ['PWR_MEAS[5]', 'A', '5 Volt current, in milliamps'],
        ['PWR_MEAS[10]', '?C', 'Temperature sensor voltage, in millidegree Celsius'],
        ['TEMP', 'deg C', 'Temperature'],
        ['sys_temp_hum[0]', '?C', 'FPGA temperature'],
        ['sys_temp_hum[1]', '?C', 'CLB temperature (SHT21 chip)'],
        ['sys_temp_hum[2]', '%', 'CLB humidity (SHT21 chip)'],
        ['sys_temp_hum[3]', '?C', 'Powerboard ADC temperature'],
        ['sys_temp_hum[4]', '?C', 'White Rabbit temperature'],
        ['sys_temp_hum[5]', '?C', 'SFP temperature'],
        ['acdc_cur', 'A', 'ACDC Current, between 0 and 2560A'],
        ['acdc_temp', 'C', 'ACDC Temperature in degrees Centigrade'],
        ['bps_i12', 'ADC', 'Current of 12V line (0 to 1023 ADC raw)'],
        ['bps_i375', 'ADC', 'Current of 375V line (0 to 1023 ADC raw)'],
        ['bps_iback', 'ADC', 'Backbone current (0 to 1023 ADC raw)'],
        ['edfa_oop', 'dBm', 'Output Optical Power (in milli dBm)'],
        ['edfa_pumpdc', 'A', 'Doide Pump Current (in micro A)'],
        ['edfa_setp_rd', 'dBm', 'Monitored Power Setpoint for APC mode (in milli dBm)'],
        ['edfa_temp', 'C', 'Temperature (in milli degrees celsius)'],
        ['tx_output_power', 'W', 'SFP transmitter power ']
    ],

    'LONG': [ #['#DMOutLogSecsPrescale', 's', 'Divider for seconds from beginning of day to log output variables'],
        ['ACDC_CUR', np.nan, 'ACDC Current, between 0 and 2560A'],
        ['ACDC_TEMP', '*C', 'ACDC Temperature'],
        ['ACDC_VOLT', np.nan, 'ACDC Voltage, between 300 and 556'],
        ['AHRS_A', np.nan, np.nan],
        #['SYS_DISABLE{0:1}', '1', 'Boolean value to disable AHRS'],
        ['AHRS_G', np.nan, np.nan],
        ['AHRS_H', np.nan, np.nan],
        ['AHRS_PITCH', np.nan, np.nan],
        ['AHRS_ROLL', np.nan, np.nan],
        ['AHRS_YAW', np.nan, np.nan],
        #['SYS_RUN_ENA{1:1}', np.nan, 'Boolean value to enable Acoustics (requires all SYS_RUN_ENA parameters)'],
        #['BPS_ALARM', np.nan, 'Alarm Status'],
        #['BPS_ALARM{1:1}', np.nan, 'Alarm status 12V'],
        #['BPS_ALARM{0:1}', np.nan, 'Alarm status 375V'],
        #['BPS_BREAKER', np.nan, 'Breaker status'],
        #['BPS_BREAKER{1:1}', np.nan, 'Breaker status 12V'],
        #['BPS_BREAKER{0:1}', np.nan, 'Breaker status 375V'],
        ['BPS_I12', np.nan, 'Current of 12V line (0 to 1023 ADC raw)'],
        ['(BPS_I12)', 'A', 'Current of 12V line'],
        ['BPS_I375', np.nan, 'Current of 375V line (0 to 1023 ADC raw)'],
        ['(BPS_I375)', 'A', 'Current of 375V line'],
        ['BPS_I5', np.nan, 'Current of 5V line (0 to 1023 ADC raw)'],
        ['(BPS_I5)', 'A', 'Current of 5V line'],
        ['BPS_IBACK', np.nan, 'Backbone current (0 to 1023 ADC raw)'],
        ['(BPS_IBACK)', 'A', 'Backbone current'],
        ['BPS_V375', np.nan, 'Voltage of 375V line (0 to 1023 ADC raw)'],
        ['(BPS_V375)', 'V', 'Voltage of 375V line'],
        ['CABLE_RTT', 's', 'Cable roundtrip time in ps'],
        #['CHAN_ENABLE', '1', 'Bitmask to enable PMTs'],
        ['CLBControlTimeoutMS', np.nan, 'Interval time for CLB data polling in milliseconds'],
        ['CLB_Temperature', 'C', 'Temperature of the CLB'],
        #['DAQ_ADF_DBG_path', np.nan, 'Output path for debug files'],
        #['DAQ_ADF_DOM_configuration', np.nan, 'Acoustic Data Filter search info for a DOM: DOMID Nwaveforms [IDwaveform threshold]'],
        #['DAQ_ADF_TOA_path', np.nan, 'Output path for TOA files'],
        #['DAQ_ADF_analysis_window_overlap', np.nan, 'Overlap of two analysis windows in units of samples'],
        #['DAQ_ADF_analysis_window_size', np.nan, 'Length of analysis window in units of samples'],
        #['DAQ_ADF_waveform', np.nan, 'Waveform identifier'],
        #['DAQ_ADF_wisdom_cache_path', np.nan, 'Storage path for ADF wisdom information'],
        #['DAQ_ProcessList', np.nan, 'Expects the comma-separated list of process types to be listed ("datafilters","dataqueues","datawriters","dispatchers")'],
        #['DAQ_Process_Name', np.nan, 'Name of a process'],
        #['DAQ_acou_ports', np.nan, 'Port for acoustic data'],
        #['DAQ_acou_recipient', np.nan, 'Receiver of acoustic data'],
        #['DAQ_bufferSize', np.nan, 'Size of the datafilter buffer'],
        #['DAQ_dataWriter', np.nan, 'Datawriter to output DataFilter data'],
        #['DAQ_detector', np.nan, 'The detector description in .detx format'],
        #['DAQ_dump_file_postfix', np.nan, 'Postfix of the dump file'],
        #['DAQ_dump_file_prefix', np.nan, 'Prefix of the dump file'],
        #['DAQ_logger_s', 's', 'Update period for error messages'],
        #['DAQ_maxHitsFrame', np.nan, 'Maximum number of hits in a frame'],
        #['DAQ_max_dump_size', np.nan, 'Maximum size of information to dump'],
        #['DAQ_numberOfFramesPerSlice', np.nan, 'Number of frames per slice'],
        #['DAQ_opto_ports', np.nan, 'Port for optical data'],
        #['DAQ_opto_recipients', np.nan, 'Receiver of optical data'],
        #['DAQ_out_server_address', np.nan, 'Output server address for MonRouter'],
        #['DAQ_out_server_port', np.nan, 'Output server port for MonRouter'],
        #['DAQ_path', np.nan, 'Path where the datawriter should write the data'],
        #['DAQ_pmtIdCheck', np.nan, 'Enables checking PMT Id when frames are received'],
        #['DAQ_queueDepth', np.nan, 'Maximal queue depth'],
        #['DAQ_queueSize', np.nan, 'Maximal queue size'],
        #['DAQ_run_start_time', 's', 'Unix time of run start'],
        #['DAQ_timeslice_duration', 's', 'Duration of a timeslice'],
        #['DAQ_triggerParameters=L2.TMaxLocal_ns', 's', 'Maximum local time for a L2 coincidence'],
        #['DAQ_triggerParameters=L2.ctMin', np.nan, 'CTMin of L2 coincidence'],
        #['DAQ_triggerParameters=L2.numberOfHits', np.nan, 'Number of hits for a L2 coincidence'],
        #['DAQ_triggerParameters=L2Min', np.nan, 'Minimum number of L2 triggers'],
        #['DAQ_triggerParameters=SN.TMaxLocal_ns', 's', 'Maximum local time for a SN coincidence'],
        #['DAQ_triggerParameters=SN.ctMin', np.nan, 'CTMin of SN coincidence'],
        #['DAQ_triggerParameters=SN.numberOfHits', np.nan, 'Number of hits for a SN coincidence'],
        #['DAQ_triggerParameters=TMaxEvent_ns', 's', 'Maximal time between first and last hit'],
        #['DAQ_triggerParameters=TMaxLocal_ns', 's', 'Maximum local time'],
        #['DAQ_triggerParameters=combineL1', np.nan, 'Combine consequtive L1s to one'],
        #['DAQ_triggerParameters=ctMin', np.nan, 'CTMin of triggers'],
        #['DAQ_triggerParameters=highRateVeto_Hz', 'Hz', 'Limit on rate'],
        #['DAQ_triggerParameters=numberOfBins', np.nan, 'Number of bins'],
        #['DAQ_triggerParameters=trigger3DMuon.DMax_m', 'm', 'Maximum distance of a trigger from muon'],
        #['DAQ_triggerParameters=trigger3DMuon.TMaxExtra_ns', 's', 'Maximum extra time for a muon trigger'],
        #['DAQ_triggerParameters=trigger3DMuon.enabled', np.nan, 'Enables/disables the muon trigger'],
        #['DAQ_triggerParameters=trigger3DMuon.factoryLimit', np.nan, 'Maximum number of muon triggers'],
        #['DAQ_triggerParameters=trigger3DMuon.gridAngle_deg', 'deg', 'Grid angle for muons in degrees'],
        #['DAQ_triggerParameters=trigger3DMuon.numberOfHits', np.nan, 'Number of hits for a muon trigger'],
        #['DAQ_triggerParameters=trigger3DMuon.numberOfModules', np.nan, 'Number of modules for a muon trigger'],
        #['DAQ_triggerParameters=trigger3DMuon.roadWidth_m', 'm', 'Road width for track reconstruction'],
        #['DAQ_triggerParameters=trigger3DShower.DMax_m', 'm', 'Maximum distance of a trigger from a 3D shower'],
        #['DAQ_triggerParameters=trigger3DShower.TMaxExtra_ns', 's', 'Maximum extra time for a shower trigger'],
        #['DAQ_triggerParameters=trigger3DShower.enabled', np.nan, 'Enables/disables the shower trigger'],
        #['DAQ_triggerParameters=trigger3DShower.factoryLimit', np.nan, 'Maximum number of showers triggers'],
        #['DAQ_triggerParameters=trigger3DShower.numberOfHits', np.nan, 'Number of hits for 3D shower trigger'],
        #['DAQ_triggerParameters=trigger3DShower.numberOfModules', np.nan, 'Number of moduels for a shower trigger'],
        #['DAQ_triggerParameters=triggerMXShower.DMax_m', 'm', 'Maximum distance of a trigger from an MX trigger'],
        #['DAQ_triggerParameters=triggerMXShower.TMaxExtra_ns', 's', 'Maximum extra time for an MX trigger'],
        #['DAQ_triggerParameters=triggerMXShower.enabled', np.nan, 'Enables/disables the MX trigger'],
        #['DAQ_triggerParameters=triggerMXShower.factoryLimit', np.nan, 'Maximum number of MX triggers'],
        #['DAQ_triggerParameters=triggerMXShower.numberOfHits', np.nan, 'Number of hits for MX trigger'],
        #['DAQ_triggerParameters=triggerMXShower.numberOfModules', np.nan, 'Number of modules necessary to trigger for MX trigger'],
        #['DAQ_triggerParameters=triggerNB.DMax_m', 'm', 'Maximum distance for the np.nanobeacon trigger'],
        #['DAQ_triggerParameters=triggerNB.enabled', np.nan, 'Enables/disables the np.nanobeacon trigger'],
        #['DAQ_triggerParameters=triggerNB.pmts', np.nan, 'List of involved PMTs for the np.nanobeacon trigger'],
        #['DAQ_triggerParameters=writeL0', np.nan, 'Write L0 triggers'],
        #['DAQ_triggerParameters=writeL0.prescale', np.nan, 'Prescale of L0 timeslices writing'],
        #['DAQ_triggerParameters=writeL1', np.nan, 'Write L1 timeslices'],
        #['DAQ_triggerParameters=writeL1.prescale', np.nan, 'Prescale of L1 timeslices writing'],
        #['DAQ_triggerParameters=writeL2', np.nan, 'Write L2 timeslices'],
        #['DAQ_triggerParameters=writeL2.prescale', np.nan, 'Prescale of L2 timeslices writing'],
        #['DAQ_triggerParameters=writeSN', np.nan, 'Write SN timeslices'],
        #['DAQ_triggerParameters=writeSN.prescale', np.nan, 'Prescale of SN timeslices writing'],
        #['DAQ_triggerParameters=writeSummary', np.nan, 'Detail level of summary'],
        #['DAQ_triggerParameters=writeSummary.prescale', np.nan, 'Prescale of summary timeslices writing'],
        #['DAQ_triggerParameters=writeTimeslices', np.nan, 'Writes full dumps of timeslices'],
        #['DAQ_triggerParameters=writeTimeslices.prescale', np.nan, 'Prescale of timeslice writing'],
        #['DAQ_update_s', 's', 'Update period for status messages'],
        ['DOM_Humidity', '%', 'Relative humidity'],
        #['DOM_ID', np.nan, 'DOM Identifier'],
        ['EDFA_EMI', np.nan, 'Emission'],
        ['EDFA_IOP', 'dBm', 'Input Optical Power'],
        ['EDFA_OOP', 'dBm', 'Output Optical Power'],
        ['EDFA_PUMPDC', 'A', 'Diode Pump Current'],
        ['EDFA_SETP_RD', 'dBm', 'Monitored Power Setpoint for APC mode'],
        #['EDFA_SETP_WR', 'dBm', 'Settings for Power Setpoint'],
        #['EDFA_SN', np.nan, 'Serial Number'],
        ['EDFA_TEMP', '?C', 'Temperature '],
        ['FPGA_Temperature', 'C', 'Temperature of the FPGA'],
        #['HW_DATE_REV', np.nan, 'Date and Revision'],
        ['Humid', '%', 'Humidity'],
        #['INST_FAIL', np.nan, 'Bitmask containing error devices'],
        #['INST_FAIL{2:1}', np.nan, 'Failure status for ACDC'],
        #['INST_FAIL{1:1}', np.nan, 'Failure status for BPS'],
        #['INST_FAIL{0:1}', np.nan, 'Failure status for EDFA'],
        #['IPMUX_MOD_IP', np.nan, 'Units IP address'],
        #['IPMUX_PORTS', np.nan, 'IP Mux Source and target port'],
        #['IPMUX_SRV_IP', np.nan, 'Target IP Address for IPMUX Packets'],
        #['SYS_RUN_ENA{2:1}', '1', 'Boolean value to enable Monitoring (requires all SYS_RUN_ENA parameters)'],
        #['NP.NANO_Delay', 's', 'Np.Nano-beacon delay in 16 ns ticks'],
        #['NP.NANO_Length', 's', 'Length of pulse in 16 ns ticks'],
        #['NP.NANO_PCount', '1', 'Np.Nano-beacon pulse train count, each second'],
        #['NP.NANO_Period', 's', 'Period of beacon in 16 ns ticks'],
        #['NP.NANO_Volt', 'V', 'Np.Nano-beacon voltage in millivolts'],
        #['SYS_RUN_ENA{3:1}', np.nan, 'Boolean value to enable Np.Nanobeacons (requires all SYS_RUN_ENA parameters)'],
        #['SYS_DISABLE{3:1}', np.nan, 'Boolean value to disable Np.Nanobeacon step up regulator'],
        #['PIEZO_ENABLE', np.nan, np.nan],
        #['PIEZO_ENABLE', np.nan, np.nan],
        #['PMT_ERR', np.nan, 'Channel error - 0 no error, 1 fault, 2 communication error'],
        #['CHAN_ENABLE(31)', np.nan, 'Bit array to enable PMTs'],
        ['PMT_HIGHVOLT', 'V', 'High Voltage'],
        #['SYS_DISABLE{2:1}', '1', 'Boolean value to disable PMT HV (power line to HV altogether)'],
        #['hr_veto_ena_ch(31)', np.nan, 'Enable high rate veto per PMT'],
        #['PMT_ID', np.nan, 'PMT Identifier of each channel'],
        #['PMT_MAPPING', np.nan, 'Maps a PMT Channel to an actual octopus module'],
        #['mulhit_ena_ch(31)', np.nan, 'Enable multiple hits per PMT'],
        #['PMT_THRESHOLD', 'V', 'PMT THreshold'],
        ['PWR_MEAS[0]', 'A', '12 Volt current, in milliamps'],
        ['PWR_MEAS[9]', 'V', '12 Volt level, in millivolts'],
        ['PWR_MEAS[2]', 'A', '1.8 Volt current, in milliamps'],
        ['PWR_MEAS[12]', 'V', '1.8 Volt level, in millivolts'],
        ['PWR_MEAS[1]', 'A', '1 Volt current, in milliamps'],
        ['PWR_MEAS[11]', 'V', '1 Volt level, in millivolts'],
        ['PWR_MEAS[3]', 'A', '2.5 Volt current, in milliamps'],
        ['PWR_MEAS[13]', 'V', '2.5 Volt level, in millivolts'],
        ['PWR_MEAS[6]', 'A', '3.3 Volt PMT current, in milliamps'],
        ['PWR_MEAS[16]', 'V', '3.3 Volt level, in millivolts'],
        ['PWR_MEAS[4]', 'A', '3.3 Volt current, in milliamps'],
        ['PWR_MEAS[14]', 'V', '3.3 Volt level, in millivolts'],
        ['PWR_MEAS[5]', 'A', '5 Volt current, in milliamps'],
        ['PWR_MEAS[15]', 'V', '5 Volt level, in millivolts'],
        ['PWR_MEAS[17]', 'V', 'DAC Control voltage, in millivolts'],
        ['PWR_MEAS[10]', '?C', 'Temperature sensor voltage, in millidegree Celsius'],
        ['PWR_MEAS[7]', 'A', 'LED current, in milliamps'],
        ['PWR_MEAS[8]', 'V', 'LED Voltage level, in millivolts'],
        #['RUN_NUMBER', np.nan, 'Run number'],
        ['SC_PORT', np.nan, 'Slow control'],
        #['SC_SRV_IP', np.nan, 'Target Ip for slow control events'],
        ['SFP_Temperature', 'C', 'Temperature of the SFP'],
        #['SYS_MAC', np.nan, 'Unit Mac Address'],
        #['SYS_RUN_ENA', '1', 'Bitmask parameter that defines CLB subsystems that can actually run.'],
        #['TDC_ENABLE', np.nan, 'TDC Enable.  Bits 0..30 Channels 1-31 Bit 31 - core enable'],
        #['TDC_ENABLE', np.nan, 'TDC Enable.  Bits 0..30 Channels 1-31 Bit 31 - core enable'],
        #['SYS_RUN_ENA{0:1}', '1', 'Boolean value to enable TDC (requires all SYS_RUN_ENA parameters)'],
        ['TEMP', 'deg C', 'Temperature'],
        ['sys_temp_hum[0]', '?C', 'FPGA temperature'],
        ['sys_temp_hum[1]', '?C', 'CLB temperature (SHT21 chip)'],
        ['sys_temp_hum[2]', '%', 'CLB humidity (SHT21 chip)'],
        ['sys_temp_hum[3]', '?C', 'Powerboard ADC temperature'],
        ['sys_temp_hum[4]', '?C', 'White Rabbit temperature'],
        ['sys_temp_hum[5]', '?C', 'SFP temperature'],
        #['SYS_DISABLE{1:1}', '1', 'Boolean value to disable Temperature/Humidity'],
        #['WR_Bitslide', 's', 'White Rabbit Bitslide value'],
        #['WR_DELTA', np.nan, 'White Rabbit Deltas'],
        #['WR_DELTA[3]', 's', 'White Rabbit Delay value Master RX'],
        #['WR_DELTA[2]', 's', 'White Rabbit Delay value Master TX'],
        #['WR_DELTA[1]', 's', 'White Rabbit Delay value Slave RX'],
        #['WR_DELTA[0]', 's', 'White Rabbit Delay value Slave TX'],
        #['WR_MU', 's', 'White Rabbit Round-Trip time'],
        ['WR_ST_GEN', np.nan, 'White Rabbit general state'],
        #['WR_ST_PTP', np.nan, 'White Rabbit PTP State'],
        #['WR_ST_SERV', np.nan, 'White Rabbit servo state'],
        ['WR_TEMP', np.nan, 'Temperature from white rabbit'],
        ['WR_TEMP', np.nan, 'Temperature from white rabbit'],
        ['acdc_cur', 'A', 'ACDC Current, between 0 and 2560A'],
        ['acdc_temp', 'C', 'ACDC Temperature in degrees Centigrade'],
        ['acdc_volt', 'V', 'ACDC Voltage, between 300 and 556'],
        #['acou_chan', np.nan, '0=Enable both acoustic channels,1=Enable only channel 1,2=Enable only channel 2'],
        #['acou_res', np.nan, '0=12 bit resolution,1=16 bit resolution,2=24 bit resolution'],
        #['bps_alarm', np.nan, 'Alarm Status'],
        #['bps_breaker', 'ADC', 'Breaker status'],
        ['bps_i12', 'ADC', 'Current of 12V line (0 to 1023 ADC raw)'],
        ['bps_i375', 'ADC', 'Current of 375V line (0 to 1023 ADC raw)'],
        ['bps_iback', 'ADC', 'Backbone current (0 to 1023 ADC raw)'],
        ['bps_v375', 'ADC', 'Voltage of 375V line (0 to 1023 ADC raw)'],
        ['bps_v5', 'ADC', 'Voltage of 5V line (0 to 1023 ADC raw)'],
        ['cable_rtt', 's', 'Cable roundtrip time in ps'],
        ['edfa_emi', np.nan, 'Emission'],
        ['edfa_iop', 'dBm', 'Input Optical Power (in milli dBm)'],
        ['edfa_oop', 'dBm', 'Output Optical Power (in milli dBm)'],
        ['edfa_pumpdc', 'A', 'Doide Pump Current (in micro A)'],
        ['edfa_setp_rd', 'dBm', 'Monitored Power Setpoint for APC mode (in milli dBm)'],
        #['edfa_setp_wr', 'dBm', 'Settings for Power Setpoint (in dBm)'],
        #['edfa_sn', np.nan, 'Serial number (Ascii string)'],
        ['edfa_temp', 'C', 'Temperature (in milli degrees celsius)'],
        #['hr_veto_ena_ch', '1', 'Bitmask to enable high rate veto on PMTs'],
        #['hr_veto_thres', np.nan, 'Threshold in hits per timeslice'],
        #['mulhit_ena_ch', '1', 'Bitmask to enable multi-hits on PMTs'],
        #['pwr_meas', np.nan, 'power measurment'],
        ['rx_input_power', 'W', 'SFP receiver input power'],
        #['stmach_pktsize', np.nan, np.nan],
        #['sys_temp_hum', np.nan, 'Mixed array of temperature and humidity (0=FPGA,1=CLB,2=CLB_hum,3=POWER,4=WR,5=SFP)'],
        #['time_slice_dur', 's', 'Timeslice duration'],
        ['tx_output_power', 'W', 'SFP transmitter power ']
    ]
}

SC_PARAMETER_DIC = {'#DMOutLogSecsPrescale': [ 's', 'Divider for seconds from beginning of day to log output variables'],
                    'ACDC_CUR': [ np.nan, 'ACDC Current, between 0 and 2560A'],
                    'ACDC_TEMP': [ '*C', 'ACDC Temperature'],
                    'ACDC_VOLT': [ np.nan, 'ACDC Voltage, between 300 and 556'],
                    'AHRS_A': [ np.nan, np.nan],
                    'SYS_DISABLE{0:1}': [ '1', 'Boolean value to disable AHRS'],
                    'AHRS_G': [ np.nan, np.nan],
                    'AHRS_H': [ np.nan, np.nan],
                    'AHRS_PITCH': [ np.nan, np.nan],
                    'AHRS_ROLL': [ np.nan, np.nan],
                    'AHRS_YAW': [ np.nan, np.nan],
                    'SYS_RUN_ENA{1:1}': [ np.nan, 'Boolean value to enable Acoustics (requires all SYS_RUN_ENA parameters)'],
                    'BPS_ALARM': [ np.nan, 'Alarm Status'],
                    'BPS_ALARM{1:1}': [ np.nan, 'Alarm status 12V'],
                    'BPS_ALARM{0:1}': [ np.nan, 'Alarm status 375V'],
                    'BPS_BREAKER': [ np.nan, 'Breaker status'],
                    'BPS_BREAKER{1:1}': [ np.nan, 'Breaker status 12V'],
                    'BPS_BREAKER{0:1}': [ np.nan, 'Breaker status 375V'],
                    'BPS_I12': [ np.nan, 'Current of 12V line (0 to 1023 ADC raw)'],
                    '(BPS_I12)': [ 'A', 'Current of 12V line'],
                    'BPS_I375': [ np.nan, 'Current of 375V line (0 to 1023 ADC raw)'],
                    '(BPS_I375)': [ 'A', 'Current of 375V line'],
                    'BPS_I5': [ np.nan, 'Current of 5V line (0 to 1023 ADC raw)'],
                    '(BPS_I5)': [ 'A', 'Current of 5V line'],
                    'BPS_IBACK': [ np.nan, 'Backbone current (0 to 1023 ADC raw)'],
                    '(BPS_IBACK)': [ 'A', 'Backbone current'],
                    'BPS_V375': [ np.nan, 'Voltage of 375V line (0 to 1023 ADC raw)'],
                    '(BPS_V375)': [ 'V', 'Voltage of 375V line'],
                    'CABLE_RTT': [ 's', 'Cable roundtrip time in ps'],
                    'CHAN_ENABLE': [ '1', 'Bitmask to enable PMTs'],
                    'CLBControlTimeoutMS': [ np.nan, 'Interval time for CLB data polling in milliseconds'],
                    'CLB_Temperature': [ 'C', 'Temperature of the CLB'],
                    'DAQ_ADF_DBG_path': [ np.nan, 'Output path for debug files'],
                    'DAQ_ADF_DOM_configuration': [ np.nan, 'Acoustic Data Filter search info for a DOM: DOMID Nwaveforms [IDwaveform threshold]'],
                    'DAQ_ADF_TOA_path': [ np.nan, 'Output path for TOA files'],
                    'DAQ_ADF_analysis_window_overlap': [ np.nan, 'Overlap of two analysis windows in units of samples'],
                    'DAQ_ADF_analysis_window_size': [ np.nan, 'Length of analysis window in units of samples'],
                    'DAQ_ADF_waveform': [ np.nan, 'Waveform identifier'],
                    'DAQ_ADF_wisdom_cache_path': [ np.nan, 'Storage path for ADF wisdom information'],
                    'DAQ_ProcessList': [ np.nan, 'Expects the comma-separated list of process types to be listed ("datafilters","dataqueues","datawriters","dispatchers")'],
                    'DAQ_Process_Name': [ np.nan, 'Name of a process'],
                    'DAQ_acou_ports': [ np.nan, 'Port for acoustic data'],
                    'DAQ_acou_recipient': [ np.nan, 'Receiver of acoustic data'],
                    'DAQ_bufferSize': [ np.nan, 'Size of the datafilter buffer'],
                    'DAQ_dataWriter': [ np.nan, 'Datawriter to output DataFilter data'],
                    'DAQ_detector': [ np.nan, 'The detector description in .detx format'],
                    'DAQ_dump_file_postfix': [ np.nan, 'Postfix of the dump file'],
                    'DAQ_dump_file_prefix': [ np.nan, 'Prefix of the dump file'],
                    'DAQ_logger_s': [ 's', 'Update period for error messages'],
                    'DAQ_maxHitsFrame': [ np.nan, 'Maximum number of hits in a frame'],
                    'DAQ_max_dump_size': [ np.nan, 'Maximum size of information to dump'],
                    'DAQ_numberOfFramesPerSlice': [ np.nan, 'Number of frames per slice'],
                    'DAQ_opto_ports': [ np.nan, 'Port for optical data'],
                    'DAQ_opto_recipients': [ np.nan, 'Receiver of optical data'],
                    'DAQ_out_server_address': [ np.nan, 'Output server address for MonRouter'],
                    'DAQ_out_server_port': [ np.nan, 'Output server port for MonRouter'],
                    'DAQ_path': [ np.nan, 'Path where the datawriter should write the data'],
                    'DAQ_pmtIdCheck': [ np.nan, 'Enables checking PMT Id when frames are received'],
                    'DAQ_queueDepth': [ np.nan, 'Maximal queue depth'],
                    'DAQ_queueSize': [ np.nan, 'Maximal queue size'],
                    'DAQ_run_start_time': [ 's', 'Unix time of run start'],
                    'DAQ_timeslice_duration': [ 's', 'Duration of a timeslice'],
                    'DAQ_triggerParameters=L2.TMaxLocal_ns': [ 's', 'Maximum local time for a L2 coincidence'],
                    'DAQ_triggerParameters=L2.ctMin': [ np.nan, 'CTMin of L2 coincidence'],
                    'DAQ_triggerParameters=L2.numberOfHits': [ np.nan, 'Number of hits for a L2 coincidence'],
                    'DAQ_triggerParameters=L2Min': [ np.nan, 'Minimum number of L2 triggers'],
                    'DAQ_triggerParameters=SN.TMaxLocal_ns': [ 's', 'Maximum local time for a SN coincidence'],
                    'DAQ_triggerParameters=SN.ctMin': [ np.nan, 'CTMin of SN coincidence'],
                    'DAQ_triggerParameters=SN.numberOfHits': [ np.nan, 'Number of hits for a SN coincidence'],
                    'DAQ_triggerParameters=TMaxEvent_ns': [ 's', 'Maximal time between first and last hit'],
                    'DAQ_triggerParameters=TMaxLocal_ns': [ 's', 'Maximum local time'],
                    'DAQ_triggerParameters=combineL1': [ np.nan, 'Combine consequtive L1s to one'],
                    'DAQ_triggerParameters=ctMin': [ np.nan, 'CTMin of triggers'],
                    'DAQ_triggerParameters=highRateVeto_Hz': [ 'Hz', 'Limit on rate'],
                    'DAQ_triggerParameters=numberOfBins': [ np.nan, 'Number of bins'],
                    'DAQ_triggerParameters=trigger3DMuon.DMax_m': [ 'm', 'Maximum distance of a trigger from muon'],
                    'DAQ_triggerParameters=trigger3DMuon.TMaxExtra_ns': [ 's', 'Maximum extra time for a muon trigger'],
                    'DAQ_triggerParameters=trigger3DMuon.enabled': [ np.nan, 'Enables/disables the muon trigger'],
                    'DAQ_triggerParameters=trigger3DMuon.factoryLimit': [ np.nan, 'Maximum number of muon triggers'],
                    'DAQ_triggerParameters=trigger3DMuon.gridAngle_deg': [ 'deg', 'Grid angle for muons in degrees'],
                    'DAQ_triggerParameters=trigger3DMuon.numberOfHits': [ np.nan, 'Number of hits for a muon trigger'],
                    'DAQ_triggerParameters=trigger3DMuon.numberOfModules': [ np.nan, 'Number of modules for a muon trigger'],
                    'DAQ_triggerParameters=trigger3DMuon.roadWidth_m': [ 'm', 'Road width for track reconstruction'],
                    'DAQ_triggerParameters=trigger3DShower.DMax_m': [ 'm', 'Maximum distance of a trigger from a 3D shower'],
                    'DAQ_triggerParameters=trigger3DShower.TMaxExtra_ns': [ 's', 'Maximum extra time for a shower trigger'],
                    'DAQ_triggerParameters=trigger3DShower.enabled': [ np.nan, 'Enables/disables the shower trigger'],
                    'DAQ_triggerParameters=trigger3DShower.factoryLimit': [ np.nan, 'Maximum number of showers triggers'],
                    'DAQ_triggerParameters=trigger3DShower.numberOfHits': [ np.nan, 'Number of hits for 3D shower trigger'],
                    'DAQ_triggerParameters=trigger3DShower.numberOfModules': [ np.nan, 'Number of moduels for a shower trigger'],
                    'DAQ_triggerParameters=triggerMXShower.DMax_m': [ 'm', 'Maximum distance of a trigger from an MX trigger'],
                    'DAQ_triggerParameters=triggerMXShower.TMaxExtra_ns': [ 's', 'Maximum extra time for an MX trigger'],
                    'DAQ_triggerParameters=triggerMXShower.enabled': [ np.nan, 'Enables/disables the MX trigger'],
                    'DAQ_triggerParameters=triggerMXShower.factoryLimit': [ np.nan, 'Maximum number of MX triggers'],
                    'DAQ_triggerParameters=triggerMXShower.numberOfHits': [ np.nan, 'Number of hits for MX trigger'],
                    'DAQ_triggerParameters=triggerMXShower.numberOfModules': [ np.nan, 'Number of modules necessary to trigger for MX trigger'],
                    'DAQ_triggerParameters=triggerNB.DMax_m': [ 'm', 'Maximum distance for the np.nanobeacon trigger'],
                    'DAQ_triggerParameters=triggerNB.enabled': [ np.nan, 'Enables/disables the np.nanobeacon trigger'],
                    'DAQ_triggerParameters=triggerNB.pmts': [ np.nan, 'List of involved PMTs for the np.nanobeacon trigger'],
                    'DAQ_triggerParameters=writeL0': [ np.nan, 'Write L0 triggers'],
                    'DAQ_triggerParameters=writeL0.prescale': [ np.nan, 'Prescale of L0 timeslices writing'],
                    'DAQ_triggerParameters=writeL1': [ np.nan, 'Write L1 timeslices'],
                    'DAQ_triggerParameters=writeL1.prescale': [ np.nan, 'Prescale of L1 timeslices writing'],
                    'DAQ_triggerParameters=writeL2': [ np.nan, 'Write L2 timeslices'],
                    'DAQ_triggerParameters=writeL2.prescale': [ np.nan, 'Prescale of L2 timeslices writing'],
                    'DAQ_triggerParameters=writeSN': [ np.nan, 'Write SN timeslices'],
                    'DAQ_triggerParameters=writeSN.prescale': [ np.nan, 'Prescale of SN timeslices writing'],
                    'DAQ_triggerParameters=writeSummary': [ np.nan, 'Detail level of summary'],
                    'DAQ_triggerParameters=writeSummary.prescale': [ np.nan, 'Prescale of summary timeslices writing'],
                    'DAQ_triggerParameters=writeTimeslices': [ np.nan, 'Writes full dumps of timeslices'],
                    'DAQ_triggerParameters=writeTimeslices.prescale': [ np.nan, 'Prescale of timeslice writing'],
                    'DAQ_update_s': [ 's', 'Update period for status messages'],
                    'DOM_Humidity': [ '%', 'Relative humidity'],
                    'DOM_ID': [ np.nan, 'DOM Identifier'],
                    'EDFA_EMI': [ np.nan, 'Emission'],
                    'EDFA_IOP': [ 'dBm', 'Input Optical Power'],
                    'EDFA_OOP': [ 'dBm', 'Output Optical Power'],
                    'EDFA_PUMPDC': [ 'A', 'Diode Pump Current'],
                    'EDFA_SETP_RD': [ 'dBm', 'Monitored Power Setpoint for APC mode'],
                    'EDFA_SETP_WR': [ 'dBm', 'Settings for Power Setpoint'],
                    'EDFA_SN': [ np.nan, 'Serial Number'],
                    'EDFA_TEMP': [ '?C', 'Temperature '],
                    'FPGA_Temperature': [ 'C', 'Temperature of the FPGA'],
                    'HW_DATE_REV': [ np.nan, 'Date and Revision'],
                    'Humid': [ '%', 'Humidity'],
                    'INST_FAIL': [ np.nan, 'Bitmask containing error devices'],
                    'INST_FAIL{2:1}': [ np.nan, 'Failure status for ACDC'],
                    'INST_FAIL{1:1}': [ np.nan, 'Failure status for BPS'],
                    'INST_FAIL{0:1}': [ np.nan, 'Failure status for EDFA'],
                    'IPMUX_MOD_IP': [ np.nan, 'Units IP address'],
                    'IPMUX_PORTS': [ np.nan, 'IP Mux Source and target port'],
                    'IPMUX_SRV_IP': [ np.nan, 'Target IP Address for IPMUX Packets'],
                    'SYS_RUN_ENA{2:1}': [ '1', 'Boolean value to enable Monitoring (requires all SYS_RUN_ENA parameters)'],
                    'NP.NANO_Delay': [ 's', 'Np.Nano-beacon delay in 16 ns ticks'],
                    'NP.NANO_Length': [ 's', 'Length of pulse in 16 ns ticks'],
                    'NP.NANO_PCount': [ '1', 'Np.Nano-beacon pulse train count, each second'],
                    'NP.NANO_Period': [ 's', 'Period of beacon in 16 ns ticks'],
                    'NP.NANO_Volt': [ 'V', 'Np.Nano-beacon voltage in millivolts'],
                    'SYS_RUN_ENA{3:1}': [ np.nan, 'Boolean value to enable Np.Nanobeacons (requires all SYS_RUN_ENA parameters)'],
                    'SYS_DISABLE{3:1}': [ np.nan, 'Boolean value to disable Np.Nanobeacon step up regulator'],
                    'PIEZO_ENABLE': [ np.nan, np.nan],
                    'PIEZO_ENABLE': [ np.nan, np.nan],
                    'PMT_ERR': [ np.nan, 'Channel error - 0 no error, 1 fault, 2 communication error'],
                    'CHAN_ENABLE(31)': [ np.nan, 'Bit array to enable PMTs'],
                    'PMT_HIGHVOLT': [ 'V', 'High Voltage'],
                    'SYS_DISABLE{2:1}': [ '1', 'Boolean value to disable PMT HV (power line to HV altogether)'],
                    'hr_veto_ena_ch(31)': [ np.nan, 'Enable high rate veto per PMT'],
                    'PMT_ID': [ np.nan, 'PMT Identifier of each channel'],
                    'PMT_MAPPING': [ np.nan, 'Maps a PMT Channel to an actual octopus module'],
                    'mulhit_ena_ch(31)': [ np.nan, 'Enable multiple hits per PMT'],
                    'PMT_THRESHOLD': [ 'V', 'PMT THreshold'],
                    'PWR_MEAS[0]': [ 'A', '12 Volt current, in milliamps'],
                    'PWR_MEAS[9]': [ 'V', '12 Volt level, in millivolts'],
                    'PWR_MEAS[2]': [ 'A', '1.8 Volt current, in milliamps'],
                    'PWR_MEAS[12]': [ 'V', '1.8 Volt level, in millivolts'],
                    'PWR_MEAS[1]': [ 'A', '1 Volt current, in milliamps'],
                    'PWR_MEAS[11]': [ 'V', '1 Volt level, in millivolts'],
                    'PWR_MEAS[3]': [ 'A', '2.5 Volt current, in milliamps'],
                    'PWR_MEAS[13]': [ 'V', '2.5 Volt level, in millivolts'],
                    'PWR_MEAS[6]': [ 'A', '3.3 Volt PMT current, in milliamps'],
                    'PWR_MEAS[16]': [ 'V', '3.3 Volt level, in millivolts'],
                    'PWR_MEAS[4]': [ 'A', '3.3 Volt current, in milliamps'],
                    'PWR_MEAS[14]': [ 'V', '3.3 Volt level, in millivolts'],
                    'PWR_MEAS[5]': [ 'A', '5 Volt current, in milliamps'],
                    'PWR_MEAS[15]': [ 'V', '5 Volt level, in millivolts'],
                    'PWR_MEAS[17]': [ 'V', 'DAC Control voltage, in millivolts'],
                    'PWR_MEAS[10]': [ '?C', 'Temperature sensor voltage, in millidegree Celsius'],
                    'PWR_MEAS[7]': [ 'A', 'LED current, in milliamps'],
                    'PWR_MEAS[8]': [ 'V', 'LED Voltage level, in millivolts'],
                    'RUN_NUMBER': [ np.nan, 'Run number'],
                    'SC_PORT': [ np.nan, 'Slow control'],
                    'SC_SRV_IP': [ np.nan, 'Target Ip for slow control events'],
                    'SFP_Temperature': [ 'C', 'Temperature of the SFP'],
                    'SYS_MAC': [ np.nan, 'Unit Mac Address'],
                    'SYS_RUN_ENA': [ '1', 'Bitmask parameter that defines CLB subsystems that can actually run.'],
                    'TDC_ENABLE': [ np.nan, 'TDC Enable.  Bits 0..30 Channels 1-31 Bit 31 - core enable'],
                    'TDC_ENABLE': [ np.nan, 'TDC Enable.  Bits 0..30 Channels 1-31 Bit 31 - core enable'],
                    'SYS_RUN_ENA{0:1}': [ '1', 'Boolean value to enable TDC (requires all SYS_RUN_ENA parameters)'],
                    'TEMP': [ 'deg C', 'Temperature'],
                    'sys_temp_hum[0]': [ '?C', 'FPGA temperature'],
                    'sys_temp_hum[1]': [ '?C', 'CLB temperature (SHT21 chip)'],
                    'sys_temp_hum[2]': [ '%', 'CLB humidity (SHT21 chip)'],
                    'sys_temp_hum[3]': [ '?C', 'Powerboard ADC temperature'],
                    'sys_temp_hum[4]': [ '?C', 'White Rabbit temperature'],
                    'sys_temp_hum[5]': [ '?C', 'SFP temperature'],
                    'SYS_DISABLE{1:1}': [ '1', 'Boolean value to disable Temperature/Humidity'],
                    'WR_Bitslide': [ 's', 'White Rabbit Bitslide value'],
                    'WR_DELTA': [ np.nan, 'White Rabbit Deltas'],
                    'WR_DELTA[3]': [ 's', 'White Rabbit Delay value Master RX'],
                    'WR_DELTA[2]': [ 's', 'White Rabbit Delay value Master TX'],
                    'WR_DELTA[1]': [ 's', 'White Rabbit Delay value Slave RX'],
                    'WR_DELTA[0]': [ 's', 'White Rabbit Delay value Slave TX'],
                    'WR_MU': [ 's', 'White Rabbit Round-Trip time'],
                    'WR_ST_GEN': [ np.nan, 'White Rabbit general state'],
                    'WR_ST_PTP': [ np.nan, 'White Rabbit PTP State'],
                    'WR_ST_SERV': [ np.nan, 'White Rabbit servo state'],
                    'WR_TEMP': [ np.nan, 'Temperature from white rabbit'],
                    'WR_TEMP': [ np.nan, 'Temperature from white rabbit'],
                    'acdc_cur': [ 'A', 'ACDC Current, between 0 and 2560A'],
                    'acdc_temp': [ 'C', 'ACDC Temperature in degrees Centigrade'],
                    'acdc_volt': [ 'V', 'ACDC Voltage, between 300 and 556'],
                    'acou_chan': [ np.nan, '0=Enable both acoustic channels,1=Enable only channel 1,2=Enable only channel 2'],
                    'acou_res': [ np.nan, '0=12 bit resolution,1=16 bit resolution,2=24 bit resolution'],
                    'bps_alarm': [ np.nan, 'Alarm Status'],
                    'bps_breaker': [ 'ADC', 'Breaker status'],
                    'bps_i12': [ 'ADC', 'Current of 12V line (0 to 1023 ADC raw)'],
                    'bps_i375': [ 'ADC', 'Current of 375V line (0 to 1023 ADC raw)'],
                    'bps_iback': [ 'ADC', 'Backbone current (0 to 1023 ADC raw)'],
                    'bps_v375': [ 'ADC', 'Voltage of 375V line (0 to 1023 ADC raw)'],
                    'bps_v5': [ 'ADC', 'Voltage of 5V line (0 to 1023 ADC raw)'],
                    'cable_rtt': [ 's', 'Cable roundtrip time in ps'],
                    'edfa_emi': [ np.nan, 'Emission'],
                    'edfa_iop': [ 'dBm', 'Input Optical Power (in milli dBm)'],
                    'edfa_oop': [ 'dBm', 'Output Optical Power (in milli dBm)'],
                    'edfa_pumpdc': [ 'A', 'Doide Pump Current (in micro A)'],
                    'edfa_setp_rd': [ 'dBm', 'Monitored Power Setpoint for APC mode (in milli dBm)'],
                    'edfa_setp_wr': [ 'dBm', 'Settings for Power Setpoint (in dBm)'],
                    'edfa_sn': [ np.nan, 'Serial number (Ascii string)'],
                    'edfa_temp': [ 'C', 'Temperature (in milli degrees celsius)'],
                    'hr_veto_ena_ch': [ '1', 'Bitmask to enable high rate veto on PMTs'],
                    'hr_veto_thres': [ np.nan, 'Threshold in hits per timeslice'],
                    'mulhit_ena_ch': [ '1', 'Bitmask to enable multi-hits on PMTs'],
                    'pwr_meas': [ np.nan, 'power measurment'],
                    'rx_input_power': [ 'W', 'SFP receiver input power'],
                    'stmach_pktsize': [ np.nan, np.nan],
                    'sys_temp_hum': [ np.nan, 'Mixed array of temperature and humidity (0=FPGA,1=CLB,2=CLB_hum,3=POWER,4=WR,5=SFP)'],
                    'time_slice_dur': [ 's', 'Timeslice duration'],
                    'tx_output_power': [ 'W', 'SFP transmitter power ']
}

        #print( "Very Short SC parameter list: {0}".format( TEST_SC_PARAMETER_LIST) )
        #print( "Short SC parameter list: {0}".format( SHORT_SC_PARAMETER_LIST) )
        #print( "Long  SC parameter list: {0}".format( SC_PARAMETER_LIST) )
