# seldon-deploy-sdk
API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1alpha1
- Package version: 1.3.0.dev4
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import seldon_deploy_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import seldon_deploy_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import seldon_deploy_sdk
from seldon_deploy_sdk.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: OAuth2
configuration = seldon_deploy_sdk.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = seldon_deploy_sdk.ApplicationLogsApi(seldon_deploy_sdk.ApiClient(configuration))
body = seldon_deploy_sdk.ApplicationLogsParams() # ApplicationLogsParams | ApplicationLogs

try:
    # Read application container logs from elastic search.
    api_response = api_instance.read_application_logs(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ApplicationLogsApi->read_application_logs: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://X.X.X.X/seldon-deploy/api/v1alpha1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationLogsApi* | [**read_application_logs**](docs/ApplicationLogsApi.md#read_application_logs) | **POST** /applicationlogs | Read application container logs from elastic search.
*BatchJobsApi* | [**create_seldon_deployment_batch_job**](docs/BatchJobsApi.md#create_seldon_deployment_batch_job) | **POST** /namespaces/{namespace}/seldondeployments/{name}/batchjobs | 
*BatchJobsApi* | [**get_deployment_batch_job**](docs/BatchJobsApi.md#get_deployment_batch_job) | **GET** /namespaces/{namespace}/seldondeployments/{name}/batchjobs/{jobName} | 
*BatchJobsApi* | [**list_seldon_deployment_batch_jobs**](docs/BatchJobsApi.md#list_seldon_deployment_batch_jobs) | **GET** /namespaces/{namespace}/seldondeployments/{name}/batchjobs | 
*DriftDetectorApi* | [**create_drift_detector_inference_service**](docs/DriftDetectorApi.md#create_drift_detector_inference_service) | **POST** /namespaces/{namespace}/inferenceservices/{name}/driftdetector | 
*DriftDetectorApi* | [**create_drift_detector_seldon_deployment**](docs/DriftDetectorApi.md#create_drift_detector_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/driftdetector | 
*DriftDetectorApi* | [**delete_drift_detector_inference_service**](docs/DriftDetectorApi.md#delete_drift_detector_inference_service) | **DELETE** /namespaces/{namespace}/inferenceservice/{name}/driftdetector | 
*DriftDetectorApi* | [**delete_drift_detector_seldon_deployment**](docs/DriftDetectorApi.md#delete_drift_detector_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/driftdetector | 
*DriftDetectorApi* | [**read_drift_detector_inference_service**](docs/DriftDetectorApi.md#read_drift_detector_inference_service) | **GET** /namespaces/{namespace}/inferenceservices/{name}/driftdetector | 
*DriftDetectorApi* | [**read_drift_detector_seldon_deployment**](docs/DriftDetectorApi.md#read_drift_detector_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/driftdetector | 
*EnvironmentApi* | [**read_cluster**](docs/EnvironmentApi.md#read_cluster) | **GET** /cluster | 
*EnvironmentApi* | [**read_health_check**](docs/EnvironmentApi.md#read_health_check) | **GET** /healthcheck | 
*EnvironmentApi* | [**read_user**](docs/EnvironmentApi.md#read_user) | **GET** /user | 
*EnvironmentApi* | [**read_version**](docs/EnvironmentApi.md#read_version) | **GET** /version | 
*ExplainApi* | [**explain_inference_service**](docs/ExplainApi.md#explain_inference_service) | **POST** /namespaces/{namespace}/inferenceservices/{name}/explain | 
*ExplainApi* | [**explain_seldon_deployment**](docs/ExplainApi.md#explain_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/explain | 
*GitOpsApi* | [**inference_service_git_restore**](docs/GitOpsApi.md#inference_service_git_restore) | **GET** /namespaces/{namespace}/inferenceservices/{name}/gitrestore | 
*GitOpsApi* | [**inference_service_git_revert**](docs/GitOpsApi.md#inference_service_git_revert) | **GET** /namespaces/{namespace}/inferenceservices/{name}/gitrevert | 
*GitOpsApi* | [**read_git_ops_status**](docs/GitOpsApi.md#read_git_ops_status) | **GET** /namespaces/{namespace}/gitops-status | 
*GitOpsApi* | [**read_inference_service_git_diff**](docs/GitOpsApi.md#read_inference_service_git_diff) | **GET** /namespaces/{namespace}/inferenceservices/{name}/gitdiff | 
*GitOpsApi* | [**read_inference_service_git_logs**](docs/GitOpsApi.md#read_inference_service_git_logs) | **GET** /namespaces/{namespace}/inferenceservices/{name}/gitlogs | 
*GitOpsApi* | [**read_seldon_deployment_git_diff**](docs/GitOpsApi.md#read_seldon_deployment_git_diff) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitdiff | 
*GitOpsApi* | [**read_seldon_deployment_git_logs**](docs/GitOpsApi.md#read_seldon_deployment_git_logs) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitlogs | 
*GitOpsApi* | [**seldon_deployment_git_restore**](docs/GitOpsApi.md#seldon_deployment_git_restore) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitrestore | 
*GitOpsApi* | [**seldon_deployment_git_revert**](docs/GitOpsApi.md#seldon_deployment_git_revert) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitrevert | 
*InferenceServicesApi* | [**create_inference_service**](docs/InferenceServicesApi.md#create_inference_service) | **POST** /namespaces/{namespace}/inferenceservices | 
*InferenceServicesApi* | [**delete_inference_service**](docs/InferenceServicesApi.md#delete_inference_service) | **DELETE** /namespaces/{namespace}/inferenceservices/{name} | 
*InferenceServicesApi* | [**list_inference_services**](docs/InferenceServicesApi.md#list_inference_services) | **GET** /namespaces/{namespace}/inferenceservices | 
*InferenceServicesApi* | [**read_inference_service**](docs/InferenceServicesApi.md#read_inference_service) | **GET** /namespaces/{namespace}/inferenceservices/{name} | 
*InferenceServicesApi* | [**update_inference_service**](docs/InferenceServicesApi.md#update_inference_service) | **PUT** /namespaces/{namespace}/inferenceservices/{name} | 
*InferenceServicesApi* | [**validate_inference_service**](docs/InferenceServicesApi.md#validate_inference_service) | **GET** /namespaces/{namespace}/inferenceservices/validate | 
*KubernetesResourcesApi* | [**list_inference_service_predictor_resources**](docs/KubernetesResourcesApi.md#list_inference_service_predictor_resources) | **GET** /namespaces/{namespace}/inferenceservices/{name}/predictor/{predictorName}/resources | 
*KubernetesResourcesApi* | [**list_inference_service_resources**](docs/KubernetesResourcesApi.md#list_inference_service_resources) | **GET** /namespaces/{namespace}/inferenceservices/{name}/resources | 
*KubernetesResourcesApi* | [**list_seldon_deployment_predictor_resources**](docs/KubernetesResourcesApi.md#list_seldon_deployment_predictor_resources) | **GET** /namespaces/{namespace}/seldondeployments/{name}/predictor/{predictorName}/resources | 
*KubernetesResourcesApi* | [**list_seldon_deployment_resources**](docs/KubernetesResourcesApi.md#list_seldon_deployment_resources) | **GET** /namespaces/{namespace}/seldondeployments/{name}/resources | 
*LoadtestJobsApi* | [**create_loadtest_inference_service**](docs/LoadtestJobsApi.md#create_loadtest_inference_service) | **POST** /namespaces/{namespace}/inferenceservices/{name}/loadtestjobs | 
*LoadtestJobsApi* | [**create_loadtest_seldon_deployment**](docs/LoadtestJobsApi.md#create_loadtest_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/loadtestjobs | 
*LoadtestJobsApi* | [**delete_loadtest_inference_service**](docs/LoadtestJobsApi.md#delete_loadtest_inference_service) | **DELETE** /namespaces/{namespace}/inferenceservices/{name}/loadtestjobs/{jobName} | 
*LoadtestJobsApi* | [**delete_loadtest_seldon_deployment**](docs/LoadtestJobsApi.md#delete_loadtest_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/loadtestjobs/{jobName} | 
*LoadtestJobsApi* | [**list_loadtest_inference_service**](docs/LoadtestJobsApi.md#list_loadtest_inference_service) | **GET** /namespaces/{namespace}/inferenceservices/{name}/loadtestjobs | 
*LoadtestJobsApi* | [**list_loadtest_seldon_deployment**](docs/LoadtestJobsApi.md#list_loadtest_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/loadtestjobs | 
*MetricsServerApi* | [**create_metrics_server_seldon_deployment**](docs/MetricsServerApi.md#create_metrics_server_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/metricsserver | 
*MetricsServerApi* | [**delete_metrics_server_seldon_deployment**](docs/MetricsServerApi.md#delete_metrics_server_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/metricsserver | 
*MetricsServerApi* | [**read_metrics_server_seldon_deployment**](docs/MetricsServerApi.md#read_metrics_server_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/metricsserver | 
*ModelMetadataServiceApi* | [**model_metadata_service_create_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_create_model_metadata) | **POST** /model/metadata | Create a Model Metadata entry.
*ModelMetadataServiceApi* | [**model_metadata_service_delete_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_delete_model_metadata) | **DELETE** /model/metadata | Delete a Model Metadata entry.
*ModelMetadataServiceApi* | [**model_metadata_service_list_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_list_model_metadata) | **GET** /model/metadata | List Model Metadata entries.
*ModelMetadataServiceApi* | [**model_metadata_service_list_runtime_metadata_for_model**](docs/ModelMetadataServiceApi.md#model_metadata_service_list_runtime_metadata_for_model) | **GET** /model/metadata/runtime | List Runtime Metadata for all deployments associated with a model.
*ModelMetadataServiceApi* | [**model_metadata_service_update_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_update_model_metadata) | **PUT** /model/metadata | Update a Model Metadata entry.
*MonitorApi* | [**inference_service_feature_distributions**](docs/MonitorApi.md#inference_service_feature_distributions) | **POST** /namespaces/{namespace}/inferenceservices/{name}/monitor/featuredistributions | 
*MonitorApi* | [**inference_service_feature_statistics**](docs/MonitorApi.md#inference_service_feature_statistics) | **POST** /namespaces/{namespace}/inferenceservices/{name}/monitor/featurestatistics | 
*MonitorApi* | [**seldon_deployment_feature_distributions**](docs/MonitorApi.md#seldon_deployment_feature_distributions) | **POST** /namespaces/{namespace}/seldondeployments/{name}/monitor/featuredistributions | 
*MonitorApi* | [**seldon_deployment_feature_statistics**](docs/MonitorApi.md#seldon_deployment_feature_statistics) | **POST** /namespaces/{namespace}/seldondeployments/{name}/monitor/featurestatistics | 
*OutlierDetectorApi* | [**create_outlier_detector_inference_service**](docs/OutlierDetectorApi.md#create_outlier_detector_inference_service) | **POST** /namespaces/{namespace}/inferenceservices/{name}/outlierdetector | 
*OutlierDetectorApi* | [**create_outlier_detector_seldon_deployment**](docs/OutlierDetectorApi.md#create_outlier_detector_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/outlierdetector | 
*OutlierDetectorApi* | [**delete_outlier_detector_inference_service**](docs/OutlierDetectorApi.md#delete_outlier_detector_inference_service) | **DELETE** /namespaces/{namespace}/inferenceservice/{name}/outlierdetector | 
*OutlierDetectorApi* | [**delete_outlier_detector_seldon_deployment**](docs/OutlierDetectorApi.md#delete_outlier_detector_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/outlierdetector | 
*OutlierDetectorApi* | [**read_outlier_detector_inference_service**](docs/OutlierDetectorApi.md#read_outlier_detector_inference_service) | **GET** /namespaces/{namespace}/inferenceservices/{name}/outlierdetector | 
*OutlierDetectorApi* | [**read_outlier_detector_seldon_deployment**](docs/OutlierDetectorApi.md#read_outlier_detector_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/outlierdetector | 
*PredictApi* | [**predict_file_inference_service**](docs/PredictApi.md#predict_file_inference_service) | **POST** /namespaces/{namespace}/inferenceservices/{name}/predictfile | 
*PredictApi* | [**predict_file_seldon_deployment**](docs/PredictApi.md#predict_file_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/predictfile | 
*PredictApi* | [**predict_inference_service**](docs/PredictApi.md#predict_inference_service) | **POST** /namespaces/{namespace}/inferenceservices/{name}/predict | 
*PredictApi* | [**predict_seldon_deployment**](docs/PredictApi.md#predict_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/predict | 
*PredictApi* | [**read_predict_curl_inference_service**](docs/PredictApi.md#read_predict_curl_inference_service) | **PUT** /namespaces/{namespace}/inferenceservices/{name}/predictcurl | 
*PredictApi* | [**read_predict_curl_seldon_deployment**](docs/PredictApi.md#read_predict_curl_seldon_deployment) | **PUT** /namespaces/{namespace}/seldondeployments/{name}/predictcurl | 
*SeldonDeploymentsApi* | [**create_seldon_deployment**](docs/SeldonDeploymentsApi.md#create_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments | 
*SeldonDeploymentsApi* | [**delete_seldon_deployment**](docs/SeldonDeploymentsApi.md#delete_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name} | 
*SeldonDeploymentsApi* | [**list_seldon_deployments**](docs/SeldonDeploymentsApi.md#list_seldon_deployments) | **GET** /namespaces/{namespace}/seldondeployments | 
*SeldonDeploymentsApi* | [**read_seldon_deployment**](docs/SeldonDeploymentsApi.md#read_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name} | 
*SeldonDeploymentsApi* | [**update_seldon_deployment**](docs/SeldonDeploymentsApi.md#update_seldon_deployment) | **PUT** /namespaces/{namespace}/seldondeployments/{name} | 
*SeldonDeploymentsApi* | [**validate_seldon_deployment**](docs/SeldonDeploymentsApi.md#validate_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/validate | 


## Documentation For Models

 - [AIXExplainerSpec](docs/AIXExplainerSpec.md)
 - [AIXExplainerType](docs/AIXExplainerType.md)
 - [AWSElasticBlockStoreVolumeSource](docs/AWSElasticBlockStoreVolumeSource.md)
 - [Addressable](docs/Addressable.md)
 - [AdvancedConfig](docs/AdvancedConfig.md)
 - [Affinity](docs/Affinity.md)
 - [AlibiDetectServerParams](docs/AlibiDetectServerParams.md)
 - [AlibiDetectorData](docs/AlibiDetectorData.md)
 - [AlibiExplainerSpec](docs/AlibiExplainerSpec.md)
 - [AlibiExplainerType](docs/AlibiExplainerType.md)
 - [AnalyticsProps](docs/AnalyticsProps.md)
 - [ApplicationLog](docs/ApplicationLog.md)
 - [ApplicationLogsParams](docs/ApplicationLogsParams.md)
 - [ApplicationLogsResponse](docs/ApplicationLogsResponse.md)
 - [AuditLog](docs/AuditLog.md)
 - [AzureDataDiskCachingMode](docs/AzureDataDiskCachingMode.md)
 - [AzureDataDiskKind](docs/AzureDataDiskKind.md)
 - [AzureDiskVolumeSource](docs/AzureDiskVolumeSource.md)
 - [AzureFileVolumeSource](docs/AzureFileVolumeSource.md)
 - [BatchDefinition](docs/BatchDefinition.md)
 - [BatchDescription](docs/BatchDescription.md)
 - [BatchDescriptionList](docs/BatchDescriptionList.md)
 - [BatchJob](docs/BatchJob.md)
 - [Batcher](docs/Batcher.md)
 - [CSIVolumeSource](docs/CSIVolumeSource.md)
 - [Capabilities](docs/Capabilities.md)
 - [Capability](docs/Capability.md)
 - [CephFSVolumeSource](docs/CephFSVolumeSource.md)
 - [CinderVolumeSource](docs/CinderVolumeSource.md)
 - [ClientIPConfig](docs/ClientIPConfig.md)
 - [ClusterInfo](docs/ClusterInfo.md)
 - [Component](docs/Component.md)
 - [ConditionStatus](docs/ConditionStatus.md)
 - [Conditions](docs/Conditions.md)
 - [ConfigMapEnvSource](docs/ConfigMapEnvSource.md)
 - [ConfigMapKeySelector](docs/ConfigMapKeySelector.md)
 - [ConfigMapProjection](docs/ConfigMapProjection.md)
 - [ConfigMapVolumeSource](docs/ConfigMapVolumeSource.md)
 - [Container](docs/Container.md)
 - [ContainerPort](docs/ContainerPort.md)
 - [ContainerState](docs/ContainerState.md)
 - [ContainerStateRunning](docs/ContainerStateRunning.md)
 - [ContainerStateTerminated](docs/ContainerStateTerminated.md)
 - [ContainerStateWaiting](docs/ContainerStateWaiting.md)
 - [ContainerStatus](docs/ContainerStatus.md)
 - [CrossVersionObjectReference](docs/CrossVersionObjectReference.md)
 - [CustomSpec](docs/CustomSpec.md)
 - [CustomThemeConfig](docs/CustomThemeConfig.md)
 - [DNSPolicy](docs/DNSPolicy.md)
 - [Deployment](docs/Deployment.md)
 - [DeploymentFeatureData](docs/DeploymentFeatureData.md)
 - [DeploymentList](docs/DeploymentList.md)
 - [DeploymentSpec](docs/DeploymentSpec.md)
 - [DeploymentStatus](docs/DeploymentStatus.md)
 - [DeploymentStrategy](docs/DeploymentStrategy.md)
 - [DeploymentStrategyType](docs/DeploymentStrategyType.md)
 - [DownwardAPIProjection](docs/DownwardAPIProjection.md)
 - [DownwardAPIVolumeFile](docs/DownwardAPIVolumeFile.md)
 - [DownwardAPIVolumeSource](docs/DownwardAPIVolumeSource.md)
 - [EmptyDirVolumeSource](docs/EmptyDirVolumeSource.md)
 - [Endpoint](docs/Endpoint.md)
 - [EndpointSpec](docs/EndpointSpec.md)
 - [EndpointType](docs/EndpointType.md)
 - [EnvFromSource](docs/EnvFromSource.md)
 - [EnvProps](docs/EnvProps.md)
 - [EnvVar](docs/EnvVar.md)
 - [EnvVarSource](docs/EnvVarSource.md)
 - [EphemeralContainer](docs/EphemeralContainer.md)
 - [EphemeralVolumeSource](docs/EphemeralVolumeSource.md)
 - [Error](docs/Error.md)
 - [ExecAction](docs/ExecAction.md)
 - [Explainer](docs/Explainer.md)
 - [ExplainerSpec](docs/ExplainerSpec.md)
 - [ExternalMetricSource](docs/ExternalMetricSource.md)
 - [FCVolumeSource](docs/FCVolumeSource.md)
 - [FeatureDistribution](docs/FeatureDistribution.md)
 - [FeatureDistributionBucket](docs/FeatureDistributionBucket.md)
 - [FeatureDistributionParameters](docs/FeatureDistributionParameters.md)
 - [FeatureDistributionResponse](docs/FeatureDistributionResponse.md)
 - [FeatureFilter](docs/FeatureFilter.md)
 - [FeatureInteraction](docs/FeatureInteraction.md)
 - [FeatureStatisticsResponse](docs/FeatureStatisticsResponse.md)
 - [FeatureStats](docs/FeatureStats.md)
 - [FeatureStatsBucket](docs/FeatureStatsBucket.md)
 - [FieldsV1](docs/FieldsV1.md)
 - [FileDiff](docs/FileDiff.md)
 - [FinalizerName](docs/FinalizerName.md)
 - [FlexVolumeSource](docs/FlexVolumeSource.md)
 - [FlockerVolumeSource](docs/FlockerVolumeSource.md)
 - [GCEPersistentDiskVolumeSource](docs/GCEPersistentDiskVolumeSource.md)
 - [GitRepoVolumeSource](docs/GitRepoVolumeSource.md)
 - [GlusterfsVolumeSource](docs/GlusterfsVolumeSource.md)
 - [HPAScalingPolicy](docs/HPAScalingPolicy.md)
 - [HPAScalingPolicyType](docs/HPAScalingPolicyType.md)
 - [HPAScalingRules](docs/HPAScalingRules.md)
 - [HTTPGetAction](docs/HTTPGetAction.md)
 - [HTTPHeader](docs/HTTPHeader.md)
 - [Handler](docs/Handler.md)
 - [HealthCheckInfo](docs/HealthCheckInfo.md)
 - [HorizontalPodAutoscalerBehavior](docs/HorizontalPodAutoscalerBehavior.md)
 - [HorizontalPodAutoscalerConfig](docs/HorizontalPodAutoscalerConfig.md)
 - [HostAlias](docs/HostAlias.md)
 - [HostPathType](docs/HostPathType.md)
 - [HostPathVolumeSource](docs/HostPathVolumeSource.md)
 - [IPFamily](docs/IPFamily.md)
 - [ISCSIVolumeSource](docs/ISCSIVolumeSource.md)
 - [InferenceService](docs/InferenceService.md)
 - [InferenceServiceList](docs/InferenceServiceList.md)
 - [InferenceServiceSpec](docs/InferenceServiceSpec.md)
 - [InferenceServiceStatus](docs/InferenceServiceStatus.md)
 - [IntOrString](docs/IntOrString.md)
 - [KeyToPath](docs/KeyToPath.md)
 - [LabelSelector](docs/LabelSelector.md)
 - [LabelSelectorOperator](docs/LabelSelectorOperator.md)
 - [LabelSelectorRequirement](docs/LabelSelectorRequirement.md)
 - [Lifecycle](docs/Lifecycle.md)
 - [ListMeta](docs/ListMeta.md)
 - [LocalObjectReference](docs/LocalObjectReference.md)
 - [Logger](docs/Logger.md)
 - [LoggerDataType](docs/LoggerDataType.md)
 - [LoggerMode](docs/LoggerMode.md)
 - [ManagedFieldsEntry](docs/ManagedFieldsEntry.md)
 - [ManagedFieldsOperationType](docs/ManagedFieldsOperationType.md)
 - [Message](docs/Message.md)
 - [MetricSourceType](docs/MetricSourceType.md)
 - [MetricSpec](docs/MetricSpec.md)
 - [MonitorInputData](docs/MonitorInputData.md)
 - [MountPropagationMode](docs/MountPropagationMode.md)
 - [NFSVolumeSource](docs/NFSVolumeSource.md)
 - [Namespace](docs/Namespace.md)
 - [NamespaceCondition](docs/NamespaceCondition.md)
 - [NamespaceConditionType](docs/NamespaceConditionType.md)
 - [NamespacePhase](docs/NamespacePhase.md)
 - [NamespaceSpec](docs/NamespaceSpec.md)
 - [NamespaceStatus](docs/NamespaceStatus.md)
 - [NodeAffinity](docs/NodeAffinity.md)
 - [NodePhase](docs/NodePhase.md)
 - [NodeSelector](docs/NodeSelector.md)
 - [NodeSelectorOperator](docs/NodeSelectorOperator.md)
 - [NodeSelectorRequirement](docs/NodeSelectorRequirement.md)
 - [NodeSelectorTerm](docs/NodeSelectorTerm.md)
 - [ObjectFieldSelector](docs/ObjectFieldSelector.md)
 - [ObjectMeta](docs/ObjectMeta.md)
 - [ObjectMetricSource](docs/ObjectMetricSource.md)
 - [OwnerReference](docs/OwnerReference.md)
 - [Parameter](docs/Parameter.md)
 - [ParmeterType](docs/ParmeterType.md)
 - [PersistentVolumeAccessMode](docs/PersistentVolumeAccessMode.md)
 - [PersistentVolumeClaimSpec](docs/PersistentVolumeClaimSpec.md)
 - [PersistentVolumeClaimTemplate](docs/PersistentVolumeClaimTemplate.md)
 - [PersistentVolumeClaimVolumeSource](docs/PersistentVolumeClaimVolumeSource.md)
 - [PersistentVolumeMode](docs/PersistentVolumeMode.md)
 - [PhotonPersistentDiskVolumeSource](docs/PhotonPersistentDiskVolumeSource.md)
 - [Pod](docs/Pod.md)
 - [PodAffinity](docs/PodAffinity.md)
 - [PodAffinityTerm](docs/PodAffinityTerm.md)
 - [PodAntiAffinity](docs/PodAntiAffinity.md)
 - [PodCondition](docs/PodCondition.md)
 - [PodConditionType](docs/PodConditionType.md)
 - [PodDNSConfig](docs/PodDNSConfig.md)
 - [PodDNSConfigOption](docs/PodDNSConfigOption.md)
 - [PodFSGroupChangePolicy](docs/PodFSGroupChangePolicy.md)
 - [PodIP](docs/PodIP.md)
 - [PodList](docs/PodList.md)
 - [PodPhase](docs/PodPhase.md)
 - [PodQOSClass](docs/PodQOSClass.md)
 - [PodReadinessGate](docs/PodReadinessGate.md)
 - [PodSecurityContext](docs/PodSecurityContext.md)
 - [PodSpec](docs/PodSpec.md)
 - [PodStatus](docs/PodStatus.md)
 - [PodTemplateSpec](docs/PodTemplateSpec.md)
 - [PodsMetricSource](docs/PodsMetricSource.md)
 - [PortworxVolumeSource](docs/PortworxVolumeSource.md)
 - [PredictiveUnit](docs/PredictiveUnit.md)
 - [PredictiveUnitImplementation](docs/PredictiveUnitImplementation.md)
 - [PredictiveUnitMethod](docs/PredictiveUnitMethod.md)
 - [PredictiveUnitType](docs/PredictiveUnitType.md)
 - [PredictorSpec](docs/PredictorSpec.md)
 - [PreemptionPolicy](docs/PreemptionPolicy.md)
 - [PreferredSchedulingTerm](docs/PreferredSchedulingTerm.md)
 - [Probe](docs/Probe.md)
 - [ProcMountType](docs/ProcMountType.md)
 - [ProjectedVolumeSource](docs/ProjectedVolumeSource.md)
 - [ProtobufAny](docs/ProtobufAny.md)
 - [Protocol](docs/Protocol.md)
 - [PullPolicy](docs/PullPolicy.md)
 - [Quantity](docs/Quantity.md)
 - [QuobyteVolumeSource](docs/QuobyteVolumeSource.md)
 - [RBDVolumeSource](docs/RBDVolumeSource.md)
 - [ResourceFieldSelector](docs/ResourceFieldSelector.md)
 - [ResourceList](docs/ResourceList.md)
 - [ResourceMetricSource](docs/ResourceMetricSource.md)
 - [ResourceName](docs/ResourceName.md)
 - [ResourceRequirements](docs/ResourceRequirements.md)
 - [RestartPolicy](docs/RestartPolicy.md)
 - [RollingUpdateDeployment](docs/RollingUpdateDeployment.md)
 - [RpcStatus](docs/RpcStatus.md)
 - [SELinuxOptions](docs/SELinuxOptions.md)
 - [SSL](docs/SSL.md)
 - [ScaleIOVolumeSource](docs/ScaleIOVolumeSource.md)
 - [ScaleTriggers](docs/ScaleTriggers.md)
 - [ScaledObjectAuthRef](docs/ScaledObjectAuthRef.md)
 - [ScalingPolicySelect](docs/ScalingPolicySelect.md)
 - [SeccompProfile](docs/SeccompProfile.md)
 - [SeccompProfileType](docs/SeccompProfileType.md)
 - [SecretEnvSource](docs/SecretEnvSource.md)
 - [SecretKeySelector](docs/SecretKeySelector.md)
 - [SecretProjection](docs/SecretProjection.md)
 - [SecretVolumeSource](docs/SecretVolumeSource.md)
 - [SecurityContext](docs/SecurityContext.md)
 - [SeldonAddressable](docs/SeldonAddressable.md)
 - [SeldonDeployment](docs/SeldonDeployment.md)
 - [SeldonDeploymentList](docs/SeldonDeploymentList.md)
 - [SeldonDeploymentSpec](docs/SeldonDeploymentSpec.md)
 - [SeldonDeploymentStatus](docs/SeldonDeploymentStatus.md)
 - [SeldonHpaSpec](docs/SeldonHpaSpec.md)
 - [SeldonPdbSpec](docs/SeldonPdbSpec.md)
 - [SeldonPodSpec](docs/SeldonPodSpec.md)
 - [SeldonScaledObjectSpec](docs/SeldonScaledObjectSpec.md)
 - [ServerType](docs/ServerType.md)
 - [Service](docs/Service.md)
 - [ServiceAccountTokenProjection](docs/ServiceAccountTokenProjection.md)
 - [ServiceAffinity](docs/ServiceAffinity.md)
 - [ServiceExternalTrafficPolicyType](docs/ServiceExternalTrafficPolicyType.md)
 - [ServiceList](docs/ServiceList.md)
 - [ServicePort](docs/ServicePort.md)
 - [ServiceSpec](docs/ServiceSpec.md)
 - [ServiceStatus](docs/ServiceStatus.md)
 - [ServiceType](docs/ServiceType.md)
 - [SessionAffinityConfig](docs/SessionAffinityConfig.md)
 - [StatusState](docs/StatusState.md)
 - [StorageMedium](docs/StorageMedium.md)
 - [StorageOSVolumeSource](docs/StorageOSVolumeSource.md)
 - [SvcOrchSpec](docs/SvcOrchSpec.md)
 - [Sysctl](docs/Sysctl.md)
 - [TCPSocketAction](docs/TCPSocketAction.md)
 - [TaintEffect](docs/TaintEffect.md)
 - [TerminationMessagePolicy](docs/TerminationMessagePolicy.md)
 - [Time](docs/Time.md)
 - [Toleration](docs/Toleration.md)
 - [TolerationOperator](docs/TolerationOperator.md)
 - [TopologySpreadConstraint](docs/TopologySpreadConstraint.md)
 - [TransformerSpec](docs/TransformerSpec.md)
 - [Transport](docs/Transport.md)
 - [Type](docs/Type.md)
 - [TypedLocalObjectReference](docs/TypedLocalObjectReference.md)
 - [UID](docs/UID.md)
 - [URIScheme](docs/URIScheme.md)
 - [URL](docs/URL.md)
 - [UnsatisfiableConstraintAction](docs/UnsatisfiableConstraintAction.md)
 - [UserInfo](docs/UserInfo.md)
 - [V1ArtifactType](docs/V1ArtifactType.md)
 - [V1DataType](docs/V1DataType.md)
 - [V1DeploymentStatus](docs/V1DeploymentStatus.md)
 - [V1DeploymentType](docs/V1DeploymentType.md)
 - [V1FeatureCategorySchema](docs/V1FeatureCategorySchema.md)
 - [V1FeatureSchema](docs/V1FeatureSchema.md)
 - [V1FeatureType](docs/V1FeatureType.md)
 - [V1Model](docs/V1Model.md)
 - [V1ModelMetadataCreateResponse](docs/V1ModelMetadataCreateResponse.md)
 - [V1ModelMetadataDeleteResponse](docs/V1ModelMetadataDeleteResponse.md)
 - [V1ModelMetadataListResponse](docs/V1ModelMetadataListResponse.md)
 - [V1ModelMetadataUpdateResponse](docs/V1ModelMetadataUpdateResponse.md)
 - [V1PredictionSchema](docs/V1PredictionSchema.md)
 - [V1RuntimeMetadata](docs/V1RuntimeMetadata.md)
 - [V1RuntimeMetadataListResponse](docs/V1RuntimeMetadataListResponse.md)
 - [VersionInfo](docs/VersionInfo.md)
 - [Volume](docs/Volume.md)
 - [VolumeDevice](docs/VolumeDevice.md)
 - [VolumeMount](docs/VolumeMount.md)
 - [VolumeProjection](docs/VolumeProjection.md)
 - [VsphereVirtualDiskVolumeSource](docs/VsphereVirtualDiskVolumeSource.md)
 - [WeightedPodAffinityTerm](docs/WeightedPodAffinityTerm.md)
 - [WindowsSecurityContextOptions](docs/WindowsSecurityContextOptions.md)


## Documentation For Authorization


## OAuth2

- **Type**: OAuth
- **Flow**: password
- **Authorization URL**: 
- **Scopes**: 
 - **email**: 
 - **groups**: 
 - **openid**: 
 - **profile**: 


## Author

hello@seldon.io

