# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class FeatureFilter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category_name': 'str',
        'feature': 'str',
        'gt': 'str',
        'gte': 'str',
        'interaction': 'FeatureInteraction',
        'is_outlier': 'bool',
        'is_timestamp': 'bool',
        'lt': 'str',
        'lte': 'str',
        'terms': 'list[str]'
    }

    attribute_map = {
        'category_name': 'category_name',
        'feature': 'feature',
        'gt': 'gt',
        'gte': 'gte',
        'interaction': 'interaction',
        'is_outlier': 'is_outlier',
        'is_timestamp': 'is_timestamp',
        'lt': 'lt',
        'lte': 'lte',
        'terms': 'terms'
    }

    def __init__(self, category_name=None, feature=None, gt=None, gte=None, interaction=None, is_outlier=None, is_timestamp=None, lt=None, lte=None, terms=None):  # noqa: E501
        """FeatureFilter - a model defined in Swagger"""  # noqa: E501

        self._category_name = None
        self._feature = None
        self._gt = None
        self._gte = None
        self._interaction = None
        self._is_outlier = None
        self._is_timestamp = None
        self._lt = None
        self._lte = None
        self._terms = None
        self.discriminator = None

        if category_name is not None:
            self.category_name = category_name
        if feature is not None:
            self.feature = feature
        if gt is not None:
            self.gt = gt
        if gte is not None:
            self.gte = gte
        if interaction is not None:
            self.interaction = interaction
        if is_outlier is not None:
            self.is_outlier = is_outlier
        if is_timestamp is not None:
            self.is_timestamp = is_timestamp
        if lt is not None:
            self.lt = lt
        if lte is not None:
            self.lte = lte
        if terms is not None:
            self.terms = terms

    @property
    def category_name(self):
        """Gets the category_name of this FeatureFilter.  # noqa: E501

        CategoryName refers to name of the feature category relevant to PROBA and ONE_HOT features  # noqa: E501

        :return: The category_name of this FeatureFilter.  # noqa: E501
        :rtype: str
        """
        return self._category_name

    @category_name.setter
    def category_name(self, category_name):
        """Sets the category_name of this FeatureFilter.

        CategoryName refers to name of the feature category relevant to PROBA and ONE_HOT features  # noqa: E501

        :param category_name: The category_name of this FeatureFilter.  # noqa: E501
        :type: str
        """

        self._category_name = category_name

    @property
    def feature(self):
        """Gets the feature of this FeatureFilter.  # noqa: E501

        FeatureName refers to the name of feature as per the model predictions schema  # noqa: E501

        :return: The feature of this FeatureFilter.  # noqa: E501
        :rtype: str
        """
        return self._feature

    @feature.setter
    def feature(self, feature):
        """Sets the feature of this FeatureFilter.

        FeatureName refers to the name of feature as per the model predictions schema  # noqa: E501

        :param feature: The feature of this FeatureFilter.  # noqa: E501
        :type: str
        """

        self._feature = feature

    @property
    def gt(self):
        """Gets the gt of this FeatureFilter.  # noqa: E501

        GreaterThan refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :return: The gt of this FeatureFilter.  # noqa: E501
        :rtype: str
        """
        return self._gt

    @gt.setter
    def gt(self, gt):
        """Sets the gt of this FeatureFilter.

        GreaterThan refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :param gt: The gt of this FeatureFilter.  # noqa: E501
        :type: str
        """

        self._gt = gt

    @property
    def gte(self):
        """Gets the gte of this FeatureFilter.  # noqa: E501

        GreaterThanOrEqual refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :return: The gte of this FeatureFilter.  # noqa: E501
        :rtype: str
        """
        return self._gte

    @gte.setter
    def gte(self, gte):
        """Sets the gte of this FeatureFilter.

        GreaterThanOrEqual refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :param gte: The gte of this FeatureFilter.  # noqa: E501
        :type: str
        """

        self._gte = gte

    @property
    def interaction(self):
        """Gets the interaction of this FeatureFilter.  # noqa: E501


        :return: The interaction of this FeatureFilter.  # noqa: E501
        :rtype: FeatureInteraction
        """
        return self._interaction

    @interaction.setter
    def interaction(self, interaction):
        """Sets the interaction of this FeatureFilter.


        :param interaction: The interaction of this FeatureFilter.  # noqa: E501
        :type: FeatureInteraction
        """

        self._interaction = interaction

    @property
    def is_outlier(self):
        """Gets the is_outlier of this FeatureFilter.  # noqa: E501

        IsOutlier refers to boolean for outlier filters  # noqa: E501

        :return: The is_outlier of this FeatureFilter.  # noqa: E501
        :rtype: bool
        """
        return self._is_outlier

    @is_outlier.setter
    def is_outlier(self, is_outlier):
        """Sets the is_outlier of this FeatureFilter.

        IsOutlier refers to boolean for outlier filters  # noqa: E501

        :param is_outlier: The is_outlier of this FeatureFilter.  # noqa: E501
        :type: bool
        """

        self._is_outlier = is_outlier

    @property
    def is_timestamp(self):
        """Gets the is_timestamp of this FeatureFilter.  # noqa: E501

        IsTimestamp refers to boolean for timestamp filters  # noqa: E501

        :return: The is_timestamp of this FeatureFilter.  # noqa: E501
        :rtype: bool
        """
        return self._is_timestamp

    @is_timestamp.setter
    def is_timestamp(self, is_timestamp):
        """Sets the is_timestamp of this FeatureFilter.

        IsTimestamp refers to boolean for timestamp filters  # noqa: E501

        :param is_timestamp: The is_timestamp of this FeatureFilter.  # noqa: E501
        :type: bool
        """

        self._is_timestamp = is_timestamp

    @property
    def lt(self):
        """Gets the lt of this FeatureFilter.  # noqa: E501

        LessThan refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :return: The lt of this FeatureFilter.  # noqa: E501
        :rtype: str
        """
        return self._lt

    @lt.setter
    def lt(self, lt):
        """Sets the lt of this FeatureFilter.

        LessThan refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :param lt: The lt of this FeatureFilter.  # noqa: E501
        :type: str
        """

        self._lt = lt

    @property
    def lte(self):
        """Gets the lte of this FeatureFilter.  # noqa: E501

        LessThanOrEqual refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :return: The lte of this FeatureFilter.  # noqa: E501
        :rtype: str
        """
        return self._lte

    @lte.setter
    def lte(self, lte):
        """Sets the lte of this FeatureFilter.

        LessThanOrEqual refers to numerical value of the feature filter relevant for timestamps or REAL features  # noqa: E501

        :param lte: The lte of this FeatureFilter.  # noqa: E501
        :type: str
        """

        self._lte = lte

    @property
    def terms(self):
        """Gets the terms of this FeatureFilter.  # noqa: E501

        Terms refers to set of feature categories to filter relevant to CATEGORICAL features  # noqa: E501

        :return: The terms of this FeatureFilter.  # noqa: E501
        :rtype: list[str]
        """
        return self._terms

    @terms.setter
    def terms(self, terms):
        """Sets the terms of this FeatureFilter.

        Terms refers to set of feature categories to filter relevant to CATEGORICAL features  # noqa: E501

        :param terms: The terms of this FeatureFilter.  # noqa: E501
        :type: list[str]
        """

        self._terms = terms

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FeatureFilter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FeatureFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
