"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocsProject = void 0;
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const languages_1 = require("../languages");
const generated_html2_docs_1 = require("./components/docs/generated-html2-docs");
const generated_markdown_docs_1 = require("./components/docs/generated-markdown-docs");
const generated_plantuml_docs_1 = require("./components/docs/generated-plantuml-docs");
const logger = log4js_1.getLogger();
/**
 * Project containing generated OpenApi docs
 */
class DocsProject extends projen_1.Project {
    constructor(options) {
        super(options);
        // HACK: remove all components but the ones we are registering - removes .gitignore, tasks, etc since these are
        // unused and a distraction for end-users!
        // @ts-ignore
        this._components = [];
        // Generate docs in all specified formats
        options.formatConfigs.forEach((formatConfig) => {
            logger.trace(`${formatConfig.documentationFormat} :: generate = ${formatConfig.generate}`);
            if (formatConfig.generate) {
                this.generateDocs(formatConfig.documentationFormat, options.specPath);
            }
        });
    }
    /**
     * Generates the docs in the given format
     */
    generateDocs(format, specPath) {
        switch (format) {
            case languages_1.DocumentationFormat.HTML2:
                return new generated_html2_docs_1.GeneratedHtml2Docs(this, { specPath });
            case languages_1.DocumentationFormat.MARKDOWN:
                return new generated_markdown_docs_1.GeneratedMarkdownDocs(this, { specPath });
            case languages_1.DocumentationFormat.PLANTUML:
                return new generated_plantuml_docs_1.GeneratedPlantUmlDocs(this, { specPath });
            default:
                throw new Error(`Unsupported documentation format ${format}`);
        }
    }
}
exports.DocsProject = DocsProject;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG9jcy1wcm9qZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3Byb2plY3QvY29kZWdlbi9kb2NzLXByb2plY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7Ozs7Ozt3SEFjd0g7OztBQUV4SCxtQ0FBbUM7QUFDbkMsbUNBQWlEO0FBRWpELDRDQUFtRDtBQUNuRCxpRkFBNEU7QUFDNUUsdUZBQWtGO0FBQ2xGLHVGQUFrRjtBQUVsRixNQUFNLE1BQU0sR0FBRyxrQkFBUyxFQUFFLENBQUM7QUFnQjNCOztHQUVHO0FBQ0gsTUFBYSxXQUFZLFNBQVEsZ0JBQU87SUFDdEMsWUFBWSxPQUEyQjtRQUNyQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDZiwrR0FBK0c7UUFDL0csMENBQTBDO1FBQzFDLGFBQWE7UUFDYixJQUFJLENBQUMsV0FBVyxHQUFHLEVBQUUsQ0FBQztRQUV0Qix5Q0FBeUM7UUFDekMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxZQUFZLEVBQUUsRUFBRTtZQUM3QyxNQUFNLENBQUMsS0FBSyxDQUNWLEdBQUcsWUFBWSxDQUFDLG1CQUFtQixrQkFBa0IsWUFBWSxDQUFDLFFBQVEsRUFBRSxDQUM3RSxDQUFDO1lBQ0YsSUFBSSxZQUFZLENBQUMsUUFBUSxFQUFFO2dCQUN6QixJQUFJLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsRUFBRSxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUM7YUFDdkU7UUFDSCxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRDs7T0FFRztJQUNILFlBQVksQ0FBQyxNQUEyQixFQUFFLFFBQWdCO1FBQ3hELFFBQVEsTUFBTSxFQUFFO1lBQ2QsS0FBSywrQkFBbUIsQ0FBQyxLQUFLO2dCQUM1QixPQUFPLElBQUkseUNBQWtCLENBQUMsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLENBQUMsQ0FBQztZQUNwRCxLQUFLLCtCQUFtQixDQUFDLFFBQVE7Z0JBQy9CLE9BQU8sSUFBSSwrQ0FBcUIsQ0FBQyxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsQ0FBQyxDQUFDO1lBQ3ZELEtBQUssK0JBQW1CLENBQUMsUUFBUTtnQkFDL0IsT0FBTyxJQUFJLCtDQUFxQixDQUFDLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxDQUFDLENBQUM7WUFDdkQ7Z0JBQ0UsTUFBTSxJQUFJLEtBQUssQ0FBQyxvQ0FBb0MsTUFBTSxFQUFFLENBQUMsQ0FBQztTQUNqRTtJQUNILENBQUM7Q0FDRjtBQWxDRCxrQ0FrQ0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5cbiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLlxuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiBZb3UgbWF5IG9idGFpbiBhIGNvcHkgb2YgdGhlIExpY2Vuc2UgYXRcblxuIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuXG4gVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiBXSVRIT1VUIFdBUlJBTlRJRVMgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC5cbiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiogKi9cblxuaW1wb3J0IHsgZ2V0TG9nZ2VyIH0gZnJvbSBcImxvZzRqc1wiO1xuaW1wb3J0IHsgUHJvamVjdCwgUHJvamVjdE9wdGlvbnMgfSBmcm9tIFwicHJvamVuXCI7XG5pbXBvcnQgeyBEb2N1bWVudGF0aW9uRm9ybWF0Q29uZmlnIH0gZnJvbSBcIi4uL2NsaWVudC1jb25maWdcIjtcbmltcG9ydCB7IERvY3VtZW50YXRpb25Gb3JtYXQgfSBmcm9tIFwiLi4vbGFuZ3VhZ2VzXCI7XG5pbXBvcnQgeyBHZW5lcmF0ZWRIdG1sMkRvY3MgfSBmcm9tIFwiLi9jb21wb25lbnRzL2RvY3MvZ2VuZXJhdGVkLWh0bWwyLWRvY3NcIjtcbmltcG9ydCB7IEdlbmVyYXRlZE1hcmtkb3duRG9jcyB9IGZyb20gXCIuL2NvbXBvbmVudHMvZG9jcy9nZW5lcmF0ZWQtbWFya2Rvd24tZG9jc1wiO1xuaW1wb3J0IHsgR2VuZXJhdGVkUGxhbnRVbWxEb2NzIH0gZnJvbSBcIi4vY29tcG9uZW50cy9kb2NzL2dlbmVyYXRlZC1wbGFudHVtbC1kb2NzXCI7XG5cbmNvbnN0IGxvZ2dlciA9IGdldExvZ2dlcigpO1xuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gZm9yIHRoZSBPcGVuQVBJIGRvY3MgcHJvamVjdFxuICovXG5leHBvcnQgaW50ZXJmYWNlIERvY3NQcm9qZWN0T3B0aW9ucyBleHRlbmRzIFByb2plY3RPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBhYnNvbHV0ZSBwYXRoIHRvIHRoZSBPcGVuQVBJIHNwZWNpZmljYXRpb24gKHNwZWMueWFtbCkgZnJvbSB3aGljaCB0byBnZW5lcmF0ZSBkb2NzXG4gICAqL1xuICByZWFkb25seSBzcGVjUGF0aDogc3RyaW5nO1xuICAvKipcbiAgICogVGhlIGZvcm1hdHMgdG8gZ2VuZXJhdGUgZG9jdW1lbnRhdGlvbiBpblxuICAgKi9cbiAgcmVhZG9ubHkgZm9ybWF0Q29uZmlnczogRG9jdW1lbnRhdGlvbkZvcm1hdENvbmZpZ1tdO1xufVxuXG4vKipcbiAqIFByb2plY3QgY29udGFpbmluZyBnZW5lcmF0ZWQgT3BlbkFwaSBkb2NzXG4gKi9cbmV4cG9ydCBjbGFzcyBEb2NzUHJvamVjdCBleHRlbmRzIFByb2plY3Qge1xuICBjb25zdHJ1Y3RvcihvcHRpb25zOiBEb2NzUHJvamVjdE9wdGlvbnMpIHtcbiAgICBzdXBlcihvcHRpb25zKTtcbiAgICAvLyBIQUNLOiByZW1vdmUgYWxsIGNvbXBvbmVudHMgYnV0IHRoZSBvbmVzIHdlIGFyZSByZWdpc3RlcmluZyAtIHJlbW92ZXMgLmdpdGlnbm9yZSwgdGFza3MsIGV0YyBzaW5jZSB0aGVzZSBhcmVcbiAgICAvLyB1bnVzZWQgYW5kIGEgZGlzdHJhY3Rpb24gZm9yIGVuZC11c2VycyFcbiAgICAvLyBAdHMtaWdub3JlXG4gICAgdGhpcy5fY29tcG9uZW50cyA9IFtdO1xuXG4gICAgLy8gR2VuZXJhdGUgZG9jcyBpbiBhbGwgc3BlY2lmaWVkIGZvcm1hdHNcbiAgICBvcHRpb25zLmZvcm1hdENvbmZpZ3MuZm9yRWFjaCgoZm9ybWF0Q29uZmlnKSA9PiB7XG4gICAgICBsb2dnZXIudHJhY2UoXG4gICAgICAgIGAke2Zvcm1hdENvbmZpZy5kb2N1bWVudGF0aW9uRm9ybWF0fSA6OiBnZW5lcmF0ZSA9ICR7Zm9ybWF0Q29uZmlnLmdlbmVyYXRlfWBcbiAgICAgICk7XG4gICAgICBpZiAoZm9ybWF0Q29uZmlnLmdlbmVyYXRlKSB7XG4gICAgICAgIHRoaXMuZ2VuZXJhdGVEb2NzKGZvcm1hdENvbmZpZy5kb2N1bWVudGF0aW9uRm9ybWF0LCBvcHRpb25zLnNwZWNQYXRoKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHZW5lcmF0ZXMgdGhlIGRvY3MgaW4gdGhlIGdpdmVuIGZvcm1hdFxuICAgKi9cbiAgZ2VuZXJhdGVEb2NzKGZvcm1hdDogRG9jdW1lbnRhdGlvbkZvcm1hdCwgc3BlY1BhdGg6IHN0cmluZykge1xuICAgIHN3aXRjaCAoZm9ybWF0KSB7XG4gICAgICBjYXNlIERvY3VtZW50YXRpb25Gb3JtYXQuSFRNTDI6XG4gICAgICAgIHJldHVybiBuZXcgR2VuZXJhdGVkSHRtbDJEb2NzKHRoaXMsIHsgc3BlY1BhdGggfSk7XG4gICAgICBjYXNlIERvY3VtZW50YXRpb25Gb3JtYXQuTUFSS0RPV046XG4gICAgICAgIHJldHVybiBuZXcgR2VuZXJhdGVkTWFya2Rvd25Eb2NzKHRoaXMsIHsgc3BlY1BhdGggfSk7XG4gICAgICBjYXNlIERvY3VtZW50YXRpb25Gb3JtYXQuUExBTlRVTUw6XG4gICAgICAgIHJldHVybiBuZXcgR2VuZXJhdGVkUGxhbnRVbWxEb2NzKHRoaXMsIHsgc3BlY1BhdGggfSk7XG4gICAgICBkZWZhdWx0OlxuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYFVuc3VwcG9ydGVkIGRvY3VtZW50YXRpb24gZm9ybWF0ICR7Zm9ybWF0fWApO1xuICAgIH1cbiAgfVxufVxuIl19