<a id="mypy-boto3-dynamodb"></a>

# mypy-boto3-dynamodb

[![PyPI - mypy-boto3-dynamodb](https://img.shields.io/pypi/v/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-dynamodb?color=blue)](https://pypistats.org/packages/mypy-boto3-dynamodb)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.DynamoDB 1.26.97](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/dynamodb.html#DynamoDB)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.14.1](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-dynamodb docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-dynamodb](#mypy-boto3-dynamodb)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
    - [From conda-forge](#from-conda-forge)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `DynamoDB`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `DynamoDB` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[dynamodb]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[dynamodb]'


# standalone installation
python -m pip install mypy-boto3-dynamodb
```

<a id="from-conda-forge"></a>

### From conda-forge

Installing `mypy-boto3-dynamodb` from the `conda-forge` channel can be achieved
by adding `conda-forge` to your channels with:

```bash
conda config --add channels conda-forge
conda config --set channel_priority strict
```

Once the `conda-forge` channel has been enabled, `mypy-boto3-dynamodb` can be
installed with:

```bash
conda install mypy-boto3-dynamodb
```

It is possible to list all of the versions of `mypy-boto3-dynamodb` available
on your platform with:

```bash
conda search mypy-boto3-dynamodb --channel conda-forge
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-dynamodb
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[dynamodb]` in your environment:

```bash
python -m pip install 'boto3-stubs[dynamodb]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[dynamodb]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[dynamodb]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[dynamodb]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[dynamodb]` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[dynamodb]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[dynamodb]` in your environment:

```bash
python -m pip install 'boto3-stubs[dynamodb]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[dynamodb]` in your environment:

```bash
python -m pip install 'boto3-stubs[dynamodb]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`DynamoDBClient` provides annotations for `boto3.client("dynamodb")`.

```python
from boto3.session import Session

from mypy_boto3_dynamodb import DynamoDBClient

client: DynamoDBClient = Session().client("dynamodb")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_dynamodb.paginator` module contains type annotations for all
paginators.

```python
from boto3.session import Session

from mypy_boto3_dynamodb import DynamoDBClient
from mypy_boto3_dynamodb.paginator import (
    ListBackupsPaginator,
    ListTablesPaginator,
    ListTagsOfResourcePaginator,
    QueryPaginator,
    ScanPaginator,
)

client: DynamoDBClient = Session().client("dynamodb")

# Explicit type annotations are optional here
# Types should be correctly discovered by mypy and IDEs
list_backups_paginator: ListBackupsPaginator = client.get_paginator("list_backups")
list_tables_paginator: ListTablesPaginator = client.get_paginator("list_tables")
list_tags_of_resource_paginator: ListTagsOfResourcePaginator = client.get_paginator(
    "list_tags_of_resource"
)
query_paginator: QueryPaginator = client.get_paginator("query")
scan_paginator: ScanPaginator = client.get_paginator("scan")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_dynamodb.waiter` module contains type annotations for all waiters.

```python
from boto3.session import Session

from mypy_boto3_dynamodb import DynamoDBClient
from mypy_boto3_dynamodb.waiter import TableExistsWaiter, TableNotExistsWaiter

client: DynamoDBClient = Session().client("dynamodb")

# Explicit type annotations are optional here
# Types should be correctly discovered by mypy and IDEs
table_exists_waiter: TableExistsWaiter = client.get_waiter("table_exists")
table_not_exists_waiter: TableNotExistsWaiter = client.get_waiter("table_not_exists")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`DynamoDBServiceResource` provides annotations for
`boto3.resource("dynamodb")`.

```python
from boto3.session import Session

from mypy_boto3_dynamodb import DynamoDBServiceResource

resource: DynamoDBServiceResource = Session().resource("dynamodb")

# now resource usage is checked by mypy and IDE should provide code completion
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations for all
resources.

```python
from boto3.session import Session

from mypy_boto3_dynamodb import DynamoDBServiceResource
from mypy_boto3_dynamodb.service_resource import Table

resource: DynamoDBServiceResource = Session().resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_table: Table = resource.Table(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations for all
`DynamoDBServiceResource` collections.

```python
from boto3.session import Session

from mypy_boto3_dynamodb import DynamoDBServiceResource
from mypy_boto3_dynamodb.service_resource import ServiceResourceTablesCollection

resource: DynamoDBServiceResource = Session().resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
tables: dynamodb_resources.ServiceResourceTablesCollection = resource.tables
```

<a id="literals"></a>

### Literals

`mypy_boto3_dynamodb.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_dynamodb.literals import (
    AttributeActionType,
    BackupStatusType,
    BackupTypeFilterType,
    BackupTypeType,
    BatchStatementErrorCodeEnumType,
    BillingModeType,
    ComparisonOperatorType,
    ConditionalOperatorType,
    ContinuousBackupsStatusType,
    ContributorInsightsActionType,
    ContributorInsightsStatusType,
    DestinationStatusType,
    ExportFormatType,
    ExportStatusType,
    GlobalTableStatusType,
    ImportStatusType,
    IndexStatusType,
    InputCompressionTypeType,
    InputFormatType,
    KeyTypeType,
    ListBackupsPaginatorName,
    ListTablesPaginatorName,
    ListTagsOfResourcePaginatorName,
    PointInTimeRecoveryStatusType,
    ProjectionTypeType,
    QueryPaginatorName,
    ReplicaStatusType,
    ReturnConsumedCapacityType,
    ReturnItemCollectionMetricsType,
    ReturnValueType,
    ReturnValuesOnConditionCheckFailureType,
    S3SseAlgorithmType,
    SSEStatusType,
    SSETypeType,
    ScalarAttributeTypeType,
    ScanPaginatorName,
    SelectType,
    StreamViewTypeType,
    TableClassType,
    TableExistsWaiterName,
    TableNotExistsWaiterName,
    TableStatusType,
    TimeToLiveStatusType,
    DynamoDBServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
    WaiterName,
    RegionName,
)


def check_value(value: AttributeActionType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_dynamodb.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_dynamodb.type_defs import (
    ResponseMetadataTypeDef,
    ArchivalSummaryTableTypeDef,
    ArchivalSummaryTypeDef,
    AttributeDefinitionServiceResourceTypeDef,
    AttributeDefinitionTableTypeDef,
    AttributeDefinitionTypeDef,
    AttributeValueTypeDef,
    AttributeValueUpdateTableTypeDef,
    AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionTypeDef,
    AutoScalingTargetTrackingScalingPolicyConfigurationUpdateTypeDef,
    BackupDetailsTypeDef,
    BackupSummaryTableTypeDef,
    BackupSummaryTypeDef,
    KeysAndAttributesServiceResourceTypeDef,
    BatchStatementErrorTypeDef,
    ItemCollectionMetricsServiceResourceTypeDef,
    BillingModeSummaryTableTypeDef,
    BillingModeSummaryTypeDef,
    CapacityServiceResourceTypeDef,
    CapacityTableTypeDef,
    CapacityTypeDef,
    ConditionTableTypeDef,
    PointInTimeRecoveryDescriptionTypeDef,
    ContributorInsightsSummaryTypeDef,
    CreateBackupInputRequestTypeDef,
    KeySchemaElementTableTypeDef,
    ProjectionTableTypeDef,
    ProvisionedThroughputTableTypeDef,
    KeySchemaElementTypeDef,
    ProjectionTypeDef,
    ProvisionedThroughputTypeDef,
    ReplicaTypeDef,
    CreateReplicaActionTypeDef,
    ProvisionedThroughputOverrideTableTypeDef,
    ProvisionedThroughputOverrideTypeDef,
    SSESpecificationTypeDef,
    StreamSpecificationTypeDef,
    TagTypeDef,
    KeySchemaElementServiceResourceTypeDef,
    ProvisionedThroughputServiceResourceTypeDef,
    SSESpecificationServiceResourceTypeDef,
    StreamSpecificationServiceResourceTypeDef,
    TagServiceResourceTypeDef,
    CsvOptionsTypeDef,
    DeleteBackupInputRequestTypeDef,
    DeleteGlobalSecondaryIndexActionTableTypeDef,
    DeleteGlobalSecondaryIndexActionTypeDef,
    ExpectedAttributeValueTableTypeDef,
    ItemCollectionMetricsTableTypeDef,
    DeleteReplicaActionTypeDef,
    DeleteReplicationGroupMemberActionTableTypeDef,
    DeleteReplicationGroupMemberActionTypeDef,
    DeleteRequestServiceResourceTypeDef,
    DeleteTableInputRequestTypeDef,
    DescribeBackupInputRequestTypeDef,
    DescribeContinuousBackupsInputRequestTypeDef,
    DescribeContributorInsightsInputRequestTypeDef,
    FailureExceptionTypeDef,
    EndpointTypeDef,
    DescribeExportInputRequestTypeDef,
    ExportDescriptionTypeDef,
    DescribeGlobalTableInputRequestTypeDef,
    DescribeGlobalTableSettingsInputRequestTypeDef,
    DescribeImportInputRequestTypeDef,
    DescribeKinesisStreamingDestinationInputRequestTypeDef,
    KinesisDataStreamDestinationTypeDef,
    DescribeTableInputRequestTypeDef,
    WaiterConfigTypeDef,
    DescribeTableReplicaAutoScalingInputRequestTypeDef,
    DescribeTimeToLiveInputRequestTypeDef,
    TimeToLiveDescriptionTypeDef,
    ExportSummaryTypeDef,
    ExportTableToPointInTimeInputRequestTypeDef,
    GetItemInputTableGetItemTypeDef,
    ProvisionedThroughputDescriptionTableTypeDef,
    ProvisionedThroughputDescriptionTypeDef,
    ProjectionServiceResourceTypeDef,
    S3BucketSourceTypeDef,
    KinesisStreamingDestinationInputRequestTypeDef,
    PaginatorConfigTypeDef,
    ListBackupsInputRequestTypeDef,
    ListContributorInsightsInputRequestTypeDef,
    ListExportsInputRequestTypeDef,
    ListGlobalTablesInputRequestTypeDef,
    ListImportsInputRequestTypeDef,
    ListTablesInputRequestTypeDef,
    ListTagsOfResourceInputRequestTypeDef,
    TagTableTypeDef,
    PointInTimeRecoverySpecificationTypeDef,
    PutRequestServiceResourceTypeDef,
    TableClassSummaryTableTypeDef,
    TableClassSummaryTypeDef,
    RestoreSummaryTableTypeDef,
    RestoreSummaryTypeDef,
    SSEDescriptionTableTypeDef,
    SSEDescriptionTypeDef,
    SSESpecificationTableTypeDef,
    StreamSpecificationTableTypeDef,
    TableBatchWriterRequestTypeDef,
    TimeToLiveSpecificationTypeDef,
    UntagResourceInputRequestTypeDef,
    UpdateContributorInsightsInputRequestTypeDef,
    ArchivalSummaryResponseMetadataTypeDef,
    BillingModeSummaryResponseMetadataTypeDef,
    DescribeLimitsOutputTypeDef,
    EmptyResponseMetadataTypeDef,
    KinesisStreamingDestinationOutputTypeDef,
    ListTablesOutputTableTypeDef,
    ListTablesOutputTypeDef,
    ProvisionedThroughputDescriptionResponseMetadataTypeDef,
    RestoreSummaryResponseMetadataTypeDef,
    SSEDescriptionResponseMetadataTypeDef,
    StreamSpecificationResponseMetadataTypeDef,
    TableClassSummaryResponseMetadataTypeDef,
    UpdateContributorInsightsOutputTypeDef,
    AttributeValueUpdateTypeDef,
    BatchStatementRequestTypeDef,
    ConditionCheckTypeDef,
    ConditionTypeDef,
    DeleteRequestTypeDef,
    DeleteTypeDef,
    ExecuteStatementInputRequestTypeDef,
    ExpectedAttributeValueTypeDef,
    GetItemInputRequestTypeDef,
    GetTypeDef,
    ItemCollectionMetricsTypeDef,
    ItemResponseTypeDef,
    KeysAndAttributesTypeDef,
    ParameterizedStatementTypeDef,
    PutRequestTypeDef,
    PutTypeDef,
    UpdateTypeDef,
    AutoScalingPolicyDescriptionTypeDef,
    AutoScalingPolicyUpdateTypeDef,
    CreateBackupOutputTypeDef,
    ListBackupsOutputTableTypeDef,
    ListBackupsOutputTypeDef,
    BatchGetItemInputServiceResourceBatchGetItemTypeDef,
    BatchStatementResponseTypeDef,
    ConsumedCapacityServiceResourceTypeDef,
    ConsumedCapacityTableTypeDef,
    ConsumedCapacityTypeDef,
    QueryInputTableQueryTypeDef,
    ScanInputTableScanTypeDef,
    ContinuousBackupsDescriptionTypeDef,
    ListContributorInsightsOutputTypeDef,
    LocalSecondaryIndexDescriptionTableTypeDef,
    CreateGlobalSecondaryIndexActionTableTypeDef,
    UpdateGlobalSecondaryIndexActionTableTypeDef,
    LocalSecondaryIndexDescriptionTypeDef,
    LocalSecondaryIndexInfoTypeDef,
    LocalSecondaryIndexTypeDef,
    CreateGlobalSecondaryIndexActionTypeDef,
    GlobalSecondaryIndexInfoTypeDef,
    GlobalSecondaryIndexTypeDef,
    SourceTableDetailsTypeDef,
    UpdateGlobalSecondaryIndexActionTypeDef,
    CreateGlobalTableInputRequestTypeDef,
    GlobalTableTypeDef,
    ReplicaGlobalSecondaryIndexDescriptionTableTypeDef,
    ReplicaGlobalSecondaryIndexTableTypeDef,
    ReplicaGlobalSecondaryIndexDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexTypeDef,
    ListTagsOfResourceOutputTypeDef,
    TagResourceInputRequestTypeDef,
    InputFormatOptionsTypeDef,
    DeleteItemInputTableDeleteItemTypeDef,
    PutItemInputTablePutItemTypeDef,
    UpdateItemInputTableUpdateItemTypeDef,
    ReplicaUpdateTypeDef,
    DescribeContributorInsightsOutputTypeDef,
    DescribeEndpointsResponseTypeDef,
    DescribeExportOutputTypeDef,
    ExportTableToPointInTimeOutputTypeDef,
    DescribeKinesisStreamingDestinationOutputTypeDef,
    DescribeTableInputTableExistsWaitTypeDef,
    DescribeTableInputTableNotExistsWaitTypeDef,
    DescribeTimeToLiveOutputTypeDef,
    ListExportsOutputTypeDef,
    GlobalSecondaryIndexDescriptionTableTypeDef,
    GlobalSecondaryIndexDescriptionTypeDef,
    GlobalSecondaryIndexServiceResourceTypeDef,
    LocalSecondaryIndexServiceResourceTypeDef,
    ImportSummaryTypeDef,
    ListBackupsInputListBackupsPaginateTypeDef,
    ListTablesInputListTablesPaginateTypeDef,
    ListTagsOfResourceInputListTagsOfResourcePaginateTypeDef,
    QueryInputQueryPaginateTypeDef,
    ScanInputScanPaginateTypeDef,
    ListTagsOfResourceOutputTableTypeDef,
    UpdateContinuousBackupsInputRequestTypeDef,
    WriteRequestServiceResourceTypeDef,
    UpdateTimeToLiveInputRequestTypeDef,
    UpdateTimeToLiveOutputTypeDef,
    BatchExecuteStatementInputRequestTypeDef,
    QueryInputRequestTypeDef,
    ScanInputRequestTypeDef,
    DeleteItemInputRequestTypeDef,
    PutItemInputRequestTypeDef,
    UpdateItemInputRequestTypeDef,
    TransactGetItemTypeDef,
    BatchGetItemInputRequestTypeDef,
    ExecuteTransactionInputRequestTypeDef,
    WriteRequestTypeDef,
    TransactWriteItemTypeDef,
    AutoScalingSettingsDescriptionTypeDef,
    AutoScalingSettingsUpdateTypeDef,
    BatchGetItemOutputServiceResourceTypeDef,
    DeleteItemOutputTableTypeDef,
    GetItemOutputTableTypeDef,
    PutItemOutputTableTypeDef,
    QueryOutputTableTypeDef,
    ScanOutputTableTypeDef,
    UpdateItemOutputTableTypeDef,
    BatchExecuteStatementOutputTypeDef,
    BatchGetItemOutputTypeDef,
    DeleteItemOutputTypeDef,
    ExecuteStatementOutputTypeDef,
    ExecuteTransactionOutputTypeDef,
    GetItemOutputTypeDef,
    PutItemOutputTypeDef,
    QueryOutputTypeDef,
    ScanOutputTypeDef,
    TransactGetItemsOutputTypeDef,
    TransactWriteItemsOutputTypeDef,
    UpdateItemOutputTypeDef,
    DescribeContinuousBackupsOutputTypeDef,
    UpdateContinuousBackupsOutputTypeDef,
    GlobalSecondaryIndexUpdateTableTypeDef,
    SourceTableFeatureDetailsTypeDef,
    CreateTableInputRequestTypeDef,
    RestoreTableFromBackupInputRequestTypeDef,
    RestoreTableToPointInTimeInputRequestTypeDef,
    TableCreationParametersTypeDef,
    GlobalSecondaryIndexUpdateTypeDef,
    ListGlobalTablesOutputTypeDef,
    ReplicaDescriptionTableTypeDef,
    CreateReplicationGroupMemberActionTableTypeDef,
    UpdateReplicationGroupMemberActionTableTypeDef,
    ReplicaDescriptionTypeDef,
    CreateReplicationGroupMemberActionTypeDef,
    UpdateReplicationGroupMemberActionTypeDef,
    UpdateGlobalTableInputRequestTypeDef,
    CreateTableInputServiceResourceCreateTableTypeDef,
    ListImportsOutputTypeDef,
    BatchWriteItemInputServiceResourceBatchWriteItemTypeDef,
    BatchWriteItemOutputServiceResourceTypeDef,
    TransactGetItemsInputRequestTypeDef,
    BatchWriteItemInputRequestTypeDef,
    BatchWriteItemOutputTypeDef,
    TransactWriteItemsInputRequestTypeDef,
    ReplicaGlobalSecondaryIndexAutoScalingDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexSettingsDescriptionTypeDef,
    GlobalSecondaryIndexAutoScalingUpdateTypeDef,
    GlobalTableGlobalSecondaryIndexSettingsUpdateTypeDef,
    ReplicaGlobalSecondaryIndexAutoScalingUpdateTypeDef,
    ReplicaGlobalSecondaryIndexSettingsUpdateTypeDef,
    BackupDescriptionTypeDef,
    ImportTableDescriptionTypeDef,
    ImportTableInputRequestTypeDef,
    TableDescriptionTableTypeDef,
    ReplicationGroupUpdateTableTypeDef,
    GlobalTableDescriptionTypeDef,
    TableDescriptionTypeDef,
    ReplicationGroupUpdateTypeDef,
    ReplicaAutoScalingDescriptionTypeDef,
    ReplicaSettingsDescriptionTypeDef,
    ReplicaAutoScalingUpdateTypeDef,
    ReplicaSettingsUpdateTypeDef,
    DeleteBackupOutputTypeDef,
    DescribeBackupOutputTypeDef,
    DescribeImportOutputTypeDef,
    ImportTableOutputTypeDef,
    DeleteTableOutputTableTypeDef,
    UpdateTableInputTableUpdateTypeDef,
    CreateGlobalTableOutputTypeDef,
    DescribeGlobalTableOutputTypeDef,
    UpdateGlobalTableOutputTypeDef,
    CreateTableOutputTypeDef,
    DeleteTableOutputTypeDef,
    DescribeTableOutputTypeDef,
    RestoreTableFromBackupOutputTypeDef,
    RestoreTableToPointInTimeOutputTypeDef,
    UpdateTableOutputTypeDef,
    UpdateTableInputRequestTypeDef,
    TableAutoScalingDescriptionTypeDef,
    DescribeGlobalTableSettingsOutputTypeDef,
    UpdateGlobalTableSettingsOutputTypeDef,
    UpdateTableReplicaAutoScalingInputRequestTypeDef,
    UpdateGlobalTableSettingsInputRequestTypeDef,
    DescribeTableReplicaAutoScalingOutputTypeDef,
    UpdateTableReplicaAutoScalingOutputTypeDef,
)


def get_structure() -> ResponseMetadataTypeDef:
    return {...}
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from `botocore` schemas.
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore`, `aiobotocore` and `aioboto3`
  libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.resource` calls
- Auto discovery of types for `session.client` and `session.resource` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-dynamodb` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
