# Generated by Django 3.1 on 2020-08-27 12:17

from django.conf import settings
import django.contrib.gis.db.models.fields
from django.db import migrations, models
import django.db.models.deletion
import localcosmos_server.datasets.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('localcosmos_server', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Dataset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('taxon_latname', models.CharField(max_length=255, null=True)),
                ('taxon_author', models.CharField(max_length=255, null=True)),
                ('taxon_source', models.CharField(max_length=255, null=True)),
                ('taxon_include_descendants', models.BooleanField(default=False)),
                ('taxon_nuid', models.CharField(max_length=255, null=True)),
                ('name_uuid', models.UUIDField(null=True)),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('data', models.JSONField()),
                ('coordinates', django.contrib.gis.db.models.fields.PointField(null=True, srid=3857)),
                ('geographic_reference', django.contrib.gis.db.models.fields.GeometryField(blank=True, null=True, srid=3857)),
                ('app_uuid', models.UUIDField()),
                ('timestamp', models.DateTimeField(null=True)),
                ('client_id', models.CharField(editable=False, max_length=255)),
                ('validation_step', models.CharField(max_length=255, null=True)),
                ('validation_errors', models.JSONField(null=True)),
                ('is_valid', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(editable=False)),
                ('last_modified', models.DateTimeField(null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, to_field='uuid')),
            ],
            options={
                'ordering': ['-pk'],
            },
        ),
        migrations.CreateModel(
            name='DatasetImages',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field_uuid', models.UUIDField()),
                ('image', models.ImageField(max_length=255, upload_to=localcosmos_server.datasets.models.dataset_image_path)),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='datasets.dataset')),
            ],
        ),
        migrations.CreateModel(
            name='DatasetValidationRoutine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('taxon_latname', models.CharField(max_length=255, null=True)),
                ('taxon_author', models.CharField(max_length=255, null=True)),
                ('taxon_source', models.CharField(max_length=255, null=True)),
                ('taxon_include_descendants', models.BooleanField(default=False)),
                ('taxon_nuid', models.CharField(max_length=255, null=True)),
                ('name_uuid', models.UUIDField(null=True)),
                ('validation_class', models.CharField(choices=[('localcosmos_server.datasets.validation.ExpertReviewValidator', 'Expert review')], max_length=255)),
                ('position', models.IntegerField(default=0)),
                ('app', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='localcosmos_server.app')),
            ],
            options={
                'ordering': ['position'],
                'unique_together': {('app', 'validation_class')},
            },
        ),
    ]
