# Generated by Django 3.1.14 on 2022-12-14 15:57

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import localcosmos_server.models
import localcosmos_server.template_content.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('localcosmos_server', '0002_servercontentimage_serverimagestore'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='TemplateContent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('template_type', models.CharField(choices=[('page', 'Page')], max_length=20)),
                ('tag', models.CharField(editable=False, max_length=100)),
                ('draft_template_name', models.CharField(max_length=355)),
                ('published_template', models.FileField(null=True, upload_to=localcosmos_server.template_content.models.get_published_page_template_path)),
                ('published_template_definition', models.FileField(null=True, upload_to=localcosmos_server.template_content.models.get_published_page_template_definition_path)),
                ('app', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='localcosmos_server.app')),
            ],
        ),
        migrations.CreateModel(
            name='LocalizedTemplateContent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=15)),
                ('draft_title', models.CharField(max_length=255)),
                ('published_title', models.CharField(max_length=255, null=True)),
                ('draft_navigation_link_name', models.CharField(max_length=30)),
                ('published_navigation_link_name', models.CharField(max_length=30, null=True)),
                ('slug', models.SlugField(unique=True)),
                ('draft_contents', models.JSONField(null=True)),
                ('published_contents', models.JSONField(null=True)),
                ('translation_ready', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('draft_version', models.IntegerField(default=1)),
                ('published_version', models.IntegerField(null=True)),
                ('published_at', models.DateTimeField(null=True)),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='template_content_creator', to=settings.AUTH_USER_MODEL)),
                ('last_modified_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('template_content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='template_content.templatecontent')),
            ],
            options={
                'unique_together': {('template_content', 'language')},
            },
            bases=(localcosmos_server.models.ServerContentImageMixin, models.Model),
        ),
    ]
