# Generated by Django 4.1.5 on 2023-02-24 14:32

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('localcosmos_server', '0003_alter_localcosmosuser_follows'),
        ('template_content', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Navigation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('navigation_type', models.CharField(max_length=355)),
                ('options', models.JSONField(null=True)),
                ('app', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='localcosmos_server.app')),
            ],
            options={
                'unique_together': {('app', 'navigation_type')},
            },
        ),
        migrations.RemoveField(
            model_name='localizedtemplatecontent',
            name='draft_navigation_link_name',
        ),
        migrations.RemoveField(
            model_name='localizedtemplatecontent',
            name='published_navigation_link_name',
        ),
        migrations.AddField(
            model_name='templatecontent',
            name='assignment',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='templatecontent',
            name='template_type',
            field=models.CharField(choices=[('page', 'Page'), ('feature', 'Feature')], max_length=20),
        ),
        migrations.AlterUniqueTogether(
            name='templatecontent',
            unique_together={('app', 'assignment')},
        ),
        migrations.CreateModel(
            name='NavigationEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(default=1)),
                ('options', models.JSONField(null=True)),
                ('navigation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='template_content.navigation')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='template_content.navigationentry')),
                ('template_content', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='template_content.templatecontent')),
            ],
            options={
                'ordering': ['position', 'pk'],
            },
        ),
        migrations.RemoveField(
            model_name='templatecontent',
            name='tag',
        ),
        migrations.CreateModel(
            name='LocalizedNavigationEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=355, null=True)),
                ('language', models.CharField(max_length=15)),
                ('link_name', models.CharField(max_length=355)),
                ('navigation_entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='template_content.navigationentry')),
            ],
            options={
                'unique_together': {('navigation_entry', 'language')},
            },
        ),
        migrations.CreateModel(
            name='LocalizedNavigation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=15)),
                ('name', models.CharField(max_length=355)),
                ('draft_version', models.IntegerField(default=1)),
                ('published_version', models.IntegerField(null=True)),
                ('published_navigation', models.JSONField(null=True)),
                ('navigation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='template_content.navigation')),
            ],
            options={
                'unique_together': {('navigation', 'language')},
            },
        ),
    ]
