from setuptools import setup, find_packages
import os.path

version = '0.1.dev0'


def read_file(path):
    with open(path) as f:
        return f.read()


long_description = '\n\n'.join([
    read_file('README.txt'),
    read_file(os.path.join('src', 'tha', 'example', 'USAGE.txt')),
    read_file('TODO.txt'),
    read_file('CHANGES.txt'),
])

setup(name='tha.example',
      version=version,
      description="",
      long_description=long_description,
      # Get strings from http://www.python.org/pypi?%3Aaction=list_classifiers
      classifiers=[],
      keywords=[],
      author='The Health Agency',
      author_email='techniek@thehealthagency.com',
      url='http://www.thehealthagency.com',
      license='',
      package_dir={'': 'src'},
      packages=find_packages('src'),
      namespace_packages=['tha'],
      include_package_data=True,
      zip_safe=False,
      install_requires=['setuptools',
                        # Add extra requirements here
                        ],
      extras_require={
          'test': ['z3c.testsetup>=0.3'],
      },
      entry_points={
          'console_scripts': [
          ]},
      )
