"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineCheckParameterAction = void 0;
const core_1 = require("@aws-cdk/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const check_parameter_function_1 = require("./check-parameter-function");
/**
 * Represents a reference to a CodePipelineCheckParameterAction.
 */
class CodePipelineCheckParameterAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.INVOKE,
            provider: 'Lambda',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
    }
    bound(scope, _stage, options) {
        const { parameterName, regExp, logParameter = false, crossAccountRole, } = this.props;
        const checkParameterFunction = new check_parameter_function_1.CheckParameterFunction(scope, 'CheckParamterFunction', {
            parameterName,
            crossAccountRole,
        });
        // allow pipeline to list functions
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:ListFunctions'],
            resources: ['*'],
        }));
        // allow pipeline to invoke this lambda functionn
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:InvokeFunction'],
            resources: [checkParameterFunction.functionArn],
        }));
        // allow lambda to put job results for this pipeline
        // CodePipeline requires this to be granted to '*'
        // (the Pipeline ARN will not be enough)
        checkParameterFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: [
                'codepipeline:PutJobSuccessResult',
                'codepipeline:PutJobFailureResult',
            ],
        }));
        return {
            configuration: {
                FunctionName: checkParameterFunction.functionName,
                UserParameters: core_1.Stack.of(scope).toJsonString({
                    parameterName,
                    regExp: regExp ? regExp.source : undefined,
                    logParameter,
                    crossAccountRole,
                }),
            },
        };
    }
}
exports.CodePipelineCheckParameterAction = CodePipelineCheckParameterAction;
//# sourceMappingURL=data:application/json;base64,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