from typing import Literal, Mapping, Optional, Union

from ..eorzea_lang import EorzeaLang

weather: Mapping[int, Mapping[Union[EorzeaLang, Literal['de', 'en', 'fr', 'ja']], Optional[str]]] = {
    0: {'de': None, 'en': None, 'fr': None, 'ja': None},
    1: {'de': 'Klar', 'en': 'Clear Skies', 'fr': 'Dégagé', 'ja': '快晴'},
    2: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    3: {'de': 'Wolkig', 'en': 'Clouds', 'fr': 'Couvert', 'ja': '曇り'},
    4: {'de': 'Neblig', 'en': 'Fog', 'fr': 'Brouillard', 'ja': '霧'},
    5: {'de': 'Windig', 'en': 'Wind', 'fr': 'Vent', 'ja': '風'},
    6: {'de': 'Stürmisch', 'en': 'Gales', 'fr': 'Vents violents', 'ja': '暴風'},
    7: {'de': 'Regnerisch', 'en': 'Rain', 'fr': 'Pluie', 'ja': '雨'},
    8: {'de': 'Wolkenbruch',
        'en': 'Showers',
        'fr': 'Pluie torrentielle',
        'ja': '暴雨'},
    9: {'de': 'Gewittrig', 'en': 'Thunder', 'fr': 'Orages', 'ja': '雷'},
    10: {'de': 'Gewitter',
         'en': 'Thunderstorms',
         'fr': 'Orages violents',
         'ja': '雷雨'},
    11: {'de': 'Staubig',
         'en': 'Dust Storms',
         'fr': 'Tempêtes de poussière',
         'ja': '砂塵'},
    12: {'de': 'Sandsturm',
         'en': 'Sandstorms',
         'fr': 'Tempêtes de sable',
         'ja': '砂嵐'},
    13: {'de': 'Heiß', 'en': 'Hot Spells', 'fr': 'Chaud', 'ja': '熱波'},
    14: {'de': 'Gluthitze', 'en': 'Heat Waves', 'fr': 'Torride', 'ja': '灼熱波'},
    15: {'de': 'Schnee', 'en': 'Snow', 'fr': 'Neige', 'ja': '雪'},
    16: {'de': 'Schneesturm', 'en': 'Blizzards', 'fr': 'Blizzard', 'ja': '吹雪'},
    17: {'de': 'Unheimlich', 'en': 'Gloom', 'fr': 'Nébuleux', 'ja': '妖霧'},
    18: {'de': 'Aurora', 'en': 'Auroras', 'fr': 'Aurore', 'ja': 'オーロラ'},
    19: {'de': 'Dunkel', 'en': 'Darkness', 'fr': 'Ténèbres', 'ja': '闇'},
    20: {'de': 'Düsternis', 'en': 'Tension', 'fr': 'Désespérance', 'ja': '闘気'},
    21: {'de': 'Wolkig', 'en': 'Clouds', 'fr': 'Couvert', 'ja': '曇り'},
    22: {'de': 'Wetterleuchten',
         'en': 'Storm Clouds',
         'fr': 'Orageux',
         'ja': '雷雲'},
    23: {'de': 'Tosend', 'en': 'Rough Seas', 'fr': 'Houle', 'ja': '時化'},
    24: {'de': 'Tosend', 'en': 'Rough Seas', 'fr': 'Houle', 'ja': '時化'},
    25: {'de': 'Finster', 'en': 'Louring', 'fr': 'Nuageux', 'ja': '曇天'},
    26: {'de': 'Gluthitze', 'en': 'Heat Waves', 'fr': 'Torride', 'ja': '灼熱波'},
    27: {'de': 'Unheimlich', 'en': 'Gloom', 'fr': 'Nébuleux', 'ja': '妖霧'},
    28: {'de': 'Stürmisch', 'en': 'Gales', 'fr': 'Vents violents', 'ja': '暴風'},
    29: {'de': 'Rauchschwaden',
         'en': 'Eruptions',
         'fr': 'Éruptions',
         'ja': '噴煙'},
    30: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    31: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    32: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    33: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    34: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    35: {'de': 'Blendend',
         'en': 'Irradiance',
         'fr': 'Rayonnement',
         'ja': '極光'},
    36: {'de': 'Kernstrahlung',
         'en': 'Core Radiation',
         'fr': 'Radiations du Cœur',
         'ja': '龍核'},
    37: {'de': 'Kernstrahlung',
         'en': 'Core Radiation',
         'fr': 'Radiations du Cœur',
         'ja': '龍核'},
    38: {'de': 'Kernstrahlung',
         'en': 'Core Radiation',
         'fr': 'Radiations du Cœur',
         'ja': '龍核'},
    39: {'de': 'Kernstrahlung',
         'en': 'Core Radiation',
         'fr': 'Radiations du Cœur',
         'ja': '龍核'},
    40: {'de': 'Wolkenschleier',
         'en': 'Shelf Clouds',
         'fr': 'Amas nuageux',
         'ja': '群雲'},
    41: {'de': 'Wolkenschleier',
         'en': 'Shelf Clouds',
         'fr': 'Amas nuageux',
         'ja': '群雲'},
    42: {'de': 'Wolkenschleier',
         'en': 'Shelf Clouds',
         'fr': 'Amas nuageux',
         'ja': '群雲'},
    43: {'de': 'Wolkenschleier',
         'en': 'Shelf Clouds',
         'fr': 'Amas nuageux',
         'ja': '群雲'},
    44: {'de': 'Bedrückend',
         'en': 'Oppression',
         'fr': 'Oppression',
         'ja': '神意'},
    45: {'de': 'Bedrückend',
         'en': 'Oppression',
         'fr': 'Oppression',
         'ja': '神意'},
    46: {'de': 'Bedrückend',
         'en': 'Oppression',
         'fr': 'Oppression',
         'ja': '神意'},
    47: {'de': 'Bedrückend',
         'en': 'Oppression',
         'fr': 'Oppression',
         'ja': '神意'},
    48: {'de': 'Bedrückend',
         'en': 'Oppression',
         'fr': 'Oppression',
         'ja': '神意'},
    49: {'de': 'Schattenwind',
         'en': 'Umbral Wind',
         'fr': 'Vent ombral',
         'ja': '霊風'},
    50: {'de': 'Schattengewitter',
         'en': 'Umbral Static',
         'fr': 'Charges ombrales',
         'ja': '放電'},
    51: {'de': 'Qualm', 'en': 'Smoke', 'fr': 'Fumées', 'ja': '煙霧'},
    52: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    53: {'de': 'Königsgewitter',
         'en': 'Royal Levin',
         'fr': 'Éclairs royaux',
         'ja': '獣雷'},
    54: {'de': 'Hochspannung',
         'en': 'Hyperelectricity',
         'fr': 'Hyperélectricité',
         'ja': '雷波'},
    55: {'de': 'Königsgewitter',
         'en': 'Royal Levin',
         'fr': 'Éclairs royaux',
         'ja': '獣雷'},
    56: {'de': 'Numinos', 'en': 'Oppression', 'fr': 'Oppression', 'ja': '神意'},
    57: {'de': 'Gewittrig', 'en': 'Thunder', 'fr': 'Orages', 'ja': '雷'},
    58: {'de': 'Gewittrig', 'en': 'Thunder', 'fr': 'Orages', 'ja': '雷'},
    59: {'de': None, 'en': 'CutScene', 'fr': None, 'ja': None},
    60: {'de': 'Mystisch',
         'en': 'Multiplicity',
         'fr': 'Multiplicité',
         'ja': '神秘'},
    61: {'de': 'Mystisch',
         'en': 'Multiplicity',
         'fr': 'Multiplicité',
         'ja': '神秘'},
    62: {'de': 'Regnerisch', 'en': 'Rain', 'fr': 'Pluie', 'ja': '雨'},
    63: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    64: {'de': 'Regnerisch', 'en': 'Rain', 'fr': 'Pluie', 'ja': '雨'},
    65: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    66: {'de': 'Hass',
         'en': 'Dragonstorms',
         'fr': 'Tempête de haine',
         'ja': '邪天'},
    67: {'de': 'Hass',
         'en': 'Dragonstorms',
         'fr': 'Tempête de haine',
         'ja': '邪天'},
    68: {'de': 'Unterirdisch',
         'en': 'Subterrain',
         'fr': 'Souterrain',
         'ja': '晴れ'},
    69: {'de': 'Gerechtigkeit',
         'en': 'Concordance',
         'fr': 'Harmonie',
         'ja': '調和'},
    70: {'de': 'Gerechtigkeit',
         'en': 'Concordance',
         'fr': 'Harmonie',
         'ja': '調和'},
    71: {'de': 'Zeitfluss',
         'en': 'Beyond Time',
         'fr': 'Hors du temps',
         'ja': '時流'},
    72: {'de': 'Zeitfluss',
         'en': 'Beyond Time',
         'fr': 'Hors du temps',
         'ja': '時流'},
    73: {'de': 'Zeitfluss',
         'en': 'Beyond Time',
         'fr': 'Hors du temps',
         'ja': '時流'},
    74: {'de': 'Dämonisch unendlich',
         'en': 'Demonic Infinity',
         'fr': 'Infini démoniaque',
         'ja': '鬼気'},
    75: {'de': 'Dämonisch unendlich',
         'en': 'Demonic Infinity',
         'fr': 'Infini démoniaque',
         'ja': '鬼気'},
    76: {'de': 'Dämonisch unendlich',
         'en': 'Demonic Infinity',
         'fr': 'Infini démoniaque',
         'ja': '鬼気'},
    77: {'de': 'Dimensionsspaltend',
         'en': 'Dimensional Disruption',
         'fr': 'Perturbation dimensionnelle',
         'ja': '次元'},
    78: {'de': 'Dimensionsspaltend',
         'en': 'Dimensional Disruption',
         'fr': 'Perturbation dimensionnelle',
         'ja': '次元'},
    79: {'de': 'Dimensionsspaltend',
         'en': 'Dimensional Disruption',
         'fr': 'Perturbation dimensionnelle',
         'ja': '次元'},
    80: {'de': 'Feiersturm',
         'en': 'Revelstorms',
         'fr': 'Tempête festive',
         'ja': '嵐天'},
    81: {'de': 'Feiersturm',
         'en': 'Revelstorms',
         'fr': 'Tempête festive',
         'ja': '嵐天'},
    82: {'de': 'Ewigschön',
         'en': 'Eternal Bliss',
         'fr': 'Béatitude éternelle',
         'ja': '美天'},
    83: {'de': 'Ewigschön',
         'en': 'Eternal Bliss',
         'fr': 'Béatitude éternelle',
         'ja': '美天'},
    84: {'de': 'Drachensturm',
         'en': 'Wyrmstorms',
         'fr': 'Tempête draconique',
         'ja': '龍天'},
    85: {'de': 'Drachensturm',
         'en': 'Wyrmstorms',
         'fr': 'Tempête draconique',
         'ja': '龍天'},
    86: {'de': 'Feiersturm',
         'en': 'Revelstorms',
         'fr': 'Tempête festive',
         'ja': '嵐天'},
    87: {'de': 'Blitzsturm',
         'en': 'Quicklevin',
         'fr': 'Vif-orage',
         'ja': '迅雷'},
    88: {'de': 'Gewittrig', 'en': 'Thunder', 'fr': 'Orages', 'ja': '雷'},
    89: {'de': 'Dimensionsspaltend',
         'en': 'Dimensional Disruption',
         'fr': 'Perturbation dimensionnelle',
         'ja': '次元'},
    90: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    91: {'de': 'Klar', 'en': 'Clear Skies', 'fr': 'Dégagé', 'ja': '快晴'},
    92: {'de': 'Weißer Zyklon',
         'en': 'White Cyclones',
         'fr': 'Tempête blanche',
         'ja': '白嵐'},
    93: {'de': 'Weißer Zyklon',
         'en': 'White Cyclones',
         'fr': 'Tempête blanche',
         'ja': '白嵐'},
    94: {'de': 'Weißer Zyklon',
         'en': 'White Cyclones',
         'fr': 'Tempête blanche',
         'ja': '白嵐'},
    95: {'de': 'Ultimativ',
         'en': 'Ultimania',
         'fr': 'Fantasmagorique',
         'ja': '幻想'},
    96: {'de': 'Weißer Zyklon',
         'en': 'White Cyclones',
         'fr': 'Tempête blanche',
         'ja': '白嵐'},
    97: {'de': 'Dunkle Mondnacht',
         'en': 'Moonlight',
         'fr': 'Clair de lune',
         'ja': '月夜'},
    98: {'de': 'Dunkle Mondnacht',
         'en': 'Moonlight',
         'fr': 'Clair de lune',
         'ja': '月夜'},
    99: {'de': 'Dunkle Mondnacht',
         'en': 'Moonlight',
         'fr': 'Clair de lune',
         'ja': '月夜'},
    100: {'de': 'Dunkle Mondnacht',
          'en': 'Moonlight',
          'fr': 'Clair de lune',
          'ja': '月夜'},
    101: {'de': 'Roter Mond',
          'en': 'Red Moon',
          'fr': 'Lune rouge',
          'ja': '紅月下'},
    102: {'de': 'Rotlodernd', 'en': 'Scarlet', 'fr': 'Vermillon', 'ja': '朱炎'},
    103: {'de': 'Rotlodernd', 'en': 'Scarlet', 'fr': 'Vermillon', 'ja': '朱炎'},
    104: {'de': 'Rotlodernd', 'en': 'Scarlet', 'fr': 'Vermillon', 'ja': '朱炎'},
    105: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    106: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    107: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    108: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    109: {'de': 'Feuer', 'en': 'Flames', 'fr': 'Flammes', 'ja': '火炎'},
    110: {'de': 'Tsunami', 'en': 'Tsunamis', 'fr': 'Raz-de-marée', 'ja': '津波'},
    111: {'de': 'Tornado', 'en': 'Cyclones', 'fr': 'Tornade', 'ja': '竜巻'},
    112: {'de': 'Erdbeben', 'en': 'Geostorms', 'fr': 'Séisme', 'ja': '地震'},
    113: {'de': 'Blauschimmernd', 'en': 'True Blue', 'fr': 'Azur', 'ja': '青春'},
    114: {'de': 'Blauschimmernd', 'en': 'True Blue', 'fr': 'Azur', 'ja': '青春'},
    115: {'de': 'Blauschimmernd', 'en': 'True Blue', 'fr': 'Azur', 'ja': '青春'},
    116: {'de': 'Astrale Turbulenzen',
          'en': 'Umbral Turbulence',
          'fr': 'Turbulences ombrales',
          'ja': '乱霊流'},
    117: {'de': 'Blauschimmernd', 'en': 'True Blue', 'fr': 'Azur', 'ja': '青春'},
    118: {'de': 'Ewiges Licht',
          'en': 'Everlasting Light',
          'fr': 'Clarté éternelle',
          'ja': '無尽光'},
    119: {'de': 'Stürmisch',
          'en': 'Gales',
          'fr': 'Vents violents',
          'ja': '暴風'},
    120: {'de': 'Apokalyptisch',
          'en': 'Termination',
          'fr': 'Apocalypse',
          'ja': '終末'},
    121: {'de': 'Apokalyptisch',
          'en': 'Termination',
          'fr': 'Apocalypse',
          'ja': '終末'},
    122: {'de': 'Feenträume', 'en': 'Dreams', 'fr': 'Rêverie', 'ja': '妖夢'},
    123: {'de': 'Feenträume', 'en': 'Dreams', 'fr': 'Rêverie', 'ja': '妖夢'},
    124: {'de': 'Feenträume', 'en': 'Dreams', 'fr': 'Rêverie', 'ja': '妖夢'},
    125: {'de': 'Strahlende Glanzhaftigkeit',
          'en': 'Brilliance',
          'fr': 'Radiance divine',
          'ja': '光天'},
    126: {'de': 'Strahlende Glanzhaftigkeit',
          'en': 'Brilliance',
          'fr': 'Radiance divine',
          'ja': '光天'},
    127: {'de': 'Apokalyptisch',
          'en': 'Termination',
          'fr': 'Apocalypse',
          'ja': '終末'},
    128: {'de': 'Apokalyptisch',
          'en': 'Termination',
          'fr': 'Apocalypse',
          'ja': '終末'},
    129: {'de': 'Ewiges Licht',
          'en': 'Everlasting Light',
          'fr': 'Clarté éternelle',
          'ja': '無尽光'},
    130: {'de': 'Rauchschwaden',
          'en': 'Eruptions',
          'fr': 'Éruptions',
          'ja': '噴煙'},
    131: {'de': 'Apokalyptisch',
          'en': 'Termination',
          'fr': 'Apocalypse',
          'ja': '終末'},
    132: {'de': 'Heiter', 'en': 'Fair Skies', 'fr': 'Clair', 'ja': '晴れ'},
    133: {'de': 'Feuerseelenwinde',
          'en': 'Umbral Flare',
          'fr': 'Vent ombral de feu',
          'ja': '焔霊風'},
    134: {'de': 'Erdseelenwinde',
          'en': 'Umbral Duststorm',
          'fr': 'Vent ombral de terre',
          'ja': '土霊風'},
    135: {'de': 'Donnerseelenwinde',
          'en': 'Umbral Levin',
          'fr': 'Vent ombral de foudre',
          'ja': '雷霊風'},
    136: {'de': 'Sturmseelenwinde',
          'en': 'Umbral Tempest',
          'fr': 'Vent ombral des tempêtes',
          'ja': '嵐霊風'},
    137: {'de': 'Sternenregen',
          'en': 'Starshower',
          'fr': "Pluie d'étoiles",
          'ja': '流星雨'},
    138: {'de': 'Erinnerungsturbulenzen',
          'en': 'Delirium',
          'fr': 'Tempête de souvenirs',
          'ja': '記憶乱流'},
    139: {'de': 'Wolkig', 'en': 'Clouds', 'fr': 'Couvert', 'ja': '曇り'},
    140: {'de': 'Wolkig', 'en': 'Clouds', 'fr': 'Couvert', 'ja': '曇り'},
    141: {'de': 'Blendend',
          'en': 'Irradiance',
          'fr': 'Rayonnement',
          'ja': '極光'},
    142: {'de': 'Blendend',
          'en': 'Irradiance',
          'fr': 'Rayonnement',
          'ja': '極光'},
    143: {'de': 'Wetterleuchten',
          'en': 'Storm Clouds',
          'fr': 'Orageux',
          'ja': '雷雲'},
    144: {'de': 'Flammensturm',
          'en': 'Firestorm',
          'fr': 'Tempête de feu',
          'ja': '焔嵐\xa0'},
    145: {'de': 'Phantomströmung',
          'en': 'Spectral Current',
          'fr': 'Courant spectral',
          'ja': '幻海流\xa0'},
    146: {'de': None, 'en': None, 'fr': None, 'ja': None},
    147: {'de': 'Endzeitig', 'en': 'Climactic', 'fr': 'Fatidique', 'ja': '決戦'},
    148: {'de': 'Mondstaubig',
          'en': 'Moon Dust',
          'fr': 'Tempêtes de régolithe',
          'ja': '月砂塵'},
    149: {'de': 'Magnetsturm',
          'en': 'Astromagnetic Storm',
          'fr': 'Astromagnétique',
          'ja': '磁気嵐'},
    150: {'de': 'Apokalypse',
          'en': 'Apocalypse',
          'fr': 'Apocalypse',
          'ja': '終末'},
    151: {'de': 'Polarisierend',
          'en': 'Polarization',
          'fr': 'Polarisation',
          'ja': '星霊'},
    152: {'de': 'Polarisierend',
          'en': 'Polarization',
          'fr': 'Polarisation',
          'ja': '星霊'},
    153: {'de': 'Polarisierend',
          'en': 'Polarization',
          'fr': 'Polarisation',
          'ja': '星霊'},
    154: {'de': 'Polarisierend',
          'en': 'Polarization',
          'fr': 'Polarisation',
          'ja': '星霊'},
    155: {'de': 'Polarisierend',
          'en': 'Polarization',
          'fr': 'Polarisation',
          'ja': '星霊'},
    156: {'de': 'Imaginär', 'en': 'Projection', 'fr': 'Virtuel', 'ja': '仮想'},
    157: {'de': 'Pandæmonium',
          'en': 'Pandæmonium',
          'fr': 'Pandæmonium',
          'ja': '万魔殿'},
    158: {'de': 'Pandæmonium',
          'en': 'Pandæmonium',
          'fr': 'Pandæmonium',
          'ja': '万魔殿'},
    159: {'de': 'Pandæmonium',
          'en': 'Pandæmonium',
          'fr': 'Pandæmonium',
          'ja': '万魔殿'},
    160: {'de': 'Eschatologie',
          'en': 'Ultimatum',
          'fr': 'Eschatologique',
          'ja': '終極'},
    161: {'de': 'Verzweifelnd',
          'en': 'Inevitability',
          'fr': 'Désespoir',
          'ja': '絶望'},
    162: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    163: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    164: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    165: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    166: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    167: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    168: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    169: {'de': 'Götterwetter',
          'en': 'Transcendence',
          'fr': 'Mythologique',
          'ja': '神域'},
    170: {'de': 'Hass',
          'en': 'Dragonstorms',
          'fr': 'Tempête de haine',
          'ja': '邪天'},
    171: {'de': 'Leere', 'en': 'Vacuity', 'fr': 'Néant', 'ja': '虚無'},
    172: {'de': 'Leere', 'en': 'Vacuity', 'fr': 'Néant', 'ja': '虚無'},
    173: {'de': 'Leere', 'en': 'Vacuity', 'fr': 'Néant', 'ja': '虚無'}
}
