# Generated by Django 4.0.2 on 2022-02-14 18:09

import ckeditor_uploader.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('taggit', '0004_alter_taggeditem_content_type_alter_taggeditem_tag'),
    ]

    operations = [
        migrations.CreateModel(
            name='ArticleCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive')], default='active', max_length=10)),
                ('created_on', models.DateTimeField(auto_now_add=True)),
                ('updated_on', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(help_text='Category name length should be in 100 characters', max_length=100, unique=True, verbose_name='category name')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive')], default='active', max_length=10)),
                ('created_on', models.DateTimeField(auto_now_add=True)),
                ('updated_on', models.DateTimeField(auto_now=True)),
                ('body', models.TextField()),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Comment',
                'verbose_name_plural': 'Comments',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='ArticleSubcategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive')], default='active', max_length=10)),
                ('created_on', models.DateTimeField(auto_now_add=True)),
                ('updated_on', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(help_text='Subcategory name length should be in 100 characters', max_length=100, unique=True, verbose_name='subcategory name')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('category', models.ForeignKey(help_text='Only active categories will be displayed here', on_delete=django.db.models.deletion.RESTRICT, to='blog.articlecategory')),
            ],
            options={
                'verbose_name': 'Subcategory',
                'verbose_name_plural': 'Subcategories',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive')], default='active', max_length=10)),
                ('created_on', models.DateTimeField(auto_now_add=True)),
                ('updated_on', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(help_text='Blog title length should be within 200', max_length=200)),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('author_name', models.CharField(blank=True, help_text='Ex. John Doe', max_length=150, null=True, verbose_name='Custom author name')),
                ('introduction', models.TextField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('body', ckeditor_uploader.fields.RichTextUploadingField()),
                ('thumbnail', models.ImageField(blank=True, null=True, upload_to='articles/thumbnails/')),
                ('cover_image', models.ImageField(blank=True, null=True, upload_to='articles/cover-images/')),
                ('image_alt_tag', models.CharField(blank=True, max_length=50, null=True)),
                ('image_caption', models.CharField(blank=True, max_length=50, null=True)),
                ('keywords', models.CharField(help_text='Keywords must be separated by comma(,)', max_length=255)),
                ('seo_title', models.CharField(blank=True, max_length=200, null=True)),
                ('seo_introduction', models.TextField(blank=True, null=True)),
                ('seo_description', models.TextField(blank=True, null=True)),
                ('seo_keywords', models.CharField(blank=True, help_text='SEO-Keywords must be separated by comma(,)', max_length=255, null=True)),
                ('display_date', models.CharField(blank=True, help_text='Ex. 12th March, 2022', max_length=50, null=True, verbose_name='Custom publish date')),
                ('allow_comments', models.BooleanField(default=False)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='blog_posts', to=settings.AUTH_USER_MODEL)),
                ('comments', models.ManyToManyField(blank=True, null=True, related_name='comment', to='blog.Comment')),
                ('like', models.ManyToManyField(blank=True, null=True, related_name='like', to=settings.AUTH_USER_MODEL)),
                ('subcategory', models.ForeignKey(help_text='Only active subcategories will displayed here', on_delete=django.db.models.deletion.RESTRICT, to='blog.articlesubcategory')),
                ('tags', taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags')),
            ],
            options={
                'verbose_name': 'Article',
                'verbose_name_plural': 'Articles',
                'ordering': ['-created_on'],
            },
        ),
    ]
