import json
resp={
    "id": "chatcmpl-8NfIAJ7tgJP3NWGgoB0mqc90M8e0A",
    "object": "chat.completion",
    "created": 1700650962,
    "model": "gpt-4-0613",
    "choices": [
        {
            "index": 0,
            "message": {
                "role": "assistant",
                "content": "{\"api_response\": \"Below is the revised class `InstructionManager` with additional instructions integrated. In the `default_instructions` dictionary, I've added the mentioned instructions along with their examples.\", \"suggestions\": \"I recommend that in real case scenarios, the instructions with specific information would be dynamically generated based on the task at hand.\", \"generate_title\": \"Revised_InstructionManager_Class\"}\n\n```python\nfrom abstract_utilities import get_actual_number\nfrom abstract_utilities.type_utils import is_bool\n\nclass InstructionManager:\n    def __init__(self)->None:\n        self.default_instructions = {\n            \"api_response\": {\"instruction\": \"Place response to prompt here.\", \"example\": \"This is the reply to your request.\"},\n            \"additional_responses\": {\"instruction\": \"Marking 'True' initiates a loop which continues to send the current chunk's prompt until the module returns a 'False' value.\", \"example\": \"false\"},\n            \"generate_title\": {\"instruction\": \"Generate a title for this query. To maintain continuity, the generated title for a given sequence is shared with subsequent queries, use underscores for spaces.\", \"example\": \"Title_for_the_query.\"},\n            \"notation\": {\"instruction\": \"This value allows for communication between modules throughout the query iterations. These notations can be used to preserve relevant information or context for subsequent prompts.\", \"example\": \"Selecting additional responses due to insufficient completion tokens.\"},\n            \"suggestions\": {\"instruction\": \"This parameter allows the module to provide suggestions for improving efficiency in future prompt sequences.\", \"example\": \"Consider batching queries to reduce server load\"},\n            \"abort\": {\"instruction\": \"If you cannot fulfill the request, respond with this value as 'True'. Leave a detailed reason as to why the query stream was aborted in 'suggestions'\", \"example\": \"False\"},\n            \"prompt_as_previous\": {\"instruction\": \"This is a user-end declaration. If this is visible, the request portion of the prompt will change to include previous response data, if needed\", \"example\": \"True\"},\n            \"request_chunks\": {\"instruction\": \"Request to prompt again the previous chunk data. If selected, the query will iterate once more with the previous data chunk included in the prompt.\", \"example\": \"False\"},\n            \"token_adjustment\": {\"instruction\": \"Suggest percentage adjustments, between -100 up to 100, for the future token allotment. If it will provide better results to increase or decrease the future allotment, place a number.\", \"example\": \"0\"},\n\n            \"context_preservation\": {\"instruction\": \"Maintain and reference relevant context from previous iterations. Store context data securely and efficiently for accurate response generation.\", \"example\": \"Context from previous iteration stored: User preference for X identified.\"},\n            \"error_handling\": {\"instruction\": \"Identify and handle errors gracefully. Provide clear error messages and log errors for debugging purposes.\", \"example\": \"Error identified: Data format mismatch. Logged for review.\"},\n            \"response_validation\": {\"instruction\": \"Validate the response for accuracy, relevance, and completeness before finalizing. Implement checks for coherence and pertinence.\", \"example\": \"Response validated for accuracy and relevance.\"},\n            \"user_feedback\": {\"instruction\": \"Incorporate user feedback mechanism post-response or at the end of the sequence. Use feedback to refine future interactions.\", \"example\": \"User feedback requested on response clarity.\"},\n            \"adaptive_token_adjustment\": {\"instruction\": \"Automatically suggest token adjustments based on historical query lengths and complexities. Adjust token size dynamically.\", \"example\": \"Token size increased by 10% based on previous complex queries.\"},\n            \"documentation\": {\"instruction\": \"Provide a detailed example for this instruction as documented in the system's manual.\", \"example\": \"Refer to page 42 for 'context_preservation' usage examples.\"},\n            \"performance_metrics\": {\"instruction\": \"Track and report performance metrics such as response time, accuracy, or relevance for each iteration.\", \"example\": \"Response time: 2 seconds, Accuracy: 95%.\"},\n            \"dynamic_chunk_management\": {\"instruction\": \"Adjust chunk sizes dynamically based on the complexity and nature of incoming data.\", \"example\": \"Chunk size increased for complex image processing task.\"},\n            \"ui_interaction\": {\"instruction\": \"Provide a user-friendly interface for module interactions, displaying progress and allowing adjustments.\", \"example\": \"UI updated with query progress and adjustment options.\"},\n            \"security_privacy\": {\"instruction\": \"Ensure data security and user privacy. Implement features for secure data handling and confidentiality.\", \"example\": \"User data encrypted and access logs maintained for privacy compliance.\"},\n            \"scalability_resource_management\": {\"instruction\": \"Optimize system scalability and efficient resource management for handling larger datasets and increased queries.\", \"example\": \"System resources adjusted for 20% increased query load.\"},\n            \"multilingual_support\": {\"instruction\": \"Provide support for multiple languages in processing and responding to queries.\", \"example\": \"Spanish language processing enabled for current query.\"},\n            \"customization_flexibility\": {\"instruction\": \"Allow customization in response formats and system integration as per user needs.\", \"example\": \"Custom response format applied as per user settings.\"}\n        }\n    \n    # Remaining methods remain the same\n```\nIn this revised class, the `default_instructions` dictionary now includes additional instructions such as 'context preservation', 'error handling', 'response validation', 'user feedback', 'adaptive token adjustment', 'documentation', 'performance metrics', 'dynamic chunk management', 'UI interaction', 'security and privacy', 'scalability and resource management', 'multilingual support', and 'customization and flexibility', amongst others."
            },
            "finish_reason": "stop"
        }
    ],
    "usage": {
        "prompt_tokens": 1987,
        "completion_tokens": 1142,
        "total_tokens": 3129
    },
    "file_path": "C:\\Users\\jrput\\Documents\\python projects\\Modules\\test_modules\\test_abstract_test_ai\\response_data\\raw_response\\1700650962.json",
    "title": 1700650962
}
print(resp['choices'][0]['message']['content'])
