import { aws_iam as iam, aws_secretsmanager as secretsmanager } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * The properties of a new set of SMTP Credentials
 */
export interface SesSmtpCredentialsProps {
    /**
     * The name of the IAM user to create
     */
    readonly iamUserName: string;
}
export declare class SesSmtpCredentials extends Construct {
    /**
     * The IAM user to which the SMTP credentials are attached.
     */
    readonly iamUser: iam.User;
    /**
     * The AWS secrets manager secret that contains the SMTP credentials.
     */
    readonly secret: secretsmanager.ISecret;
    constructor(scope: Construct, id: string, props: SesSmtpCredentialsProps);
}
