"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CrossAccountZoneDelegationRecord = exports.ZoneDelegationRecord = exports.DsRecord = exports.NsRecord = exports.MxRecord = exports.CaaAmazonRecord = exports.CaaRecord = exports.CaaTag = exports.SrvRecord = exports.TxtRecord = exports.CnameRecord = exports.AaaaRecord = exports.ARecord = exports.AddressRecordTarget = exports.RecordSet = exports.RecordTarget = exports.RecordType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const route53_generated_1 = require("./route53.generated");
const util_1 = require("./util");
const CROSS_ACCOUNT_ZONE_DELEGATION_RESOURCE_TYPE = 'Custom::CrossAccountZoneDelegation';
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * The record type.
 */
var RecordType;
(function (RecordType) {
    /**
     * route traffic to a resource, such as a web server, using an IPv4 address in dotted decimal
     * notation
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AFormat
     */
    RecordType["A"] = "A";
    /**
     * route traffic to a resource, such as a web server, using an IPv6 address in colon-separated
     * hexadecimal format
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AAAAFormat
     */
    RecordType["AAAA"] = "AAAA";
    /**
     * A CAA record specifies which certificate authorities (CAs) are allowed to issue certificates
     * for a domain or subdomain
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CAAFormat
     */
    RecordType["CAA"] = "CAA";
    /**
     * A CNAME record maps DNS queries for the name of the current record, such as acme.example.com,
     * to another domain (example.com or example.net) or subdomain (acme.example.com or zenith.example.org).
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CNAMEFormat
     */
    RecordType["CNAME"] = "CNAME";
    /**
     * A delegation signer (DS) record refers a zone key for a delegated subdomain zone.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#DSFormat
     */
    RecordType["DS"] = "DS";
    /**
     * An MX record specifies the names of your mail servers and, if you have two or more mail servers,
     * the priority order.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#MXFormat
     */
    RecordType["MX"] = "MX";
    /**
     * A Name Authority Pointer (NAPTR) is a type of record that is used by Dynamic Delegation Discovery
     * System (DDDS) applications to convert one value to another or to replace one value with another.
     * For example, one common use is to convert phone numbers into SIP URIs.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NAPTRFormat
     */
    RecordType["NAPTR"] = "NAPTR";
    /**
     * An NS record identifies the name servers for the hosted zone
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NSFormat
     */
    RecordType["NS"] = "NS";
    /**
     * A PTR record maps an IP address to the corresponding domain name.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#PTRFormat
     */
    RecordType["PTR"] = "PTR";
    /**
     * A start of authority (SOA) record provides information about a domain and the corresponding Amazon
     * Route 53 hosted zone
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SOAFormat
     */
    RecordType["SOA"] = "SOA";
    /**
     * SPF records were formerly used to verify the identity of the sender of email messages.
     * Instead of an SPF record, we recommend that you create a TXT record that contains the applicable value.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SPFFormat
     */
    RecordType["SPF"] = "SPF";
    /**
     * An SRV record Value element consists of four space-separated values. The first three values are
     * decimal numbers representing priority, weight, and port. The fourth value is a domain name.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SRVFormat
     */
    RecordType["SRV"] = "SRV";
    /**
     * A TXT record contains one or more strings that are enclosed in double quotation marks (").
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#TXTFormat
     */
    RecordType["TXT"] = "TXT";
})(RecordType = exports.RecordType || (exports.RecordType = {}));
/**
 * Type union for a record that accepts multiple types of target.
 */
class RecordTarget {
    /**
     *
     * @param values correspond with the chosen record type (e.g. for 'A' Type, specify one or more IP addresses)
     * @param aliasTarget alias for targets such as CloudFront distribution to route traffic to
     */
    constructor(values, aliasTarget) {
        this.values = values;
        this.aliasTarget = aliasTarget;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_IAliasRecordTarget(aliasTarget);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RecordTarget);
            }
            throw error;
        }
    }
    /**
     * Use string values as target.
     */
    static fromValues(...values) {
        return new RecordTarget(values);
    }
    /**
     * Use an alias as target.
     */
    static fromAlias(aliasTarget) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_IAliasRecordTarget(aliasTarget);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAlias);
            }
            throw error;
        }
        return new RecordTarget(undefined, aliasTarget);
    }
    /**
     * Use ip addresses as target.
     */
    static fromIpAddresses(...ipAddresses) {
        return RecordTarget.fromValues(...ipAddresses);
    }
}
exports.RecordTarget = RecordTarget;
_a = JSII_RTTI_SYMBOL_1;
RecordTarget[_a] = { fqn: "@aws-cdk/aws-route53.RecordTarget", version: "1.170.0" };
/**
 * A record set.
 */
class RecordSet extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_RecordSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RecordSet);
            }
            throw error;
        }
        const ttl = props.target.aliasTarget ? undefined : ((props.ttl && props.ttl.toSeconds()) ?? 1800).toString();
        const recordSet = new route53_generated_1.CfnRecordSet(this, 'Resource', {
            hostedZoneId: props.zone.hostedZoneId,
            name: util_1.determineFullyQualifiedDomainName(props.recordName || props.zone.zoneName, props.zone),
            type: props.recordType,
            resourceRecords: props.target.values,
            aliasTarget: props.target.aliasTarget && props.target.aliasTarget.bind(this, props.zone),
            ttl,
            comment: props.comment,
        });
        this.domainName = recordSet.ref;
    }
}
exports.RecordSet = RecordSet;
_b = JSII_RTTI_SYMBOL_1;
RecordSet[_b] = { fqn: "@aws-cdk/aws-route53.RecordSet", version: "1.170.0" };
/**
 * Target for a DNS A Record
 *
 * @deprecated Use RecordTarget
 */
class AddressRecordTarget extends RecordTarget {
}
exports.AddressRecordTarget = AddressRecordTarget;
_c = JSII_RTTI_SYMBOL_1;
AddressRecordTarget[_c] = { fqn: "@aws-cdk/aws-route53.AddressRecordTarget", version: "1.170.0" };
/**
 * A DNS A record
 *
 * @resource AWS::Route53::RecordSet
 */
class ARecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.A,
            target: props.target,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_ARecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ARecord);
            }
            throw error;
        }
    }
}
exports.ARecord = ARecord;
_d = JSII_RTTI_SYMBOL_1;
ARecord[_d] = { fqn: "@aws-cdk/aws-route53.ARecord", version: "1.170.0" };
/**
 * A DNS AAAA record
 *
 * @resource AWS::Route53::RecordSet
 */
class AaaaRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.AAAA,
            target: props.target,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_AaaaRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AaaaRecord);
            }
            throw error;
        }
    }
}
exports.AaaaRecord = AaaaRecord;
_e = JSII_RTTI_SYMBOL_1;
AaaaRecord[_e] = { fqn: "@aws-cdk/aws-route53.AaaaRecord", version: "1.170.0" };
/**
 * A DNS CNAME record
 *
 * @resource AWS::Route53::RecordSet
 */
class CnameRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.CNAME,
            target: RecordTarget.fromValues(props.domainName),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CnameRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CnameRecord);
            }
            throw error;
        }
    }
}
exports.CnameRecord = CnameRecord;
_f = JSII_RTTI_SYMBOL_1;
CnameRecord[_f] = { fqn: "@aws-cdk/aws-route53.CnameRecord", version: "1.170.0" };
/**
 * A DNS TXT record
 *
 * @resource AWS::Route53::RecordSet
 */
class TxtRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.TXT,
            target: RecordTarget.fromValues(...props.values.map(v => formatTxt(v))),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_TxtRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TxtRecord);
            }
            throw error;
        }
    }
}
exports.TxtRecord = TxtRecord;
_g = JSII_RTTI_SYMBOL_1;
TxtRecord[_g] = { fqn: "@aws-cdk/aws-route53.TxtRecord", version: "1.170.0" };
/**
 * Formats a text value for use in a TXT record
 *
 * Use `JSON.stringify` to correctly escape and enclose in double quotes ("").
 *
 * DNS TXT records can contain up to 255 characters in a single string. TXT
 * record strings over 255 characters must be split into multiple text strings
 * within the same record.
 *
 * @see https://aws.amazon.com/premiumsupport/knowledge-center/route53-resolve-dkim-text-record-error/
 */
function formatTxt(string) {
    const result = [];
    let idx = 0;
    while (idx < string.length) {
        result.push(string.slice(idx, idx += 255)); // chunks of 255 characters long
    }
    return result.map(r => JSON.stringify(r)).join('');
}
/**
 * A DNS SRV record
 *
 * @resource AWS::Route53::RecordSet
 */
class SrvRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.SRV,
            target: RecordTarget.fromValues(...props.values.map(v => `${v.priority} ${v.weight} ${v.port} ${v.hostName}`)),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_SrvRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SrvRecord);
            }
            throw error;
        }
    }
}
exports.SrvRecord = SrvRecord;
_h = JSII_RTTI_SYMBOL_1;
SrvRecord[_h] = { fqn: "@aws-cdk/aws-route53.SrvRecord", version: "1.170.0" };
/**
 * The CAA tag.
 */
var CaaTag;
(function (CaaTag) {
    /**
     * Explicity authorizes a single certificate authority to issue a
     * certificate (any type) for the hostname.
     */
    CaaTag["ISSUE"] = "issue";
    /**
     * Explicity authorizes a single certificate authority to issue a
     * wildcard certificate (and only wildcard) for the hostname.
     */
    CaaTag["ISSUEWILD"] = "issuewild";
    /**
     * Specifies a URL to which a certificate authority may report policy
     * violations.
     */
    CaaTag["IODEF"] = "iodef";
})(CaaTag = exports.CaaTag || (exports.CaaTag = {}));
/**
 * A DNS CAA record
 *
 * @resource AWS::Route53::RecordSet
 */
class CaaRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.CAA,
            target: RecordTarget.fromValues(...props.values.map(v => `${v.flag} ${v.tag} "${v.value}"`)),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CaaRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CaaRecord);
            }
            throw error;
        }
    }
}
exports.CaaRecord = CaaRecord;
_j = JSII_RTTI_SYMBOL_1;
CaaRecord[_j] = { fqn: "@aws-cdk/aws-route53.CaaRecord", version: "1.170.0" };
/**
 * A DNS Amazon CAA record.
 *
 * A CAA record to restrict certificate authorities allowed
 * to issue certificates for a domain to Amazon only.
 *
 * @resource AWS::Route53::RecordSet
 */
class CaaAmazonRecord extends CaaRecord {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            values: [
                {
                    flag: 0,
                    tag: CaaTag.ISSUE,
                    value: 'amazon.com',
                },
            ],
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CaaAmazonRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CaaAmazonRecord);
            }
            throw error;
        }
    }
}
exports.CaaAmazonRecord = CaaAmazonRecord;
_k = JSII_RTTI_SYMBOL_1;
CaaAmazonRecord[_k] = { fqn: "@aws-cdk/aws-route53.CaaAmazonRecord", version: "1.170.0" };
/**
 * A DNS MX record
 *
 * @resource AWS::Route53::RecordSet
 */
class MxRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.MX,
            target: RecordTarget.fromValues(...props.values.map(v => `${v.priority} ${v.hostName}`)),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_MxRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, MxRecord);
            }
            throw error;
        }
    }
}
exports.MxRecord = MxRecord;
_l = JSII_RTTI_SYMBOL_1;
MxRecord[_l] = { fqn: "@aws-cdk/aws-route53.MxRecord", version: "1.170.0" };
/**
 * A DNS NS record
 *
 * @resource AWS::Route53::RecordSet
 */
class NsRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.NS,
            target: RecordTarget.fromValues(...props.values),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_NsRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NsRecord);
            }
            throw error;
        }
    }
}
exports.NsRecord = NsRecord;
_m = JSII_RTTI_SYMBOL_1;
NsRecord[_m] = { fqn: "@aws-cdk/aws-route53.NsRecord", version: "1.170.0" };
/**
 * A DNS DS record
 *
 * @resource AWS::Route53::RecordSet
 */
class DsRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.DS,
            target: RecordTarget.fromValues(...props.values),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_DsRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DsRecord);
            }
            throw error;
        }
    }
}
exports.DsRecord = DsRecord;
_o = JSII_RTTI_SYMBOL_1;
DsRecord[_o] = { fqn: "@aws-cdk/aws-route53.DsRecord", version: "1.170.0" };
/**
 * A record to delegate further lookups to a different set of name servers.
 */
class ZoneDelegationRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.NS,
            target: RecordTarget.fromValues(...core_1.Token.isUnresolved(props.nameServers)
                ? props.nameServers // Can't map a string-array token!
                : props.nameServers.map(ns => (core_1.Token.isUnresolved(ns) || ns.endsWith('.')) ? ns : `${ns}.`)),
            ttl: props.ttl || core_1.Duration.days(2),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_ZoneDelegationRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ZoneDelegationRecord);
            }
            throw error;
        }
    }
}
exports.ZoneDelegationRecord = ZoneDelegationRecord;
_p = JSII_RTTI_SYMBOL_1;
ZoneDelegationRecord[_p] = { fqn: "@aws-cdk/aws-route53.ZoneDelegationRecord", version: "1.170.0" };
/**
 * A Cross Account Zone Delegation record
 */
class CrossAccountZoneDelegationRecord extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CrossAccountZoneDelegationRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CrossAccountZoneDelegationRecord);
            }
            throw error;
        }
        if (!props.parentHostedZoneName && !props.parentHostedZoneId) {
            throw Error('At least one of parentHostedZoneName or parentHostedZoneId is required');
        }
        if (props.parentHostedZoneName && props.parentHostedZoneId) {
            throw Error('Only one of parentHostedZoneName and parentHostedZoneId is supported');
        }
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, CROSS_ACCOUNT_ZONE_DELEGATION_RESOURCE_TYPE, {
            codeDirectory: path.join(__dirname, 'cross-account-zone-delegation-handler'),
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
        });
        const role = iam.Role.fromRoleArn(this, 'cross-account-zone-delegation-handler-role', provider.roleArn);
        const addToPrinciplePolicyResult = role.addToPrincipalPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['sts:AssumeRole'],
            resources: [props.delegationRole.roleArn],
        }));
        const customResource = new core_1.CustomResource(this, 'CrossAccountZoneDelegationCustomResource', {
            resourceType: CROSS_ACCOUNT_ZONE_DELEGATION_RESOURCE_TYPE,
            serviceToken: provider.serviceToken,
            removalPolicy: props.removalPolicy,
            properties: {
                AssumeRoleArn: props.delegationRole.roleArn,
                ParentZoneName: props.parentHostedZoneName,
                ParentZoneId: props.parentHostedZoneId,
                DelegatedZoneName: props.delegatedZone.zoneName,
                DelegatedZoneNameServers: props.delegatedZone.hostedZoneNameServers,
                TTL: (props.ttl || core_1.Duration.days(2)).toSeconds(),
            },
        });
        if (addToPrinciplePolicyResult.policyDependable) {
            customResource.node.addDependency(addToPrinciplePolicyResult.policyDependable);
        }
    }
}
exports.CrossAccountZoneDelegationRecord = CrossAccountZoneDelegationRecord;
_q = JSII_RTTI_SYMBOL_1;
CrossAccountZoneDelegationRecord[_q] = { fqn: "@aws-cdk/aws-route53.CrossAccountZoneDelegationRecord", version: "1.170.0" };
//# sourceMappingURL=data:application/json;base64,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