# Extracted from the IANA Root Zone Database: https://www.iana.org/domains/root/db
# on 2024:09:20 12:05:03 UTC by https://github.com/pogzyb/asyncwhois/tools/tld-server-updates.py


class CountryCodeTLD:
    AC = "whois.nic.ac"
    AD = "whois.nic.ad"
    AE = "whois.aeda.net.ae"
    AF = "whois.nic.af"
    AG = "whois.nic.ag"
    AI = "whois.nic.ai"
    AL = None
    AM = "whois.amnic.net"
    AN = None
    AO = None
    AQ = None
    AR = "whois.nic.ar"
    AS = "whois.nic.as"
    AT = "whois.nic.at"
    AU = "whois.auda.org.au"
    AW = "whois.nic.aw"
    AX = "whois.ax"
    AZ = None
    BA = None
    BB = None
    BD = None
    BE = "whois.dns.be"
    BF = "whois.registre.bf"
    BG = "whois.register.bg"
    BH = "whois.nic.bh"
    BI = "whois1.nic.bi"
    BL = None
    BJ = "whois.nic.bj"
    BM = "whois.nic.bm"
    BN = "whois.bnnic.bn"
    BO = "whois.nic.bo"
    BQ = None
    BR = "whois.registro.br"
    BS = None
    BT = None
    BW = "whois.nic.net.bw"
    BY = "whois.cctld.by"
    BZ = None
    BV = None
    CA = "whois.cira.ca"
    CC = "ccwhois.verisign-grs.com"
    CD = None
    CF = "whois.dot.cf"
    CG = None
    CH = "whois.nic.ch"
    CI = "whois.nic.ci"
    CK = None
    CL = "whois.nic.cl"
    CM = None
    CN = "whois.cnnic.cn"
    CO = "whois.nic.co"
    CR = "whois.nic.cr"
    CU = None
    CV = "whois.nic.cv"
    CX = "whois.nic.cx"
    CW = None
    CY = None
    CZ = "whois.nic.cz"
    DE = "whois.denic.de"
    DJ = None
    DK = "whois.punktum.dk"
    DM = "whois.dmdomains.dm"
    DO = "whois.nic.do"
    DZ = "whois.nic.dz"
    EC = "whois.nic.ec"
    EE = "whois.tld.ee"
    EG = None
    EH = None
    ER = None
    ES = "whois.nic.es"
    ET = None
    EU = "whois.eu"
    FI = "whois.fi"
    FJ = "www.whois.fj"
    FK = None
    FM = "whois.nic.fm"
    FO = "whois.nic.fo"
    FR = "whois.nic.fr"
    GA = None
    GB = None
    GD = "whois.nic.gd"
    GE = "whois.nic.ge"
    GG = "whois.gg"
    GF = "whois.mediaserv.net"
    GH = "whois.nic.gh"
    GI = "whois.identitydigital.services"
    GL = "whois.nic.gl"
    GM = None
    GN = "whois.ande.gov.gn"
    GP = "whois.nic.gp"
    GQ = "whois.dominio.gq"
    GR = None
    GS = "whois.nic.gs"
    GT = None
    GU = None
    GW = None
    GY = "whois.registry.gy"
    HK = "whois.hkirc.hk"
    HM = "whois.registry.hm"
    HN = "whois.nic.hn"
    HR = "whois.dns.hr"
    HT = "whois.nic.ht"
    HU = "whois.nic.hu"
    ID = "whois.id"
    IE = "whois.weare.ie"
    IL = "whois.isoc.org.il"
    IM = "whois.nic.im"
    IN = "whois.registry.in"
    IO = "whois.nic.io"
    IR = "whois.nic.ir"
    IQ = "whois.cmc.iq"
    IS = "whois.isnic.is"
    IT = "whois.nic.it"
    JE = "whois.je"
    JM = None
    JO = None
    JP = "whois.jprs.jp"
    KE = "whois.kenic.or.ke"
    KG = "whois.kg"
    KH = None
    KI = "whois.nic.ki"
    KM = None
    KN = "whois.nic.kn"
    KP = None
    KR = "whois.kr"
    KW = None
    KY = "whois.kyregistry.ky"
    KZ = "whois.nic.kz"
    LA = "whois.nic.la"
    LB = "whois.lbdr.org.lb"
    LC = None
    LI = "whois.nic.li"
    LK = None
    LR = None
    LS = "whois.nic.ls"
    LT = "whois.domreg.lt"
    LU = "whois.dns.lu"
    LV = "whois.nic.lv"
    LY = "whois.nic.ly"
    MA = "whois.registre.ma"
    MC = None
    MD = "whois.nic.md"
    ME = "whois.nic.me"
    MF = None
    MG = "whois.nic.mg"
    MH = None
    MK = "whois.marnet.mk"
    ML = "whois.nic.ml"
    MM = "whois.registry.gov.mm"
    MN = "whois.nic.mn"
    MO = "whois.monic.mo"
    MQ = "whois.mediaserv.net"
    MR = "whois.nic.mr"
    MS = "whois.nic.ms"
    MP = None
    MT = None
    MU = "whois.nic.mu"
    MV = None
    MW = "whois.nic.mw"
    MY = "whois.mynic.my"
    MZ = "whois.nic.mz"
    NA = "whois.na-nic.com.na"
    MX = "whois.mx"
    NC = "whois.nc"
    NE = None
    NF = "whois.nic.nf"
    NG = "whois.nic.net.ng"
    NI = None
    NL = "whois.domain-registry.nl"
    NO = "whois.norid.no"
    NP = None
    NR = None
    NU = "whois.iis.nu"
    NZ = "whois.irs.net.nz"
    OM = "whois.registry.om"
    PA = None
    PE = "kero.yachay.pe"
    PF = "whois.registry.pf"
    PG = None
    PH = None
    PK = "whois.pknic.net.pk"
    PL = "whois.dns.pl"
    PN = None
    PM = "whois.nic.pm"
    PR = "whois.afilias-srs.net"
    PT = "whois.dns.pt"
    PS = None
    PW = "whois.nic.pw"
    PY = None
    QA = "whois.registry.qa"
    RE = "whois.nic.re"
    RO = "whois.rotld.ro"
    RS = "whois.rnids.rs"
    RU = "whois.tcinet.ru"
    RW = "whois.ricta.org.rw"
    SA = "whois.nic.net.sa"
    SB = "whois.nic.net.sb"
    SC = "whois.nic.sc"
    SD = "whois.nic.sd"
    SE = "whois.iis.se"
    SH = "whois.nic.sh"
    SG = "whois.sgnic.sg"
    SI = "whois.register.si"
    SJ = None
    SK = "whois.sk-nic.sk"
    SL = None
    SN = "whois.nic.sn"
    SM = "whois.nic.sm"
    SO = "whois.nic.so"
    SR = None
    SS = "whois.nic.ss"
    ST = "whois.nic.st"
    SU = "whois.tcinet.ru"
    SV = None
    SX = "whois.sx"
    SY = "whois.tld.sy"
    SZ = None
    TC = "whois.nic.tc"
    TD = "whois.nic.td"
    TF = "whois.nic.tf"
    TG = "whois.nic.tg"
    TH = "whois.thnic.co.th"
    TJ = None
    TK = "whois.dot.tk"
    TL = "whois.nic.tl"
    TM = "whois.nic.tm"
    TN = "whois.ati.tn"
    TO = "whois.tonic.to"
    TR = "whois.trabis.gov.tr"
    TP = None
    TT = None
    TV = "whois.nic.tv"
    TW = "whois.twnic.net.tw"
    TZ = "whois.tznic.or.tz"
    UA = "whois.ua"
    UG = "whois.co.ug"
    UK = "whois.nic.uk"
    UM = None
    UY = "whois.nic.org.uy"
    UZ = "whois.cctld.uz"
    US = "whois.nic.us"
    VA = None
    VE = "whois.nic.ve"
    VC = "whois.identitydigital.services"
    VG = "whois.nic.vg"
    VI = "virgil.nic.vi"
    VN = None
    VU = "whois.dnrs.vu"
    WF = "whois.nic.wf"
    WS = "whois.website.ws"
    XN__2SCRJ9C = "whois.registry.in"
    XN__3E0B707E = "whois.kr"
    XN__3HCRJ9C = "whois.registry.in"
    XN__45BR5CYL = "whois.registry.in"
    XN__45BRJ9C = "whois.registry.in"
    XN__4DBRK0CE = "whois.isoc.org.il"
    XN__54B7FTA0CC = None
    XN__80AO21A = "whois.nic.kz"
    XN__90A3AC = "whois.rnids.rs"
    XN__90AE = "whois.imena.bg"
    XN__90AIS = "whois.cctld.by"
    XN__CLCHC0EA0B2G2A9GCD = "whois.ta.sgnic.sg"
    XN__D1ALF = "whois.marnet.mk"
    XN__E1A4C = "whois.eu"
    XN__FIQS8S = "cwhois.cnnic.cn"
    XN__FIQZ9S = "cwhois.cnnic.cn"
    XN__FPCRJ9C3D = "whois.registry.in"
    XN__FZC2C9E2C = None
    XN__GECRJ9C = "whois.registry.in"
    XN__H2BRJ9C = "whois.registry.in"
    XN__H2BRJ9C8C = "whois.registry.in"
    XN__H2BREG3EVE = "whois.registry.in"
    XN__J1AMH = "whois.dotukr.com"
    XN__J6W193G = "whois.hkirc.hk"
    XN__KPRY57D = "whois.twnic.net.tw"
    XN__KPRW13D = "whois.twnic.net.tw"
    XN__L1ACC = None
    XN__LGBBAT1AD8J = "whois.nic.dz"
    XN__MGB9AWBF = "whois.registry.om"
    XN__MGBA3A4F16A = "whois.nic.ir"
    XN__MGBAH1A3HJKRD = "whois.nic.mr"
    XN__MGBAAM7A8H = "whois.aeda.net.ae"
    XN__MGBAI9AZGQP6J = None
    XN__MGBAYH7GPA = None
    XN__MGBBH1A71E = "whois.registry.in"
    XN__MGBBH1A = "whois.registry.in"
    XN__MGBC0A9AZCG = None
    XN__MGBCPQ6GPA1A = None
    XN__MGBERP4A5D4AR = "whois.nic.net.sa"
    XN__MGBGU82A = "whois.registry.in"
    XN__MGBPL2FH = None
    XN__MGBTX2B = "whois.cmc.iq"
    XN__MGBX4CD0AB = "whois.mynic.my"
    XN__MIX891F = "whois.monic.mo"
    XN__NODE = None
    XN__O3CW4H = "whois.thnic.co.th"
    XN__OGBPF8FL = "whois.tld.sy"
    XN__P1AI = "whois.tcinet.ru"
    XN__PGBS0DH = "whois.ati.tn"
    XN__Q7CE6A = "whois.nic.la"
    XN__QXAM = None
    XN__QXA6A = "whois.eu"
    XN__RVC1E0AM3E = "whois.registry.in"
    XN__S9BRJ9C = "whois.registry.in"
    XN__WGBH1C = None
    XN__WGBL6A = "whois.registry.qa"
    XN__XKC2AL3HYE2A = None
    XN__XKC2DL3A5EE0H = "whois.registry.in"
    XN__YFRO4I67O = "whois.zh.sgnic.sg"
    XN__Y9A3AQ = "whois.amnic.net"
    XN__YGBI2AMMX = "whois.pnina.ps"
    YE = "whois.y.net.ye"
    YT = "whois.nic.yt"
    ZA = None
    ZM = "whois.zicta.zm"
    ZW = None


class GenericTLD:
    AARP = "whois.nic.aarp"
    AAA = None
    ABB = "whois.nic.abb"
    ABBOTT = "whois.nic.abbott"
    ABARTH = None
    ABC = "whois.nic.abc"
    ABBVIE = "whois.nic.abbvie"
    ABLE = None
    ABOGADO = "whois.nic.abogado"
    ABUDHABI = "whois.nic.abudhabi"
    ACADEMY = "whois.nic.academy"
    ACCOUNTANT = "whois.nic.accountant"
    ACCENTURE = "whois.nic.accenture"
    ACCOUNTANTS = "whois.nic.accountants"
    ACO = "whois.nic.aco"
    ACTIVE = None
    ACTOR = "whois.nic.actor"
    ADS = "whois.nic.google"
    ADAC = None
    ADULT = "whois.nic.adult"
    AEG = "whois.nic.aeg"
    AETNA = None
    AFAMILYCOMPANY = None
    AFRICA = "whois.nic.africa"
    AFL = "whois.nic.afl"
    AGAKHAN = "whois.nic.agakhan"
    AGENCY = "whois.nic.agency"
    AIG = None
    AIGO = None
    AIRBUS = "whois.nic.airbus"
    AIRTEL = "whois.nic.airtel"
    AIRFORCE = "whois.nic.airforce"
    AKDN = "whois.nic.akdn"
    ALIBABA = "whois.nic.alibaba"
    ALIPAY = "whois.nic.alipay"
    ALLFINANZ = "whois.nic.allfinanz"
    ALLSTATE = "whois.nic.allstate"
    ALLY = "whois.nic.ally"
    ALFAROMEO = None
    ALSACE = "whois.nic.alsace"
    ALSTOM = "whois.nic.alstom"
    AMAZON = "whois.nic.amazon"
    AMERICANEXPRESS = None
    AMERICANFAMILY = "whois.nic.americanfamily"
    AMEX = None
    AMFAM = "whois.nic.amfam"
    AMICA = None
    AMSTERDAM = "whois.nic.amsterdam"
    ANALYTICS = None
    ANDROID = "whois.nic.google"
    ANZ = "whois.nic.anz"
    ANQUAN = "whois.teleinfo.cn"
    APARTMENTS = "whois.nic.apartments"
    APP = "whois.nic.google"
    AOL = "whois.nic.aol"
    AQUARELLE = "whois.nic.aquarelle"
    APPLE = "whois.nic.apple"
    ARAB = "whois.nic.arab"
    ARAMCO = None
    ARMY = "whois.nic.army"
    ARCHI = "whois.nic.archi"
    ART = "whois.nic.art"
    ARTE = "whois.nic.arte"
    ASDA = "whois.nic.asda"
    ASSOCIATES = "whois.nic.associates"
    ATTORNEY = "whois.nic.attorney"
    ATHLETA = None
    AUCTION = "whois.nic.auction"
    AUDIBLE = "whois.nic.audible"
    AUDIO = "whois.nic.audio"
    AUDI = "whois.nic.audi"
    AUSPOST = "whois.nic.auspost"
    AUTO = "whois.nic.auto"
    AUTOS = "whois.nic.autos"
    AUTHOR = "whois.nic.author"
    AVIANCA = None
    AWS = "whois.nic.aws"
    AXA = None
    AZURE = "whois.nic.azure"
    BABY = "whois.nic.baby"
    BAIDU = "whois.gtld.knet.cn"
    BANAMEX = None
    BAND = "whois.nic.band"
    BANK = "whois.nic.bank"
    BANANAREPUBLIC = None
    BAR = "whois.nic.bar"
    BARCLAYCARD = "whois.nic.barclaycard"
    BARCLAYS = "whois.nic.barclays"
    BARCELONA = "whois.nic.barcelona"
    BARGAINS = "whois.nic.bargains"
    BAREFOOT = "whois.nic.barefoot"
    BASEBALL = "whois.nic.baseball"
    BAUHAUS = "whois.nic.bauhaus"
    BASKETBALL = "whois.nic.basketball"
    BAYERN = "whois.nic.bayern"
    BBC = "whois.nic.bbc"
    BBT = "whois.nic.bbt"
    BBVA = "whois.nic.bbva"
    BCG = "whois.nic.bcg"
    BCN = "whois.nic.bcn"
    BEATS = "whois.nic.beats"
    BEAUTY = "whois.nic.beauty"
    BEER = "whois.nic.beer"
    BENTLEY = "whois.nic.bentley"
    BERLIN = "whois.nic.berlin"
    BESTBUY = "whois.nic.bestbuy"
    BEST = "whois.nic.best"
    BET = "whois.nic.bet"
    BHARTI = None
    BIBLE = "whois.nic.bible"
    BID = "whois.nic.bid"
    BIKE = "whois.nic.bike"
    BING = "whois.nic.bing"
    BINGO = "whois.nic.bingo"
    BIO = "whois.nic.bio"
    BLACKFRIDAY = "whois.nic.blackfriday"
    BLANCO = None
    BLACK = "whois.nic.black"
    BLOG = "whois.nic.blog"
    BLOCKBUSTER = "whois.nic.blockbuster"
    BLUE = "whois.nic.blue"
    BLOOMBERG = "whois.nic.bloomberg"
    BMW = "whois.nic.bmw"
    BNL = None
    BMS = "whois.nic.bms"
    BOATS = "whois.nic.boats"
    BOEHRINGER = "whois.nic.boehringer"
    BNPPARIBAS = "whois.nic.bnpparibas"
    BOFA = "whois.nic.bofa"
    BOM = "whois.gtlds.nic.br"
    BOND = "whois.nic.bond"
    BOO = "whois.nic.google"
    BOOK = "whois.nic.book"
    BOOKING = None
    BOOTS = None
    BOSCH = "whois.nic.bosch"
    BOSTIK = "whois.nic.bostik"
    BOT = "whois.nic.bot"
    BOSTON = "whois.nic.boston"
    BOUTIQUE = "whois.nic.boutique"
    BOX = "whois.nic.box"
    BRADESCO = "whois.nic.bradesco"
    BROADWAY = "whois.nic.broadway"
    BRIDGESTONE = "whois.nic.bridgestone"
    BROKER = "whois.nic.broker"
    BROTHER = "whois.nic.brother"
    BRUSSELS = "whois.nic.brussels"
    BUDAPEST = None
    BUGATTI = None
    BUILD = "whois.nic.build"
    BUILDERS = "whois.nic.builders"
    BUSINESS = "whois.nic.business"
    BUY = "whois.nic.buy"
    BUZZ = "whois.nic.buzz"
    BZH = "whois.nic.bzh"
    CAB = "whois.nic.cab"
    CAFE = "whois.nic.cafe"
    CAL = "whois.nic.google"
    CALL = "whois.nic.call"
    CALVINKLEIN = None
    CAM = "whois.nic.cam"
    CAMERA = "whois.nic.camera"
    CAMP = "whois.nic.camp"
    CANCERRESEARCH = None
    CAPETOWN = "whois.nic.capetown"
    CANON = "whois.nic.canon"
    CAPITALONE = "whois.nic.capitalone"
    CAR = "whois.nic.car"
    CAPITAL = "whois.nic.capital"
    CARDS = "whois.nic.cards"
    CARAVAN = None
    CARE = "whois.nic.care"
    CAREERS = "whois.nic.careers"
    CAREER = "whois.nic.career"
    CARTIER = None
    CARS = "whois.nic.cars"
    CASE = "whois.nic.case"
    CASA = "whois.nic.casa"
    CASEIH = None
    CASINO = "whois.nic.casino"
    CATERING = "whois.nic.catering"
    CASH = "whois.nic.cash"
    CBA = "whois.nic.cba"
    CBN = None
    CBRE = None
    CATHOLIC = "whois.nic.catholic"
    CBS = None
    CEB = None
    CENTER = "whois.nic.center"
    CERN = "whois.nic.cern"
    CFA = "whois.nic.cfa"
    CEO = "whois.nic.ceo"
    CFD = "whois.nic.cfd"
    CHANEL = "whois.nic.chanel"
    CHARITY = "whois.nic.charity"
    CHASE = None
    CHANNEL = "whois.nic.google"
    CHAT = "whois.nic.chat"
    CHEAP = "whois.nic.cheap"
    CHINTAI = "whois.nic.chintai"
    CHRISTMAS = "whois.nic.christmas"
    CHROME = "whois.nic.google"
    CHLOE = None
    CHURCH = "whois.nic.church"
    CIPRIANI = "whois.nic.cipriani"
    CHRYSLER = None
    CIRCLE = "whois.nic.circle"
    CISCO = None
    CITADEL = "whois.nic.citadel"
    CITI = None
    CITIC = None
    CITY = "whois.nic.city"
    CITYEATS = None
    CLAIMS = "whois.nic.claims"
    CLICK = "whois.nic.click"
    CLEANING = "whois.nic.cleaning"
    CLINIC = "whois.nic.clinic"
    CLINIQUE = "whois.nic.clinique"
    CLOUD = "whois.nic.cloud"
    CLOTHING = "whois.nic.clothing"
    CLUB = "whois.nic.club"
    CLUBMED = "whois.nic.clubmed"
    COACH = "whois.nic.coach"
    CODES = "whois.nic.codes"
    COLLEGE = "whois.nic.college"
    COLOGNE = "whois.ryce-rsp.com"
    COM = "whois.verisign-grs.com"
    COFFEE = "whois.nic.coffee"
    COMCAST = None
    COMMBANK = "whois.nic.commbank"
    COMMUNITY = "whois.nic.community"
    COMPANY = "whois.nic.company"
    COMPARE = "whois.nic.compare"
    COMPUTER = "whois.nic.computer"
    COMSEC = "whois.nic.comsec"
    CONDOS = "whois.nic.condos"
    CONSTRUCTION = "whois.nic.construction"
    CONTACT = "whois.nic.contact"
    CONSULTING = "whois.nic.consulting"
    CONTRACTORS = "whois.nic.contractors"
    COOKING = "whois.nic.cooking"
    COOL = "whois.nic.cool"
    COOKINGCHANNEL = None
    CORSICA = "whois.nic.corsica"
    COUNTRY = "whois.nic.country"
    COUPONS = "whois.nic.coupons"
    COUPON = None
    COURSES = "whois.nic.courses"
    CPA = "whois.nic.cpa"
    CREDIT = "whois.nic.credit"
    CREDITUNION = "whois.nic.creditunion"
    CRICKET = "whois.nic.cricket"
    CREDITCARD = "whois.nic.creditcard"
    CROWN = "whois.nic.crown"
    CRUISE = "whois.nic.cruise"
    CRS = "whois.nic.crs"
    CRUISES = "whois.nic.cruises"
    CSC = None
    CUISINELLA = "whois.nic.cuisinella"
    CYMRU = "whois.nic.cymru"
    CYOU = "whois.nic.cyou"
    DABUR = "whois.nic.dabur"
    DAD = "whois.nic.google"
    DANCE = "whois.nic.dance"
    DATA = "whois.nic.data"
    DATE = "whois.nic.date"
    DATING = "whois.nic.dating"
    DATSUN = "whois.nic.gmo"
    DAY = "whois.nic.google"
    DCLK = "whois.nic.google"
    DDS = "whois.nic.dds"
    DEALER = "whois.nic.dealer"
    DEAL = "whois.nic.deal"
    DEGREE = "whois.nic.degree"
    DEALS = "whois.nic.deals"
    DELL = None
    DELIVERY = "whois.nic.delivery"
    DELTA = "whois.nic.delta"
    DEMOCRAT = "whois.nic.democrat"
    DENTAL = "whois.nic.dental"
    DELOITTE = "whois.nic.deloitte"
    DESI = "whois.nic.desi"
    DENTIST = "whois.nic.dentist"
    DEV = "whois.nic.google"
    DESIGN = "whois.nic.design"
    DIAMONDS = "whois.nic.diamonds"
    DIET = "whois.nic.diet"
    DHL = None
    DIRECT = "whois.nic.direct"
    DIRECTORY = "whois.nic.directory"
    DIGITAL = "whois.nic.digital"
    DISCOVER = None
    DISH = "whois.nic.dish"
    DISCOUNT = "whois.nic.discount"
    DIY = "whois.nic.diy"
    DOCS = "whois.nic.google"
    DOCTOR = "whois.nic.doctor"
    DNP = "whois.nic.dnp"
    DOG = "whois.nic.dog"
    DODGE = None
    DOHA = None
    DOMAINS = "whois.nic.domains"
    DOT = "whois.nic.dot"
    DOWNLOAD = "whois.nic.download"
    DOOSAN = None
    DRIVE = "whois.nic.google"
    DUBAI = "whois.nic.dubai"
    DTV = "whois.nic.dtv"
    DUNLOP = "whois.nic.dunlop"
    DUCK = None
    DUNS = None
    DUPONT = None
    DURBAN = "whois.nic.durban"
    DVAG = "whois.nic.dvag"
    DVR = "whois.nic.dvr"
    EARTH = "whois.nic.earth"
    EAT = "whois.nic.google"
    ECO = "whois.nic.eco"
    EDUCATION = "whois.nic.education"
    EDEKA = "whois.nic.edeka"
    EMERCK = "whois.nic.emerck"
    EMAIL = "whois.nic.email"
    ENGINEER = "whois.nic.engineer"
    ENGINEERING = "whois.nic.engineering"
    ENERGY = "whois.nic.energy"
    ENTERPRISES = "whois.nic.enterprises"
    EPOST = None
    EPSON = "whois.nic.epson"
    ERICSSON = "whois.nic.ericsson"
    EQUIPMENT = "whois.nic.equipment"
    ERNI = "whois.nic.erni"
    ESQ = "whois.nic.google"
    ESTATE = "whois.nic.estate"
    ESURANCE = None
    EUROVISION = "whois.nic.eurovision"
    ETISALAT = None
    EVENTS = "whois.nic.events"
    EUS = "whois.nic.eus"
    EVERBANK = None
    EXCHANGE = "whois.nic.exchange"
    EXPERT = "whois.nic.expert"
    EXPRESS = "whois.nic.express"
    EXTRASPACE = "whois.nic.extraspace"
    EXPOSED = "whois.nic.exposed"
    FAGE = "whois.nic.fage"
    FAIL = "whois.nic.fail"
    FAITH = "whois.nic.faith"
    FAIRWINDS = "whois.nic.fairwinds"
    FAN = "whois.nic.fan"
    FANS = "whois.nic.fans"
    FAMILY = "whois.nic.family"
    FARMERS = None
    FASHION = "whois.nic.fashion"
    FARM = "whois.nic.farm"
    FEDEX = "whois.nic.fedex"
    FEEDBACK = "whois.nic.feedback"
    FAST = "whois.nic.fast"
    FERRARI = "whois.nic.ferrari"
    FIAT = None
    FERRERO = None
    FIDELITY = "whois.nic.fidelity"
    FIDO = "whois.nic.fido"
    FINAL = "whois.gtlds.nic.br"
    FINANCE = "whois.nic.finance"
    FILM = "whois.nic.film"
    FINANCIAL = "whois.nic.financial"
    FIRESTONE = "whois.nic.firestone"
    FIRE = "whois.nic.fire"
    FISH = "whois.nic.fish"
    FIRMDALE = "whois.nic.firmdale"
    FIT = "whois.nic.fit"
    FISHING = "whois.nic.fishing"
    FLICKR = None
    FITNESS = "whois.nic.fitness"
    FLIR = None
    FLORIST = "whois.nic.florist"
    FLIGHTS = "whois.nic.flights"
    FLOWERS = "whois.nic.flowers"
    FLY = "whois.nic.google"
    FLSMIDTH = None
    FOOD = None
    FOODNETWORK = None
    FOOTBALL = "whois.nic.football"
    FORD = None
    FOO = "whois.nic.google"
    FOREX = "whois.nic.forex"
    FORSALE = "whois.nic.forsale"
    FORUM = "whois.nic.forum"
    FOUNDATION = "whois.nic.foundation"
    FOX = "whois.nic.fox"
    FREE = "whois.nic.free"
    FRL = "whois.nic.frl"
    FROGANS = "whois.nic.frogans"
    FRONTDOOR = None
    FRESENIUS = "whois.nic.fresenius"
    FTR = None
    FRONTIER = None
    FUJITSU = "whois.nic.gmo"
    FUJIXEROX = None
    FUN = "whois.nic.fun"
    FUND = "whois.nic.fund"
    FURNITURE = "whois.nic.furniture"
    FUTBOL = "whois.nic.futbol"
    FYI = "whois.nic.fyi"
    GALLERY = "whois.nic.gallery"
    GAL = "whois.nic.gal"
    GALLO = "whois.nic.gallo"
    GAME = "whois.nic.game"
    GAMES = "whois.nic.games"
    GALLUP = "whois.nic.gallup"
    GAP = None
    GARDEN = "whois.nic.garden"
    GAY = "whois.nic.gay"
    GBIZ = "whois.nic.google"
    GDN = "whois.nic.gdn"
    GENT = "whois.nic.gent"
    GENTING = "whois.nic.genting"
    GEA = "whois.nic.gea"
    GEORGE = "whois.nic.george"
    GGEE = "whois.nic.ggee"
    GIFT = "whois.uniregistry.net"
    GIFTS = "whois.nic.gifts"
    GIVES = "whois.nic.gives"
    GIVING = "whois.nic.giving"
    GLASS = "whois.nic.glass"
    GLADE = None
    GLE = "whois.nic.google"
    GLOBAL = "whois.nic.global"
    GLOBO = "whois.gtlds.nic.br"
    GMAIL = "whois.nic.google"
    GMBH = "whois.nic.gmbh"
    GMX = "whois.nic.gmx"
    GMO = "whois.nic.gmo"
    GODADDY = "whois.nic.godaddy"
    GOLD = "whois.nic.gold"
    GOLDPOINT = "whois.nic.goldpoint"
    GOLF = "whois.nic.golf"
    GOO = "whois.nic.gmo"
    GOODYEAR = "whois.nic.goodyear"
    GOOG = "whois.nic.google"
    GOODHANDS = None
    GOOGLE = "whois.nic.google"
    GOP = "whois.nic.gop"
    GOT = "whois.nic.got"
    GRAINGER = None
    GRAPHICS = "whois.nic.graphics"
    GRATIS = "whois.nic.gratis"
    GREEN = "whois.nic.green"
    GRIPE = "whois.nic.gripe"
    GROCERY = "whois.nic.grocery"
    GROUP = "whois.nic.group"
    GUARDIAN = None
    GUCCI = "whois.nic.gucci"
    GUGE = "whois.nic.google"
    GUIDE = "whois.nic.guide"
    GUITARS = "whois.nic.guitars"
    GURU = "whois.nic.guru"
    HAIR = "whois.nic.hair"
    HAMBURG = "whois.nic.hamburg"
    HANGOUT = "whois.nic.google"
    HAUS = "whois.nic.haus"
    HDFC = "whois.nic.hdfc"
    HDFCBANK = "whois.nic.hdfcbank"
    HEALTH = None
    HBO = None
    HEALTHCARE = "whois.nic.healthcare"
    HELP = "whois.nic.help"
    HERE = "whois.nic.google"
    HERMES = "whois.nic.hermes"
    HGTV = None
    HELSINKI = "whois.nic.helsinki"
    HIPHOP = "whois.nic.hiphop"
    HISAMITSU = "whois.nic.gmo"
    HIV = "whois.nic.hiv"
    HITACHI = "whois.nic.gmo"
    HKT = "whois.nic.hkt"
    HOCKEY = "whois.nic.hockey"
    HOLIDAY = "whois.nic.holiday"
    HOMEDEPOT = "whois.nic.homedepot"
    HOLDINGS = "whois.nic.holdings"
    HOMEGOODS = None
    HOMES = "whois.nic.homes"
    HONDA = "whois.nic.honda"
    HONEYWELL = None
    HOMESENSE = None
    HORSE = "whois.nic.horse"
    HOSPITAL = "whois.nic.hospital"
    HOST = "whois.nic.host"
    HOT = "whois.nic.hot"
    HOTELES = None
    HOTELS = "whois.nic.hotels"
    HOSTING = "whois.nic.hosting"
    HOTMAIL = "whois.nic.hotmail"
    HOW = "whois.nic.google"
    HSBC = None
    HOUSE = "whois.nic.house"
    HTC = None
    HUGHES = "whois.nic.hughes"
    HYATT = None
    HYUNDAI = "whois.nic.hyundai"
    IBM = "whois.nic.ibm"
    ICBC = "whois.nic.icbc"
    ICU = "whois.nic.icu"
    ICE = "whois.nic.ice"
    IFM = "whois.nic.ifm"
    IEEE = None
    IKANO = "whois.nic.ikano"
    IINET = None
    IMDB = "whois.nic.imdb"
    IMAMAT = "whois.nic.imamat"
    IMMO = "whois.nic.immo"
    IMMOBILIEN = "whois.nic.immobilien"
    INDUSTRIES = "whois.nic.industries"
    INFINITI = "whois.nic.gmo"
    INC = "whois.nic.inc"
    INFO = "whois.nic.info"
    INK = "whois.nic.ink"
    INSTITUTE = "whois.nic.institute"
    ING = "whois.nic.google"
    INSURANCE = "whois.nic.insurance"
    INSURE = "whois.nic.insure"
    INTEL = None
    INTUIT = None
    INVESTMENTS = "whois.nic.investments"
    INTERNATIONAL = "whois.nic.international"
    IPIRANGA = None
    ISELECT = None
    IRISH = "whois.nic.irish"
    ISMAILI = "whois.nic.ismaili"
    IST = "whois.nic.ist"
    ISTANBUL = "whois.nic.istanbul"
    ITAU = None
    ITV = "whois.nic.itv"
    IWC = None
    JAGUAR = "whois.nic.jaguar"
    JAVA = "whois.nic.java"
    IVECO = None
    JCP = None
    JCB = "whois.nic.gmo"
    JEEP = "whois.nic.jeep"
    JETZT = "whois.nic.jetzt"
    JEWELRY = "whois.nic.jewelry"
    JIO = "whois.nic.jio"
    JLC = None
    JLL = "whois.nic.jll"
    JMP = None
    JNJ = None
    JOBURG = "whois.nic.joburg"
    JOT = "whois.nic.jot"
    JOY = "whois.nic.joy"
    JPMORGAN = None
    JPRS = None
    JUEGOS = "whois.uniregistry.net"
    JUNIPER = "whois.nic.juniper"
    KAUFEN = "whois.nic.kaufen"
    KERRYHOTELS = "whois.nic.kerryhotels"
    KDDI = "whois.nic.kddi"
    KERRYLOGISTICS = "whois.nic.kerrylogistics"
    KFH = "whois.nic.kfh"
    KERRYPROPERTIES = "whois.nic.kerryproperties"
    KIA = "whois.nic.kia"
    KIDS = "whois.nic.kids"
    KIM = "whois.nic.kim"
    KINDLE = "whois.nic.kindle"
    KITCHEN = "whois.nic.kitchen"
    KIWI = "whois.nic.kiwi"
    KINDER = None
    KOELN = "whois.ryce-rsp.com"
    KOMATSU = "whois.nic.komatsu"
    KOSHER = "whois.nic.kosher"
    KPN = None
    KPMG = None
    KRD = "whois.nic.krd"
    KRED = None
    KUOKGROUP = "whois.nic.kuokgroup"
    KYOTO = "whois.nic.kyoto"
    LACAIXA = "whois.nic.lacaixa"
    LADBROKES = None
    LAMBORGHINI = "whois.nic.lamborghini"
    LAMER = "whois.nic.lamer"
    LANCASTER = "whois.nic.lancaster"
    LANCIA = None
    LAND = "whois.nic.land"
    LANCOME = None
    LANDROVER = "whois.nic.landrover"
    LANXESS = None
    LASALLE = "whois.nic.lasalle"
    LAT = "whois.nic.lat"
    LATROBE = "whois.nic.latrobe"
    LATINO = "whois.nic.latino"
    LAWYER = "whois.nic.lawyer"
    LDS = "whois.nic.lds"
    LAW = "whois.nic.law"
    LEASE = "whois.nic.lease"
    LECLERC = "whois.nic.leclerc"
    LEFRAK = "whois.nic.lefrak"
    LEGAL = "whois.nic.legal"
    LEGO = "whois.nic.lego"
    LEXUS = "whois.nic.lexus"
    LGBT = "whois.nic.lgbt"
    LIAISON = None
    LIDL = "whois.nic.lidl"
    LIFE = "whois.nic.life"
    LIFEINSURANCE = "whois.nic.lifeinsurance"
    LIFESTYLE = "whois.nic.lifestyle"
    LIKE = "whois.nic.like"
    LIGHTING = "whois.nic.lighting"
    LILLY = None
    LIMO = "whois.nic.limo"
    LIMITED = "whois.nic.limited"
    LINCOLN = None
    LINDE = None
    LIPSY = "whois.nic.lipsy"
    LINK = "whois.uniregistry.net"
    LIVE = "whois.nic.live"
    LIVING = None
    LIXIL = None
    LLC = "whois.nic.llc"
    LLP = "whois.nic.llp"
    LOAN = "whois.nic.loan"
    LOANS = "whois.nic.loans"
    LOCKER = "whois.nic.locker"
    LOCUS = "whois.nic.locus"
    LOFT = None
    LOL = "whois.nic.lol"
    LONDON = "whois.nic.london"
    LOTTE = "whois.nic.lotte"
    LOVE = "whois.nic.love"
    LPL = "whois.nic.lpl"
    LPLFINANCIAL = "whois.nic.lplfinancial"
    LOTTO = "whois.nic.lotto"
    LTD = "whois.nic.ltd"
    LTDA = "whois.nic.ltda"
    LUNDBECK = "whois.nic.lundbeck"
    LUPIN = None
    LUXE = "whois.nic.luxe"
    LUXURY = "whois.nic.luxury"
    MACYS = None
    MADRID = "whois.nic.madrid"
    MAIF = "whois.nic.maif"
    MAKEUP = "whois.nic.makeup"
    MAN = "whois.nic.man"
    MAISON = "whois.nic.maison"
    MANGO = "whois.nic.mango"
    MAP = "whois.nic.google"
    MANAGEMENT = "whois.nic.management"
    MARKET = "whois.nic.market"
    MARKETING = "whois.nic.marketing"
    MARRIOTT = "whois.nic.marriott"
    MARSHALLS = None
    MASERATI = None
    MARKETS = "whois.nic.markets"
    MATTEL = None
    MBA = "whois.nic.mba"
    MCD = None
    MCDONALDS = None
    MCKINSEY = "whois.nic.mckinsey"
    MED = "whois.nic.med"
    MEET = "whois.nic.google"
    MEDIA = "whois.nic.media"
    MEME = "whois.nic.google"
    MELBOURNE = "whois.nic.melbourne"
    MEN = "whois.nic.men"
    MEMORIAL = "whois.nic.memorial"
    MEO = None
    MERCKMSD = "whois.nic.merckmsd"
    MENU = "whois.nic.menu"
    METLIFE = None
    MICROSOFT = "whois.nic.microsoft"
    MIAMI = "whois.nic.miami"
    MINI = "whois.nic.mini"
    MINT = None
    MITSUBISHI = "whois.nic.gmo"
    MIT = "whois.nic.mit"
    MLB = None
    MLS = "whois.nic.mls"
    MMA = "whois.nic.mma"
    MOBI = "whois.nic.mobi"
    MOBILE = "whois.nic.mobile"
    MODA = "whois.nic.moda"
    MOBILY = None
    MOI = "whois.nic.moi"
    MOE = "whois.nic.moe"
    MOM = "whois.nic.mom"
    MONASH = "whois.nic.monash"
    MONEY = "whois.nic.money"
    MONSTER = "whois.nic.monster"
    MONTBLANC = None
    MOPAR = None
    MORTGAGE = "whois.nic.mortgage"
    MORMON = "whois.nic.mormon"
    MOSCOW = "whois.nic.moscow"
    MOTO = "whois.nic.moto"
    MOTORCYCLES = "whois.nic.motorcycles"
    MOV = "whois.nic.google"
    MOVIE = "whois.nic.movie"
    MOVISTAR = None
    MSD = "whois.nic.msd"
    MTN = "whois.nic.mtn"
    MTPC = None
    MTR = "whois.nic.mtr"
    MUSIC = "whois.nic.music"
    MUTUAL = None
    MUTUELLE = None
    NAB = "whois.nic.nab"
    NADEX = None
    NAGOYA = "whois.nic.nagoya"
    NATIONWIDE = None
    NATURA = None
    NAVY = "whois.nic.navy"
    NBA = None
    NEC = "whois.nic.nec"
    NET = "whois.verisign-grs.com"
    NETBANK = "whois.nic.netbank"
    NETFLIX = None
    NETWORK = "whois.nic.network"
    NEW = "whois.nic.google"
    NEUSTAR = None
    NEWHOLLAND = None
    NEXT = "whois.nic.next"
    NEXTDIRECT = "whois.nic.nextdirect"
    NEWS = "whois.nic.news"
    NEXUS = "whois.nic.google"
    NGO = "whois.nic.ngo"
    NHK = "whois.nic.nhk"
    NFL = None
    NICO = "whois.nic.nico"
    NIKE = None
    NINJA = "whois.nic.ninja"
    NIKON = "whois.nic.nikon"
    NISSAN = "whois.nic.gmo"
    NISSAY = "whois.nic.nissay"
    NOKIA = "whois.nic.nokia"
    NORTHWESTERNMUTUAL = None
    NORTON = "whois.nic.norton"
    NOW = "whois.nic.now"
    NOWTV = "whois.nic.nowtv"
    NOWRUZ = "whois.nic.nowruz"
    NRA = "whois.nic.nra"
    NRW = "whois.nic.nrw"
    NYC = "whois.nic.nyc"
    NTT = None
    OBI = "whois.nic.obi"
    OBSERVER = "whois.nic.observer"
    OFF = None
    OFFICE = "whois.nic.office"
    OKINAWA = "whois.nic.okinawa"
    OLAYAN = "whois.nic.olayan"
    OLAYANGROUP = "whois.nic.olayangroup"
    OLDNAVY = None
    OLLO = "whois.nic.ollo"
    OMEGA = "whois.nic.omega"
    ONE = "whois.nic.one"
    ONG = "whois.nic.ong"
    ONL = "whois.nic.onl"
    ONYOURSIDE = None
    ONLINE = "whois.nic.online"
    OPEN = "whois.nic.open"
    OOO = "whois.nic.ooo"
    ORACLE = "whois.nic.oracle"
    ORG = "whois.publicinterestregistry.org"
    ORGANIC = "whois.nic.organic"
    ORIENTEXPRESS = None
    ORANGE = "whois.nic.orange"
    OSAKA = "whois.nic.osaka"
    ORIGINS = "whois.nic.origins"
    OTSUKA = "whois.nic.otsuka"
    OTT = "whois.nic.ott"
    OVH = "whois.nic.ovh"
    PAGE = "whois.nic.google"
    PAMPEREDCHEF = None
    PANASONIC = "whois.nic.gmo"
    PANERAI = None
    PARS = "whois.nic.pars"
    PARTNERS = "whois.nic.partners"
    PARIS = "whois.nic.paris"
    PARTS = "whois.nic.parts"
    PARTY = "whois.nic.party"
    PAY = "whois.nic.pay"
    PCCW = "whois.nic.pccw"
    PASSAGENS = None
    PET = "whois.nic.pet"
    PFIZER = None
    PHARMACY = "whois.nic.pharmacy"
    PHD = "whois.nic.google"
    PHILIPS = "whois.nic.philips"
    PHOTO = "whois.nic.photo"
    PHOTOGRAPHY = "whois.nic.photography"
    PHONE = "whois.nic.phone"
    PHOTOS = "whois.nic.photos"
    PHYSIO = "whois.nic.physio"
    PIAGET = None
    PICS = "whois.nic.pics"
    PICTURES = "whois.nic.pictures"
    PID = "whois.nic.pid"
    PICTET = "whois.nic.pictet"
    PIN = "whois.nic.pin"
    PING = "whois.nic.ping"
    PINK = "whois.nic.pink"
    PIZZA = "whois.nic.pizza"
    PIONEER = "whois.nic.pioneer"
    PLACE = "whois.nic.place"
    PLAY = "whois.nic.google"
    PLAYSTATION = "whois.nic.playstation"
    PLUMBING = "whois.nic.plumbing"
    PLUS = "whois.nic.plus"
    PNC = "whois.nic.pnc"
    POHL = "whois.nic.pohl"
    POKER = "whois.nic.poker"
    POLITIE = "whois.nic.politie"
    PORN = "whois.nic.porn"
    PRAXI = None
    PRAMERICA = None
    PRESS = "whois.nic.press"
    PRIME = "whois.nic.prime"
    PROD = "whois.nic.google"
    PRODUCTIONS = "whois.nic.productions"
    PROF = "whois.nic.google"
    PROGRESSIVE = "whois.nic.progressive"
    PROMO = "whois.nic.promo"
    PROPERTIES = "whois.nic.properties"
    PROPERTY = "whois.nic.property"
    PROTECTION = "whois.nic.protection"
    PRU = None
    PRUDENTIAL = None
    PUB = "whois.nic.pub"
    PWC = "whois.nic.pwc"
    QPON = "whois.nic.qpon"
    QUEBEC = "whois.nic.quebec"
    QUEST = "whois.nic.quest"
    RACING = "whois.nic.racing"
    QVC = None
    RADIO = "whois.nic.radio"
    RAID = None
    READ = "whois.nic.read"
    REALESTATE = "whois.nic.realestate"
    REALTOR = "whois.nic.realtor"
    REALTY = "whois.nic.realty"
    RECIPES = "whois.nic.recipes"
    RED = "whois.nic.red"
    REDSTONE = "whois.nic.redstone"
    REDUMBRELLA = "whois.nic.redumbrella"
    REHAB = "whois.nic.rehab"
    REISE = "whois.nic.reise"
    REISEN = "whois.nic.reisen"
    RELIANCE = "whois.nic.reliance"
    REIT = "whois.nic.reit"
    REN = "whois.nic.ren"
    RENT = "whois.nic.rent"
    RENTALS = "whois.nic.rentals"
    REPAIR = "whois.nic.repair"
    REPUBLICAN = "whois.nic.republican"
    REPORT = "whois.nic.report"
    REST = "whois.nic.rest"
    RESTAURANT = "whois.nic.restaurant"
    REVIEW = "whois.nic.review"
    REXROTH = "whois.nic.rexroth"
    REVIEWS = "whois.nic.reviews"
    RICH = "whois.nic.rich"
    RICOH = "whois.nic.ricoh"
    RICHARDLI = "whois.nic.richardli"
    RIL = "whois.nic.ril"
    RIO = "whois.gtlds.nic.br"
    RIGHTATHOME = None
    RMIT = None
    RIP = "whois.nic.rip"
    ROCKS = "whois.nic.rocks"
    ROCHER = None
    RODEO = "whois.nic.rodeo"
    ROGERS = "whois.nic.rogers"
    ROOM = "whois.nic.room"
    RSVP = "whois.nic.google"
    RUHR = "whois.nic.ruhr"
    RUGBY = "whois.nic.rugby"
    RUN = "whois.nic.run"
    RWE = "whois.nic.rwe"
    RYUKYU = "whois.nic.ryukyu"
    SAARLAND = "whois.nic.saarland"
    SAFETY = "whois.nic.safety"
    SAFE = "whois.nic.safe"
    SALE = "whois.nic.sale"
    SALON = "whois.nic.salon"
    SAKURA = None
    SAMSCLUB = "whois.nic.samsclub"
    SAMSUNG = "whois.nic.samsung"
    SANDVIK = "whois.nic.sandvik"
    SANDVIKCOROMANT = "whois.nic.sandvikcoromant"
    SAP = "whois.nic.sap"
    SAPO = None
    SANOFI = "whois.nic.sanofi"
    SARL = "whois.nic.sarl"
    SAVE = "whois.nic.save"
    SAXO = "whois.nic.saxo"
    SAS = None
    SBS = "whois.nic.sbs"
    SBI = "whois.nic.sbi"
    SCA = None
    SCB = "whois.nic.scb"
    SCHAEFFLER = "whois.afilias-srs.net"
    SCHMIDT = "whois.nic.schmidt"
    SCHOLARSHIPS = "whois.nic.scholarships"
    SCHOOL = "whois.nic.school"
    SCHULE = "whois.nic.schule"
    SCHWARZ = "whois.nic.schwarz"
    SCIENCE = "whois.nic.science"
    SCJOHNSON = None
    SCOT = "whois.nic.scot"
    SCOR = None
    SEARCH = "whois.nic.google"
    SEAT = "whois.nic.seat"
    SECURE = "whois.nic.secure"
    SEEK = "whois.nic.seek"
    SELECT = "whois.nic.select"
    SECURITY = "whois.nic.security"
    SENER = "whois.nic.rwe"
    SES = None
    SEVEN = "whois.nic.seven"
    SERVICES = "whois.nic.services"
    SEX = "whois.nic.sex"
    SEW = "whois.nic.sew"
    SFR = "whois.nic.sfr"
    SEXY = "whois.nic.sexy"
    SHARP = "whois.nic.gmo"
    SHANGRILA = "whois.nic.shangrila"
    SHAW = None
    SHIA = "whois.nic.shia"
    SHELL = "whois.nic.shell"
    SHOES = "whois.nic.shoes"
    SHIKSHA = "whois.nic.shiksha"
    SHOP = "whois.nic.shop"
    SHOPPING = "whois.nic.shopping"
    SHOUJI = "whois.teleinfo.cn"
    SHOW = "whois.nic.show"
    SHRIRAM = None
    SHOWTIME = None
    SINA = "whois.nic.sina"
    SILK = "whois.nic.silk"
    SINGLES = "whois.nic.singles"
    SITE = "whois.nic.site"
    SKI = "whois.nic.ski"
    SKIN = "whois.nic.skin"
    SKY = "whois.nic.sky"
    SKYPE = "whois.nic.skype"
    SLING = "whois.nic.sling"
    SMART = "whois.nic.smart"
    SMILE = "whois.nic.smile"
    SNCF = "whois.nic.sncf"
    SOCCER = "whois.nic.soccer"
    SOCIAL = "whois.nic.social"
    SOFTWARE = "whois.nic.software"
    SOFTBANK = "whois.nic.softbank"
    SOHU = None
    SOLUTIONS = "whois.nic.solutions"
    SONG = None
    SOLAR = "whois.nic.solar"
    SONY = "whois.nic.sony"
    SOY = "whois.nic.google"
    SPA = "whois.nic.spa"
    SPACE = "whois.nic.space"
    SPIEGEL = None
    SPOT = "whois.nic.spot"
    SPREADBETTING = None
    SPORT = "whois.nic.sport"
    SRL = "whois.nic.srl"
    SRT = None
    STAPLES = None
    STAR = "whois.nic.star"
    STADA = "whois.nic.stada"
    STATEBANK = "whois.nic.statebank"
    STATEFARM = None
    STARHUB = None
    STATOIL = None
    STCGROUP = "whois.nic.stcgroup"
    STOCKHOLM = "whois.nic.stockholm"
    STC = "whois.nic.stc"
    STORAGE = "whois.nic.storage"
    STREAM = "whois.nic.stream"
    STUDIO = "whois.nic.studio"
    STORE = "whois.nic.store"
    STUDY = "whois.nic.study"
    STYLE = "whois.nic.style"
    SUCKS = "whois.nic.sucks"
    SUPPLY = "whois.nic.supply"
    SUPPLIES = "whois.nic.supplies"
    SUPPORT = "whois.nic.support"
    SURF = "whois.nic.surf"
    SURGERY = "whois.nic.surgery"
    SUZUKI = "whois.nic.suzuki"
    SWATCH = "whois.nic.swatch"
    SWIFTCOVER = None
    SWISS = "whois.nic.swiss"
    SYDNEY = "whois.nic.sydney"
    SYMANTEC = None
    SYSTEMS = "whois.nic.systems"
    TAB = "whois.nic.tab"
    TALK = "whois.nic.talk"
    TAOBAO = "whois.nic.taobao"
    TAIPEI = "whois.nic.taipei"
    TARGET = None
    TATAMOTORS = "whois.nic.tatamotors"
    TATAR = "whois.nic.tatar"
    TATTOO = "whois.nic.tattoo"
    TAX = "whois.nic.tax"
    TAXI = "whois.nic.taxi"
    TCI = "whois.nic.tci"
    TDK = "whois.nic.tdk"
    TEAM = "whois.nic.team"
    TECHNOLOGY = "whois.nic.technology"
    TECH = "whois.nic.tech"
    TELECITY = None
    TEMASEK = "whois.nic.temasek"
    TELEFONICA = None
    TEVA = "whois.nic.teva"
    TENNIS = "whois.nic.tennis"
    THD = "whois.nic.thd"
    THEATRE = "whois.nic.theatre"
    THEATER = "whois.nic.theater"
    TIAA = "whois.nic.tiaa"
    TICKETS = "whois.nic.tickets"
    TIFFANY = None
    TIPS = "whois.nic.tips"
    TIRES = "whois.nic.tires"
    TIENDA = "whois.nic.tienda"
    TIROL = "whois.nic.tirol"
    TJMAXX = None
    TJX = None
    TKMAXX = None
    TMALL = "whois.nic.tmall"
    TODAY = "whois.nic.today"
    TOKYO = "whois.nic.tokyo"
    TOOLS = "whois.nic.tools"
    TOP = "whois.nic.top"
    TORAY = "whois.nic.toray"
    TOTAL = "whois.nic.total"
    TOURS = "whois.nic.tours"
    TOWN = "whois.nic.town"
    TOSHIBA = "whois.nic.toshiba"
    TOYOTA = "whois.nic.toyota"
    TOYS = "whois.nic.toys"
    TRADE = "whois.nic.trade"
    TRADING = "whois.nic.trading"
    TRAINING = "whois.nic.training"
    TRAVELCHANNEL = None
    TRAVELERS = "whois.nic.travelers"
    TRAVELERSINSURANCE = "whois.nic.travelersinsurance"
    TRV = "whois.nic.trv"
    TRUST = "whois.nic.trust"
    TUBE = "whois.nic.tube"
    TUI = "whois.nic.tui"
    TUNES = "whois.nic.tunes"
    TUSHU = "whois.nic.tushu"
    TVS = "whois.nic.tvs"
    UBANK = "whois.nic.ubank"
    UCONNECT = None
    UNICOM = "whois.nic.unicom"
    UNIVERSITY = "whois.nic.university"
    UNO = "whois.nic.uno"
    UBS = "whois.nic.ubs"
    UOL = "whois.gtlds.nic.br"
    UPS = "whois.nic.ups"
    VANA = "whois.nic.vana"
    VACATIONS = "whois.nic.vacations"
    VANGUARD = "whois.nic.vanguard"
    VEGAS = "whois.nic.vegas"
    VENTURES = "whois.nic.ventures"
    VERISIGN = "whois.nic.verisign"
    VERSICHERUNG = "whois.nic.versicherung"
    VET = "whois.nic.vet"
    VIAJES = "whois.nic.viajes"
    VIDEO = "whois.nic.video"
    VIKING = "whois.nic.viking"
    VILLAS = "whois.nic.villas"
    VIG = "whois.nic.vig"
    VIP = "whois.nic.vip"
    VIRGIN = "whois.nic.virgin"
    VIN = "whois.nic.vin"
    VISION = "whois.nic.vision"
    VISA = "whois.nic.visa"
    VISTAPRINT = None
    VISTA = None
    VIVO = None
    VIVA = "whois.nic.viva"
    VLAANDEREN = "whois.nic.vlaanderen"
    VOLKSWAGEN = None
    VODKA = "whois.nic.vodka"
    VOLVO = "whois.nic.volvo"
    VOTE = "whois.nic.vote"
    VOTING = "whois.nic.voting"
    VOTO = "whois.nic.voto"
    VOYAGE = "whois.nic.voyage"
    VUELOS = None
    WALES = "whois.nic.wales"
    WALMART = "whois.nic.walmart"
    WALTER = "whois.nic.walter"
    WANG = "whois.gtld.knet.cn"
    WANGGOU = "whois.nic.wanggou"
    WARMAN = None
    WATCH = "whois.nic.watch"
    WEATHER = None
    WATCHES = "whois.nic.watches"
    WEATHERCHANNEL = None
    WEBCAM = "whois.nic.webcam"
    WEBSITE = "whois.nic.website"
    WEBER = "whois.nic.weber"
    WED = "whois.nic.wed"
    WEIBO = "whois.nic.weibo"
    WEDDING = "whois.nic.wedding"
    WEIR = "whois.nic.weir"
    WIEN = "whois.nic.wien"
    WHOSWHO = "whois.nic.whoswho"
    WIKI = "whois.nic.wiki"
    WIN = "whois.nic.win"
    WILLIAMHILL = None
    WINE = "whois.nic.wine"
    WINNERS = None
    WINDOWS = "whois.nic.windows"
    WOLTERSKLUWER = "whois.nic.wolterskluwer"
    WOODSIDE = "whois.nic.woodside"
    WORK = "whois.nic.work"
    WORKS = "whois.nic.works"
    WORLD = "whois.nic.world"
    WOW = "whois.nic.wow"
    WME = "whois.nic.wme"
    WTF = "whois.nic.wtf"
    XBOX = "whois.nic.xbox"
    WTC = "whois.nic.wtc"
    XEROX = "whois.nic.xerox"
    XFINITY = None
    XIHUAN = "whois.teleinfo.cn"
    XIN = "whois.nic.xin"
    XN__11B4C3D = "whois.nic.xn--11b4c3d"
    XN__1QQW23A = "whois.ngtld.cn"
    XN__1CK2E1B = None
    XN__30RR7Y = "whois.gtld.knet.cn"
    XN__3DS443G = "whois.teleinfo.cn"
    XN__3BST00M = "whois.gtld.knet.cn"
    XN__3PXU8K = "whois.nic.xn--3pxu8k"
    XN__42C2D9A = "whois.nic.xn--42c2d9a"
    XN__3OQ18VL8PN36A = None
    XN__45Q11C = "whois.gtld.knet.cn"
    XN__4GBRIM = "whois.nic.xn--4gbrim"
    XN__55QX5D = "whois.ngtld.cn"
    XN__5SU34J936BGSG = "whois.nic.xn--5su34j936bgsg"
    XN__5TZM5G = "whois.nic.xn--5tzm5g"
    XN__55QW42G = "whois.conac.cn"
    XN__6FRZ82G = "whois.nic.xn--6frz82g"
    XN__6QQ986B3XL = "whois.gtld.knet.cn"
    XN__80ADXHKS = "whois.nic.xn--80adxhks"
    XN__80AQECDR1A = "whois.nic.xn--80aqecdr1a"
    XN__80ASEHDB = "whois.nic.xn--80asehdb"
    XN__80ASWG = "whois.nic.xn--80aswg"
    XN__8Y0A063A = "whois.nic.xn--8y0a063a"
    XN__9DBQ2A = "whois.nic.xn--9dbq2a"
    XN__9KRT00A = "whois.nic.xn--9krt00a"
    XN__9ET52U = "whois.gtld.knet.cn"
    XN__B4W605FERD = "whois.nic.xn--b4w605ferd"
    XN__C1AVG = "whois.nic.xn--c1avg"
    XN__BCK1B9A5DRE4C = None
    XN__C2BR7G = "whois.nic.xn--c2br7g"
    XN__CCK2B3B = None
    XN__CCKWCXETD = "whois.nic.xn--cckwcxetd"
    XN__CZR694B = None
    XN__CG4BKI = "whois.kr"
    XN__CZRS0T = "whois.nic.xn--czrs0t"
    XN__D1ACJ3B = "whois.nic.xn--d1acj3b"
    XN__CZRU2D = "whois.gtld.knet.cn"
    XN__ECKVDTC9D = None
    XN__EFVY88H = "whois.nic.xn--efvy88h"
    XN__ESTV75G = None
    XN__FCT429K = None
    XN__FIQ228C5HS = "whois.teleinfo.cn"
    XN__FHBEI = "whois.nic.xn--fhbei"
    XN__FIQ64B = "whois.gtld.knet.cn"
    XN__FJQ720A = "whois.nic.xn--fjq720a"
    XN__FLW351E = "whois.nic.google"
    XN__FZYS8D69UVGM = "whois.nic.xn--fzys8d69uvgm"
    XN__G2XX48C = None
    XN__GCKR3F0F = None
    XN__GK3AT1E = None
    XN__HXT814E = "whois.gtld.knet.cn"
    XN__I1B6B1A6A2E = "whois.nic.xn--i1b6b1a6a2e"
    XN__IMR513N = None
    XN__IO0A7I = "whois.ngtld.cn"
    XN__JLQ480N2RG = "whois.nic.xn--jlq480n2rg"
    XN__J1AEF = "whois.nic.xn--j1aef"
    XN__JLQ61U9W7B = None
    XN__JVR189M = None
    XN__KCRX77D1X4A = "whois.nic.xn--kcrx77d1x4a"
    XN__KPU716F = None
    XN__KPUT3I = "whois.nic.xn--kput3i"
    XN__MGBA3A3EJT = None
    XN__MGBA7C0BBN0A = "whois.nic.xn--mgba7c0bbn0a"
    XN__MGBAAKC7DVF = None
    XN__MGBAB2BD = "whois.nic.xn--mgbab2bd"
    XN__MGBB9FBPOB = None
    XN__MGBCA7DZDO = "whois.nic.xn--mgbca7dzdo"
    XN__MGBI4ECEXP = "whois.nic.xn--mgbi4ecexp"
    XN__MGBT3DHD = "whois.nic.xn--mgbt3dhd"
    XN__MK1BU44C = "whois.nic.xn--mk1bu44c"
    XN__MXTQ1M = "whois.nic.xn--mxtq1m"
    XN__NGBE9E0A = "whois.nic.xn--ngbe9e0a"
    XN__NGBRX = "whois.nic.xn--ngbrx"
    XN__NGBC5AZD = "whois.nic.xn--ngbc5azd"
    XN__NQV7FS00EMA = "whois.nic.xn--nqv7fs00ema"
    XN__NQV7F = "whois.nic.xn--nqv7f"
    XN__NYQY26A = None
    XN__OTU796D = None
    XN__P1ACF = "whois.nic.xn--p1acf"
    XN__PBT977C = None
    XN__PSSY2U = "whois.nic.xn--pssy2u"
    XN__Q9JYB4C = "whois.nic.google"
    XN__QCKA1PMC = "whois.nic.google"
    XN__RHQV96G = None
    XN__ROVU88B = None
    XN__SES554G = "whois.nic.xn--ses554g"
    XN__T60B56A = "whois.nic.xn--t60b56a"
    XN__TCKWE = "whois.nic.xn--tckwe"
    XN__TIQ49XQYJ = "whois.nic.xn--tiq49xqyj"
    XN__UNUP4Y = "whois.nic.xn--unup4y"
    XN__VERMGENSBERATER_CTB = "whois.nic.xn--vermgensberater-ctb"
    XN__VHQUV = "whois.nic.xn--vhquv"
    XN__VERMGENSBERATUNG_PWB = "whois.nic.xn--vermgensberatung-pwb"
    XN__W4R85EL8FHU5DNRA = "whois.nic.xn--w4r85el8fhu5dnra"
    XN__VUQ861B = "whois.teleinfo.cn"
    XN__W4RS40L = "whois.nic.xn--w4rs40l"
    XN__XHQ521B = "whois.ngtld.cn"
    XPERIA = None
    XN__ZFR164B = "whois.conac.cn"
    XYZ = "whois.nic.xyz"
    YAHOO = "whois.nic.yahoo"
    YAMAXUN = "whois.nic.yamaxun"
    YANDEX = None
    YACHTS = "whois.nic.yachts"
    YODOBASHI = "whois.nic.gmo"
    YOGA = "whois.nic.yoga"
    YOKOHAMA = "whois.nic.yokohama"
    YOU = "whois.nic.you"
    YOUTUBE = "whois.nic.google"
    YUN = "whois.teleinfo.cn"
    ZARA = "whois.nic.zara"
    ZAPPOS = "whois.nic.zappos"
    ZIP = "whois.nic.google"
    ZIPPO = None
    ZERO = None
    ZONE = "whois.nic.zone"
    ZUERICH = "whois.nic.zuerich"


class SponsoredTLD:
    AERO = "whois.aero"
    ASIA = "whois.nic.asia"
    CAT = "whois.nic.cat"
    COOP = "whois.nic.coop"
    EDU = "whois.educause.edu"
    GOV = "whois.dotgov.gov"
    INT = "whois.iana.org"
    JOBS = "whois.nic.jobs"
    MIL = None
    MUSEUM = "whois.nic.museum"
    POST = "whois.dotpostregistry.net"
    TEL = "whois.nic.tel"
    TRAVEL = "whois.nic.travel"
    XXX = "whois.nic.xxx"
