"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = exports.FileSystemProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nas_generated_1 = require("./nas.generated");
Object.defineProperty(exports, "FileSystemProperty", { enumerable: true, get: function () { return nas_generated_1.RosFileSystem; } });
/**
 * A ROS resource type:  `ALIYUN::NAS::FileSystem`
 */
class FileSystem extends ros.Resource {
    /**
     * Create a new `ALIYUN::NAS::FileSystem`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFileSystem = new nas_generated_1.RosFileSystem(this, id, {
            description: props.description,
            storageType: props.storageType,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            duration: props.duration,
            snapshotId: props.snapshotId,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            encryptType: props.encryptType,
            vpcId: props.vpcId,
            capacity: props.capacity,
            protocolType: props.protocolType,
            chargeType: props.chargeType,
            fileSystemType: props.fileSystemType,
            bandwidth: props.bandwidth,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFileSystem;
        this.attrFileSystemId = rosFileSystem.attrFileSystemId;
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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