# Generated by Django 2.0.8 on 2020-05-27 09:21

# Django
from django.db import migrations

# SquareletAuth
from squarelet_auth import settings


def entitlements(apps, schema_editor):
    Plan = apps.get_model("squarelet_auth_organizations", "Plan")
    Entitlement = apps.get_model("squarelet_auth_organizations", "Entitlement")

    for plan in Plan.objects.all():
        entitlement = Entitlement.objects.create(
            name=plan.name, slug=plan.slug, resources=plan.resources
        )


def delete_entitlements(apps, schema_editor):
    Entitlement = apps.get_model("organizations", "Entitlement")
    Entitlement.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [("squarelet_auth_organizations", "0004_auto_20200527_0920")]

    operations = [migrations.RunPython(entitlements, delete_entitlements)]
