import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::CodeStar::GitHubRepository`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 */
export interface CfnGitHubRepositoryProps {
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryname
     */
    readonly repositoryName: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryowner
     */
    readonly repositoryOwner: string;
    /**
     * `AWS::CodeStar::GitHubRepository.Code`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-code
     */
    readonly code?: CfnGitHubRepository.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.ConnectionArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-connectionarn
     */
    readonly connectionArn?: string;
    /**
     * `AWS::CodeStar::GitHubRepository.EnableIssues`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-enableissues
     */
    readonly enableIssues?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.IsPrivate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-isprivate
     */
    readonly isPrivate?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryAccessToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryaccesstoken
     */
    readonly repositoryAccessToken?: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositorydescription
     */
    readonly repositoryDescription?: string;
}
/**
 * A CloudFormation `AWS::CodeStar::GitHubRepository`.
 *
 * @external
 * @cloudformationResource AWS::CodeStar::GitHubRepository
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 */
export declare class CfnGitHubRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeStar::GitHubRepository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGitHubRepository;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryname
     */
    repositoryName: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryowner
     */
    repositoryOwner: string;
    /**
     * `AWS::CodeStar::GitHubRepository.Code`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-code
     */
    code: CfnGitHubRepository.CodeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.ConnectionArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-connectionarn
     */
    connectionArn: string | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.EnableIssues`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-enableissues
     */
    enableIssues: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.IsPrivate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-isprivate
     */
    isPrivate: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryAccessToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryaccesstoken
     */
    repositoryAccessToken: string | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositorydescription
     */
    repositoryDescription: string | undefined;
    /**
     * Create a new `AWS::CodeStar::GitHubRepository`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGitHubRepositoryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeStar::GitHubRepository`.
 *
 * @external
 * @cloudformationResource AWS::CodeStar::GitHubRepository
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 */
export declare namespace CfnGitHubRepository {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-code.html
     */
    interface CodeProperty {
        /**
         * `CfnGitHubRepository.CodeProperty.S3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-code.html#cfn-codestar-githubrepository-code-s3
         */
        readonly s3: CfnGitHubRepository.S3Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeStar::GitHubRepository`.
 *
 * @external
 * @cloudformationResource AWS::CodeStar::GitHubRepository
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 */
export declare namespace CfnGitHubRepository {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html
     */
    interface S3Property {
        /**
         * `CfnGitHubRepository.S3Property.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-bucket
         */
        readonly bucket: string;
        /**
         * `CfnGitHubRepository.S3Property.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-key
         */
        readonly key: string;
        /**
         * `CfnGitHubRepository.S3Property.ObjectVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-objectversion
         */
        readonly objectVersion?: string;
    }
}
