"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process = require("child_process");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const process = require("process");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const glob_1 = require("glob");
class StaticSite extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                {
                    transitions: [
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: aws_cdk_lib_1.Duration.days(7),
                        },
                    ],
                },
            ],
        });
        const hostedZone = props.hostedZone
            ? props.hostedZone
            : aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, 'HostedZone', {
                domainName: props.domain,
            });
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.Certificate(this, 'Certificate', {
            domainName: props.domain,
            validation: aws_cdk_lib_1.aws_certificatemanager.CertificateValidation.fromDns(hostedZone),
        });
        const originAccessIdentity = new aws_cdk_lib_1.aws_cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        bucket.grantRead(originAccessIdentity);
        const distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket, {
                    originAccessIdentity,
                }),
                allowedMethods: aws_cdk_lib_1.aws_cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            },
            domainNames: [props.domain],
            certificate,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 404,
                    responsePagePath: '/404.html',
                },
            ],
            defaultRootObject: 'index.html',
        });
        new aws_cdk_lib_1.aws_route53.ARecord(this, 'AAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(distribution)),
        });
        new aws_cdk_lib_1.aws_route53.AaaaRecord(this, 'AaaaAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(distribution)),
        });
        const hashFile = '/.hashfile';
        let invalidations = [hashFile];
        invalidations.push(...compareRemoteToLocal(props.domain, hashFile, props.path));
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'StaticDeployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(props.path)],
            destinationBucket: bucket,
            distribution: distribution,
            distributionPaths: invalidations,
        });
    }
}
exports.StaticSite = StaticSite;
_a = JSII_RTTI_SYMBOL_1;
StaticSite[_a] = { fqn: "pwed-cdk.pwed_static_site.StaticSite", version: "0.0.44" };
function getHashes(globPattern, dir) {
    let fh = new Map();
    const gs = glob_1.sync(globPattern, { cwd: dir, nodir: true });
    const pwd = process.cwd();
    process.chdir(dir);
    gs.forEach(function (file) {
        const fileBuffer = fs.readFileSync(file, {});
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBuffer);
        const hex = hashSum.digest('hex');
        fh.set(file, hex);
    });
    process.chdir(pwd);
    return fh;
}
function getInvalidations(oldHashes, newHashes) {
    let invalidations = [];
    oldHashes.forEach(function (v, k) {
        if (newHashes.get(k) !== v) {
            invalidations.push(`/${k}`);
        }
    });
    return invalidations;
}
function compareRemoteToLocal(domain, hashFile, localFolder) {
    let oldHashesJSON;
    const newHashes = getHashes('**', localFolder);
    fs.writeFileSync(path.join(localFolder, hashFile), JSON.stringify(Object.fromEntries(newHashes)));
    try {
        oldHashesJSON = child_process
            .execSync(`curl -s https://${domain}/${hashFile}`)
            .toString();
    }
    catch {
        return ['/*'];
    }
    let oldHashes;
    try {
        oldHashes = new Map(Object.entries(JSON.parse(oldHashesJSON)));
    }
    catch (e) {
        return ['/*'];
    }
    return getInvalidations(oldHashes, newHashes);
}
//# sourceMappingURL=data:application/json;base64,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