import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
 *
 * @experimental
 */
export declare class Awsconnector extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Retrieves all health metrics that were published from the Server Migration Connector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     *
     * @experimental
     */
    toGetConnectorHealth(): this;
    /**
     * (experimental) Registers AWS Connector with AWS Connector Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     *
     * @experimental
     */
    toRegisterConnector(): this;
    /**
     * (experimental) Validates Server Migration Connector Id that was registered with AWS Connector Service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     *
     * @experimental
     */
    toValidateConnectorId(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
