import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [fis](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfaultinjectionsimulator.html).
 *
 * @experimental
 */
export declare class Fis extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create an AWS FIS experiment template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_CreateExperimentTemplate.html
     *
     * @experimental
     */
    toCreateExperimentTemplate(): this;
    /**
     * (experimental) Grants permission to delete the AWS FIS experiment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_DeleteExperimentTemplate.html
     *
     * @experimental
     */
    toDeleteExperimentTemplate(): this;
    /**
     * (experimental) Grants permission to retrieve an AWS FIS action.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetAction.html
     *
     * @experimental
     */
    toGetAction(): this;
    /**
     * (experimental) Grants permission to retrieve an AWS FIS experiment.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetExperiment.html
     *
     * @experimental
     */
    toGetExperiment(): this;
    /**
     * (experimental) Grants permission to retrieve an AWS FIS Experiment Template.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetExperimentTemplate.html
     *
     * @experimental
     */
    toGetExperimentTemplate(): this;
    /**
     * (experimental) Grants permission to inject an API internal error on the provided AWS service from an FIS Experiment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     * - .ifOperations()
     * - .ifPercentage()
     * - .ifTargets()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/Welcome.html
     *
     * @experimental
     */
    toInjectApiInternalError(): this;
    /**
     * (experimental) Grants permission to inject an API throttle error on the provided AWS service from an FIS Experiment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     * - .ifOperations()
     * - .ifPercentage()
     * - .ifTargets()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/Welcome.html
     *
     * @experimental
     */
    toInjectApiThrottleError(): this;
    /**
     * (experimental) Grants permission to inject an API unavailable error on the provided AWS service from an FIS Experiment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     * - .ifOperations()
     * - .ifPercentage()
     * - .ifTargets()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/Welcome.html
     *
     * @experimental
     */
    toInjectApiUnavailableError(): this;
    /**
     * (experimental) Grants permission to list all available AWS FIS actions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListActions.html
     *
     * @experimental
     */
    toListActions(): this;
    /**
     * (experimental) Grants permission to list all available AWS FIS experiment templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListExperimentTemplates.html
     *
     * @experimental
     */
    toListExperimentTemplates(): this;
    /**
     * (experimental) Grants permission to list all available AWS FIS experiments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListExperiments.html
     *
     * @experimental
     */
    toListExperiments(): this;
    /**
     * (experimental) Grants permission to list the tags for an AWS FIS resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to run an AWS FIS experiment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_StartExperiment.html
     *
     * @experimental
     */
    toStartExperiment(): this;
    /**
     * (experimental) Grants permission to stop an AWS FIS experiment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_StopExperiment.html
     *
     * @experimental
     */
    toStopExperiment(): this;
    /**
     * (experimental) Grants permission to tag AWS FIS resources.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag AWS FIS resources.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the specified AWS FIS experiment template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_UpdateExperimentTemplate.html
     *
     * @experimental
     */
    toUpdateExperimentTemplate(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type action to the statement.
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/actions.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAction(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type experiment to the statement.
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/experiments.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onExperiment(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type experiment-template to the statement.
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/working-with-templates.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onExperimentTemplate(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the list of operations on the AWS service that is being affected by the AWS FIS action.
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOperations(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the percentage of calls being affected by the AWS FIS action.
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifPercentage(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the AWS service that is being affected by the AWS FIS action.
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifService(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the list of resource ARNs being targeted by the AWS FIS action.
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTargets(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [fis](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfaultinjectionsimulator.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
