import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [iot1click](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot1-click.html).
 *
 * @experimental
 */
export declare class Iot1click extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to associate a device to a placement.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_AssociateDeviceWithPlacement.html
     *
     * @experimental
     */
    toAssociateDeviceWithPlacement(): this;
    /**
     * (experimental) Grants permission to claim a batch of devices with a claim code.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/claims-claimcode.html
     *
     * @experimental
     */
    toClaimDevicesByClaimCode(): this;
    /**
     * (experimental) Grants permission to create a new placement in a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_CreatePlacement.html
     *
     * @experimental
     */
    toCreatePlacement(): this;
    /**
     * (experimental) Grants permission to create a new project.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_CreateProject.html
     *
     * @experimental
     */
    toCreateProject(): this;
    /**
     * (experimental) Grants permission to delete a placement from a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_DeletePlacement.html
     *
     * @experimental
     */
    toDeletePlacement(): this;
    /**
     * (experimental) Grants permission to delete a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_DeleteProject.html
     *
     * @experimental
     */
    toDeleteProject(): this;
    /**
     * (experimental) Grants permission to describe a device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid.html
     *
     * @experimental
     */
    toDescribeDevice(): this;
    /**
     * (experimental) Grants permission to describe a placement.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_DescribePlacement.html
     *
     * @experimental
     */
    toDescribePlacement(): this;
    /**
     * (experimental) Grants permission to describe a project.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_DescribeProject.html
     *
     * @experimental
     */
    toDescribeProject(): this;
    /**
     * (experimental) Grants permission to disassociate a device from a placement.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_DissacociateDeviceFromPlacement.html
     *
     * @experimental
     */
    toDisassociateDeviceFromPlacement(): this;
    /**
     * (experimental) Grants permission to finalize a device claim.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid-finalize-claim.html
     *
     * @experimental
     */
    toFinalizeDeviceClaim(): this;
    /**
     * (experimental) Grants permission to get available methods of a device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid-methods.html
     *
     * @experimental
     */
    toGetDeviceMethods(): this;
    /**
     * (experimental) Grants permission to get devices associated to a placement.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_GetDevicesInPlacement.html
     *
     * @experimental
     */
    toGetDevicesInPlacement(): this;
    /**
     * (experimental) Grants permission to initialize a device claim.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid-initiate-claim.html
     *
     * @experimental
     */
    toInitiateDeviceClaim(): this;
    /**
     * (experimental) Grants permission to invoke a device method.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid-methods.html
     *
     * @experimental
     */
    toInvokeDeviceMethod(): this;
    /**
     * (experimental) Grants permission to list past events published by a device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid-events.html
     *
     * @experimental
     */
    toListDeviceEvents(): this;
    /**
     * (experimental) Grants permission to list all devices.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices.html
     *
     * @experimental
     */
    toListDevices(): this;
    /**
     * (experimental) Grants permission to list placements in a project.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_ListPlacements.html
     *
     * @experimental
     */
    toListPlacements(): this;
    /**
     * (experimental) Grants permission to list all projects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_ListProjects.html
     *
     * @experimental
     */
    toListProjects(): this;
    /**
     * (experimental) Grants permission to lists the tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to add or modify the tags of a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to unclaim a device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid-unclaim.html
     *
     * @experimental
     */
    toUnclaimDevice(): this;
    /**
     * (experimental) Grants permission to remove the given tags (metadata) from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update device state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/devices-deviceid-state.html
     *
     * @experimental
     */
    toUpdateDeviceState(): this;
    /**
     * (experimental) Grants permission to update a placement.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_UpdatePlacement.html
     *
     * @experimental
     */
    toUpdatePlacement(): this;
    /**
     * (experimental) Update a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_UpdateProject.html
     *
     * @experimental
     */
    toUpdateProject(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type device to the statement.
     *
     * https://docs.aws.amazon.com/iot-1-click/1.0/devices-apireference/resources.html
     *
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDevice(deviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type project to the statement.
     *
     * https://docs.aws.amazon.com/iot-1-click/latest/projects-apireference/API_Operations.html
     *
     * @param projectName - Identifier for the projectName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onProject(projectName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [iot1click](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot1-click.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
