import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
 *
 * @experimental
 */
export declare class LexV2 extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to build an existing bot locale in a bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_BuildBotLocale.html
     *
     * @experimental
     */
    toBuildBotLocale(): this;
    /**
     * (experimental) Grants permission to create a new bot and a test bot alias pointing to the DRAFT bot version.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html
     *
     * @experimental
     */
    toCreateBot(): this;
    /**
     * (experimental) Grants permission to create a new bot alias in a bot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotAlias.html
     *
     * @experimental
     */
    toCreateBotAlias(): this;
    /**
     * (experimental) Grants permission to create a bot channel in an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toCreateBotChannel(): this;
    /**
     * (experimental) Grants permission to create a new bot locale in an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotLocale.html
     *
     * @experimental
     */
    toCreateBotLocale(): this;
    /**
     * (experimental) Grants permission to create a new version of an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotVersion.html
     *
     * @experimental
     */
    toCreateBotVersion(): this;
    /**
     * (experimental) Grants permission to create an export for an existing resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateExport.html
     *
     * @experimental
     */
    toCreateExport(): this;
    /**
     * (experimental) Grants permission to create a new intent in an existing bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html
     *
     * @experimental
     */
    toCreateIntent(): this;
    /**
     * (experimental) Grants permission to create a new resource policy for a Lex resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateResourcePolicy.html
     *
     * @experimental
     */
    toCreateResourcePolicy(): this;
    /**
     * (experimental) Grants permission to create a new slot in an intent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateSlot.html
     *
     * @experimental
     */
    toCreateSlot(): this;
    /**
     * (experimental) Grants permission to create a new slot type in an existing bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateSlotType.html
     *
     * @experimental
     */
    toCreateSlotType(): this;
    /**
     * (experimental) Grants permission to create an upload url for import file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html
     *
     * @experimental
     */
    toCreateUploadUrl(): this;
    /**
     * (experimental) Grants permission to delete an existing bot.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteBotAlias
     * - lex:DeleteBotChannel
     * - lex:DeleteBotLocale
     * - lex:DeleteBotVersion
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html
     *
     * @experimental
     */
    toDeleteBot(): this;
    /**
     * (experimental) Grants permission to delete an existing bot alias in a bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotAlias.html
     *
     * @experimental
     */
    toDeleteBotAlias(): this;
    /**
     * (experimental) Grants permission to delete an existing bot channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toDeleteBotChannel(): this;
    /**
     * (experimental) Grants permission to delete an existing bot locale in a bot.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotLocale.html
     *
     * @experimental
     */
    toDeleteBotLocale(): this;
    /**
     * (experimental) Grants permission to delete an existing bot version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotVersion.html
     *
     * @experimental
     */
    toDeleteBotVersion(): this;
    /**
     * (experimental) Grants permission to delete an existing export.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteExport.html
     *
     * @experimental
     */
    toDeleteExport(): this;
    /**
     * (experimental) Grants permission to delete an existing import.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteImport.html
     *
     * @experimental
     */
    toDeleteImport(): this;
    /**
     * (experimental) Grants permission to delete an existing intent in a bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteIntent.html
     *
     * @experimental
     */
    toDeleteIntent(): this;
    /**
     * (experimental) Grants permission to delete an existing resource policy for a Lex resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteResourcePolicy.html
     *
     * @experimental
     */
    toDeleteResourcePolicy(): this;
    /**
     * (experimental) Grants permission to delete session information for a bot alias and user ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DeleteSession.html
     *
     * @experimental
     */
    toDeleteSession(): this;
    /**
     * (experimental) Grants permission to delete an existing slot in an intent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteSlot.html
     *
     * @experimental
     */
    toDeleteSlot(): this;
    /**
     * (experimental) Grants permission to delete an existing slot type in a bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteSlotType.html
     *
     * @experimental
     */
    toDeleteSlotType(): this;
    /**
     * (experimental) Grants permission to delete utterance data for a bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteUtterances.html
     *
     * @experimental
     */
    toDeleteUtterances(): this;
    /**
     * (experimental) Grants permission to retrieve an existing bot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBot.html
     *
     * @experimental
     */
    toDescribeBot(): this;
    /**
     * (experimental) Grants permission to retrieve an existing bot alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotAlias.html
     *
     * @experimental
     */
    toDescribeBotAlias(): this;
    /**
     * (experimental) Grants permission to retrieve an existing bot channel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toDescribeBotChannel(): this;
    /**
     * (experimental) Grants permission to retrieve an existing bot locale.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotLocale.html
     *
     * @experimental
     */
    toDescribeBotLocale(): this;
    /**
     * (experimental) Grants permission to retrieve an existing bot version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotVersion.html
     *
     * @experimental
     */
    toDescribeBotVersion(): this;
    /**
     * (experimental) Grants permission to retrieve an existing export.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lex:DescribeBot
     * - lex:DescribeBotLocale
     * - lex:DescribeIntent
     * - lex:DescribeSlot
     * - lex:DescribeSlotType
     * - lex:ListBotLocales
     * - lex:ListIntents
     * - lex:ListSlotTypes
     * - lex:ListSlots
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html
     *
     * @experimental
     */
    toDescribeExport(): this;
    /**
     * (experimental) Grants permission to retrieve an existing import.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html
     *
     * @experimental
     */
    toDescribeImport(): this;
    /**
     * (experimental) Grants permission to retrieve an existing intent.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeIntent.html
     *
     * @experimental
     */
    toDescribeIntent(): this;
    /**
     * (experimental) Grants permission to retrieve an existing resource policy for a Lex resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeResourcePolicy.html
     *
     * @experimental
     */
    toDescribeResourcePolicy(): this;
    /**
     * (experimental) Grants permission to retrieve an existing slot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeSlot.html
     *
     * @experimental
     */
    toDescribeSlot(): this;
    /**
     * (experimental) Grants permission to retrieve an existing slot type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeSlotType.html
     *
     * @experimental
     */
    toDescribeSlotType(): this;
    /**
     * (experimental) Grants permission to retrieve session information for a bot alias and user ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_GetSession.html
     *
     * @experimental
     */
    toGetSession(): this;
    /**
     * (experimental) Grants permission to list utterances and statistics for a bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html
     *
     * @experimental
     */
    toListAggregatedUtterances(): this;
    /**
     * (experimental) Grants permission to list bot aliases in an bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotAliases.html
     *
     * @experimental
     */
    toListBotAliases(): this;
    /**
     * (experimental) Grants permission to list bot channels.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toListBotChannels(): this;
    /**
     * (experimental) Grants permission to list bot locales in a bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotLocales.html
     *
     * @experimental
     */
    toListBotLocales(): this;
    /**
     * (experimental) Grants permission to list existing bot versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotVersions.html
     *
     * @experimental
     */
    toListBotVersions(): this;
    /**
     * (experimental) Grants permission to list existing bots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBots.html
     *
     * @experimental
     */
    toListBots(): this;
    /**
     * (experimental) Grants permission to list built-in intents.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInIntents.html
     *
     * @experimental
     */
    toListBuiltInIntents(): this;
    /**
     * (experimental) Grants permission to list built-in slot types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInSlotTypes.html
     *
     * @experimental
     */
    toListBuiltInSlotTypes(): this;
    /**
     * (experimental) Grants permission to list existing exports.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html
     *
     * @experimental
     */
    toListExports(): this;
    /**
     * (experimental) Grants permission to list existing imports.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html
     *
     * @experimental
     */
    toListImports(): this;
    /**
     * (experimental) Grants permission to list intents in a bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListIntents.html
     *
     * @experimental
     */
    toListIntents(): this;
    /**
     * (experimental) Grants permission to list slot types in a bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListSlotTypes.html
     *
     * @experimental
     */
    toListSlotTypes(): this;
    /**
     * (experimental) Grants permission to list slots in an intent.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListSlots.html
     *
     * @experimental
     */
    toListSlots(): this;
    /**
     * (experimental) Grants permission to lists tags for a Lex resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to create a new session or modify an existing session for a bot alias and user ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_PutSession.html
     *
     * @experimental
     */
    toPutSession(): this;
    /**
     * (experimental) Grants permission to send user input (text-only) to an bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html
     *
     * @experimental
     */
    toRecognizeText(): this;
    /**
     * (experimental) Grants permission to send user input (text or speech) to an bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html
     *
     * @experimental
     */
    toRecognizeUtterance(): this;
    /**
     * (experimental) Grants permission to stream user input (speech/text/DTMF) to a bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_StartConversation.html
     *
     * @experimental
     */
    toStartConversation(): this;
    /**
     * (experimental) Grants permission to start a new import with the uploaded import file.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - lex:CreateBot
     * - lex:CreateBotLocale
     * - lex:CreateIntent
     * - lex:CreateSlot
     * - lex:CreateSlotType
     * - lex:DeleteBotLocale
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     * - lex:UpdateBot
     * - lex:UpdateBotLocale
     * - lex:UpdateIntent
     * - lex:UpdateSlot
     * - lex:UpdateSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html
     *
     * @experimental
     */
    toStartImport(): this;
    /**
     * (experimental) Grants permission to add or overwrite tags of a Lex resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a Lex resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBot.html
     *
     * @experimental
     */
    toUpdateBot(): this;
    /**
     * (experimental) Grants permission to update an existing bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html
     *
     * @experimental
     */
    toUpdateBotAlias(): this;
    /**
     * (experimental) Grants permission to update an existing bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotLocale.html
     *
     * @experimental
     */
    toUpdateBotLocale(): this;
    /**
     * (experimental) Grants permission to update an existing export.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateExport.html
     *
     * @experimental
     */
    toUpdateExport(): this;
    /**
     * (experimental) Grants permission to update an existing intent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateIntent.html
     *
     * @experimental
     */
    toUpdateIntent(): this;
    /**
     * (experimental) Grants permission to update an existing resource policy for a Lex resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateResourcePolicy.html
     *
     * @experimental
     */
    toUpdateResourcePolicy(): this;
    /**
     * (experimental) Grants permission to update an existing slot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateSlot.html
     *
     * @experimental
     */
    toUpdateSlot(): this;
    /**
     * (experimental) Grants permission to update an existing slot type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateSlotType.html
     *
     * @experimental
     */
    toUpdateSlotType(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type bot to the statement.
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBot(botId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type bot alias to the statement.
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param botAliasId - Identifier for the botAliasId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBotAlias(botId: string, botAliasId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
