import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [machinelearning](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmachinelearning.html).
 *
 * @experimental
 */
export declare class Machinelearning extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Adds one or more tags to an object, up to a limit of 10.
     *
     * Each tag consists of a key and an optional value
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_AddTags.html
     *
     * @experimental
     */
    toAddTags(): this;
    /**
     * (experimental) Generates predictions for a group of observations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateBatchPrediction.html
     *
     * @experimental
     */
    toCreateBatchPrediction(): this;
    /**
     * (experimental) Creates a DataSource object from an Amazon RDS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRDS.html
     *
     * @experimental
     */
    toCreateDataSourceFromRDS(): this;
    /**
     * (experimental) Creates a DataSource from a database hosted on an Amazon Redshift cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRedshift.html
     *
     * @experimental
     */
    toCreateDataSourceFromRedshift(): this;
    /**
     * (experimental) Creates a DataSource object from S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromS3.html
     *
     * @experimental
     */
    toCreateDataSourceFromS3(): this;
    /**
     * (experimental) Creates a new Evaluation of an MLModel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateEvaluation.html
     *
     * @experimental
     */
    toCreateEvaluation(): this;
    /**
     * (experimental) Creates a new MLModel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateMLModel.html
     *
     * @experimental
     */
    toCreateMLModel(): this;
    /**
     * (experimental) Creates a real-time endpoint for the MLModel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateRealtimeEndpoint.html
     *
     * @experimental
     */
    toCreateRealtimeEndpoint(): this;
    /**
     * (experimental) Assigns the DELETED status to a BatchPrediction, rendering it unusable.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteBatchPrediction.html
     *
     * @experimental
     */
    toDeleteBatchPrediction(): this;
    /**
     * (experimental) Assigns the DELETED status to a DataSource, rendering it unusable.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteDataSource.html
     *
     * @experimental
     */
    toDeleteDataSource(): this;
    /**
     * (experimental) Assigns the DELETED status to an Evaluation, rendering it unusable.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteEvaluation.html
     *
     * @experimental
     */
    toDeleteEvaluation(): this;
    /**
     * (experimental) Assigns the DELETED status to an MLModel, rendering it unusable.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteMLModel.html
     *
     * @experimental
     */
    toDeleteMLModel(): this;
    /**
     * (experimental) Deletes a real time endpoint of an MLModel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteRealtimeEndpoint.html
     *
     * @experimental
     */
    toDeleteRealtimeEndpoint(): this;
    /**
     * (experimental) Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteTags.html
     *
     * @experimental
     */
    toDeleteTags(): this;
    /**
     * (experimental) Returns a list of BatchPrediction operations that match the search criteria in the request.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeBatchPredictions.html
     *
     * @experimental
     */
    toDescribeBatchPredictions(): this;
    /**
     * (experimental) Returns a list of DataSource that match the search criteria in the request.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeDataSources.html
     *
     * @experimental
     */
    toDescribeDataSources(): this;
    /**
     * (experimental) Returns a list of DescribeEvaluations that match the search criteria in the request.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeEvaluations.html
     *
     * @experimental
     */
    toDescribeEvaluations(): this;
    /**
     * (experimental) Returns a list of MLModel that match the search criteria in the request.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeMLModels.html
     *
     * @experimental
     */
    toDescribeMLModels(): this;
    /**
     * (experimental) Describes one or more of the tags for your Amazon ML object.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeTags.html
     *
     * @experimental
     */
    toDescribeTags(): this;
    /**
     * (experimental) Returns a BatchPrediction that includes detailed metadata, status, and data file information.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetBatchPrediction.html
     *
     * @experimental
     */
    toGetBatchPrediction(): this;
    /**
     * (experimental) Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetDataSource.html
     *
     * @experimental
     */
    toGetDataSource(): this;
    /**
     * (experimental) Returns an Evaluation that includes metadata as well as the current status of the Evaluation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetEvaluation.html
     *
     * @experimental
     */
    toGetEvaluation(): this;
    /**
     * (experimental) Returns an MLModel that includes detailed metadata, and data source information as well as the current status of the MLModel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetMLModel.html
     *
     * @experimental
     */
    toGetMLModel(): this;
    /**
     * (experimental) Generates a prediction for the observation using the specified ML Model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_Predict.html
     *
     * @experimental
     */
    toPredict(): this;
    /**
     * (experimental) Updates the BatchPredictionName of a BatchPrediction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateBatchPrediction.html
     *
     * @experimental
     */
    toUpdateBatchPrediction(): this;
    /**
     * (experimental) Updates the DataSourceName of a DataSource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateDataSource.html
     *
     * @experimental
     */
    toUpdateDataSource(): this;
    /**
     * (experimental) Updates the EvaluationName of an Evaluation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateEvaluation.html
     *
     * @experimental
     */
    toUpdateEvaluation(): this;
    /**
     * (experimental) Updates the MLModelName and the ScoreThreshold of an MLModel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateMLModel.html
     *
     * @experimental
     */
    toUpdateMLModel(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type batchprediction to the statement.
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#batch-predictions
     *
     * @param batchPredictionId - Identifier for the batchPredictionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onBatchprediction(batchPredictionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type datasource to the statement.
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#datasources
     *
     * @param datasourceId - Identifier for the datasourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDatasource(datasourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type evaluation to the statement.
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#evaluations
     *
     * @param evaluationId - Identifier for the evaluationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEvaluation(evaluationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type mlmodel to the statement.
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#ml-models
     *
     * @param mlModelId - Identifier for the mlModelId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onMlmodel(mlModelId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [machinelearning](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmachinelearning.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
