"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTestingExistingVpcSubnets = exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        // create a default keycloak workload with minimal required props
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
            keycloakVersion: index_1.KeycloakVersion.V15_0_2,
            auroraServerless: true,
            nodeCount: 2,
            autoScaleTask: {
                min: 2,
                max: 10,
                targetCpuUtilization: 60,
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
class IntegTestingExistingVpcSubnets {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
            keycloakVersion: index_1.KeycloakVersion.V15_0_2,
            vpc: ec2.Vpc.fromLookup(stack, 'Vpc', { vpcId: 'vpc-0417e46d' }),
            publicSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'pub-1a', 'subnet-5bbe7b32'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1b', 'subnet-0428367c'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1c', 'subnet-1586a75f'),
                ],
            },
            privateSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'priv-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
            databaseSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'db-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTestingExistingVpcSubnets = IntegTestingExistingVpcSubnets;
new IntegTesting();
// new IntegTestingExistingVpcSubnets();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMsbUNBQW9EO0FBRXBELE1BQWEsWUFBWTtJQUV2QjtRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBRTFCLE1BQU0sR0FBRyxHQUFHO1lBQ1YsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLElBQUksV0FBVztZQUNyRCxPQUFPLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUI7U0FDekMsQ0FBQztRQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUUzRCxpRUFBaUU7UUFDakUsSUFBSSxnQkFBUSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7WUFDOUIsY0FBYyxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxJQUFJLFVBQVU7WUFDdEUsZUFBZSxFQUFFLHVCQUFlLENBQUMsT0FBTztZQUN4QyxnQkFBZ0IsRUFBRSxJQUFJO1lBQ3RCLFNBQVMsRUFBRSxDQUFDO1lBQ1osYUFBYSxFQUFFO2dCQUNiLEdBQUcsRUFBRSxDQUFDO2dCQUNOLEdBQUcsRUFBRSxFQUFFO2dCQUNQLG9CQUFvQixFQUFFLEVBQUU7YUFDekI7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdkIsQ0FBQztDQUNGO0FBM0JELG9DQTJCQztBQUdELE1BQWEsOEJBQThCO0lBRXpDO1FBQ0UsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7UUFFMUIsTUFBTSxHQUFHLEdBQUc7WUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7WUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO1NBQ3pDLENBQUM7UUFFRixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLGVBQWUsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7UUFFM0QsSUFBSSxnQkFBUSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7WUFDOUIsY0FBYyxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxJQUFJLFVBQVU7WUFDdEUsZUFBZSxFQUFFLHVCQUFlLENBQUMsT0FBTztZQUN4QyxHQUFHLEVBQUUsR0FBRyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFLEtBQUssRUFBRSxjQUFjLEVBQUUsQ0FBQztZQUNoRSxhQUFhLEVBQUU7Z0JBQ2IsT0FBTyxFQUFFO29CQUNQLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUUsaUJBQWlCLENBQUM7b0JBQzNELEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUUsaUJBQWlCLENBQUM7b0JBQzNELEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUUsaUJBQWlCLENBQUM7aUJBQzVEO2FBQ0Y7WUFDRCxjQUFjLEVBQUU7Z0JBQ2QsT0FBTyxFQUFFO29CQUNQLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsMEJBQTBCLENBQUM7b0JBQ3JFLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsMEJBQTBCLENBQUM7b0JBQ3JFLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsMEJBQTBCLENBQUM7aUJBQ3RFO2FBQ0Y7WUFDRCxlQUFlLEVBQUU7Z0JBQ2YsT0FBTyxFQUFFO29CQUNQLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsMEJBQTBCLENBQUM7b0JBQ25FLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsMEJBQTBCLENBQUM7b0JBQ25FLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsMEJBQTBCLENBQUM7aUJBQ3BFO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdkIsQ0FBQztDQUNGO0FBeENELHdFQXdDQztBQUVELElBQUksWUFBWSxFQUFFLENBQUM7QUFFbkIsd0NBQXdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWMyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgS2V5Q2xvYWssIEtleWNsb2FrVmVyc2lvbiB9IGZyb20gJy4vaW5kZXgnO1xuXG5leHBvcnQgY2xhc3MgSW50ZWdUZXN0aW5nIHtcbiAgcmVhZG9ubHkgc3RhY2s6IGNkay5TdGFja1tdO1xuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBjb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG4gICAgY29uc3QgZW52ID0ge1xuICAgICAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04gfHwgJ3VzLWVhc3QtMScsXG4gICAgICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxuICAgIH07XG5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAna2V5Y2xvYWstZGVtbycsIHsgZW52IH0pO1xuXG4gICAgLy8gY3JlYXRlIGEgZGVmYXVsdCBrZXljbG9hayB3b3JrbG9hZCB3aXRoIG1pbmltYWwgcmVxdWlyZWQgcHJvcHNcbiAgICBuZXcgS2V5Q2xvYWsoc3RhY2ssICdLZXlDbG9haycsIHtcbiAgICAgIGNlcnRpZmljYXRlQXJuOiBzdGFjay5ub2RlLnRyeUdldENvbnRleHQoJ0FDTV9DRVJUX0FSTicpIHx8ICdNT0NLX0FSTicsXG4gICAgICBrZXljbG9ha1ZlcnNpb246IEtleWNsb2FrVmVyc2lvbi5WMTVfMF8yLFxuICAgICAgYXVyb3JhU2VydmVybGVzczogdHJ1ZSxcbiAgICAgIG5vZGVDb3VudDogMixcbiAgICAgIGF1dG9TY2FsZVRhc2s6IHtcbiAgICAgICAgbWluOiAyLFxuICAgICAgICBtYXg6IDEwLFxuICAgICAgICB0YXJnZXRDcHVVdGlsaXphdGlvbjogNjAsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5zdGFjayA9IFtzdGFja107XG4gIH1cbn1cblxuXG5leHBvcnQgY2xhc3MgSW50ZWdUZXN0aW5nRXhpc3RpbmdWcGNTdWJuZXRzIHtcbiAgcmVhZG9ubHkgc3RhY2s6IGNkay5TdGFja1tdO1xuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBjb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG4gICAgY29uc3QgZW52ID0ge1xuICAgICAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04sXG4gICAgICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxuICAgIH07XG5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAna2V5Y2xvYWstZGVtbycsIHsgZW52IH0pO1xuXG4gICAgbmV3IEtleUNsb2FrKHN0YWNrLCAnS2V5Q2xvYWsnLCB7XG4gICAgICBjZXJ0aWZpY2F0ZUFybjogc3RhY2subm9kZS50cnlHZXRDb250ZXh0KCdBQ01fQ0VSVF9BUk4nKSB8fCAnTU9DS19BUk4nLFxuICAgICAga2V5Y2xvYWtWZXJzaW9uOiBLZXljbG9ha1ZlcnNpb24uVjE1XzBfMixcbiAgICAgIHZwYzogZWMyLlZwYy5mcm9tTG9va3VwKHN0YWNrLCAnVnBjJywgeyB2cGNJZDogJ3ZwYy0wNDE3ZTQ2ZCcgfSksXG4gICAgICBwdWJsaWNTdWJuZXRzOiB7XG4gICAgICAgIHN1Ym5ldHM6IFtcbiAgICAgICAgICBlYzIuU3VibmV0LmZyb21TdWJuZXRJZChzdGFjaywgJ3B1Yi0xYScsICdzdWJuZXQtNWJiZTdiMzInKSxcbiAgICAgICAgICBlYzIuU3VibmV0LmZyb21TdWJuZXRJZChzdGFjaywgJ3B1Yi0xYicsICdzdWJuZXQtMDQyODM2N2MnKSxcbiAgICAgICAgICBlYzIuU3VibmV0LmZyb21TdWJuZXRJZChzdGFjaywgJ3B1Yi0xYycsICdzdWJuZXQtMTU4NmE3NWYnKSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgICBwcml2YXRlU3VibmV0czoge1xuICAgICAgICBzdWJuZXRzOiBbXG4gICAgICAgICAgZWMyLlN1Ym5ldC5mcm9tU3VibmV0SWQoc3RhY2ssICdwcml2LTFhJywgJ3N1Ym5ldC0wZTk0NjBkYmNmYzRjZjZlZScpLFxuICAgICAgICAgIGVjMi5TdWJuZXQuZnJvbVN1Ym5ldElkKHN0YWNrLCAncHJpdi0xYicsICdzdWJuZXQtMDU2MmY2NjZiZGY1YzI5YWYnKSxcbiAgICAgICAgICBlYzIuU3VibmV0LmZyb21TdWJuZXRJZChzdGFjaywgJ3ByaXYtMWMnLCAnc3VibmV0LTAwYWIxNWMwMDIyODcyZjA2JyksXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgICAgZGF0YWJhc2VTdWJuZXRzOiB7XG4gICAgICAgIHN1Ym5ldHM6IFtcbiAgICAgICAgICBlYzIuU3VibmV0LmZyb21TdWJuZXRJZChzdGFjaywgJ2RiLTFhJywgJ3N1Ym5ldC0wZTk0NjBkYmNmYzRjZjZlZScpLFxuICAgICAgICAgIGVjMi5TdWJuZXQuZnJvbVN1Ym5ldElkKHN0YWNrLCAnZGItMWInLCAnc3VibmV0LTA1NjJmNjY2YmRmNWMyOWFmJyksXG4gICAgICAgICAgZWMyLlN1Ym5ldC5mcm9tU3VibmV0SWQoc3RhY2ssICdkYi0xYycsICdzdWJuZXQtMDBhYjE1YzAwMjI4NzJmMDYnKSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgdGhpcy5zdGFjayA9IFtzdGFja107XG4gIH1cbn1cblxubmV3IEludGVnVGVzdGluZygpO1xuXG4vLyBuZXcgSW50ZWdUZXN0aW5nRXhpc3RpbmdWcGNTdWJuZXRzKCk7XG5cbiJdfQ==