#!/usr/bin/env python3
#
# GlobalChem - FDA List One
#
# -------------------------

class FDAListOne(object):

    def __init__(self):

        self.name = 'fda_list_one'

    @staticmethod
    def get_smiles():

        smiles = {
            'fd&c blue #1': r'[Na+].[Na+].[O-]S(=O)(=O)c1cccc(c1)CN(c2ccc(cc2)/C(=C4/C=CC(=[N+](CC)Cc3cccc(c3)S([O-])(=O)=O)/C=C/4)c5ccccc5S([O-])(=O)=O)CC',
            'fd&c blue #1 Aluminum Lake': 'CCN(CC1=CC(=CC=C1)S(=O)(=O)[O-])C2=CC=C(C=C2)C(=C3C=CC(=[N+](CC)CC4=CC(=CC=C4)S(=O)(=O)[O-])C=C3)C5=CC=CC=C5S(=O)(=O)[O-].CCN(CC1=CC(=CC=C1)S(=O)(=O)[O-])C2=CC=C(C=C2)C(=C3C=CC(=[N+](CC)CC4=CC(=CC=C4)S(=O)(=O)[O-])C=C3)C5=CC=CC=C5S(=O)(=O)[O-].CCN(CC1=CC(=CC=C1)S(=O)(=O)[O-])C2=CC=C(C=C2)C(=C3C=CC(=[N+](CC)CC4=CC(=CC=C4)S(=O)(=O)[O-])C=C3)C5=CC=CC=C5S(=O)(=O)[O-].[Al+3].[Al+3]',
            'fd&c blue #2': 'C1=CC(=CC=C1C2=CC=C(C=C2)N=NC3=C(C=C4C=CC(=CC4=C3O)N)S(=O)(=O)[O-])N=NC5=C(C6=C(C=C(C=C6C=C5S(=O)(=O)[O-])S(=O)(=O)[O-])N)O.[Na+].[Na+].[Na+]',
            'fd&c blue #2 Aluminum Lake on alumina': 'O=S(c1ccc2c(C(/C(N2)=C3C(c4c(N/3)ccc(S(=O)([O-])=O)c4)=O)=O)c1)([O-])=O.O=S(c5ccc6c(C(/C(N6)=C7C(c8c(N/7)ccc(S(=O)([O-])=O)c8)=O)=O)c5)([O-])=O.O=S(c9ccc%10c(C(/C(N%10)=C%11C(c%12c(N/%11)ccc(S(=O)([O-])=O)c%12)=O)=O)c9)([O-])=O.[AlH3+3].[AlH3+3]',
            'fd&c green #3': 'CCN(CC1=CC(=CC=C1)S(=O)(=O)O)C2=CC=C(C=C2)C(=C3C=CC(=[N+](CC)CC4=CC(=CC=C4)S(=O)(=O)O)C=C3)C5=CC=CC=C5',
            'fd&c red #3': '[Na+].[Na+].[O-]C(=O)C1=CC=CC=C1C1=C2C=C(I)C(=O)C(I)=C2OC2=C(I)C([O-])=C(I)C=C12',
            'fd&c red #40 and its Aluminum Lake': 'CC1=CC(=C(C=C1S(=O)(=O)[O-])OC)N=NC2=C(C=CC3=C2C=CC(=C3)S(=O)(=O)[O-])O.[AlH3+3]',
            'fd&c yellow #5': 'C1=CC(=CC=C1N=NC2C(=NN(C2=O)C3=CC=C(C=C3)S(=O)(=O)[O-])C(=O)[O-])S(=O)(=O)[O-].[Na+].[Na+].[Na+]',
            'fd&c yellow #5 Aluminum Lake': 'C1=CC(=CC=C1N=NC2C(=NN(C2=O)C3=CC=C(C=C3)S(=O)(=O)[O-])C(=O)[O-])S(=O)(=O)[O-].[AlH3+3]',
            'fd&c yellow #6': 'C1=CC(=CC=C1N=NC2=C(C=CC3=C2C=CC(=C3)S(=O)(=O)[O-])O)S(=O)(=O)[O-].[Na+].[Na+]',
            'fd&c lakes': '[AlH3+3].[Ca+2]',
            'citrus red #2': 'COC1=CC(=C(C=C1)OC)N=NC2=C(C=CC3=CC=CC=C32)O',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'fd&c blue #1': '[Na+].[Na+].[#8-]-[#16](=[#8])(=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6](:[#6]:1)-[#6]-[#7](-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#6]1-[#6]=[#6]-[#6](=[#7+](-[#6]-[#6])-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6](:[#6]:2)-[#16](-[#8-])(=[#8])=[#8])-[#6]=[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#16](-[#8-])(=[#8])=[#8])-[#6]-[#6]',
            'fd&c blue #1 aluminum lake': '[#6]-[#6]-[#7](-[#6]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8-])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#6]1-[#6]=[#6]-[#6](=[#7+](-[#6]-[#6])-[#6]-[#6]2:[#6]:[#6](:[#6]:[#6]:[#6]:2)-[#16](=[#8])(=[#8])-[#8-])-[#6]=[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#16](=[#8])(=[#8])-[#8-].[#6]-[#6]-[#7](-[#6]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8-])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#6]1-[#6]=[#6]-[#6](=[#7+](-[#6]-[#6])-[#6]-[#6]2:[#6]:[#6](:[#6]:[#6]:[#6]:2)-[#16](=[#8])(=[#8])-[#8-])-[#6]=[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#16](=[#8])(=[#8])-[#8-].[#6]-[#6]-[#7](-[#6]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8-])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#6]1-[#6]=[#6]-[#6](=[#7+](-[#6]-[#6])-[#6]-[#6]2:[#6]:[#6](:[#6]:[#6]:[#6]:2)-[#16](=[#8])(=[#8])-[#8-])-[#6]=[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#16](=[#8])(=[#8])-[#8-].[Al+3].[Al+3]',
            'fd&c blue #2': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7]=[#7]-[#6]1:[#6](:[#6]:[#6]2:[#6]:[#6]:[#6](:[#6]:[#6]:2:[#6]:1-[#8])-[#7])-[#16](=[#8])(=[#8])-[#8-])-[#7]=[#7]-[#6]1:[#6](:[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#6]:[#6]:1-[#16](=[#8])(=[#8])-[#8-])-[#16](=[#8])(=[#8])-[#8-])-[#7])-[#8].[Na+].[Na+].[Na+]',
            'fd&c blue #2 aluminum lake on alumina': '[#8]=[#16](-[#6]1:[#6]:[#6]:[#6]2:[#6](-[#6](/[#6](-[#7]-2)=[#6]2/[#6](-[#6]3:[#6](-[#7]-2):[#6]:[#6]:[#6](-[#16](=[#8])(-[#8-])=[#8]):[#6]:3)=[#8])=[#8]):[#6]:1)(-[#8-])=[#8].[#8]=[#16](-[#6]1:[#6]:[#6]:[#6]2:[#6](-[#6](/[#6](-[#7]-2)=[#6]2/[#6](-[#6]3:[#6](-[#7]-2):[#6]:[#6]:[#6](-[#16](=[#8])(-[#8-])=[#8]):[#6]:3)=[#8])=[#8]):[#6]:1)(-[#8-])=[#8].[#8]=[#16](-[#6]1:[#6]:[#6]:[#6]2:[#6](-[#6](/[#6](-[#7]-2)=[#6]2/[#6](-[#6]3:[#6](-[#7]-2):[#6]:[#6]:[#6](-[#16](=[#8])(-[#8-])=[#8]):[#6]:3)=[#8])=[#8]):[#6]:1)(-[#8-])=[#8].[AlH3+3].[AlH3+3]',
            'fd&c green #3': '[#6]-[#6]-[#7](-[#6]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#6]1-[#6]=[#6]-[#6](=[#7+](-[#6]-[#6])-[#6]-[#6]2:[#6]:[#6](:[#6]:[#6]:[#6]:2)-[#16](=[#8])(=[#8])-[#8])-[#6]=[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'fd&c red #3': '[Na+].[Na+].[#8-]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]1:[#6]2:[#6]:[#6](-[#53]):[#6](=[#8]):[#6](-[#53]):[#6]-2:[#8]:[#6]2:[#6](-[#53]):[#6](-[#8-]):[#6](-[#53]):[#6]:[#6]:1:2',
            'fd&c red #40 and its aluminum lake': '[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#16](=[#8])(=[#8])-[#8-])-[#8]-[#6])-[#7]=[#7]-[#6]1:[#6](:[#6]:[#6]:[#6]2:[#6]:1:[#6]:[#6]:[#6](:[#6]:2)-[#16](=[#8])(=[#8])-[#8-])-[#8].[AlH3+3]',
            'fd&c yellow #5': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#7]=[#7]-[#6]1-[#6](=[#7]-[#7](-[#6]-1=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8-])-[#6](=[#8])-[#8-])-[#16](=[#8])(=[#8])-[#8-].[Na+].[Na+].[Na+]',
            'fd&c yellow #5 aluminum lake': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#7]=[#7]-[#6]1-[#6](=[#7]-[#7](-[#6]-1=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8-])-[#6](=[#8])-[#8-])-[#16](=[#8])(=[#8])-[#8-].[AlH3+3]',
            'fd&c yellow #6': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#7]=[#7]-[#6]1:[#6](:[#6]:[#6]:[#6]2:[#6]:1:[#6]:[#6]:[#6](:[#6]:2)-[#16](=[#8])(=[#8])-[#8-])-[#8])-[#16](=[#8])(=[#8])-[#8-].[Na+].[Na+]',
            'fd&c lakes': '[AlH3+3].[Ca+2]',
            'citrus red #2': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#7]=[#7]-[#6]1:[#6](:[#6]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#8]',
        }

        return smarts