#!/usr/bin/env python3
#
# GlobalChem - Constituents OfCannabisSativa
#
# -----------------------------------

class ConstituentsOfCannabisSativa(object):

    def __init__(self):

        self.name = 'constituents_of_cannabis_sativa'

    @staticmethod
    def get_smiles():

        '''

        Missing Entries:

            'tetano-cannabine': '',
            'edestinase': '',
            'peptidase': '',
            '1-octene-3-01': '',
            '2-c-methylaldotetronic': '',
            '2-c-methyl aldotetronolactone': '',
            'campes-4-en-3-one': '',
            'cannabidhydrophenanthrene': '',
            'isovitesin-7-O-giucoara binoside': '',
            'isovitexin-O-glucoside': '',
            'cannabicurmaronone': '',
            '2"-O-glucopyranosylorientin': '',
            'orientin-7-O-glucoside': '',

        '''

        smiles = {
            'cannabigerolic acid': r'CCCCCC1=CC(=C(C(=C1C(=O)O)O)C/C=C(\C)/CCC=C(C)C)O',
            'cannabigerolic acid monomethylether': r'CCCCCC1=CC(=C(C(=C1C(=O)O)O)C/C=C(\C)/CCC=C(C)C)OC',
            'cannabigerol': r'CCCCCC1=CC(=C(C(=C1)O)C/C=C(\C)/CCC=C(C)C)O',
            'cannabigerol monomethylether': r'CCCCCC1=CC(=C(C(=C1C(=O)O)O)C/C=C(\C)/CCC=C(C)C)OC',
            'cannabigerovarinic acid': 'CCCC1=CC(=C(C(=C1C(=O)O)O)CC=C(C)CCC=C(C)C)O',
            'cannabigerovarin': r'CCCC1=CC(=C(C(=C1)O)C/C=C(\C)/CCC=C(C)C)O',
            'cannabichromenic acid': 'CCCCCC1=CC2=C(C=CC(O2)(C)CCC=C(C)C)C(=C1C(=O)O)O',
            'cannabichromene': 'CCCCCC1=CC(=C2C=CC(OC2=C1)(C)CCC=C(C)C)O',
            'cannabichromevarinic acid': 'CCCC1=CC(=C2C=CC(OC2=C1)(C)CCC=C(C)C)O',
            'cannabichromevarin': 'CCCC1=CC(=C2C=CC(OC2=C1)(C)CCC=C(C)C)O',
            'cannabidiolic acid': 'CCCCCC1=CC(=C(C(=C1C(=O)O)O)C2C=C(CCC2C(=C)C)C)O',
            'cannabidiol': 'CCCCCC1=CC(=C(C(=C1)O)C2C=C(CCC2C(=C)C)C)O',
            'cannabidiol monomethylether': 'CCCCCC1=CC(=C(C(=C1)OC)C2C=C(CCC2C(=C)C)C)O',
            'cannabidiol c4': 'CCCCC1=CC2=C(C=C1)C(OC3=CC(=CC(=C32)O)C)(C)C',
            'cannabidivarinic acid': 'CCCC1=CC(=C(C(=C1C(=O)O)O)C2C=C(CCC2C(=C)C)C)O',
            'cannabidivarin': 'CCCC1=CC(=C(C(=C1)O)C2C=C(CCC2C(=C)C)C)O',
            'cannabidiorcol': 'CC1=CC(C(CC1)C(=C)C)C2=C(C=C(C=C2O)C)O',
            'delta-9 tetrahgdrocannabinolic acid a': 'CCCCCC1=CC2=C(C3C=C(CCC3C(O2)(C)C)C)C(=C1C(=O)O)O',
            'delta-9 tetrahgdrocannabinolic acid b': 'CCCCCC1=CC(=C2C3C=C(CCC3C(OC2=C1C(=O)O)(C)C)C)O',
            'delta-9 tetrahydrocannabinol': 'CCCCC1=CC(=C2C3C=C(CCC3C(OC2=C1)(C)C)C)O',
            'detla-9 tetrahvdrocannabinolic acid c': 'CCCCC1=CC2=C(C3C=C(CCC3C(O2)(C)C)C)C(=C1C(=O)O)O',
            'delta-9 tetrahydrocannabinol c4': 'CCCCC1=CC(=C2C3C=C(CCC3C(OC2=C1)(C)C)C)O',
            'delta-9 tetrahydrocannabivarinic acid': 'CCCC1=CC2=C(C3C=C(CCC3C(O2)(C)C)C)C(=C1C(=O)O)O',
            'delta-9 tetrahydrocannabivarin': 'CCCC1=CC(=C2C3C=C(CCC3C(OC2=C1)(C)C)C)O',
            'delta-9 tetrahydrocannabiorcolic acid': 'CC1=CC2=C(C3C=C(CCC3C(O2)(C)C)C)C(=C1C(=O)O)O',
            'detla-9 tetrahydrocannabiorcol': 'CC1=CC(=C2C3C=C(CCC3C(OC2=C1)(C)C)C)O',
            'detla-8 tetrahydrocannabinolic acid': 'CCCCCC1=CC2=C(C3CC(=CCC3C(O2)(C)C)C)C(=C1C(=O)O)O',
            'delta-8 tetrahydrocannabinol': 'CCCCCC1=CC(=C2C3CC(=CCC3C(OC2=C1)(C)C)C)O',
            'cannabicyclolic acid': 'CCCCCC1=CC2=C(C3C4C(C3(C)C)CCC4(O2)C)C(=C1C(=O)O)O',
            'cannabicyclol': 'CCCCCC1=CC(=C2C3C4C(C3(C)C)CCC4(OC2=C1)C)O',
            'cannabicyclovarin': 'CCCC1=CC(=C2C3C4C(C3(C)C)CCC4(OC2=C1)C)O',
            'cannabielsoic acid a': 'CCCCCC1=CC2=C(C3C(CCC(C3O2)(C)O)C(=C)C)C(=C1C(=O)O)O',
            'cannabielsoic acid b': 'CCCCCC1=CC(=C2C3C(CCC(C3OC2=C1C(=O)O)(C)O)C(=C)C)O',
            'cannabielsoin': 'CCCCCC1=CC(=C2C3C(CCC(C3OC2=C1)(C)O)C(=C)C)O',
            'cannabinolic acid a': 'CCCCCC1=CC2=C(C3=C(C=CC(=C3)C)C(O2)(C)C)C(=C1C(=O)O)O',
            'cannabinol': 'CCCCCC1=CC(=C2C(=C1)OC(C3=C2C=C(C=C3)C)(C)C)O',
            'cannabinol methylether': 'CCCCCC1=CC2=C(C(=C1)OC)C3=C(C=CC(=C3)C)C(O2)(C)C',
            'cannabinol c4': 'CCCCC1=CC2=C(C=C1)C(OC3=CC(=CC(=C32)O)C)(C)C',
            'cannabivarin': 'CCCC1=CC(=C2C(=C1)OC(C3=C2C=C(C=C3)C)(C)C)O',
            'cannabiorcol': 'CC1=CC2=C(C=C1)C(OC3=CC(=CC(=C32)O)C)(C)',
            'cannabinodiol': 'CCCCCC1=CC(=C(C(=C1)O)C2=C(C=CC(=C2)C)C(=C)C)O',
            'cannabinodivarin': 'CCCC1=CC(=C(C(=C1)O)C2=C(C=CC(=C2)C)C(=C)C)O',
            'cannabitriol': 'CCCCCC1=CC(=C2C(=C1)OC(C3=C2C(C(CC3)(C)O)O)(C)C)O',
            '9,10-dihydroxy-delta-6a,10a-tetrahydrocannabinol': 'CCCCCC1=CC(O)=C2C(OC(C)(C)C3=C2C(O)C(C)(O)CC3)=C1',
            '10-ethoxy-9-hydroxy-delta-6a,10a-tetrahydrocannabinol': 'CCCCCC1=CC(O)=C2C(OC(C)(C)C3=C2C(OCC)C(C)(O)CC3)=C1',
            '8,9-dihydroxy-delta-tetrahydrocannabinol': 'CCCCCC1=CC(O)=C2C(OC(C)(C)C3=C2CC(C)(O)C(O)C3)=C1',
            'cannabidiolic acid tetrahydrocannabitriol ester ': 'CCCCCC1=CC(=C2C(=C1)OC(C3=C2C(C(C(C3)OC(=O)C4=C(C(=C(C=C4CCCCC)O)C5C=C(CCC5C(=C)C)C)O)C)O)(C)C)O',
            'dehydrocannabifuran': 'CCCCCC1=CC(=C2C(=C1)OC3=C(C=CC(=C23)C(=C)C)C)O',
            'cannabifuran': 'CCCCCC1=CC(=C2C(=C1)OC3=C(C=CC(=C23)C(C)C)C)O',
            'cannabichromanon': 'CCCCCC1=CC(=C2C(=C1)OC(C(C2=O)CCC(=O)C)(C)C)O',
            'cannabicitran': 'CCCCCC1=CC2=C3C4CC(CCC4C(O2)(C)C)(OC3=C1)C',
            '10-oxo-delta-6a,10a-tetrahydrocannabinol': 'CCCCCC1=CC(O)=C2C(OC(C)(C)C3=C2C(=O)C(C)CC3)=C1',
            'delta-9 6a,10a-tetrahydrocannabinol': 'CCCCCC1=CC(O)=C2C(OC(C)(C)C3=C2CC(C)(O)C(O)C3)=C1',
            '3,4,5,6-tetrahydro-7-hydroxy-alpha,alpha-2-trimethyl-9-n-propyl-2,6-methano-2H-1-benzoxocin-5-methanol': 'CCCC1=CC(=C2C3CC(CCC3C(C)(C)O)(OC2=C1)C)O',
            '6a,9,10,10a-9,10-dihydroxyhexahydrocannabinol': 'CCCCCC1=CC(=C2C3C(CCC(C3O)(C)O)C(OC2=C1)(C)C)O',
            '6a,7,10a-trihydroxy-delta-9 tetrahydrocannabinol': 'CCCCCC1=CC(=C2C3(O)C=C(CC(O)C3(O)C(OC2=C1)(C)C)C)O',
            'choline': 'C[N+](C)(C)CCO',
            'trigonelline': 'C[N+]1=CC=CC(=C1)C(=O)[O-]',
            'muscarine': 'CC1C(CC(O1)C[N+](C)(C)C)O',
            'l-plus isoleucine betaine': 'C[N+](C)(C)CC(=O)[O-]',
            'neurine': 'C[N+](C)(C)C=C.[OH-]',
            'piperidine': 'C1CCNCC1',
            'hordenine': 'CN(C)CCC1=CC=C(C=C1)O',
            'ammonia': 'N',
            'methylamine': 'CN',
            'ethylamine': 'CCN',
            'n-propylamine': 'CCCN',
            'n-butylamine': 'CCCCN',
            'iso-butylamine': 'CC(C)CN',
            'secbutylamine': 'CCC(C)N',
            'dimethylamine': 'CNC',
            'pyrrolidine': 'C1CCNC1',
            'cannabisativine': 'CCCCCC(C(C1C=CCC2N1CCCNCCCCNC(=O)C2)O)O',
            'anhydrocannabisativine': 'CC1(C(C(O)C2CCCC2)O)C=CCC(C3)N1CCCNCCCCNC3=O',
            'alanine': 'CC(C(=O)O)N',
            'asparatic acid': 'C(C(C(=O)O)N)C(=O)O',
            'cystine': 'C(C(C(=O)O)N)SSCC(C(=O)O)N',
            'glutamic acid': 'CCC(O)=O',
            'glycine': 'C(C(=O)O)N',
            'serine': 'C(C(C(=O)O)N)O',
            'arginine': 'C(CC(C(=O)O)N)CN=C(N)N',
            'histidine': 'C1=C(NC=N1)CC(C(=O)O)N',
            'isoleucine': 'CCC(C)C(C(=O)O)N',
            'leucine': 'CC(C)CC(C(=O)O)N',
            'lysine': 'C(CCN)CC(C(=O)O)N',
            'methionine': 'CSCCC(C(=O)O)N',
            'phenylalanine': 'C1=CC=C(C=C1)CC(C(=O)O)N',
            'proline': 'C1CC(NC1)C(=O)O',
            'threonine': 'CC(C(C(=O)O)N)O',
            'tryptophan': 'C1=CC=C2C(=C1)C(=CN2)CC(C(=O)O)N',
            'tyrosine': 'C1=CC(=CC=C1CC(C(=O)O)N)O',
            'valine': 'CC(C)C(C(=O)O)N',
            'edestin': 'NC(CCSC)C(NC(C)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CO)C(NC(CC(C)C)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CS)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC([H])C(NC(C(C)([H])O)C(NC(CO)C(NC(C)C(NC(C(CC)([H])C)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CCC(N)=O)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CS)C(NC(CCC(N)=O)C(NC(C(CC)([H])C)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(CCC(O)=O)C(NC(C)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(CCC(O)=O)C(NC(C)C(NC(CCC(O)=O)C(NC(C)C(NC([H])C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CCC(O)=O)C(NC(CO)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(CC1=CNC=N1)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(CS)C(NC(C)C(NC([H])C(NC(C(C)C)C(NC(C)C(NC(C(C)C)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CC(N)=O)C(NC([H])C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(C(CC)([H])C)C(NC(C(C)C)C(NC(CCCCN)C(NC([H])C(NC(CCCCNC(N)=N)C(NC([H])C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC([H])C(NC(C(C)C)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(C2CCCN2)C(NC([H])C(NC(CS)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CO)C(NC(CCC(N)=O)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CCC(N)=O)C(NC([H])C(NC(CCC(N)=O)C(NC([H])C(NC(CCC(N)=O)C(NC(CO)C(NC(CCC(N)=O)C(NC([H])C(NC(CO)C(NC(CCC(N)=O)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CC1=CNC=N1)C(NC(CCC(N)=O)C(NC(CCCCN)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CC1=CNC=N1)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC([H])C(NC(CC(O)=O)C(NC(C(CC)([H])C)C(NC(C(C)C)C(NC(C)C(NC(C(CC)([H])C)C(NC(C2CCCN2)C(NC(C)C(NC([H])C(NC(C(C)C)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC([H])C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CO)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(CO)C(NC(CC(N)=O)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(C)C(NC([H])C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CCC(O)=O)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC([H])C(NC([H])C(NC(CCCCNC(N)=N)C(NC([H])C(NC(C)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CCC(O)=O)C(NC([H])C(NC(CCCCNC(N)=N)C(NC(CC1=CNC=N1)C(NC(CO)C(NC(CO)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCNC(N)=N)C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC([H])C(NC(CC1=CC=CC=C1)C(NC(CC(N)=O)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CC(N)=O)C(NC(C(C)C)C(NC(CC(O)=O)C(NC(CO)C(NC(CCC(O)=O)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CCCCN)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC([H])C(NC(CCC(N)=O)C(NC(CC(N)=O)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CC(N)=O)C(NC(CO)C(NC(C(CC)([H])C)C(NC(C(CC)([H])C)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(CCCCN)C(NC([H])C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CO)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CO)C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CC1=CNC=N1)C(NC(CCC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(C(CC)([H])C)C(NC(CCC(O)=O)C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CCSC)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC([H])C(NC([H])C(NC(CCCCNC(N)=N)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(C)C(NC(CC(N)=O)C(NC([H])C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CS)C(NC(CO)C(NC(CCSC)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC([H])C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(C)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CC1=CC=CC=C1)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(CCC(N)=O)C(NC(C)C(NC([H])C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(CO)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CO)C(NC(C)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(C(C)C)C(NC(CC(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCN)C(NC(CC(N)=O)C(NC(C)C(NC(C(CC)([H])C)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(CC1=CNC=N1)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(N)=O)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(C)C(NC(CC1=CNC=N1)C(NC(CO)C(NC(C(C)C)C(NC(CCSC)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)C)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CCCCNC(N)=N)C(NC(C)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(CCC(N)=O)C(NC(C(C)C)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CC1=CNC=N1)C(NC(CCSC)C(NC([H])C(NC(CCC(N)=O)C(NC(CCCCN)C(NC(CS)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC([H])C(NC(CCC(O)=O)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC([H])C(NC(CCC(N)=O)C(NC(C(CC)([H])C)C(NC(C(C)C)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(C2CCCN2)C(NC(CCC(N)=O)C(NC(CC(N)=O)C(NC(CC1=CNC=N1)C(NC(C)C(NC(C(C)C)C(NC(C(C)C)C(NC(CCCCN)C(NC(CCC(N)=O)C(NC(C)C(NC(CO)C(NC(CO)C(NC(CC(O)=O)C(NC([H])C(NC(CC1=CC=CC=C1)C(NC(CCC(O)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(C)C)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(CC(N)=O)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(C)C)C(NC(CO)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(C)C(NC([H])C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(CO)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(CCCCNC(N)=N)C(NC(C)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(C)C(NC(C(C)C)C(NC(CC(C)C)C(NC(C)C(NC(CC(N)=O)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(C(CC)([H])C)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(C)C(NC(CCCCNC(N)=N)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CCCCN)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(CO)C(NC(CO)C(NC(C(C)([H])O)C(NC(CO)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(C)C(NC(C(C)([H])O)C(NC(C)C(NCC(O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O',
            'zeatin': 'CC(=CCNC1=NC=NC2=C1NC=N2)CO',
            'zeatin nucleoside': 'CC(=CCNC1=C2C(=NC=N1)N(C=N2)C3C(C(C(O3)CO)O)O)CO',
            'glucosidase': 'NC(CCSC)C(NC(CCC(N)=O)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(CCSC)C(NC(CCSC)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCCCNC(N)=N)C(NC([H])C(NC([H])C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(N)=O)C(NC(C(CC)([H])C)C(NC(CC1=CC=C(O)C=C1)C(NC(C2CCCN2)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CC(O)=O)C(NC([H])C(NC(C(C)C)C(NC([H])C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC([H])C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(CCC(O)=O)C(NC(CCCCN)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)C)C(NC(C)C(NC(CO)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(C(C)C)C(NC(CC(O)=O)C(NC([H])C(NC(C(CC)([H])C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC(CO)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=CC=C1)C(NC(C(C)([H])O)C(NC(CO)C(NC(C2CCCN2)C(NC(CCSC)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC([H])C(NC(CC1=CC=C(O)C=C1)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CO)C(NC(CC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CCSC)C(NC(CC1=CC=CC=C1)C(NC([H])C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC(C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CCCCN)C(NC(C)C(NC(CC1=CNC=N1)C(NC(CO)C(NC(CC(C)C)C(NC([H])C(NC(CC(C)C)C(NC(CCCCN)C(NC(C(C)C)C(NC(CCSC)C(NC(C(CC)([H])C)C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(CO)C(NC(CC1=CNC=N1)C(NC(C(C)([H])O)C(NC(CO)C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(CC1=CNC=N1)C(NC(C2CCCN2)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(CC(N)=O)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(C)C(NC(CC(O)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC([H])C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC(CO)C(NC(C(CC)([H])C)C(NC(CC1=CC=CC=C1)C(NC([H])C(NC([H])C(NC(CO)C(NC(C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(CO)C(NC(CCC(N)=O)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CC1=CNC=N1)C(NC(CC1=CNC=N1)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(C)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(C)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(CCSC)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=CC=C1)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC([H])C(NC(C(C)C)C(NC(CC(O)=O)C(NC([H])C(NC(CC1=CC=CC=C1)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=CC=C1)C(NC(CC1=CNC=N1)C(NC(CC(O)=O)C(NC(C)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(C2CCCN2)C(NC(CCCCN)C(NC([H])C(NC(CCC(O)=O)C(NC(C)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC([H])C(NC(C)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(C)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CC1=CNC=N1)C(NC(C(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(CCCCN)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(C)C(NC(CC(C)C)C(NC(CCSC)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(C2CCCN2)C(NC([H])C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC([H])C(NC(CCC(O)=O)C(NC(C(CC)([H])C)C(NC([H])C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCSC)C(NC(C)C(NC(CCC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(C)C(NC([H])C(NC([H])C(NC(CC(O)=O)C(NC(CCCCN)C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC(CCSC)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(CCSC)C(NC(C2CCCN2)C(NC(CC1=CNC=N1)C(NC(CO)C(NC(C)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(C)C(NC([H])C(NC(CC(O)=O)C(NC(C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C2CCCN2)C(NC(CS)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C)C(NC(C(C)([H])O)C(NC(CO)C(NC(CC(N)=O)C(NC(CC1=CNC=N1)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(C)C(NC(C(C)([H])O)C(NC(CCCCNC(N)=N)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC([H])C(NC(C)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CC1=CNC=N1)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(C(C)C)C(NC(CCSC)C(NC(CC(C)C)C(NC(C)C(NC(C(C)C)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CO)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CO)C(NC(C(C)C)C(NC(CS)C(NC(CC(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(N)=O)C(NC([H])C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC([H])C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(C)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(CCC(N)=O)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CC1=CC=C(O)C=C1)C(NC([H])C(NC(CCCCN)C(NC(C(C)C)C(NC(CC(C)C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC([H])C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC([H])C(NC(CS)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(CCSC)C(NC(C2CCCN2)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC([H])C(NC(CCC(O)=O)C(NC(CCC(N)=O)C(NC([H])C(NC([H])C(NC(CC1=CC=CC=C1)C(NC(CO)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(CCC(O)=O)C(NC(C2CCCN2)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCSC)C(NC(CCC(O)=O)C(NC(C)C(NC(CCCCNC(N)=N)C(NC(CC1=CNC=N1)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(C)C(NC(C(C)C)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(C)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CC1=CNC=N1)C(NC(C2CCCN2)C(NC(C)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC([H])C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CO)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CC(O)=O)C(NC(C(C)C)C(NC([H])C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CC(C)C)C(NC([H])C(NC(CC1=CC=CC=C1)C(NC(C(C)([H])O)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(CCCCN)C(NC([H])C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CS)C(NC(C(C)C)C(NC(CC1=CC=CC=C1)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC([H])C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(CCC(O)=O)C(NC(C(C)C)C(NC(C)C(NC(CO)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(C)C(NC(CC1=CNC=N1)C(NC(CC1=CC=CC=C1)C(NC(C(C)([H])O)C(NC(C)C(NC(C(C)([H])O)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC([H])C(NC(CO)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(N)=O)C(NC(C)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CCSC)C(NC(CCC(N)=O)C(NC(C(C)C)C(NC(C)C(NCC(O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O',
            'polyphenol oxidase': 'NC(CCSC)C(NC(C)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CO)C(NC(CO)C(NC(C2CCCN2)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(CO)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CO)C(NC(C)C(NC(CC1=CNC=N1)C(NC(CC1=CNC=N1)C(NC(CC1=CNC=N1)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(C(C)C)C(NC(CC(N)=O)C(NC([H])C(NC(CCCCN)C(NC(C(C)C)C(NC(CO)C(NC(CS)C(NC(CCC(N)=O)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC([H])C(NC(CC(N)=O)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CCC(N)=O)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC([H])C(NC(CC(C)C)C(NC([H])C(NC([H])C(NC(CCSC)C(NC(CC1=CC=C(O)C=C1)C(NC(C)C(NC(C)C(NC(CC(C)C)C(NC([H])C(NC(CO)C(NC(CCC(O)=O)C(NC([H])C(NC(C)C(NC(CC(N)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C)C(NC(C)C(NC(C2CCCN2)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CCC(O)=O)C(NC(CCCCN)C(NC(CS)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CO)C(NC(CC(O)=O)C(NC(C)C(NC(CC(C)C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(O)=O)C(NC([H])C(NC(CO)C(NC(C(C)C)C(NC([H])C(NC(CC(O)=O)C(NC(CC1=CNC=N1)C(NC(CS)C(NC(CS)C(NC(C2CCCN2)C(NC(C2CCCN2)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CCC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC(CC(N)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CNC=N1)C(NC(CC(N)=O)C(NC(CC1=CNC=N1)C(NC(C(C)C)C(NC(CCCCN)C(NC(CCCCN)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(C2CCCN2)C(NC(C)C(NC(CC1=CNC=N1)C(NC(CCCCN)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(CC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCN)C(NC(CCCCNC(N)=N)C(NC(C)C(NC(C(CC)([H])C)C(NC(C)C(NC(C(CC)([H])C)C(NC(CCSC)C(NC(CCCCN)C(NC(CO)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCSC)C(NC(CO)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CC1=CNC=N1)C(NC(CCSC)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(C)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(CC1=CNC=N1)C(NC(CS)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(CS)C(NC(CC(O)=O)C(NC([H])C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(CC(C)C)C(NC([H])C(NC(CC1=CNC=N1)C(NC(CC(N)=O)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(C(C)C)C(NC(CC1=CNC=N1)C(NC(C)C(NC(CO)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(C2CCCN2)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CC1=CNC=N1)C(NC(CCCCNC(N)=N)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC([H])C(NC(CCCCN)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CCCCN)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(C)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(N)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(O)=O)C(NC(CC1=CNC=N1)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC([H])C(NC(CCSC)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(C(CC)([H])C)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC(CCC(O)=O)C(NC(CCSC)C(NC(CC(O)=O)C(NC(CO)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(CC(N)=O)C(NC(CC1=CNC=N1)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CCCCN)C(NC(CCSC)C(NC(CCSC)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CO)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC([H])C(NC(CO)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CCSC)C(NC(CCCCNC(N)=N)C(NC(CCCCN)C(NC(C)C(NC(CCSC)C(NC(C(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(C2CCCN2)C(NC(CO)C(NC(C(C)C)C(NC(CO)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(CCCCN)C(NC(C)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC([H])C(NC(CO)C(NC(C2CCCN2)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCNC(N)=N)C(NC(C)C(NC([H])C(NC(CC(O)=O)C(NC(CCCCN)C(NC(CCSC)C(NC(CCC(O)=O)C(NC([H])C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CO)C(NC([H])C(NC(C)C(NC([H])C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCSC)C(NC(C2CCCN2)C(NC(CC1=CNC=N1)C(NC(CC(N)=O)C(NC(CO)C(NC(C(C)C)C(NC(CC1=CNC=N1)C(NC(C(C)C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(C)([H])O)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(CCCCN)C(NC([H])C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CC(O)=O)C(NC(CCSC)C(NC([H])C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CO)C(NC(C)C(NC([H])C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CS)C(NC(CC1=CNC=N1)C(NC(CC1=CNC=N1)C(NC(CO)C(NC(CC(N)=O)C(NC(C(C)C)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCSC)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CO)C(NC(CC(C)C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC([H])C(NC([H])C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCNC(N)=N)C(NC(CC(N)=O)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(C)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC([H])C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCN)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCSC)C(NC(CO)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CCC(N)=O)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CC(C)C)C(NC([H])C(NC([H])C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CO)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CCCCN)C(NC(CCCCN)C(NC(C(C)C)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(CCCCN)C(NC(C(C)C)C(NC(CCSC)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CCCCN)C(NC(CC1=CC=C(O)C=C1)C(NC(CO)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(C(C)C)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(CCCCN)C(NC(CO)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCCCN)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CC1=CNC=N1)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(C(C)C)C(NC(CC(C)C)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC(CC(C)C)C(NC([H])C(NC(CCCCN)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(C(CC)([H])C)C(NC(CCCCN)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CC(O)=O)C(NC([H])C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCN)C(NC(C2CCCN2)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(C)C(NC([H])C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(C(C)([H])O)C(NC(CO)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(CC1=CNC=N1)C(NC([H])C(NC([H])C(NC([H])C(NC([H])C(NC([H])C(NC([H])C(NC([H])C(NC(CC(O)=O)C(NC(CCSC)C(NC(CO)C(NC(CC1=CNC=N1)C(NC(CCSC)C(NC(C)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CCSC)C(NC([H])C(NC(CCCCN)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CC(C)C)C(NC(CCCCN)C(NC(CC(C)C)C(NC(C)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(C)C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CC(O)=O)C(NC(CO)C(NC(C(CC)([H])C)C(NC(CCC(N)=O)C(NC(C(C)C)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(C(C)C)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(CO)C(NC([H])C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(CO)C(NC(C(CC)([H])C)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC([H])C(NC(C(CC)([H])C)C(NC(CC(O)=O)C(NC(C(CC)([H])C)C(NC(CCC(O)=O)C(NCC(O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O',
            'peroxidase': 'NC(CCSC)C(NC(CC1=CNC=N1)C(NC(CC1=CC=CC=C1)C(NC(CO)C(NC(CO)C(NC(CO)C(NC(CO)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(C(C)([H])O)C(NC(CS)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CS)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC(C)C(NC(CO)C(NC(CC(C)C)C(NC(CO)C(NC(CC(O)=O)C(NC(C)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(CO)C(NC(CS)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(C(C)C)C(NC(CO)C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(C)C(NC(C)C(NC(CO)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC(CC1=CC=CC=C1)C(NC(CC1=CNC=N1)C(NC(CC(O)=O)C(NC(CS)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CC(N)=O)C(NC([H])C(NC(CS)C(NC(CC(O)=O)C(NC(C)C(NC(CO)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(CCC(O)=O)C(NC(CCCCN)C(NC(CC(O)=O)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC([H])C(NC(CC(N)=O)C(NC(C)C(NC(CC(N)=O)C(NC(CO)C(NC(C)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CC1=CC=CC=C1)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCSC)C(NC(CCCCN)C(NC(C)C(NC(C)C(NC(C(C)C)C(NC(CCC(O)=O)C(NC(CO)C(NC(C)C(NC(CS)C(NC(C2CCCN2)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CO)C(NC(CS)C(NC(C)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(C)C(NC(C)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CO)C(NC(C(C)C)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C)C(NC([H])C(NC([H])C(NC(C2CCCN2)C(NC(CO)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC([H])C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(CO)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(C)C(NC(CC(N)=O)C(NC(C)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(C)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=CC=C1)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CCCCN)C(NC(CC(O)=O)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CCCCNC(N)=N)C(NC(CC(N)=O)C(NC(C(C)C)C(NC([H])C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CO)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(C(C)C)C(NC(C)C(NC(CC(C)C)C(NC(CO)C(NC([H])C(NC([H])C(NC(CC1=CNC=N1)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC([H])C(NC(CCCCN)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CS)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=CC=C1)C(NC(C(CC)([H])C)C(NC(CCSC)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CO)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC([H])C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CC(C)C)C(NC(CS)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC([H])C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CO)C(NC(C)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CC(N)=O)C(NC(CCCCN)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CCC(N)=O)C(NC(CCCCN)C(NC([H])C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CCC(N)=O)C(NC(CO)C(NC(CC(O)=O)C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CO)C(NC(CO)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(C)C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(C(CC)([H])C)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(C)C(NC(CC(N)=O)C(NC(CO)C(NC(C(C)([H])O)C(NC(CCC(N)=O)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=CC=C1)C(NC(CC(N)=O)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CCC(O)=O)C(NC(C)C(NC(CCSC)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CCSC)C(NC([H])C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC([H])C(NC(C(C)([H])O)C(NC(CCC(N)=O)C(NC([H])C(NC(CCC(N)=O)C(NC(C(CC)([H])C)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CC(N)=O)C(NC(CS)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(C(C)C)C(NC(CC(N)=O)C(NC(CO)C(NC(CC(N)=O)C(NC(CO)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC(CC(O)=O)C(NC(CCSC)C(NC(C(C)C)C(NC(CCC(O)=O)C(NC(C(C)C)C(NC(C(C)C)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CO)C(NC(CO)C(NC(CCSC)C(NCC(O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O',
            'adenosine-5-triphosphatase': 'C1=NC(=C2C(=N1)N(C=N2)C3C(C(C(O3)COP(=O)(O)OP(=O)(O)OP(=O)(O)O)O)O)N',
            'arabinose': 'C1C(C(C(C(O1)O)O)O)O',
            'fructose': 'C1C(C(C(C(O1)(CO)O)O)O)O',
            'galactose': 'C(C1C(C(C(C(O1)O)O)O)O)O',
            'galacturonic acid': 'C1(C(C(OC(C1O)O)C(=O)O)O)O',
            'alpha and beta d-glucose': 'C(C(C(C(C(C=O)O)O)O)O)O',
            'altro-heptulose': 'C(C1C(C(C(C(O1)(CO)O)O)O)O)O',
            'd-manno-heptulose': 'C(C(C(C(C(C(=O)CO)O)O)O)O)O',
            'mannose': 'C(C1C(C(C(C(O1)O)O)O)O)O',
            'd-glycerol-d-manno-octulose': 'C(C(C(C(C(C(C(=O)CO)O)O)O)O)O)O',
            'rhamnose': 'CC1C(C(C(C(O1)O)O)O)O',
            'ribose': 'C1C(C(C(C(O1)O)O)O)O',
            'xylose': 'C1C(C(C(C(O1)O)O)O)O',
            'sucrose': 'C(C1C(C(C(C(O1)OC2(C(C(C(O2)CO)O)O)CO)O)O)O)O',
            'maltose': 'C(C1C(C(C(C(O1)OC2C(OC(C(C2O)O)O)CO)O)O)O)O',
            'raffinose': 'C(C1C(C(C(C(O1)OCC2C(C(C(C(O2)OC3(C(C(C(O3)CO)O)O)CO)O)O)O)O)O)O)O',
            'cellulose': 'C(C1C(C(C(C(O1)OC2C(OC(C(C2O)O)O)CO)O)O)O)O',
            'hemicellulose': 'CC(C(C1=CC=CC=C1)O)NC.CC(C(C1=CC=CC=C1)O)NC',
            'pectin': 'C1(C(C(OC(C1O)O)C(=O)O)O)O',
            'xylan': 'C1C(C(C(C(O1)O)O)O)O',
            'arabitol': 'C(C(C(C(CO)O)O)O)O',
            'erythritol': 'C(C(C(CO)O)O)O',
            'galactitol': 'C(C(C(C(C(CO)O)O)O)O)O',
            'glycerol': 'C(C(CO)O)O',
            'mannitol': 'C(C(C(C(C(CO)O)O)O)O)O',
            'ribitol': 'C(C1C(C(C(O1)C(C(C(C(CO)O)O)O)O)O)O)O',
            'sorbitol': 'C(C(C(C(C(CO)O)O)O)O)O',
            'xylitol': 'C(C(C(C(CO)O)O)O)O',
            'd-minus bornesitol': 'OC1C(O)C(O)C(OC)C(O)C1O',
            'plus inositol': 'C1(C(C(C(C(C1O)O)O)O)O)O',
            'myo inositol': 'C1(C(C(C(C(C1O)O)O)O)O)O',
            'plus quebrachitol': 'COC1C(C(C(C(C1O)O)O)O)O',
            'galactosamine': 'C(C1C(C(C(C(O1)O)N)O)O)O',
            'glucosamine': 'C(C1C(C(C(C(O1)O)N)O)O)O',
            'n-nonane': 'CCCCCCCCC',
            'n-decane': 'CCCCCCCCCC',
            'n-undecane': 'CCCCCCCCCCC',
            'n-dodecane': 'CCCCCCCCCCCC',
            'n-tridecane': 'CCCCCCCCCCCCC',
            'd-tetradecane': 'CCCCCCCCCCCCCC',
            '3,6-dimethyl-tridecane': 'CCCCC(C)CCC(C)CC',
            'n-pentadecane': 'CCCCCCCCCCCCCCC',
            '2,6-dimethyl tetradecane': 'CCCCCCCCC(C)CCCC(C)C',
            'n-hexadecane': 'CCCCCCCCCCCCCCCC',
            'n-heptadecane': 'CCCCCCCCCCCCCCCCC',
            '2,6-dimethyl hexadecane': 'CCCCCCCCCCCC(C)CCC(C)C',
            'n-octadecane': 'CCCCCCCCCCCCCCCCCC',
            '3,6-dimethyl heptadecane': 'CCCCCCCCCCCC(C)CC(C)CC',
            '3,7-dimethyl heptadecane': 'CCCCCCCCCCC(C)CCC(C)CC',
            'n-nonadecane': 'CCCCCCCCCCCCCCCCCCC',
            '3,6-dimethyl octadecane': 'CCC(C)CCC(C)CC',
            '3,7-dimethyl octadecane': 'CC(C)CCCC(C)CC',
            'n-eicosane': 'CCCCCCCCCCCCCCCCCCCC',
            'n-heneicosane': 'CCCCCCCCCCCCCCCCCCCCC',
            '3-methyl tricosane': 'CCCCCCCCCCCCCCCCCCCCC(C)CC',
            'n-tetracosane': 'CCCCCCCCCCCCCCCCCCCCCCCC',
            '2-methyl tetracosane': 'CCCCCCCCCCCCCCCCCCCCCCC(C)C',
            'n-pentacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCC',
            'n-hexacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCCC',
            '3-methyl-pentacosane': 'CCCCCCCCCCCCCCCCCCCCCCC(C)CC',
            '2-methyl hexacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCC(C)C',
            'n-heptacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCC',
            '3-methyl heptacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCC(C)CC',
            'n-octacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            '2-methyl octacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCC(C)C',
            '9-methyl octacosane': 'CCCCCCCCCCCCCCCCCCCC(C)CCCCCCCC',
            'n-nonacosane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            '3-methyl triacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCC(C)CC',
            'n-triacotane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            '2-methyl hentriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCC(C)C',
            'n-hentriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            '3-methyl hentriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCC(C)CC',
            'n-dotriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            '2-methyl dotriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC(C)C',
            'n-tritriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            'tetra-triacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            'pentatriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            'hexatriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            'heptatriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            'octatriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            'nonatriacontane': 'CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC',
            'methanol': 'CO',
            'ethanol': 'CCO',
            'octanol-1': 'CCCCCCCC(O)',
            'octanol-3': 'CCCCCC(O)CC',
            'nonanol-1': 'CCCCCCCCC(O)',
            'hexadecanol-1': 'CCCCCCCC(O)CCCCCC',
            'acetaldehyde': 'CC=O',
            'isobutyraldehyde': 'CC(C)C=O',
            'pentanal': 'CCCCC=O',
            'hexanal': 'CCCCCC=O',
            'heptanal': 'CCCCCCC=O',
            'octanal': 'CCCCCCCC=O',
            'nonanal': 'CCCCCCCCC=O',
            'decanal': 'CCCCCCCCCC=O',
            'undecanal': 'CCCCCCCCCCC=O',
            'dodecanal': 'CCCCCCCCCCCC=O',
            'tridecanal': 'CCCCCCCCCCCCC=O',
            'p-ethylbenzaldehyde': 'CCc1ccc(C=O)cc1',
            'acetone': 'CC(C)=O',
            'heptanone-2': 'CCCCCC(=O)C',
            '2-methyl-2heptene-6-one': 'CC(C)=CCCC(C)=O',
            'decanone-2': 'CCCCCCCCC(=O)C',
            'undecanone-2': 'CCCCCCCCCC(=O)C',
            'dodecanone-2': 'CCCCCCCCCCC(=O)C',
            'pentadecanone-2': 'CCCCCCCCCCCCCC(=O)C',
            'octanone-3': 'CCCCCC(=O)CC',
            '2,2,6-trimethyl cyclohexanone': 'CC1CCCC(C)(C)C1=O',
            '2,2,6-trimethyl-5-cyclohexenone': 'CC1=CCCC(C)(C)C1=O',
            '3-decene-5-one': 'CCCCCC(=O)C=CCC',
            '6,10-dimethyl undecanone-2': 'CC(C)CCCC(C)CCCC(=O)C',
            '6,10,14-trimethyl pentadecanone-2': 'CC(C)CCCC(C)CCCC(C)CCCC(=O)C',
            'arabinonic acid': 'C(C(C(C(C(=O)O)O)O)O)O',
            'azelaic acid': 'C(CCCC(=O)O)CCCC(=O)O',
            'cinnamic acid': 'C1=CC=C(C=C1)C=CC(=O)O',
            'citric acid': 'OC(=O)CC(O)(CC(O)=O)C(O)=O',
            'glucaric acid': 'OC(C(O)C(O)C(O)=O)C(O)C(O)=O',
            'gluconic acid': 'OCC(O)C(O)C(O)C(O)C(O)=O',
            'glyceric acid': 'OCC(O)C(O)=O',
            'p-hydroxybenzoic acid': 'OC(=O)c1ccc(O)cc1',
            'p-hydroxycinnamic acid': 'OC(=O)C=Cc1ccc(O)cc1',
            'isocitric acid': 'OC(C(CC(O)=O)C(O)=O)C(O)=O',
            'malic acid': 'OC(CC(O)=O)C(O)=O',
            'malonic acid': 'OC(=O)CC(O)=O',
            '3-methyoxy-4-hydroxycinnamic acetate': 'COC1=C(C=CC(=C1)C=CC(=O)O)[O-]',
            'phosphoric acid': 'O[P](O)(O)=O',
            'pyroglutamic acid': 'OC(=O)C1CCC(=O)N1',
            'quinic acid': 'C1C(C(C(CC1(C(=O)O)O)O)O)O',
            'succinic acid': 'OC(=O)CCC(O)=O',
            'threonic acid': 'OCC(O)C(O)C(O)=O',
            'vanillic acid': 'COc1cc(ccc1O)C(O)=O',
            'arachidic acid': 'CCCCCCCCCCCCCCCCCCCC(O)=O',
            'behenic acid': 'CCCCCCCCCCCCCCCCCCCCCC(O)=O',
            'eicosadienic acid': 'CCCCCCCCCCCCCCCC=CC=CC(O)=O',
            'eicosemic acid': r'O=C(O)CCCCCCC\C=C/CCCCCCCCCC',
            'linoleic': r'CCCCC/C=C/C/C=C/CCCCCCCC(O)=O',
            'linolenic acid': r'CC/C=C/C/C=C/C/C=C/CCCCCCCC(O)=O',
            'myristic acid': 'CCCCCCCCCCCCCC(O)=O',
            'oleic acid': r'CCCCCCCC\C=C/CCCCCCCC(O)=O',
            'palmitic acid': 'CCCCCCCCCCCCCCCC(O)=O',
            'palmitoleic acid': r'CCCCCC\C=C/CCCCCCCC(O)=O',
            'sativic acid': 'CCCCCC(O)C(O)CC(O)C(O)CCCCCCCC(O)=O',
            'stearic acid': 'CCCCCCCCCCCCCCCCCC(O)=O',
            'benzyl acetate': 'CC(=O)OCc1ccccc1',
            'para ethyl benzyl acetate': 'CCC1=CC=C(C=C1)COC(=O)C',
            '3-hexenyl caproate': 'CCCCCC(=O)OCCC=CCC',
            'hexyl acetate': 'CCCCCCOC(C)=O',
            'hexyl butyrate': 'CCCCCCOC(=O)CCC',
            'hexyl isobutyrate': 'CCCCCCOC(=O)C(C)C',
            'methyl acetate': 'COC(C)=O',
            'methyl linoleate': r'CCCCC/C=C\C\C=C/CCCCCCCC(=O)OC',
            'methyl palmitate': 'CCCCCCCCCCCCCCCC(=O)OC',
            'methyl salicylate': 'COC(=O)c1ccccc1O',
            'octyl caproate': 'CCCCCCCCOC(=O)CCCCC',
            'campesterol': 'CC(C)C(C)CCC(C)C1CCC2C3CC=C4CC(O)CCC4(C)C3CCC12C',
            'campest-5-en-3beta-ol-7-one': 'CC(C)C(C)CCC(C)C1CCC2C1(CCC3C2=CCC4C3(CCC(C4)O)C)C',
            'ergosterol': r'CC(C)C(C)/C=C/C(C)C1CCC2C3=CC=C4CC(O)CCC4(C)C3CCC12C',
            'beta-sitosterol': 'CCC(CCC(C)C1CCC2C3CC=C4CC(O)CCC4(C)C3CCC12C)C(C)C',
            '5alpha-stigmasta-7,24-dien-3beta-ol': 'CCC(CCC(C)C1CCC2C3=CCC4CC(O)CCC4(C)C3CCC12C)=C(C)C',
            'stigmasta-5,22-dien-3beta-ol-7-one': 'CCC(C=CC(C)C1CCC2C1(CCC3C2CC=C4C3(CCC(C4)OC(=O)C)C)C)C(C)C',
            'stigmast-5-en-3beta-ol-7-one': 'CCC(CCC(C)C1CCC2C1(CCC3C2CC=C4C3(CCC(C4)O)C)C)C(C)C',
            'stigmast-4-en-3-one': 'CCC(CCC(C)C1CCC2C3CCC4=CC(=O)CCC4(C)C3CCC12C)C(C)C',
            'stigmasterol': r'CCC(/C=C/C(C)C1CCC2C3CC=C4CC(O)CCC4(C)C3CCC12C)C(C)C',
            'borneol': 'CC1(C)C2CCC1(C)C(O)C2',
            'bornyl acetate': 'CC(=O)OC1CC2CCC1(C)C2(C)C',
            'camphene': 'CC1(C)C2CCC(C2)C1=C',
            'camphenehydrate': 'CC1(C2CCC(C2)C1(C)O)C',
            'camphor': 'CC1(C)C2CCC1(C)C(=O)C2',
            'delta-3 carene': 'CC1=CCC2C(C1)C2(C)C',
            'delta-4 carene': 'CC1CC2C(C2(C)C)C=C1',
            'carvacrol': 'CC(C)c1ccc(C)c(O)c1',
            'carvone': 'CC(=C)C1CC=C(C)C(=O)C1',
            'beta-cyclocitral': 'CC1=C(C=O)C(C)(C)CCC1',
            '1,4-cineol': 'CC(C)C12CCC(C)(CC1)O2',
            '1,8-cineol': 'CC12CCC(CC1)C(C)(C)O2',
            'citral b': 'CC(C)=CCC\C(C)=C/C=O',
            'citronellol': 'CC(CCO)CCC=C(C)C',
            'para cymene': 'CC(C)c1ccc(C)cc1',
            'para cymene-8-ol': 'CC1=CC=C(C=C1)C(C)(C)O',
            'dihydrocarveyl acetate': 'CC1CCC(CC1OC(C)=O)C(C)=C',
            'dihydrocarvone': 'CC1CCC(CC1=O)C(C)=C',
            'fenchyl alcohol': 'CC1(C)C2CCC(C)(C2)C1O',
            'fenchone': 'CC1(C)C2CCC(C)(C2)C1=O',
            'geraniol': r'CC(C)=CCC\C(C)=C\CO',
            'geranyl acetone': r'CC(C)=CCCC(/C)=C/CCC(C)=O',
            'limonene': 'CC(=C)C1CCC(=CC1)C',
            'linalool': 'CC(C)=CCCC(C)(O)C=C',
            'linalool oxide': 'CC(C)=CCCC(C)(O)C1CO1',
            'meta mentha-1,8-dien-5-ol': '',
            '1-methyl-4-iso-propenylbenzene': 'CC(=C)c1ccc(C)cc1',
            'myrcene': 'CC(C)=CCCC(=C)C=C',
            'nerol':r'CC(C)=CCC\C(C)=C/CO',
            'nerolidol': 'CC(C)=CCCC(C)=CCCC(C)(O)C=C',
            'beta-ocimene': 'CC(C)=CCC=C(C)C=C',
            'perillene': 'CC(C)=CCCc1cocc1',
            'alpha-phellandrene': 'CC(C)C1CC=C(C)C=C1',
            'beta-phellandrene': 'CC(C)C1CCC(=C)C=C1',
            '3-phenyl-2-methyl-prop-1-ene': 'CC(=C)Cc1ccccc1',
            'alpha-pinene': 'CC1=CCC2CC1C2(C)C',
            'beta-pinene': 'CC1(C)C2CCC(=C)C1C2',
            'alpha-pinene oxide': 'CC1(C)C2CC3OC3(C)C1C2',
            'pinocarveol': 'CC1(C)C2CC(O)C(=C)C1C2',
            'pinocarvone': 'CC1(C)C2CC1C(=C)C(=O)C2',
            'piperitenone': 'CC(C)=C1CCC(=CC1=O)C',
            'piperitone oxide': 'CC(C)C1CCC2(C)OC2C1=O',
            'piperitenone oxide': 'CC(C)=C1CCC2(C)OC2C1=O',
            'pulegone': 'CC1CCC(=C(C)C)C(=O)C1',
            'sabinene': 'CC(C)C12CCC(=C)C1C2',
            'sabiene hydrate': 'CC(C)C12CCC(C1C2)(C)O',
            'sabinol': 'CC(C)C12CC(O)C(=C)C1C2',
            'safranal': 'CC1=C(C=O)C(C)(C)CC=C1',
            'alpha thujene': 'CC1=CCC2(C1C2)C(C)C',
            'alpha terpinene': 'CC1=CC=C(CC1)C(C)C',
            'gamma terpinene': 'CC1=CCC(=CC1)C(C)C',
            'alpha terpiene-4-ol': 'CC1=CCC(CC1)(C(C)C)O',
            'alpha terpinolene': 'CC1=CCC(=C(C)C)CC1',
            'alpha terpineol': 'CC1=CCC(CC1)C(C)(C)O',
            'beta terpineol': 'CC(=C)C1CCC(CC1)(C)O',
            'thujyl alcohol': 'CC(C)C12CC1C(C)CC2O',
            'allo-aromadendrene': 'CC1CCC2C1C3C(C3(C)C)CCC2=C',
            'alpha-bergamotene': 'CC(C)=CCCC1(C)C2CC=C(C)C1C2',
            'beta bisabolene': 'CC1=CCC(CC1)C(=C)CCC=C(C)C',
            'alpha bisabolol': 'CC1=CCC(CC1)C(C)(CCC=C(C)C)O',
            'calamenene': 'CC(C)C1CCC(C)c2ccc(C)cc12',
            'caryophyllene': r'C\C1=C/CCC(=C)C2CC(C)(C)C2CC1',
            'alpha caryophyllene': 'CC1=CCC(C=CCC(=CCC1)C)(C)C',
            'beta caryophyllene': 'CC1=CCCC(=C)C2CC(C2CC1)(C)C',
            'alpha caryophyllene alcohol': 'CC1(CC2C(C1)C3(CCCC2(C3O)C)C)C',
            'isocarophyllene': 'CC1=CCCC(=C)C2CC(C2CC1)(C)C',
            'caryophyllene oxide': 'CC1(C)CC2C1CCC3(C)OC3CCC2=C',
            'alpha cedrene': 'CC1CCC2C13CC=C(C(C3)C2(C)C)C',
            'gamma cadinene': 'CC1=CC2C(CC1)C(=C)CCC2C(C)C',
            'delta cadinene': 'CC1=CC2C(CCC(=C2CC1)C)C(C)C',
            'alpha copaene': 'CC1=CCC2C3C1C2(CCC3C(C)C)C',
            'alpha cubebene': 'CC1CCC(C2C13C2C(=CC3)C)C(C)C',
            'alpha curcumene': 'CC1=CC=C(C=C1)C(C)CCC=C(C)C',
            'beta cucumene': 'CC1=CCC(=CC1)C(C)CCC=C(C)C',
            'gamma elemene': 'CC(=C1CCC(C(C1)C(=C)C)(C)C=C)C',
            'gamma eudesmol': 'CC1=C2CC(CCC2(CCC1)C)C(C)(C)O',
            'beta farnesene': 'CC(=CCCC(=CCCC(=C)C=C)C)C',
            'z beta farnesene': 'CCC(=C)CCC=C(C)CCC=C(C)C',
            'alpha farnesene': 'CC(=CCCC(=CCC=C(C)C=C)C)C',
            'farnesol': 'CC(C)=CCCC(C)=CCCC(C)=CCO',
            'farnesyl acetone': 'CC(C)=CCCC(C)=CCCC(C)=CCCC(C)=O',
            'alpha gurjunene': 'CC1CCC2C(C2(C)C)C3=C(CCC13)C',
            'guaiol': 'CC1CCC(CC2=C1CCC2C)C(C)(C)O',
            'beta humulene': 'CC1=CCC(C=CCC(=C)CCC1)(C)C',
            'humelene epoxide I': 'CC1=CCCC2(C(O2)CC(C=CC1)(C)C)C',
            'humelene epoxide II': 'CC1=CCC(C=CCC2(C(O2)CC1)C)(C)C',
            'ledol': 'CC1CCC2C1C3C(CCC2(C)O)C3(C)C',
            'longifolene': 'CC1(C)CCCC2(C)C3CCC(C13)C2=C',
            'epi-beta-sanalene': 'CC(=CCCC1(C2CCC(C2)C1=C)C)C',
            'alpha selinene': 'CC1=CCCC2(C1CC(CC2)C(=C)C)C',
            'beta selinene': 'CC(=C)C1CCC2(CCCC(=C)C2C1)C',
            'selina-3,7-diene': 'CC(C)C1=CC[C@@]2(C)CCC=C(C)C2C1',
            'selina-4,7-diene': 'CC1=C2CC(=CCC2(CCC1)C)C(C)C',
            'friedelin': 'CC1C(=O)CCC2C1(C)CCC3C2(C)CCC4(C)C5CC(C)(C)CCC5(C)CCC34C',
            'epifriedelanol': 'CC1C(O)CCC2C1(C)CCC3C2(C)CCC4(C)C5CC(C)(C)CCC5(C)CCC34C',
            'vomifoliol': r'CC(O)/C=C/C1(O)C(=CC(=O)CC1(C)C)C',
            'dihydrovomifoliol': 'CC1(C)CCCC2(C)OC(=O)C=C12',
            'beta ionone': 'CC1=C(C(CCC1)(C)C)C=CC(=O)C',
            'dihydroactinidiolide': 'CC1(CCCC2(C1=CC(=O)O2)C)C',
            'acetylcannabispirol': 'COc1cc2CCC3(CCC(CC3)OC(=O)C)c2c(O)c1',
            'cannabispiradienone': 'COC1=CC2=C(C(=C1)O)C3(CC2)C=CC(=O)C=C3',
            'beta cannabispiranol': 'COC1=CC2=C(C(=C1)O)C3(CCC(CC3)O)CC2',
            'cannabispirenone': 'COC1=CC2=C(C(=C1)O)C3(CCC(=O)C=C3)CC2',
            'cannabispirenone-isomer': 'COC1=CC2=C(C(=C1)O)C3(CCC(=O)C=C3)CC2',
            'cannabispirone': 'COC1=CC2=C(C(=C1)O)C3(CCC(=O)CC3)CC2',
            '3-[2-(4-hydroxyphenyl)ethyl]-5-methoxyphenol': 'COc1cc(O)cc(CCc2ccc(O)cc2)c1',
            '3-[2-(3-hydroxy-4-methoxyphenyl)ethyl]-5-methoxyphenol': 'COc1cc(O)cc(CCc2ccc(OC)c(O)c2)c1',
            '3-[2-(3-isoprenyl-4-hydroxy-5-methoxy-phenyl)ethyl]-5-methoxyphenol': 'COc1cc(O)cc(CCc2cc(OC)c(O)c(C=CC(C)=C)c2)c1',
            'canniprene': 'CC(=CCC1=C(C=CC(=C1O)OC)CCC2=CC(=CC(=C2)OC)O)C',
            'eugenol': 'COc1cc(CC=C)ccc1O',
            'isoeugenol': 'COc1cc(C=CC)ccc1O',
            'anethol': 'COc1ccc(C=CC)cc1',
            'methyleugenol': 'COc1ccc(CC=C)cc1OC',
            'apigenin-7-O-para coumarylglucoside': r'OC1C(COC(=O)\C=C\C2=CC=C(O)C=C2)OC(OC2=CC(O)=C3C(=O)C=C(OC3=C2)C2=CC=C(O)C=C2)C(O)C1',
            'cosmosioside': 'OCC1OC(Oc2cc(O)c3C(=O)C=C(Oc3c2)c4ccc(O)cc4)C(O)C(O)C1O',
            'apigenin-O-glycoside': 'C1=CC(=CC=C1C2=CC(=O)C3=C(C=C(C=C3O2)OC4C(C(C(C(O4)CO)O)O)O)O)O',
            'isovitesin-7-O-rhamnoglucoside': 'CC1C(C(C(C(O1)OC2=C(C(=C3C(=C2)OC(=CC3=O)C4=CC=C(C=C4)O)O)C5C(C(C(C(O5)CO)O)O)O)O)O)O',
            'kaempferol-O-glycoside': 'C1=CC(=CC=C1C2=C(C(=O)C3=C(C=C(C=C3O2)OC4C(C(C(C(O4)CO)O)O)O)O)O)O',
            'luteolin-O-glycoside': 'C1=CC(=C(C=C1C2=CC(=O)C3=C(C=C(C=C3O2)O)O)O)OC4C(C(C(C(O4)CO)O)O)O',
            'orientin': 'OCC1OC(C(O)C(O)C1O)c2c(O)cc(O)c3C(=O)C=C(Oc23)c4ccc(O)c(O)c4',
            'orientin-O-glucoside': 'C1=CC(=C(C=C1C2=CC(=O)C3=C(O2)C(=C(C=C3O)O)C4C(C(C(C(O4)CO)O)O)O)O)O',
            'orientin-7-O-rhamnoglucoside': 'CC1C(C(C(C(O1)OC2=C(C3=C(C(=C2)O)C(=O)C=C(O3)C4=CC(=C(C=C4)O)O)C5C(C(C(C(O5)CO)O)O)O)O)O)O',
            'quercetin-O-glucoside': 'C1=CC(=C(C=C1C2=C(C(=O)C3=C(C=C(C=C3O2)OC4C(C(C(C(O4)CO)O)O)O)O)O)O)O',
            'vitexin-7-O-g"-glucoside': 'C1=CC(=CC=C1C2=CC(=O)C3=C(O2)C(=C(C=C3O)OC4C(C(C(C(O4)CO)O)O)O)C5C(C(C(C(O5)CO)O)O)O)O',
            'vitexin-O-glucoside': 'C1=CC(=CC=C1C2=CC(=O)C3=C(O2)C(=C(C=C3O)O)C4C(C(C(C(O4)CO)O)O)O)OC5C(C(C(C(O5)CO)O)O)O',
            'vitexin-O-rhamnoglucoside': 'CC1C(C(C(C(O1)OC2C(C(C(OC2C3=C(C=C(C4=C3OC(=CC4=O)C5=CC=C(C=C5)O)O)O)CO)O)O)O)O)O',
            '2"-O-glucopyranosylvitexin': 'C1=CC(=CC=C1C2=CC(=O)C3=C(O2)C(=C(C=C3O)O)C4C(C(C(C(O4)CO)O)O)OC5C(C(C(C(O5)CO)O)O)O)O',
            'vitamin k': 'CC(C)CCCC(C)CCCC(C)CCC/C(C)=C/CC1=C(C)C(=O)c2ccccc2C1=O',
            'carotene': 'CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(CCCC2(C)C)C)C)C',
            'zanthophylls': 'CC1=C(C(CC(C1)O)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2C(=CC(CC2(C)C)O)C)C)C',
            'cannabichromanone c3': 'CCCCCC1=CC(=C2C(=C1)OC(C(C2=O)CCC(=O)C)(C)C)O',
            'cannabielsoin c3': 'CCCCCC1=CC(=C2C3C(CCC(C3OC2=C1)(C)O)C(=C)C)O',
            'cannabielsoin acid b': 'CCCCCC1=CC(=C2C3C(CCC(C3OC2=C1C(=O)O)(C)O)C(=C)C)O',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'cannabigerolic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6]/[#6]=[#6](\[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'cannabigerolic acid monomethylether': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6]/[#6]=[#6](\[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]-[#6]',
            'cannabigerol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8])-[#6]/[#6]=[#6](\[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'cannabigerol monomethylether': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6]/[#6]=[#6](\[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]-[#6]',
            'cannabigerovarinic acid': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6]-[#6]=[#6](-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'cannabigerovarin': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8])-[#6]/[#6]=[#6](\[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'cannabichromenic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]=[#6]-[#6](-[#8]-2)(-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'cannabichromene': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]=[#6]-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'cannabichromevarinic acid': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]=[#6]-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'cannabichromevarin': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]=[#6]-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'cannabidiolic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6]1-[#6]=[#6](-[#6]-[#6]-[#6]-1-[#6](=[#6])-[#6])-[#6])-[#8]',
            'cannabidiol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8])-[#6]1-[#6]=[#6](-[#6]-[#6]-[#6]-1-[#6](=[#6])-[#6])-[#6])-[#8]',
            'cannabidiol monomethylether': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8]-[#6])-[#6]1-[#6]=[#6](-[#6]-[#6]-[#6]-1-[#6](=[#6])-[#6])-[#6])-[#8]',
            'cannabidiol c4': '[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#6](-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-2)-[#8])-[#6])(-[#6])-[#6]',
            'cannabidivarinic acid': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6]1-[#6]=[#6](-[#6]-[#6]-[#6]-1-[#6](=[#6])-[#6])-[#6])-[#8]',
            'cannabidivarin': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8])-[#6]1-[#6]=[#6](-[#6]-[#6]-[#6]-1-[#6](=[#6])-[#6])-[#6])-[#8]',
            'cannabidiorcol': '[#6]-[#6]1=[#6]-[#6](-[#6](-[#6]-[#6]-1)-[#6](=[#6])-[#6])-[#6]1:[#6](:[#6]:[#6](:[#6]:[#6]:1-[#8])-[#6])-[#8]',
            'delta-9 tetrahgdrocannabinolic acid a': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-2)(-[#6])-[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'delta-9 tetrahgdrocannabinolic acid b': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1-[#6](=[#8])-[#8])(-[#6])-[#6])-[#6])-[#8]',
            'delta-9 tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'detla-9 tetrahvdrocannabinolic acid c': '[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-2)(-[#6])-[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'delta-9 tetrahydrocannabinol c4': '[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'delta-9 tetrahydrocannabivarinic acid': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-2)(-[#6])-[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'delta-9 tetrahydrocannabivarin': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'delta-9 tetrahydrocannabiorcolic acid': '[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-2)(-[#6])-[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'detla-9 tetrahydrocannabiorcol': '[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'detla-8 tetrahydrocannabinolic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3-[#6]-[#6](=[#6]-[#6]-[#6]-3-[#6](-[#8]-2)(-[#6])-[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'delta-8 tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]-[#6](=[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'cannabicyclolic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3-[#6]4-[#6](-[#6]-3(-[#6])-[#6])-[#6]-[#6]-[#6]-4(-[#8]-2)-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'cannabicyclol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]4-[#6](-[#6]-3(-[#6])-[#6])-[#6]-[#6]-[#6]-4(-[#8]-[#6]:2:[#6]:1)-[#6])-[#8]',
            'cannabicyclovarin': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]4-[#6](-[#6]-3(-[#6])-[#6])-[#6]-[#6]-[#6]-4(-[#8]-[#6]:2:[#6]:1)-[#6])-[#8]',
            'cannabielsoic acid a': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3-[#6](-[#6]-[#6]-[#6](-[#6]-3-[#8]-2)(-[#6])-[#8])-[#6](=[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'cannabielsoic acid b': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6](-[#6]-[#6]-[#6](-[#6]-3-[#8]-[#6]:2:[#6]:1-[#6](=[#8])-[#8])(-[#6])-[#8])-[#6](=[#6])-[#6])-[#8]',
            'cannabielsoin': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6](-[#6]-[#6]-[#6](-[#6]-3-[#8]-[#6]:2:[#6]:1)(-[#6])-[#8])-[#6](=[#6])-[#6])-[#8]',
            'cannabinolic acid a': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](-[#6]3:[#6](:[#6]:[#6]:[#6](:[#6]:3)-[#6])-[#6](-[#8]-2)(-[#6])-[#6]):[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8]',
            'cannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1)-[#8]-[#6](-[#6]1:[#6]-2:[#6]:[#6](:[#6]:[#6]:1)-[#6])(-[#6])-[#6])-[#8]',
            'cannabinol methylether': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6](:[#6]:1)-[#8]-[#6])-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1)-[#6])-[#6](-[#8]-2)(-[#6])-[#6]',
            'cannabinol c4': '[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#6](-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-2)-[#8])-[#6])(-[#6])-[#6]',
            'cannabivarin': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1)-[#8]-[#6](-[#6]1:[#6]-2:[#6]:[#6](:[#6]:[#6]:1)-[#6])(-[#6])-[#6])-[#8]',
            'cannabiorcol': '[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#6](-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-2)-[#8])-[#6])-[#6]',
            'cannabinodiol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8])-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1)-[#6])-[#6](=[#6])-[#6])-[#8]',
            'cannabinodivarin': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8])-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1)-[#6])-[#6](=[#6])-[#6])-[#8]',
            'cannabitriol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1)-[#8]-[#6](-[#6]1=[#6]-2-[#6](-[#6](-[#6]-[#6]-1)(-[#6])-[#8])-[#8])(-[#6])-[#6])-[#8]',
            '9,10-dihydroxy-delta-6a,10a-tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](-[#8]):[#6]2:[#6](-[#8]-[#6](-[#6])(-[#6])-[#6]3=[#6]-2-[#6](-[#8])-[#6](-[#6])(-[#8])-[#6]-[#6]-3):[#6]:1',
            '10-ethoxy-9-hydroxy-delta-6a,10a-tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](-[#8]):[#6]2:[#6](-[#8]-[#6](-[#6])(-[#6])-[#6]3=[#6]-2-[#6](-[#8]-[#6]-[#6])-[#6](-[#6])(-[#8])-[#6]-[#6]-3):[#6]:1',
            '8,9-dihydroxy-delta-tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](-[#8]):[#6]2:[#6](-[#8]-[#6](-[#6])(-[#6])-[#6]3=[#6]-2-[#6]-[#6](-[#6])(-[#8])-[#6](-[#8])-[#6]-3):[#6]:1',
            'cannabidiolic acid tetrahydrocannabitriol ester ': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1)-[#8]-[#6](-[#6]1=[#6]-2-[#6](-[#6](-[#6](-[#6]-1)-[#8]-[#6](=[#8])-[#6]1:[#6](:[#6](:[#6](:[#6]:[#6]:1-[#6]-[#6]-[#6]-[#6]-[#6])-[#8])-[#6]1-[#6]=[#6](-[#6]-[#6]-[#6]-1-[#6](=[#6])-[#6])-[#6])-[#8])-[#6])-[#8])(-[#6])-[#6])-[#8]',
            'dehydrocannabifuran': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1):[#8]:[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:2:1)-[#6](=[#6])-[#6])-[#6])-[#8]',
            'cannabifuran': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1):[#8]:[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:2:1)-[#6](-[#6])-[#6])-[#6])-[#8]',
            'cannabichromanon': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1)-[#8]-[#6](-[#6](-[#6]-2=[#8])-[#6]-[#6]-[#6](=[#8])-[#6])(-[#6])-[#6])-[#8]',
            'cannabicitran': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]2:[#6]3-[#6]4-[#6]-[#6](-[#6]-[#6]-[#6]-4-[#6](-[#8]-2)(-[#6])-[#6])(-[#8]-[#6]:3:[#6]:1)-[#6]',
            '10-oxo-delta-6a,10a-tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](-[#8]):[#6]2:[#6](-[#8]-[#6](-[#6])(-[#6])-[#6]3=[#6]-2-[#6](=[#8])-[#6](-[#6])-[#6]-[#6]-3):[#6]:1',
            'delta-9 6a,10a-tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](-[#8]):[#6]2:[#6](-[#8]-[#6](-[#6])(-[#6])-[#6]3=[#6]-2-[#6]-[#6](-[#6])(-[#8])-[#6](-[#8])-[#6]-3):[#6]:1',
            '3,4,5,6-tetrahydro-7-hydroxy-alpha,alpha-2-trimethyl-9-n-propyl-2,6-methano-2h-1-benzoxocin-5-methanol': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]-[#6](-[#6]-[#6]-[#6]-3-[#6](-[#6])(-[#6])-[#8])(-[#8]-[#6]:2:[#6]:1)-[#6])-[#8]',
            '6a,9,10,10a-9,10-dihydroxyhexahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6](-[#6]-[#6]-[#6](-[#6]-3-[#8])(-[#6])-[#8])-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#8]',
            '6a,7,10a-trihydroxy-delta-9 tetrahydrocannabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3(-[#8])-[#6]=[#6](-[#6]-[#6](-[#8])-[#6]-3(-[#8])-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'choline': '[#6]-[#7+](-[#6])(-[#6])-[#6]-[#6]-[#8]',
            'trigonelline': '[#6]-[#7+]1:[#6]:[#6]:[#6]:[#6](:[#6]:1)-[#6](=[#8])-[#8-]',
            'muscarine': '[#6]-[#6]1-[#6](-[#6]-[#6](-[#8]-1)-[#6]-[#7+](-[#6])(-[#6])-[#6])-[#8]',
            'l-plus isoleucine betaine': '[#6]-[#7+](-[#6])(-[#6])-[#6]-[#6](=[#8])-[#8-]',
            'neurine': '[#6]-[#7+](-[#6])(-[#6])-[#6]=[#6].[#8H-]',
            'piperidine': '[#6]1-[#6]-[#6]-[#7]-[#6]-[#6]-1',
            'hordenine': '[#6]-[#7](-[#6])-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'ammonia': '[#7]',
            'methylamine': '[#6]-[#7]',
            'ethylamine': '[#6]-[#6]-[#7]',
            'n-propylamine': '[#6]-[#6]-[#6]-[#7]',
            'n-butylamine': '[#6]-[#6]-[#6]-[#6]-[#7]',
            'iso-butylamine': '[#6]-[#6](-[#6])-[#6]-[#7]',
            'secbutylamine': '[#6]-[#6]-[#6](-[#6])-[#7]',
            'dimethylamine': '[#6]-[#7]-[#6]',
            'pyrrolidine': '[#6]1-[#6]-[#6]-[#7]-[#6]-1',
            'cannabisativine': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6](-[#6]1-[#6]=[#6]-[#6]-[#6]2-[#7]-1-[#6]-[#6]-[#6]-[#7]-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](=[#8])-[#6]-2)-[#8])-[#8]',
            'anhydrocannabisativine': '[#6]-[#6]1(-[#6](-[#6](-[#8])-[#6]2-[#6]-[#6]-[#6]-[#6]-2)-[#8])-[#6]=[#6]-[#6]-[#6]2-[#6]-[#6](-[#7]-[#6]-[#6]-[#6]-[#6]-[#7]-[#6]-[#6]-[#6]-[#7]-1-2)=[#8]',
            'alanine': '[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'asparatic acid': '[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#6](=[#8])-[#8]',
            'cystine': '[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#16]-[#16]-[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'glutamic acid': '[#6]-[#6]-[#6](-[#8])=[#8]',
            'glycine': '[#6](-[#6](=[#8])-[#8])-[#7]',
            'serine': '[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#8]',
            'arginine': '[#6](-[#6]-[#6](-[#6](=[#8])-[#8])-[#7])-[#6]-[#7]=[#6](-[#7])-[#7]',
            'histidine': '[#6]1:[#6](:[#7H]:[#6]:[#7]:1)-[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'isoleucine': '[#6]-[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8])-[#7]',
            'leucine': '[#6]-[#6](-[#6])-[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'lysine': '[#6](-[#6]-[#6]-[#7])-[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'methionine': '[#6]-[#16]-[#6]-[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'phenylalanine': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'proline': '[#6]1-[#6]-[#6](-[#7]-[#6]-1)-[#6](=[#8])-[#8]',
            'threonine': '[#6]-[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#8]',
            'tryptophan': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1):[#6](:[#6]:[#7H]:2)-[#6]-[#6](-[#6](=[#8])-[#8])-[#7]',
            'tyrosine': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]-[#6](-[#6](=[#8])-[#8])-[#7])-[#8]',
            'valine': '[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8])-[#7]',
            'edestin': '[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6]-[#6](-[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8]',
            'zeatin': '[#6]-[#6](=[#6]-[#6]-[#7]-[#6]1:[#7]:[#6]:[#7]:[#6]2:[#6]:1:[#7H]:[#6]:[#7]:2)-[#6]-[#8]',
            'zeatin nucleoside': '[#6]-[#6](=[#6]-[#6]-[#7]-[#6]1:[#6]2:[#6](:[#7]:[#6]:[#7]:1):[#7](:[#6]:[#7]:2)-[#6]1-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#6]-[#8]',
            'glucosidase': '[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6]-[#6](-[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8]',
            'polyphenol oxidase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
            'peroxidase': '[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6]-[#6](-[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8]',
            'adenosine-5-triphosphatase': '[#6]1:[#7]:[#6](:[#6]2:[#6](:[#7]:1):[#7](:[#6]:[#7]:2)-[#6]1-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8]-[#15](=[#8])(-[#8])-[#8]-[#15](=[#8])(-[#8])-[#8]-[#15](=[#8])(-[#8])-[#8])-[#8])-[#8])-[#7]',
            'arabinose': '[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'fructose': '[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)(-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'galactose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8])-[#8]',
            'galacturonic acid': '[#6]1(-[#6](-[#6](-[#8]-[#6](-[#6]-1-[#8])-[#8])-[#6](=[#8])-[#8])-[#8])-[#8]',
            'alpha and beta d-glucose': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6]=[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'altro-heptulose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)(-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'd-manno-heptulose': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6](=[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'mannose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8])-[#8]',
            'd-glycerol-d-manno-octulose': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](=[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'rhamnose': '[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'ribose': '[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'xylose': '[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'sucrose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1(-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'maltose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'raffinose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1(-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'cellulose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'hemicellulose': '[#6]-[#6](-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8])-[#7]-[#6].[#6]-[#6](-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8])-[#7]-[#6]',
            'pectin': '[#6]1(-[#6](-[#6](-[#8]-[#6](-[#6]-1-[#8])-[#8])-[#6](=[#8])-[#8])-[#8])-[#8]',
            'xylan': '[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'arabitol': '[#6](-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'erythritol': '[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8]',
            'galactitol': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'glycerol': '[#6](-[#6](-[#6]-[#8])-[#8])-[#8]',
            'mannitol': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'ribitol': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#8]-1)-[#6](-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'sorbitol': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'xylitol': '[#6](-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'd-minus bornesitol': '[#8]-[#6]1-[#6](-[#8])-[#6](-[#8])-[#6](-[#8]-[#6])-[#6](-[#8])-[#6]-1-[#8]',
            'plus inositol': '[#6]1(-[#6](-[#6](-[#6](-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'myo inositol': '[#6]1(-[#6](-[#6](-[#6](-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'plus quebrachitol': '[#6]-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#8])-[#8]',
            'galactosamine': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#7])-[#8])-[#8])-[#8]',
            'glucosamine': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#7])-[#8])-[#8])-[#8]',
            'n-nonane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-decane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-undecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-dodecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-tridecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'd-tetradecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3,6-dimethyl-tridecane': '[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'n-pentadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '2,6-dimethyl tetradecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            'n-hexadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-heptadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '2,6-dimethyl hexadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6](-[#6])-[#6]',
            'n-octadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3,6-dimethyl heptadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6](-[#6])-[#6]-[#6]',
            '3,7-dimethyl heptadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'n-nonadecane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3,6-dimethyl octadecane': '[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            '3,7-dimethyl octadecane': '[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'n-eicosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-heneicosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3-methyl tricosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'n-tetracosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '2-methyl tetracosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            'n-pentacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-hexacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3-methyl-pentacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            '2-methyl hexacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            'n-heptacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3-methyl heptacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'n-octacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '2-methyl octacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            '9-methyl octacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'n-nonacosane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3-methyl triacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'n-triacotane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '2-methyl hentriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            'n-hentriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '3-methyl hentriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'n-dotriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '2-methyl dotriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            'n-tritriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'tetra-triacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'pentatriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'hexatriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'heptatriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'octatriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'nonatriacontane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'methanol': '[#6]-[#8]',
            'ethanol': '[#6]-[#6]-[#8]',
            'octanol-1': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]',
            'octanol-3': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])-[#6]-[#6]',
            'nonanol-1': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]',
            'hexadecanol-1': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'acetaldehyde': '[#6]-[#6]=[#8]',
            'isobutyraldehyde': '[#6]-[#6](-[#6])-[#6]=[#8]',
            'pentanal': '[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'hexanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'heptanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'octanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'nonanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'decanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'undecanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'dodecanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'tridecanal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8]',
            'p-ethylbenzaldehyde': '[#6]-[#6]-[#6]1:[#6]:[#6]:[#6](-[#6]=[#8]):[#6]:[#6]:1',
            'acetone': '[#6]-[#6](-[#6])=[#8]',
            'heptanone-2': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]',
            '2-methyl-2heptene-6-one': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])=[#8]',
            'decanone-2': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]',
            'undecanone-2': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]',
            'dodecanone-2': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]',
            'pentadecanone-2': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]',
            'octanone-3': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]-[#6]',
            '2,2,6-trimethyl cyclohexanone': '[#6]-[#6]1-[#6]-[#6]-[#6]-[#6](-[#6])(-[#6])-[#6]-1=[#8]',
            '2,2,6-trimethyl-5-cyclohexenone': '[#6]-[#6]1=[#6]-[#6]-[#6]-[#6](-[#6])(-[#6])-[#6]-1=[#8]',
            '3-decene-5-one': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]=[#6]-[#6]-[#6]',
            '6,10-dimethyl undecanone-2': '[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]',
            '6,10,14-trimethyl pentadecanone-2': '[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]',
            'arabinonic acid': '[#6](-[#6](-[#6](-[#6](-[#6](=[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'azelaic acid': '[#6](-[#6]-[#6]-[#6]-[#6](=[#8])-[#8])-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'cinnamic acid': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]=[#6]-[#6](=[#8])-[#8]',
            'citric acid': '[#8]-[#6](=[#8])-[#6]-[#6](-[#8])(-[#6]-[#6](-[#8])=[#8])-[#6](-[#8])=[#8]',
            'glucaric acid': '[#8]-[#6](-[#6](-[#8])-[#6](-[#8])-[#6](-[#8])=[#8])-[#6](-[#8])-[#6](-[#8])=[#8]',
            'gluconic acid': '[#8]-[#6]-[#6](-[#8])-[#6](-[#8])-[#6](-[#8])-[#6](-[#8])-[#6](-[#8])=[#8]',
            'glyceric acid': '[#8]-[#6]-[#6](-[#8])-[#6](-[#8])=[#8]',
            'p-hydroxybenzoic acid': '[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1',
            'p-hydroxycinnamic acid': '[#8]-[#6](=[#8])-[#6]=[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1',
            'isocitric acid': '[#8]-[#6](-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#8])=[#8])-[#6](-[#8])=[#8]',
            'malic acid': '[#8]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#8])=[#8]',
            'malonic acid': '[#8]-[#6](=[#8])-[#6]-[#6](-[#8])=[#8]',
            '3-methyoxy-4-hydroxycinnamic acetate': '[#6]-[#8]-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1)-[#6]=[#6]-[#6](=[#8])-[#8])-[#8-]',
            'phosphoric acid': '[#8]-[#15](-[#8])(-[#8])=[#8]',
            'pyroglutamic acid': '[#8]-[#6](=[#8])-[#6]1-[#6]-[#6]-[#6](=[#8])-[#7]-1',
            'quinic acid': '[#6]1-[#6](-[#6](-[#6](-[#6]-[#6]-1(-[#6](=[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'succinic acid': '[#8]-[#6](=[#8])-[#6]-[#6]-[#6](-[#8])=[#8]',
            'threonic acid': '[#8]-[#6]-[#6](-[#8])-[#6](-[#8])-[#6](-[#8])=[#8]',
            'vanillic acid': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#8])-[#6](-[#8])=[#8]',
            'arachidic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'behenic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'eicosadienic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]=[#6]-[#6](-[#8])=[#8]',
            'eicosemic acid': '[#8]=[#6](-[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]/[#6]=[#6]\[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'linoleic': '[#6]-[#6]-[#6]-[#6]-[#6]/[#6]=[#6]/[#6]/[#6]=[#6]/[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'linolenic acid': '[#6]-[#6]/[#6]=[#6]/[#6]/[#6]=[#6]/[#6]/[#6]=[#6]/[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'myristic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'oleic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]/[#6]=[#6]\[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'palmitic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'palmitoleic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]/[#6]=[#6]\[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'sativic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])-[#6](-[#8])-[#6]-[#6](-[#8])-[#6](-[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'stearic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#8])=[#8]',
            'benzyl acetate': '[#6]-[#6](=[#8])-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'para ethyl benzyl acetate': '[#6]-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#8]-[#6](=[#8])-[#6]',
            '3-hexenyl caproate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]',
            'hexyl acetate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]-[#6](-[#6])=[#8]',
            'hexyl butyrate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]',
            'hexyl isobutyrate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]-[#6](=[#8])-[#6](-[#6])-[#6]',
            'methyl acetate': '[#6]-[#8]-[#6](-[#6])=[#8]',
            'methyl linoleate': '[#6]-[#6]-[#6]-[#6]-[#6]/[#6]=[#6]\[#6]/[#6]=[#6]\[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]',
            'methyl palmitate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]',
            'methyl salicylate': '[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]',
            'octyl caproate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]-[#6]',
            'campesterol': '[#6]-[#6](-[#6])-[#6](-[#6])-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]=[#6]4-[#6]-[#6](-[#8])-[#6]-[#6]-[#6]-4(-[#6])-[#6]-3-[#6]-[#6]-[#6]-1-2-[#6]',
            'campest-5-en-3beta-ol-7-one': '[#6]-[#6](-[#6])-[#6](-[#6])-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]1-[#6]-2=[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6](-[#6]-2)-[#8])-[#6])-[#6]',
            'ergosterol': '[#6]-[#6](-[#6])-[#6](-[#6])/[#6]=[#6]/[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]3=[#6]-[#6]=[#6]4-[#6]-[#6](-[#8])-[#6]-[#6]-[#6]-4(-[#6])-[#6]-3-[#6]-[#6]-[#6]-1-2-[#6]',
            'beta-sitosterol': '[#6]-[#6]-[#6](-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]=[#6]4-[#6]-[#6](-[#8])-[#6]-[#6]-[#6]-4(-[#6])-[#6]-3-[#6]-[#6]-[#6]-1-2-[#6])-[#6](-[#6])-[#6]',
            '5alpha-stigmasta-7,24-dien-3beta-ol': '[#6]-[#6]-[#6](-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]3=[#6]-[#6]-[#6]4-[#6]-[#6](-[#8])-[#6]-[#6]-[#6]-4(-[#6])-[#6]-3-[#6]-[#6]-[#6]-1-2-[#6])=[#6](-[#6])-[#6]',
            'stigmasta-5,22-dien-3beta-ol-7-one': '[#6]-[#6]-[#6](-[#6]=[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]1-[#6]-2-[#6]-[#6]=[#6]2-[#6]-1(-[#6]-[#6]-[#6](-[#6]-2)-[#8]-[#6](=[#8])-[#6])-[#6])-[#6])-[#6](-[#6])-[#6]',
            'stigmast-5-en-3beta-ol-7-one': '[#6]-[#6]-[#6](-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]1-[#6]-2-[#6]-[#6]=[#6]2-[#6]-1(-[#6]-[#6]-[#6](-[#6]-2)-[#8])-[#6])-[#6])-[#6](-[#6])-[#6]',
            'stigmast-4-en-3-one': '[#6]-[#6]-[#6](-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]-[#6]4=[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-4(-[#6])-[#6]-3-[#6]-[#6]-[#6]-1-2-[#6])-[#6](-[#6])-[#6]',
            'stigmasterol': '[#6]-[#6]-[#6](/[#6]=[#6]/[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]=[#6]4-[#6]-[#6](-[#8])-[#6]-[#6]-[#6]-4(-[#6])-[#6]-3-[#6]-[#6]-[#6]-1-2-[#6])-[#6](-[#6])-[#6]',
            'borneol': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]-[#6]-1(-[#6])-[#6](-[#8])-[#6]-2',
            'bornyl acetate': '[#6]-[#6](=[#8])-[#8]-[#6]1-[#6]-[#6]2-[#6]-[#6]-[#6]-1(-[#6])-[#6]-2(-[#6])-[#6]',
            'camphene': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]-[#6](-[#6]-2)-[#6]-1=[#6]',
            'camphenehydrate': '[#6]-[#6]1(-[#6]2-[#6]-[#6]-[#6](-[#6]-2)-[#6]-1(-[#6])-[#8])-[#6]',
            'camphor': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]-[#6]-1(-[#6])-[#6](=[#8])-[#6]-2',
            'delta-3 carene': '[#6]-[#6]1=[#6]-[#6]-[#6]2-[#6](-[#6]-1)-[#6]-2(-[#6])-[#6]',
            'delta-4 carene': '[#6]-[#6]1-[#6]-[#6]2-[#6](-[#6]-2(-[#6])-[#6])-[#6]=[#6]-1',
            'carvacrol': '[#6]-[#6](-[#6])-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6](-[#8]):[#6]:1',
            'carvone': '[#6]-[#6](=[#6])-[#6]1-[#6]-[#6]=[#6](-[#6])-[#6](=[#8])-[#6]-1',
            'beta-cyclocitral': '[#6]-[#6]1=[#6](-[#6]=[#8])-[#6](-[#6])(-[#6])-[#6]-[#6]-[#6]-1',
            '1,4-cineol': '[#6]-[#6](-[#6])-[#6]12-[#6]-[#6]-[#6](-[#6])(-[#6]-[#6]-1)-[#8]-2',
            '1,8-cineol': '[#6]-[#6]12-[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](-[#6])(-[#6])-[#8]-2',
            'citral b': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]/[#6](-[#6])=[#6]\[#6]=[#8]',
            'citronellol': '[#6]-[#6](-[#6]-[#6]-[#8])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]',
            'para cymene': '[#6]-[#6](-[#6])-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            'para cymene-8-ol': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6])(-[#6])-[#8]',
            'dihydrocarveyl acetate': '[#6]-[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1-[#8]-[#6](-[#6])=[#8])-[#6](-[#6])=[#6]',
            'dihydrocarvone': '[#6]-[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1=[#8])-[#6](-[#6])=[#6]',
            'fenchyl alcohol': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]-[#6](-[#6])(-[#6]-2)-[#6]-1-[#8]',
            'fenchone': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]-[#6](-[#6])(-[#6]-2)-[#6]-1=[#8]',
            'geraniol': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]/[#6](-[#6])=[#6]/[#6]-[#8]',
            'geranyl acetone': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]/[#6](-[#6])=[#6]/[#6]-[#6]-[#6](-[#6])=[#8]',
            'limonene': '[#6]-[#6](=[#6])-[#6]1-[#6]-[#6]-[#6](=[#6]-[#6]-1)-[#6]',
            'linalool': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])(-[#8])-[#6]=[#6]',
            'linalool oxide': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])(-[#8])-[#6]1-[#6]-[#8]-1',
            'meta mentha-1,8-dien-5-ol': '',
            '1-methyl-4-iso-propenylbenzene': '[#6]-[#6](=[#6])-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            'myrcene': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](=[#6])-[#6]=[#6]',
            'nerol': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]/[#6](-[#6])=[#6]\[#6]-[#8]',
            'nerolidol': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])(-[#8])-[#6]=[#6]',
            'beta-ocimene': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]=[#6](-[#6])-[#6]=[#6]',
            'perillene': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6]1:[#6]:[#8]:[#6]:[#6]:1',
            'alpha-phellandrene': '[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-1',
            'beta-phellandrene': '[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6](=[#6])-[#6]=[#6]-1',
            '3-phenyl-2-methyl-prop-1-ene': '[#6]-[#6](=[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'alpha-pinene': '[#6]-[#6]1=[#6]-[#6]-[#6]2-[#6]-[#6]-1-[#6]-2(-[#6])-[#6]',
            'beta-pinene': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]-[#6](=[#6])-[#6]-1-[#6]-2',
            'alpha-pinene oxide': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]3-[#8]-[#6]-3(-[#6])-[#6]-1-[#6]-2',
            'pinocarveol': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6](-[#8])-[#6](=[#6])-[#6]-1-[#6]-2',
            'pinocarvone': '[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]-1-[#6](=[#6])-[#6](=[#8])-[#6]-2',
            'piperitenone': '[#6]-[#6](-[#6])=[#6]1-[#6]-[#6]-[#6](=[#6]-[#6]-1=[#8])-[#6]',
            'piperitone oxide': '[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2(-[#6])-[#8]-[#6]-2-[#6]-1=[#8]',
            'piperitenone oxide': '[#6]-[#6](-[#6])=[#6]1-[#6]-[#6]-[#6]2(-[#6])-[#8]-[#6]-2-[#6]-1=[#8]',
            'pulegone': '[#6]-[#6]1-[#6]-[#6]-[#6](=[#6](-[#6])-[#6])-[#6](=[#8])-[#6]-1',
            'sabinene': '[#6]-[#6](-[#6])-[#6]12-[#6]-[#6]-[#6](=[#6])-[#6]-1-[#6]-2',
            'sabiene hydrate': '[#6]-[#6](-[#6])-[#6]12-[#6]-[#6]-[#6](-[#6]-1-[#6]-2)(-[#6])-[#8]',
            'sabinol': '[#6]-[#6](-[#6])-[#6]12-[#6]-[#6](-[#8])-[#6](=[#6])-[#6]-1-[#6]-2',
            'safranal': '[#6]-[#6]1=[#6](-[#6]=[#8])-[#6](-[#6])(-[#6])-[#6]-[#6]=[#6]-1',
            'alpha thujene': '[#6]-[#6]1=[#6]-[#6]-[#6]2(-[#6]-1-[#6]-2)-[#6](-[#6])-[#6]',
            'alpha terpinene': '[#6]-[#6]1=[#6]-[#6]=[#6](-[#6]-[#6]-1)-[#6](-[#6])-[#6]',
            'gamma terpinene': '[#6]-[#6]1=[#6]-[#6]-[#6](=[#6]-[#6]-1)-[#6](-[#6])-[#6]',
            'alpha terpiene-4-ol': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6](-[#6])-[#6])-[#8]',
            'alpha terpinolene': '[#6]-[#6]1=[#6]-[#6]-[#6](=[#6](-[#6])-[#6])-[#6]-[#6]-1',
            'alpha terpineol': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](-[#6])(-[#6])-[#8]',
            'beta terpineol': '[#6]-[#6](=[#6])-[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6])-[#8]',
            'thujyl alcohol': '[#6]-[#6](-[#6])-[#6]12-[#6]-[#6]-1-[#6](-[#6])-[#6]-[#6]-2-[#8]',
            'allo-aromadendrene': '[#6]-[#6]1-[#6]-[#6]-[#6]2-[#6]-1-[#6]1-[#6](-[#6]-1(-[#6])-[#6])-[#6]-[#6]-[#6]-2=[#6]',
            'alpha-bergamotene': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6]1(-[#6])-[#6]2-[#6]-[#6]=[#6](-[#6])-[#6]-1-[#6]-2',
            'beta bisabolene': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](=[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]',
            'alpha bisabolol': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](-[#6])(-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#8]',
            'calamenene': '[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6](-[#6])-[#6]2:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:2-1',
            'caryophyllene': '[#6]/[#6]1=[#6]\[#6]-[#6]-[#6](=[#6])-[#6]2-[#6]-[#6](-[#6])(-[#6])-[#6]-2-[#6]-[#6]-1',
            'alpha caryophyllene': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]=[#6]-[#6]-[#6](=[#6]-[#6]-[#6]-1)-[#6])(-[#6])-[#6]',
            'beta caryophyllene': '[#6]-[#6]1=[#6]-[#6]-[#6]-[#6](=[#6])-[#6]2-[#6]-[#6](-[#6]-2-[#6]-[#6]-1)(-[#6])-[#6]',
            'alpha caryophyllene alcohol': '[#6]-[#6]1(-[#6]-[#6]2-[#6](-[#6]-1)-[#6]1(-[#6]-[#6]-[#6]-[#6]-2(-[#6]-1-[#8])-[#6])-[#6])-[#6]',
            'isocarophyllene': '[#6]-[#6]1=[#6]-[#6]-[#6]-[#6](=[#6])-[#6]2-[#6]-[#6](-[#6]-2-[#6]-[#6]-1)(-[#6])-[#6]',
            'caryophyllene oxide': '[#6]-[#6]1(-[#6])-[#6]-[#6]2-[#6]-1-[#6]-[#6]-[#6]1(-[#6])-[#8]-[#6]-1-[#6]-[#6]-[#6]-2=[#6]',
            'alpha cedrene': '[#6]-[#6]1-[#6]-[#6]-[#6]2-[#6]-13-[#6]-[#6]=[#6](-[#6](-[#6]-3)-[#6]-2(-[#6])-[#6])-[#6]',
            'gamma cadinene': '[#6]-[#6]1=[#6]-[#6]2-[#6](-[#6]-[#6]-1)-[#6](=[#6])-[#6]-[#6]-[#6]-2-[#6](-[#6])-[#6]',
            'delta cadinene': '[#6]-[#6]1=[#6]-[#6]2-[#6](-[#6]-[#6]-[#6](=[#6]-2-[#6]-[#6]-1)-[#6])-[#6](-[#6])-[#6]',
            'alpha copaene': '[#6]-[#6]1=[#6]-[#6]-[#6]2-[#6]3-[#6]-1-[#6]-2(-[#6]-[#6]-[#6]-3-[#6](-[#6])-[#6])-[#6]',
            'alpha cubebene': '[#6]-[#6]1-[#6]-[#6]-[#6](-[#6]2-[#6]-13-[#6]-2-[#6](=[#6]-[#6]-3)-[#6])-[#6](-[#6])-[#6]',
            'alpha curcumene': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]',
            'beta cucumene': '[#6]-[#6]1=[#6]-[#6]-[#6](=[#6]-[#6]-1)-[#6](-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]',
            'gamma elemene': '[#6]-[#6](=[#6]1-[#6]-[#6]-[#6](-[#6](-[#6]-1)-[#6](=[#6])-[#6])(-[#6])-[#6]=[#6])-[#6]',
            'gamma eudesmol': '[#6]-[#6]1=[#6]2-[#6]-[#6](-[#6]-[#6]-[#6]-2(-[#6]-[#6]-[#6]-1)-[#6])-[#6](-[#6])(-[#6])-[#8]',
            'beta farnesene': '[#6]-[#6](=[#6]-[#6]-[#6]-[#6](=[#6]-[#6]-[#6]-[#6](=[#6])-[#6]=[#6])-[#6])-[#6]',
            'z beta farnesene': '[#6]-[#6]-[#6](=[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]',
            'alpha farnesene': '[#6]-[#6](=[#6]-[#6]-[#6]-[#6](=[#6]-[#6]-[#6]=[#6](-[#6])-[#6]=[#6])-[#6])-[#6]',
            'farnesol': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])=[#6]-[#6]-[#8]',
            'farnesyl acetone': '[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])=[#6]-[#6]-[#6]-[#6](-[#6])=[#8]',
            'alpha gurjunene': '[#6]-[#6]1-[#6]-[#6]-[#6]2-[#6](-[#6]-2(-[#6])-[#6])-[#6]2=[#6](-[#6]-[#6]-[#6]-1-2)-[#6]',
            'guaiol': '[#6]-[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]2=[#6]-1-[#6]-[#6]-[#6]-2-[#6])-[#6](-[#6])(-[#6])-[#8]',
            'beta humulene': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]=[#6]-[#6]-[#6](=[#6])-[#6]-[#6]-[#6]-1)(-[#6])-[#6]',
            'humelene epoxide i': '[#6]-[#6]1=[#6]-[#6]-[#6]-[#6]2(-[#6](-[#8]-2)-[#6]-[#6](-[#6]=[#6]-[#6]-1)(-[#6])-[#6])-[#6]',
            'humelene epoxide ii': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]=[#6]-[#6]-[#6]2(-[#6](-[#8]-2)-[#6]-[#6]-1)-[#6])(-[#6])-[#6]',
            'ledol': '[#6]-[#6]1-[#6]-[#6]-[#6]2-[#6]-1-[#6]1-[#6](-[#6]-[#6]-[#6]-2(-[#6])-[#8])-[#6]-1(-[#6])-[#6]',
            'longifolene': '[#6]-[#6]1(-[#6])-[#6]-[#6]-[#6]-[#6]2(-[#6])-[#6]3-[#6]-[#6]-[#6](-[#6]-1-3)-[#6]-2=[#6]',
            'epi-beta-sanalene': '[#6]-[#6](=[#6]-[#6]-[#6]-[#6]1(-[#6]2-[#6]-[#6]-[#6](-[#6]-2)-[#6]-1=[#6])-[#6])-[#6]',
            'alpha selinene': '[#6]-[#6]1=[#6]-[#6]-[#6]-[#6]2(-[#6]-1-[#6]-[#6](-[#6]-[#6]-2)-[#6](=[#6])-[#6])-[#6]',
            'beta selinene': '[#6]-[#6](=[#6])-[#6]1-[#6]-[#6]-[#6]2(-[#6]-[#6]-[#6]-[#6](=[#6])-[#6]-2-[#6]-1)-[#6]',
            'selina-3,7-diene': '[#6]-[#6](-[#6])-[#6]1=[#6]-[#6]-[#6@@]2(-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]-2-[#6]-1',
            'selina-4,7-diene': '[#6]-[#6]1=[#6]2-[#6]-[#6](=[#6]-[#6]-[#6]-2(-[#6]-[#6]-[#6]-1)-[#6])-[#6](-[#6])-[#6]',
            'friedelin': '[#6]-[#6]1-[#6](=[#8])-[#6]-[#6]-[#6]2-[#6]-1(-[#6])-[#6]-[#6]-[#6]1-[#6]-2(-[#6])-[#6]-[#6]-[#6]2(-[#6])-[#6]3-[#6]-[#6](-[#6])(-[#6])-[#6]-[#6]-[#6]-3(-[#6])-[#6]-[#6]-[#6]-1-2-[#6]',
            'epifriedelanol': '[#6]-[#6]1-[#6](-[#8])-[#6]-[#6]-[#6]2-[#6]-1(-[#6])-[#6]-[#6]-[#6]1-[#6]-2(-[#6])-[#6]-[#6]-[#6]2(-[#6])-[#6]3-[#6]-[#6](-[#6])(-[#6])-[#6]-[#6]-[#6]-3(-[#6])-[#6]-[#6]-[#6]-1-2-[#6]',
            'vomifoliol': '[#6]-[#6](-[#8])/[#6]=[#6]/[#6]1(-[#8])-[#6](=[#6]-[#6](=[#8])-[#6]-[#6]-1(-[#6])-[#6])-[#6]',
            'dihydrovomifoliol': '[#6]-[#6]1(-[#6])-[#6]-[#6]-[#6]-[#6]2(-[#6])-[#8]-[#6](=[#8])-[#6]=[#6]-1-2',
            'beta ionone': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#8])-[#6]',
            'dihydroactinidiolide': '[#6]-[#6]1(-[#6]-[#6]-[#6]-[#6]2(-[#6]-1=[#6]-[#6](=[#8])-[#8]-2)-[#6])-[#6]',
            'acetylcannabispirol': '[#6]-[#8]-[#6]1:[#6]:[#6]2-[#6]-[#6]-[#6]3(-[#6]-[#6]-[#6](-[#6]-[#6]-3)-[#8]-[#6](=[#8])-[#6])-[#6]:2:[#6](-[#8]):[#6]:1',
            'cannabispiradienone': '[#6]-[#8]-[#6]1:[#6]:[#6]2:[#6](:[#6](:[#6]:1)-[#8])-[#6]1(-[#6]-[#6]-2)-[#6]=[#6]-[#6](=[#8])-[#6]=[#6]-1',
            'beta cannabispiranol': '[#6]-[#8]-[#6]1:[#6]:[#6]2:[#6](:[#6](:[#6]:1)-[#8])-[#6]1(-[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#8])-[#6]-[#6]-2',
            'cannabispirenone': '[#6]-[#8]-[#6]1:[#6]:[#6]2:[#6](:[#6](:[#6]:1)-[#8])-[#6]1(-[#6]-[#6]-[#6](=[#8])-[#6]=[#6]-1)-[#6]-[#6]-2',
            'cannabispirenone-isomer': '[#6]-[#8]-[#6]1:[#6]:[#6]2:[#6](:[#6](:[#6]:1)-[#8])-[#6]1(-[#6]-[#6]-[#6](=[#8])-[#6]=[#6]-1)-[#6]-[#6]-2',
            'cannabispirone': '[#6]-[#8]-[#6]1:[#6]:[#6]2:[#6](:[#6](:[#6]:1)-[#8])-[#6]1(-[#6]-[#6]-[#6](=[#8])-[#6]-[#6]-1)-[#6]-[#6]-2',
            '3-[2-(4-hydroxyphenyl)ethyl]-5-methoxyphenol': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#8]):[#6]:[#6](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:2):[#6]:1',
            '3-[2-(3-hydroxy-4-methoxyphenyl)ethyl]-5-methoxyphenol': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#8]):[#6]:[#6](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6](-[#8]-[#6]):[#6](-[#8]):[#6]:2):[#6]:1',
            '3-[2-(3-isoprenyl-4-hydroxy-5-methoxy-phenyl)ethyl]-5-methoxyphenol': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#8]):[#6]:[#6](-[#6]-[#6]-[#6]2:[#6]:[#6](-[#8]-[#6]):[#6](-[#8]):[#6](-[#6]=[#6]-[#6](-[#6])=[#6]):[#6]:2):[#6]:1',
            'canniprene': '[#6]-[#6](=[#6]-[#6]-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1-[#8])-[#8]-[#6])-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1)-[#8]-[#6])-[#8])-[#6]',
            'eugenol': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#6]-[#6]=[#6]):[#6]:[#6]:[#6]:1-[#8]',
            'isoeugenol': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#6]=[#6]-[#6]):[#6]:[#6]:[#6]:1-[#8]',
            'anethol': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6]=[#6]-[#6]):[#6]:[#6]:1',
            'methyleugenol': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6]=[#6]):[#6]:[#6]:1-[#8]-[#6]',
            'apigenin-7-o-para coumarylglucoside': '[#8]-[#6]1-[#6](-[#6]-[#8]-[#6](=[#8])/[#6]=[#6]/[#6]2:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:2)-[#8]-[#6](-[#8]-[#6]2:[#6]:[#6](-[#8]):[#6]3:[#6](=[#8]):[#6]:[#6](:[#8]:[#6]:3:[#6]:2)-[#6]2:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:2)-[#6](-[#8])-[#6]-1',
            'cosmosioside': '[#8]-[#6]-[#6]1-[#8]-[#6](-[#8]-[#6]2:[#6]:[#6](-[#8]):[#6]3:[#6](=[#8]):[#6]:[#6](:[#8]:[#6]:3:[#6]:2)-[#6]2:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:2)-[#6](-[#8])-[#6](-[#8])-[#6]-1-[#8]',
            'apigenin-o-glycoside': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6]:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'isovitesin-7-o-rhamnoglucoside': '[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1:[#6](:[#6](:[#6]2:[#6](:[#6]:1):[#8]:[#6](:[#6]:[#6]:2=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'kaempferol-o-glycoside': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6](:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'luteolin-o-glycoside': '[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#6]1:[#6]:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]',
            'orientin': '[#8]-[#6]-[#6]1-[#8]-[#6](-[#6](-[#8])-[#6](-[#8])-[#6]-1-[#8])-[#6]1:[#6](-[#8]):[#6]:[#6](-[#8]):[#6]2:[#6](=[#8]):[#6]:[#6](:[#8]:[#6]:1:2)-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6](-[#8]):[#6]:1',
            'orientin-o-glucoside': '[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#6]1:[#6]:[#6](=[#8]):[#6]2:[#6](:[#8]:1):[#6](:[#6](:[#6]:[#6]:2-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'orientin-7-o-rhamnoglucoside': '[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1:[#6](:[#6]2:[#6](:[#6](:[#6]:1)-[#8]):[#6](=[#8]):[#6]:[#6](:[#8]:2)-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'quercetin-o-glucoside': '[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#6]1:[#6](:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'vitexin-7-o-g"-glucoside': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6]:[#6](=[#8]):[#6]2:[#6](:[#8]:1):[#6](:[#6](:[#6]:[#6]:2-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'vitexin-o-glucoside': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6]:[#6](=[#8]):[#6]2:[#6](:[#8]:1):[#6](:[#6](:[#6]:[#6]:2-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]',
            'vitexin-o-rhamnoglucoside': '[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#8]-[#6]-1-[#6]1:[#6](:[#6]:[#6](:[#6]2:[#6]:1:[#8]:[#6](:[#6]:[#6]:2=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            '2"-o-glucopyranosylvitexin': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6]:[#6](=[#8]):[#6]2:[#6](:[#8]:1):[#6](:[#6](:[#6]:[#6]:2-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'vitamin k': '[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]/[#6](-[#6])=[#6]/[#6]-[#6]1=[#6](-[#6])-[#6](=[#8])-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#6]-1=[#8]',
            'carotene': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6]-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6]',
            'zanthophylls': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6](-[#6]-1)-[#8])(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1-[#6](=[#6]-[#6](-[#6]-[#6]-1(-[#6])-[#6])-[#8])-[#6])-[#6])-[#6]',
            'cannabichromanone c3': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1)-[#8]-[#6](-[#6](-[#6]-2=[#8])-[#6]-[#6]-[#6](=[#8])-[#6])(-[#6])-[#6])-[#8]',
            'cannabielsoin c3': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6](-[#6]-[#6]-[#6](-[#6]-3-[#8]-[#6]:2:[#6]:1)(-[#6])-[#8])-[#6](=[#6])-[#6])-[#8]',
            'cannabielsoin acid b': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6](-[#6]-[#6]-[#6](-[#6]-3-[#8]-[#6]:2:[#6]:1-[#6](=[#8])-[#8])(-[#6])-[#8])-[#6](=[#6])-[#6])-[#8]',
        }

        return smarts