#!/usr/bin/env python3
#
# GlobalChem - Lube Ingredients in Products
#
# -----------------------------------------

class ExsensProducts(object):

    def __init__(self):

        self.name = 'exsens_products'

    @staticmethod
    def get_smiles():

        smiles = {
            'water': 'O',
            'sodium hydroxide': '[OH-].[Na+]',
            'glycerin': 'C(C(CO)O)O',
            'propylene glycol': 'CC(CO)O',
            'hydroxyethylcellulose': 'CC(COCC1C(C(C(C(O1)OC2C(OC(C(C2OCC(C)O)OCC(C)O)OCC(C)O)COCC(C)O)OCC(C)O)OCC(C)O)OCC(C)O)O',
            'sodium benzoate': 'C1=CC=C(C=C1)C(=O)[O-].[Na+]',
            'potassium sorbate': 'CC=CC=CC(=O)[O-].[K+]',
            'sodium saccharine': 'C1=CC=C2C(=C1)C(=O)NS2(=O)=O.[Na+]',
            'citric acid': 'C(C(=O)O)C(CC(=O)O)(C(=O)O)O',
            'rebaudioside a': 'CC12CCCC(C1CCC34C2CCC(C3)(C(=C)C4)OC5C(C(C(C(O5)CO)O)OC6C(C(C(C(O6)CO)O)O)O)OC7C(C(C(C(O7)CO)O)O)O)(C)C(=O)OC8C(C(C(C(O8)CO)O)O)O',
            'sunflower seed oil': 'N12C(N([H])[H])=NC([H])([H])C1([H])C1=C([H])C([H])=C([H])C([H])=C1C([H])([H])C1=C([H])C([H])=C([H])C([H])=C21',
            'polyglyceryl 6 distearate': 'CCCCCCCCCCCCCCCCCC(=O)OCC(COCC(COCC(COC(=O)CCCCCCCCCCCCCCCCC)O)O)O',
            'beeswax': 'CCCCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCC(=O)O.CC(CCCCCCCCCCCCCC(=O)[O-])O.CCCCCCCCC=CCCCCCCCC(=O)O',
            'sodium acrylate': 'C=CC(=O)[O-].[Na+]',
            'shea butter oil': r'CCCCCCCCC=CCCCCCCCC(=O)O.CCCCCCCCCCCCCCCCCC(=O)O.CCCCCCCCCCCCCCCC(=O)O.CCCCC/C=C\C/C=C\CCCCCCCC(=O)O',
            'tocopherol': 'CC1=C(C2=C(CCC(O2)(C)CCCC(C)CCCC(C)CCCC(C)C)C(=C1O)C)C',
            'jojoba oil': 'CCCCCCCCC=CCCCCCCCC=O.CCCCCCCCC=CCCCCCCCCCCO.CCCCCCCCC=CCCCCCCCCCCCCO[Si](C)(C)C(C)(C)C.CCCCCCCCC=CCCCCCCCCCCCCCC(=O)O',
            'lecithin': 'CCCCCCCCC(=O)OC(COC(=O)CCCCCCCC=CCC=CCCCCC)COP(=O)(CC[N+](C)(C)C)[O-]',
            'cetyl alcohol': 'OCCCCCCCCCCCCCCCC',
            'polyglyceryl-3 beeswax': 'C(C(CO)O)O.CCCCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCCCCCCCCC.CCCCCCCCCCCCCCCC(=O)O.CC(CCCCCCCCCCCCCC(=O)[O-])O.CCCCCCCCC=CCCCCCCCC(=O)O',
            'xanthan gum': 'CC(=O)OCC1C(C(C(C(O1)OC2C(C(OC(C2OC3C(C(C(C(O3)CO)OP)O)O)CO)CP)O)OC4C(C(C(C(O4)C(=O)O)OC5C(C(C6C(O5)COC(O6)(C)C(=O)O)O)O)O)O)O)O',
            'benzyl alcohol': 'C1=CC=C(C=C1)CO',
            'polyglyceryl-6 disterate': 'CCCCCCCCCCCCCCCCCC(=O)O.C(C(COCC(COCC(COCC(COCC(COCC(CO)O)O)O)O)O)O)O',
            'ethyl menthane carboxamide':'CCNC(=O)C1CC(CCC1C(C)C)C',
            'caprylic acid':'CCCCCCCC(=O)O',
            'capric triglyceride':'CCCCCCCCCCCCCCCC(=O)O.C(C(CO)O)O',
            'isopropyl palmitate': 'CCCCCCCCCCCCCCCC(=O)OC(C)C',
            'prunus amygdalus dulcis oil':'CS(=O)(=O)O.CS(=O)(=O)O.C=CCNC1=NC(=NC(=N1)N2CCN(CC2)C(C3=CC=C(C=C3)F)C4=CC=C(C=C4)F)NCC=C',
            'hydrated silica': 'O.O=[Si]=O',
            'parfum': 'CCOC(=O)C1=CC=CC=C1C(=O)OCC',
            'synthetic fluorphlogopite': '[O-2].[O-2].[O-2].[O-2].[O-2].[O-2].[O-2].[O-2].[O-2].[O-2].[F-].[F-].[Mg+2].[Mg+2].[Mg+2].[Al+3].[Si+4].[Si+4].[Si+4].[K+]',
            'iron hydroxide': '[OH-].[OH-].[OH-].[Fe+3]',
            'titanium dioxide': 'O=[Ti]=O',
            'hexyl cinnamal': 'CCCCCCC(=CC1=CC=CC=C1)C=O',
            'linalool': 'CC(=CCCC(C)(C=C)O)C',
            'citronellol':'CC(CCC=C(C)C)CCO',
            'alpha isomethyl ionone': 'CC1=CCCC(C1C=C(C)C(=O)C)(C)C',
            'benzyl salicylate':'C1=CC=C(C=C1)COC(=O)C2=CC=CC=C2O',
            'citral': 'O=CC=C(C)CCC=C(C)C',
            'eugenol': 'COC1=C(C=CC(=C1)CC=C)O',
            'amyl cinnamal':'CCCCCC(=CC1=CC=CC=C1)C=O',
            'isoeugenol': r'C/C=C/C1=CC(=C(C=C1)O)OC',
            'sesame seed oil': 'CCCCCCCCCCCCCCCCCC(=O)O.CCCCCCCCCCCCCCCC(=O)O.CCCCCCCCC=CCCCCCCCC(=O)O.CCCCCC=CCC=CCCCCCCCC(=O)O',
            'orbignya oleifera seed oil': 'CCCCCCCCCCCC(=O)O.CCCCCCCCCCCCCC(=O)O.CCCCCCCCC=CCCCCCCCC(=O)O',
            'macadamia ternifolia seed oil': r'O=C(O)CCCCCCC\C=C/CCCCCC',
            'limonene': 'CC1=CCC(CC1)C(=C)C',
            'avocado oil': 'CCCCCCCCCCCCCCCCCC(=O)OCC.CCCCCCCCCCCCCCCC(=O)OCC.CCCCCCCCC=CCCCCCCCC(=O)OCC.CCCCCCC=CCCCCCCCC(=O)OCC.CCCCCC=CCC=CCCCCCCCC(=O)OCC.CCC=CCC=CCC=CCCCCCCCC(=O)OCC',
            'coconut oil': 'CCCCCCCCCCCC(=O)OC(COC(=O)CCCCCCC)COC(=O)CCCCCCCCC',
            'hydroxycitronellal': 'CC(CCCC(C)(C)O)CC=O',
            'geraniol': r'CC(=CCC/C(=C/CO)/C)C',
            'cinnamyl alcohol': 'C1=CC=C(C=C1)C=CCO',
            'coumarin': 'C1=CC=C2C(=C1)C=CC(=O)O2',
            'phenoxyethanol': 'C1=CC=C(C=C1)OCCO',
            'butylphenyl methylpropional': 'CC(CC1=CC=C(C=C1)C(C)(C)C)C=O',
            'apricot kernel oil': 'C1=CC=C(C=C1)C(C#N)OC2C(C(C(C(O2)COC3C(C(C(C(O3)CO)O)O)O)O)O)O',
            'aloe vera leaf juice': 'CC1=CC=C(C=C1)C(=O)C=CC2=CC(=CC=C2)[N+](=O)[O-]'
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'water': '[#8]',
            'sodium hydroxide': '[#8H-].[Na+]',
            'glycerin': '[#6](-[#6](-[#6]-[#8])-[#8])-[#8]',
            'propylene glycol': '[#6]-[#6](-[#6]-[#8])-[#8]',
            'hydroxyethylcellulose': '[#6]-[#6](-[#6]-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#6]-1-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#6]-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]',
            'sodium benzoate': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#8])-[#8-].[Na+]',
            'potassium sorbate': '[#6]-[#6]=[#6]-[#6]=[#6]-[#6](=[#8])-[#8-].[K+]',
            'sodium saccharine': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1)-[#6](=[#8])-[#7]-[#16]-2(=[#8])=[#8].[Na+]',
            'citric acid': '[#6](-[#6](=[#8])-[#8])-[#6](-[#6]-[#6](=[#8])-[#8])(-[#6](=[#8])-[#8])-[#8]',
            'rebaudioside a': '[#6]-[#6]12-[#6]-[#6]-[#6]-[#6](-[#6]-1-[#6]-[#6]-[#6]13-[#6]-2-[#6]-[#6]-[#6](-[#6]-1)(-[#6](=[#6])-[#6]-3)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])(-[#6])-[#6](=[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]',
            'sunflower seed oil': '[#7]12-[#6](-[#7H2])=[#7]-[#6H2]-[#6H]-1-[#6]1:[#6H]:[#6H]:[#6H]:[#6H]:[#6]:1-[#6H2]-[#6]1:[#6H]:[#6H]:[#6H]:[#6H]:[#6]:1-2',
            'polyglyceryl 6 distearate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])-[#8])-[#8])-[#8]',
            'beeswax': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8-])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'sodium acrylate': '[#6]=[#6]-[#6](=[#8])-[#8-].[Na+]',
            'shea butter oil': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]/[#6]=[#6]\[#6]/[#6]=[#6]\[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'tocopherol': '[#6]-[#6]1:[#6](:[#6]2:[#6](-[#6]-[#6]-[#6](-[#8]-2)(-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]):[#6](:[#6]:1-[#8])-[#6])-[#6]',
            'jojoba oil': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]-[Si](-[#6])(-[#6])-[#6](-[#6])(-[#6])-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'lecithin': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6](-[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6])-[#6]-[#8]-[#15](=[#8])(-[#6]-[#6]-[#7+](-[#6])(-[#6])-[#6])-[#8-]',
            'cetyl alcohol': '[#8]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'polyglyceryl-3 beeswax': '[#6](-[#6](-[#6]-[#8])-[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8-])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'xanthan gum': '[#6]-[#6](=[#8])-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#6](-[#8]-[#6](-[#6]-1-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8]-[#15])-[#8])-[#8])-[#6]-[#8])-[#6]-[#15])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6](=[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6]2-[#6](-[#8]-1)-[#6]-[#8]-[#6](-[#8]-2)(-[#6])-[#6](=[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'benzyl alcohol': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#8]',
            'polyglyceryl-6 disterate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6](-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'ethyl menthane carboxamide': '[#6]-[#6]-[#7]-[#6](=[#8])-[#6]1-[#6]-[#6](-[#6]-[#6]-[#6]-1-[#6](-[#6])-[#6])-[#6]',
            'caprylic acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'capric triglyceride': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6](-[#6](-[#6]-[#8])-[#8])-[#8]',
            'isopropyl palmitate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6](-[#6])-[#6]',
            'prunus amygdalus dulcis oil': '[#6]-[#16](=[#8])(=[#8])-[#8].[#6]-[#16](=[#8])(=[#8])-[#8].[#6]=[#6]-[#6]-[#7]-[#6]1:[#7]:[#6](:[#7]:[#6](:[#7]:1)-[#7]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6](-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9])-[#7]-[#6]-[#6]=[#6]',
            'hydrated silica': '[#8].[#8]=[Si]=[#8]',
            'parfum': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6](=[#8])-[#8]-[#6]-[#6]',
            'synthetic fluorphlogopite': '[#8-2].[#8-2].[#8-2].[#8-2].[#8-2].[#8-2].[#8-2].[#8-2].[#8-2].[#8-2].[#9-].[#9-].[Mg+2].[Mg+2].[Mg+2].[Al+3].[Si+4].[Si+4].[Si+4].[K+]',
            'iron hydroxide': '[#8H-].[#8H-].[#8H-].[Fe+3]',
            'titanium dioxide': '[#8]=[Ti]=[#8]',
            'hexyl cinnamal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]=[#8]',
            'linalool': '[#6]-[#6](=[#6]-[#6]-[#6]-[#6](-[#6])(-[#6]=[#6])-[#8])-[#6]',
            'citronellol': '[#6]-[#6](-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#6]-[#6]-[#8]',
            'alpha isomethyl ionone': '[#6]-[#6]1=[#6]-[#6]-[#6]-[#6](-[#6]-1-[#6]=[#6](-[#6])-[#6](=[#8])-[#6])(-[#6])-[#6]',
            'benzyl salicylate': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]',
            'citral': '[#8]=[#6]-[#6]=[#6](-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6]',
            'eugenol': '[#6]-[#8]-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1)-[#6]-[#6]=[#6])-[#8]',
            'amyl cinnamal': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]=[#8]',
            'isoeugenol': '[#6]/[#6]=[#6]/[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]',
            'sesame seed oil': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'orbignya oleifera seed oil': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'macadamia ternifolia seed oil': '[#8]=[#6](-[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]/[#6]=[#6]\[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'limonene': '[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](=[#6])-[#6]',
            'avocado oil': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6].[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6]',
            'coconut oil': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6](-[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])-[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'hydroxycitronellal': '[#6]-[#6](-[#6]-[#6]-[#6]-[#6](-[#6])(-[#6])-[#8])-[#6]-[#6]=[#8]',
            'geraniol': '[#6]-[#6](=[#6]-[#6]-[#6]/[#6](=[#6]/[#6]-[#8])-[#6])-[#6]',
            'cinnamyl alcohol': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]=[#6]-[#6]-[#8]',
            'coumarin': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1):[#6]:[#6]:[#6](=[#8]):[#8]:2',
            'phenoxyethanol': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#6]-[#8]',
            'butylphenyl methylpropional': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6])(-[#6])-[#6])-[#6]=[#8]',
            'apricot kernel oil': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6]#[#7])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'aloe vera leaf juice': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#8])-[#6]=[#6]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#7+](=[#8])-[#8-]',
        }

        return smarts
