# -*- coding: utf-8 -*-
# this is being read using exec() by atelier.sphinxconf.configure()

USE_PYDATA_THEME = False

# from atelier.sphinxconf import configure
from pathlib import Path
import atelier

docs_root = Path(__file__).parent.absolute()
# print("20210426", docs_root)

public_url = atelier.current_project.get_public_docs_url('docs')
if public_url:
    html_context.update(public_url=public_url)

    def get_lang_selector(language, pagename, sep=" | "):
        prj = atelier.current_project
        # public_url = prj.get_xconfig('intersphinx_urls')['docs']
        # public_url = prj.get_public_docs_url('docs')
        public_url = html_context['public_url']
        selectable_languages = prj.config['selectable_languages']
        if selectable_languages is None:
            return ''
        if len(selectable_languages) == 1:
            return ''
        filename = pagename + source_suffix
        if pagename.endswith("/" + master_doc):
            pagename = pagename[:-5]
        elif pagename == master_doc:
            pagename = ""

        html = ''
        for i, lng in enumerate(selectable_languages):
            if i > 0:
                html += sep
            if lng == language:
                html += "<b>{}</b>".format(lng)
            else:
                href = "/" + pagename
                if i == 0:
                    pth = docs_root.parent / "docs" / filename
                    if not pth.exists():
                        href = public_url + "/"
                        # print("Not found a:", pth)
                else:
                    pth = docs_root.parent / (lng + "docs") / filename
                    href = public_url + "/" + lng + href
                    if not pth.exists():
                        href = public_url + "/" + lng
                        # print("Not found b:", pth)
                html += '<a href="{}">{}</a>'.format(href, lng)
        # html += "</p>"
        return html

    html_context.update(get_lang_selector=get_lang_selector)


# extlinks = {}
# extensions = []
# templates_path = []

# configure(globals())

# extensions += ['sphinxcontrib.youtube']
extensions += ['atelier.sphinxconf.blog']
extensions += ['atelier.sphinxconf.complex_tables']
# extensions += ['lino.sphinxcontrib.actordoc']
# extensions += ['sphinxcontrib.taglist']
# extensions += ['sphinx.ext.inheritance_diagram']

# extensions += ['atelier.sphinxconf.sigal_image']
# sigal_base_url = 'https://sigal.saffre-rumma.net'

extensions += ['sphinx_panels'] # pip install sphinx-panels

# source_suffix = '.rst'
# master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'en'

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%d.%B.%Y'

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
# html_theme = 'default'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# A shorter title for the navigation bar.  Default is the same as html_title.
html_short_title = "⌘"

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = "logo.jpg"

# same logo is being used for all languages
# html_logo = str(Path().absolute() / '../docs/.static/rumma100.png') # pandas

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
if (docs_root / '.static').exists():
    html_static_path.append('.static')

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%Y-%m-%d'
#~ html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True


# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
html_use_modindex = False

# If false, no index is generated.
html_use_index = False

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
html_copy_source = False

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''
# html_use_opensearch = lino.SETUP_INFO['url']

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
# htmlhelp_basename = 'hg'


if USE_PYDATA_THEME:
    html_sidebars = {
      '**':  [
        'languages.html',
        'sidebar-search-bs.html' ,
        'sidebar-nav-bs.html' ],
    }
else:
    html_sidebars = {
        '**' : ['languages.html',
            'globaltoc.html',
            'separator.html',
            'searchbox.html',
            'links.html'
            ]}



if USE_PYDATA_THEME:
    # https://pydata-sphinx-theme.readthedocs.io/en/latest/user_guide/index.html
    html_theme = "pydata_sphinx_theme"
    html_theme_options = {
        # "gitlab_url": "https://gitlab.com/saffre-rumma/www",
        'globaltoc_includehidden': True,
        "show_prev_next": False,
        "search_bar_text": "Search..."
    }
    panels_add_bootstrap_css = False
    # html_css_files += ["https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"]
else:
    # https://insipid-sphinx-theme.readthedocs.io/en/0.2.0/configuration.html
    html_theme = "insipid"  # pip install insipid_sphinx_theme
    html_css_files = ['mystyles.css']
    html_theme_options = {
        'globaltoc_includehidden': False,
        'left_buttons': [
            'search-button.html',
            'home-button.html',
        ],
        'right_buttons': [
            'fullscreen-button.html',
            'repo-button.html',
            'facebook-button.html',
        ],
    }

# intersphinx_mapping = dict(
#     cg=('https://community.lino-framework.org/', None))
