/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Graph font family
 * @internal
 */
export declare const FONT_FAMILY = "Roboto Condensed";
/**
 * Graph font stylesheet
 * @internal
 */
export declare const FONT_STYLESHEET = "https://fonts.googleapis.com/css2?family=Roboto+Condensed:wght@300;400;700&display=swap";
/**
 * Graph fonts
 * @internal
 */
export declare const GraphFonts: {
    readonly LIGHT: {
        fontname: string;
        class: string;
    };
    readonly LIGHT_ITALIC: {
        fontname: string;
        class: string;
    };
    readonly REGULAR: {
        fontname: string;
        class: string;
    };
    readonly REGULAR_ITALIC: {
        fontname: string;
        class: string;
    };
    readonly BOLD: {
        fontname: string;
        class: string;
    };
    readonly BOLD_ITALIC: {
        fontname: string;
        class: string;
    };
};
/**
 * Graph font css style classes
 * @internal
 */
export declare const FONT_CSS_CLASSES: string;
