/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { ISynthesisSession } from "aws-cdk-lib";
import { IConstruct } from "constructs";
/**
 * Interface for constructs that want to do something custom during synthesis
 *
 * This feature is intended for use by official AWS CDK libraries only; 3rd party
 * library authors and CDK users should not use this function.
 *
 * **TODO**: Find an alternative synthesis solution that does not conflict with
 * the above statement. Before this package is stable, this should be resolved.
 *
 * @internal
 */
export interface ICustomSynthesis {
    /**
     * Called when the construct is synthesized
     */
    onSynthesize(session: ISynthesisSession): void;
}
/**
 * Cdk internal function for mapping construct synthesis property
 * for custom synthesis handling.
 *
 * @internal
 */
export declare function addCustomSynthesis(construct: IConstruct, synthesis: ICustomSynthesis): void;
/**
 * Source information on a construct (class fqn and version)
 *
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L22
 */
export interface ConstructInfo {
    readonly fqn: string;
    readonly version: string;
}
/**
 * Retrieve {@link ConstructInfo} for a {@link IConstruct}
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L46
 */
export declare function constructInfoFromConstruct(construct: IConstruct): ConstructInfo | undefined;
