import { IGraphFilterPlan } from "./types";
import { Graph } from "../core";
/**
 * Focus the graph on a specific node.
 * @throws Error if store is not filterable
 * @destructive
 */
export declare function focusFilter(store: Graph.Store, plan: IGraphFilterPlan): void;
/**
 * Preset that performs {@link Filters.pruneExtraneous} filter on store.
 * @throws Error if store is not filterable
 * @destructive
 */
export declare function nonExtraneousFilterPreset(store: Graph.Store): void;
/**
 * Preset that performs {@link Filters.compact} filter on store.
 * @throws Error if store is not filterable
 * @destructive
 */
export declare function compactFilterPreset(store: Graph.Store): void;
